/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.logics.rdl.examples;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.sf.tweety.logics.commons.syntax.Variable;
import net.sf.tweety.logics.fol.syntax.FolFormula;
import net.sf.tweety.logics.rdl.parser.RdlParser;
import net.sf.tweety.logics.rdl.reasoner.SimpleDefaultReasoner;
import net.sf.tweety.logics.rdl.semantics.DefaultSequence;
import net.sf.tweety.logics.rdl.syntax.DefaultRule;
import net.sf.tweety.logics.rdl.syntax.DefaultTheory;

public class RdlExample {
    static List<DefaultRule> createTestSet(RdlParser parser, String ... list) throws Exception {
        LinkedList<DefaultRule> result = new LinkedList<DefaultRule>();
        for (String str : list) {
            result.add((DefaultRule)parser.parseFormula(str));
        }
        return result;
    }

    static void defaultRuleTest() throws Exception {
        RdlParser parser = new RdlParser();
        DefaultTheory th = (DefaultTheory)parser.parseBeliefBaseFromFile(RdlExample.class.getResource("/example_default_theory.txt").getFile());
        System.out.println("\n--equals--");
        DefaultRule dr = (DefaultRule)parser.parseFormula("a::b();d/c()");
        List<DefaultRule> testset = RdlExample.createTestSet(parser, "a() :: b(); d / c()", "::b(); d()/c()", "a()::b(); d()/d()", "a()::b()/d()", "a()::b(); d(); c()/d()");
        for (DefaultRule d : testset) {
            System.out.println(dr + " = " + d + "\t" + dr.equals((Object)d));
        }
        testset = RdlExample.createTestSet(parser, "Bird(A)::Flies(A)/Flies(A)", "::! Swims(A)/Flies(A)", ":: Flies(B)/Flies(A)", "exists X: (Flies(X)) :: Flies(B); !Swims(B)  / Flies(B)", "Married(A,B)::Female(A)/Male(B)", "Married(A,B)::Female(A);Male(B)/Male(B)", "Father(A,B) :: Married(A,C) / Mother(C,B) ", "::(forall X: (Male(X)))/(exists Y:(Male(Y)))", "exists Z:(Married(X,Z))::Male(X)  / exists Y:(Father(X,Y))");
        System.out.println("\n--isNormal--");
        for (DefaultRule d : testset) {
            System.out.print((Object)d);
            System.out.println("\t\t" + (d.isNormal(th) ? "normal" : "not normal"));
        }
        System.out.println("\n--getUnboundVariables--");
        for (DefaultRule d : testset) {
            Set<Variable> vs = d.getUnboundVariables();
            System.out.print(d + "\t\t{");
            for (Variable v : vs) {
                System.out.print(v);
            }
            System.out.println("}");
        }
    }

    static void parserTest() throws Exception {
        RdlParser parser = new RdlParser();
        DefaultTheory th = (DefaultTheory)parser.parseBeliefBaseFromFile(RdlExample.class.getResource("/example_default_theory.txt").getFile());
        System.out.println(th);
        DefaultRule d = (DefaultRule)parser.parseFormula("exists X:(Flies(X))::Flies(B)/Flies(B)");
        System.out.println((Object)d);
    }

    static void sequenceTest() throws Exception {
        RdlParser parser = new RdlParser();
        DefaultTheory t = (DefaultTheory)parser.parseBeliefBaseFromFile(RdlExample.class.getResource("/simple_default_theory.txt").getFile());
        DefaultSequence s = new DefaultSequence(t);
        System.out.println(s);
        s = s.app((DefaultRule)parser.parseFormula("a::b/b"));
        System.out.println(s);
        s = s.app((DefaultRule)parser.parseFormula("::b/b"));
        System.out.println(s);
        DefaultSequence s2 = s.app((DefaultRule)parser.parseFormula("c::b/b"));
        System.out.println(s2);
        s = s.app((DefaultRule)parser.parseFormula("::!b/!b"));
        System.out.println(s);
        System.out.println("\n--isClosed--");
        s = new DefaultSequence(t).app((DefaultRule)parser.parseFormula("::b;d/d"));
        System.out.println(s);
        System.out.println(s.isClosed(t));
        s = s.app((DefaultRule)parser.parseFormula("a::c/c"));
        System.out.println(s);
        System.out.println(s.isClosed(t));
        s = s.app((DefaultRule)parser.parseFormula("::!d/!d"));
        System.out.println(s);
        System.out.println(s.isClosed(t));
    }

    static void processTreeTest() throws Exception {
        RdlParser parser = new RdlParser();
        DefaultTheory t = (DefaultTheory)parser.parseBeliefBaseFromFile(RdlExample.class.getResource("/simple_default_theory.txt").getFile());
        SimpleDefaultReasoner reasoner = new SimpleDefaultReasoner();
        System.out.println(reasoner.getModels(t));
        System.out.println(reasoner.query(t, (FolFormula)parser.parseFormula("!a")));
    }

    static void extensionTest() throws Exception {
        RdlParser parser = new RdlParser();
        DefaultTheory t = (DefaultTheory)parser.parseBeliefBaseFromFile(RdlExample.class.getResource("/example_default_theory.txt").getFile());
        t = t.ground();
        for (DefaultRule d : t.getDefaults()) {
            System.out.println((Object)d);
        }
    }

    public static void main(String[] args) throws Exception {
        RdlExample.processTreeTest();
    }
}

