/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.logics.rdl.semantics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import net.sf.tweety.logics.rdl.semantics.DefaultSequence;
import net.sf.tweety.logics.rdl.semantics.Extension;
import net.sf.tweety.logics.rdl.syntax.DefaultRule;
import net.sf.tweety.logics.rdl.syntax.DefaultTheory;

public class DefaultProcessTree {
    Collection<DefaultSequence> processes = new ArrayList<DefaultSequence>();
    Collection<Extension> extensions = new HashSet<Extension>();

    public DefaultProcessTree(DefaultTheory t) {
        t = t.ground();
        ArrayList<DefaultSequence> seqs_old = new ArrayList<DefaultSequence>();
        ArrayList<DefaultSequence> seqs_new = new ArrayList<DefaultSequence>();
        seqs_old.add(new DefaultSequence(t));
        while (!seqs_old.isEmpty()) {
            for (DefaultSequence seq_old : seqs_old) {
                for (DefaultRule d : t.getDefaults()) {
                    DefaultSequence seq_new = seq_old.app(d);
                    if (!seq_new.isProcess() || !seq_new.isSuccessful()) continue;
                    if (seq_new.isClosed(t)) {
                        this.processes.add(seq_new);
                        continue;
                    }
                    seqs_new.add(seq_new);
                }
            }
            seqs_old = seqs_new;
            seqs_new = new ArrayList();
        }
        for (DefaultSequence seq : this.processes) {
            this.extensions.add(new Extension(seq.getIn()));
        }
    }

    public Collection<DefaultSequence> getProcesses() {
        return this.processes;
    }

    public Collection<Extension> getExtensions() {
        return this.extensions;
    }
}

