/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.logics.rdl.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.tweety.commons.Formula;
import net.sf.tweety.commons.Parser;
import net.sf.tweety.commons.ParserException;
import net.sf.tweety.logics.fol.FolBeliefSet;
import net.sf.tweety.logics.fol.parser.FolParser;
import net.sf.tweety.logics.fol.syntax.FolFormula;
import net.sf.tweety.logics.fol.syntax.Tautology;
import net.sf.tweety.logics.rdl.DefaultTheory;
import net.sf.tweety.logics.rdl.syntax.DefaultRule;

public class RdlParser
extends Parser<DefaultTheory> {
    private FolParser folparser;
    private final String DIV_COLON = "::";
    private final String DIV_COMMA = ";";
    private final String DIV_SLASH = "/";
    private final Pattern JUS_SPLIT = Pattern.compile("^([^;]+);(.*)$");
    private final Pattern DEFAULT_SPLIT = Pattern.compile("^(.*)::(.*)/(.*)$");

    public DefaultTheory parseBeliefBase(Reader reader) throws IOException, ParserException {
        String line;
        this.folparser = new FolParser();
        BufferedReader br = new BufferedReader(reader);
        String str = "";
        while ((line = br.readLine()) != null && !line.matches(".*::.*")) {
            str = str + line + "\n";
        }
        FolBeliefSet facts = (FolBeliefSet)this.folparser.parseBeliefBase(str);
        LinkedList<DefaultRule> defaults = new LinkedList<DefaultRule>();
        do {
            if (line.matches("^\\s*$")) continue;
            defaults.add((DefaultRule)this.parseFormula(line));
        } while ((line = br.readLine()) != null);
        return new DefaultTheory(facts, defaults);
    }

    public Formula parseFormula(Reader reader) throws IOException, ParserException {
        BufferedReader br = new BufferedReader(reader);
        String line = br.readLine();
        Matcher matcher = this.DEFAULT_SPLIT.matcher(line);
        if (!matcher.matches()) {
            return this.folparser.parseFormula(line);
        }
        Tautology pre = new Tautology();
        if (!matcher.group(1).matches("^\\s*$")) {
            pre = (FolFormula)this.parseFormula(matcher.group(1));
        }
        FolFormula conc = (FolFormula)this.parseFormula(matcher.group(3));
        String jus = matcher.group(2);
        LinkedList<FolFormula> juslist = new LinkedList<FolFormula>();
        while (true) {
            Matcher m;
            if (!(m = this.JUS_SPLIT.matcher(jus)).matches()) break;
            jus = m.group(2);
            juslist.add((FolFormula)this.parseFormula(m.group(1)));
        }
        juslist.add((FolFormula)this.parseFormula(jus));
        return new DefaultRule((FolFormula)pre, juslist, conc);
    }
}

