/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.cellprocessor.joda;

import org.joda.time.format.DateTimeFormatter;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.util.CsvContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJodaParsingProcessor<T>
extends CellProcessorAdaptor
implements StringCellProcessor {
    private final DateTimeFormatter formatter;

    public AbstractJodaParsingProcessor() {
        this.formatter = null;
    }

    public AbstractJodaParsingProcessor(CellProcessor next) {
        super(next);
        this.formatter = null;
    }

    public AbstractJodaParsingProcessor(DateTimeFormatter formatter) {
        AbstractJodaParsingProcessor.checkPreconditions(formatter);
        this.formatter = formatter;
    }

    public AbstractJodaParsingProcessor(DateTimeFormatter formatter, CellProcessor next) {
        super(next);
        AbstractJodaParsingProcessor.checkPreconditions(formatter);
        this.formatter = formatter;
    }

    private static void checkPreconditions(DateTimeFormatter formatter) {
        if (formatter == null) {
            throw new NullPointerException("formatter should not be null");
        }
    }

    public Object execute(Object value, CsvContext context) {
        T result;
        this.validateInputNotNull(value, context);
        if (!(value instanceof String)) {
            throw new SuperCsvCellProcessorException(String.class, value, context, (CellProcessor)this);
        }
        String string = (String)value;
        try {
            result = this.formatter != null ? this.parse(string, this.formatter) : this.parse(string);
        }
        catch (IllegalArgumentException e) {
            throw new SuperCsvCellProcessorException("Failed to parse value", context, (CellProcessor)this, (Throwable)e);
        }
        return this.next.execute(result, context);
    }

    protected abstract T parse(String var1);

    protected abstract T parse(String var1, DateTimeFormatter var2);
}

