/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.interchange.xmlrpc;

import net.sf.sojo.interchange.AbstractSerializer;
import net.sf.sojo.interchange.xmlrpc.XmlRpcException;
import net.sf.sojo.interchange.xmlrpc.XmlRpcParser;
import net.sf.sojo.interchange.xmlrpc.XmlRpcWalkerInterceptor;

public class XmlRpcSerializer
extends AbstractSerializer {
    private XmlRpcParser xmlRpcParser = new XmlRpcParser();
    private boolean returnValueAsList = false;
    private boolean convertResult2XmlRpcExceptionAndThrow = false;
    private String methodName = null;
    XmlRpcWalkerInterceptor xmlRpcWalker = new XmlRpcWalkerInterceptor();

    public XmlRpcSerializer() {
        this.setWithSimpleKeyMapper(false);
        this.walker.addInterceptor(this.xmlRpcWalker);
    }

    public XmlRpcSerializer(boolean pvReturnValueAsList) {
        this();
        this.setReturnValueAsList(pvReturnValueAsList);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setReturnValueAsList(boolean pvReturnValueAsList) {
        this.returnValueAsList = pvReturnValueAsList;
    }

    public boolean getReturnValueAsList() {
        return this.returnValueAsList;
    }

    public void setConvertResult2XmlRpcExceptionAndThrow(boolean pvConvertResult2XmlRpcException) {
        this.convertResult2XmlRpcExceptionAndThrow = pvConvertResult2XmlRpcException;
    }

    public boolean getConvertResult2XmlRpcExceptionAndThrow() {
        return this.convertResult2XmlRpcExceptionAndThrow;
    }

    public Object serialize(Object pvRootObject) {
        this.walker.walk(pvRootObject);
        String lvReturn = this.xmlRpcWalker.getXmlRpcString();
        return lvReturn;
    }

    public String serializeXmlRpcRequest(String pvMethodName, Object pvArgs) {
        if (pvMethodName == null || pvMethodName.length() == 0) {
            throw new XmlRpcException("Missing method-name: " + this.getMethodName());
        }
        Object o = this.serialize(pvArgs);
        StringBuffer lvReturn = new StringBuffer("<?xml version='1.0' encoding='UTF-8'?><methodCall><methodName>");
        lvReturn.append(pvMethodName).append("</methodName>" + o + "</methodCall>");
        return lvReturn.toString();
    }

    public String serializeXmlRpcResponse(Object pvReturnValue) {
        Object o = this.serialize(pvReturnValue);
        StringBuffer lvReturn = new StringBuffer("<?xml version='1.0' encoding='UTF-8'?><methodResponse>");
        lvReturn.append(o).append("</methodResponse>");
        return lvReturn.toString();
    }

    public Object deserialize(Object pvSourceObject, Class pvRootClass) {
        Object lvReturn = null;
        if (pvSourceObject != null) {
            this.xmlRpcParser.setReturnValueAsList(this.getReturnValueAsList());
            this.xmlRpcParser.setConvertResult2XmlRpcExceptionAndThrow(this.getConvertResult2XmlRpcExceptionAndThrow());
            lvReturn = this.xmlRpcParser.parse(pvSourceObject.toString());
            this.methodName = this.xmlRpcParser.getMethodName();
        }
        lvReturn = this.getObjectUtil().makeComplex(lvReturn, pvRootClass);
        return lvReturn;
    }
}

