/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.core.filter;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.sojo.core.filter.ClassPropertyFilter;
import net.sf.sojo.core.filter.ClassPropertyFilterHandler;
import net.sf.sojo.core.filter.ClassPropertyFilterHelper;

public class ClassPropertyFilterHandlerImpl
implements ClassPropertyFilterHandler {
    private Map classPropertyFilterMap = new HashMap();
    private boolean withAssignableFilterClasses = true;

    public ClassPropertyFilterHandlerImpl() {
    }

    public ClassPropertyFilterHandlerImpl(ClassPropertyFilter pvFilter) {
        this.addClassPropertyFilter(pvFilter);
    }

    public ClassPropertyFilterHandlerImpl(Class[] pvClassPropertyFilterClasses) {
        this.addClassPropertyFilterByFilterClasses(pvClassPropertyFilterClasses);
    }

    public void setWithAssignableFilterClasses(boolean pvWithAssignableFilterClasses) {
        this.withAssignableFilterClasses = pvWithAssignableFilterClasses;
    }

    public boolean getWithAssignableFilterClasses() {
        return this.withAssignableFilterClasses;
    }

    public void addClassPropertyFilterByFilterClasses(Class[] pvClassPropertyFilterClasses) {
        if (pvClassPropertyFilterClasses != null) {
            int i = 0;
            while (i < pvClassPropertyFilterClasses.length) {
                ClassPropertyFilter lvFilter = ClassPropertyFilterHelper.createClassPropertyFilterByClass(pvClassPropertyFilterClasses[i]);
                this.addClassPropertyFilter(lvFilter);
                ++i;
            }
        }
    }

    public void addClassPropertyFilter(ClassPropertyFilter pvClassPropertyFilter) {
        this.classPropertyFilterMap.put(pvClassPropertyFilter.getFilterClass(), pvClassPropertyFilter);
    }

    public void removeClassPropertyFilterByClassName(Class pvFilterClass) {
        this.classPropertyFilterMap.remove(pvFilterClass);
    }

    public ClassPropertyFilter getClassPropertyFilterByClass(Class pvFilterClass) {
        if (this.withAssignableFilterClasses) {
            Iterator it = this.classPropertyFilterMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry lvEntry = it.next();
                Class lvClass = (Class)lvEntry.getKey();
                if (!lvClass.isAssignableFrom(pvFilterClass)) continue;
                return (ClassPropertyFilter)lvEntry.getValue();
            }
            return null;
        }
        return (ClassPropertyFilter)this.classPropertyFilterMap.get(pvFilterClass);
    }

    public int getClassPropertyFilterSize() {
        return this.classPropertyFilterMap.size();
    }
}

