/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.core;

import net.sf.sojo.core.AbstractConversion;
import net.sf.sojo.core.reflect.ReflectionHelper;

public abstract class SimpleConversion
extends AbstractConversion {
    protected Class fromType = null;
    protected Class toType = null;

    public SimpleConversion(Class pvFromType) {
        this(pvFromType, pvFromType);
    }

    public SimpleConversion(Class pvFromType, Class pvToType) {
        if (!ReflectionHelper.isSimpleType(pvFromType) || !ReflectionHelper.isSimpleType(pvToType)) {
            throw new IllegalArgumentException("The classes: " + pvFromType + " and " + pvToType + " must be a simple type.");
        }
        this.fromType = pvFromType;
        this.toType = pvToType;
    }

    public boolean isFromTypeAndToTypeDifferent(Class pvFromtype, Class pvToType) {
        boolean lvIsFromTypeAndToTypeDifferent = false;
        if (!this.fromType.equals(this.toType)) {
            lvIsFromTypeAndToTypeDifferent = true;
        }
        return lvIsFromTypeAndToTypeDifferent;
    }

    public Class getFromType() {
        return this.fromType;
    }

    public Class getToType() {
        return this.toType;
    }

    public boolean isAssignableFrom(Object pvObject) {
        if (pvObject == null) {
            return false;
        }
        return pvObject.getClass().equals(this.fromType);
    }

    public boolean isAssignableTo(Class pvToType) {
        return ReflectionHelper.isSimpleType(pvToType);
    }

    public abstract Object convert(Object var1, Class var2);
}

