/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.parser.SmcLexer;
import net.sf.smc.parser.SmcMessage;
import net.sf.smc.parser.SmcParserContext;

public final class SmcParser {
    public static final int LANGUAGE_COUNT = 17;
    private final String _name;
    private final TargetLanguage _targetLanguage;
    private List<SmcMessage> _messages;
    private SmcParserContext _parserFSM;
    private SmcLexer _lexer;
    private boolean _parseStatus;
    private boolean _quitFlag;
    private SmcFSM _fsm;
    private SmcMap _mapInProgress;
    private SmcState _stateInProgress;
    private String _transitionName;
    private SmcTransition _transitionInProgress;
    private SmcGuard _guardInProgress;
    private SmcParameter _paramInProgress;
    private SmcAction _actionInProgress;
    private String _argInProgress;
    private List<SmcParameter> _paramList;
    private List<SmcAction> _actionList;
    private List<String> _argList;
    private int _lineNumber;
    private static List<Character> OPEN_CLAUSE_LIST;
    private static List<Character> CLOSE_CLAUSE_LIST;
    private static List<Character> QUOTE_LIST;
    private static Method[] _TransMethod;

    public SmcParser(String name, InputStream istream, TargetLanguage targetLanguage, boolean debugFlag) {
        this._name = name;
        this._targetLanguage = targetLanguage;
        this._messages = new ArrayList<SmcMessage>();
        this._lexer = new SmcLexer(istream, debugFlag);
        this._parserFSM = new SmcParserContext(this);
        this._parserFSM.setDebugFlag(debugFlag);
    }

    public SmcFSM parse() throws IOException, IllegalAccessException, InvocationTargetException {
        SmcLexer.Token token = null;
        Object[] params = new Object[1];
        this._mapInProgress = null;
        this._stateInProgress = null;
        this._transitionName = null;
        this._transitionInProgress = null;
        this._guardInProgress = null;
        this._paramInProgress = null;
        this._actionInProgress = null;
        this._argInProgress = null;
        this._paramList = null;
        this._actionList = null;
        this._argList = null;
        this._parseStatus = true;
        this._quitFlag = false;
        this._fsm = new SmcFSM(this._name, this._targetLanguage.sourceFileName(this._name));
        this._lexer.setCookedMode();
        int tokenType = 0;
        while (!this._quitFlag && (token = this._lexer.nextToken()) != null) {
            tokenType = token.getType();
            this._lineNumber = token.getLineNumber();
            if (tokenType <= 0 && tokenType >= 32) {
                this.error("Undefined token type (" + Integer.toString(tokenType) + ")", token.getLineNumber());
                this._quitFlag = true;
                this._parseStatus = false;
                continue;
            }
            if (tokenType == 1) {
                this._quitFlag = true;
                this._parseStatus = false;
                this.error(token.getValue(), token.getLineNumber());
                continue;
            }
            if (tokenType == 2) {
                this._quitFlag = true;
                continue;
            }
            params[0] = token;
            _TransMethod[tokenType].invoke((Object)this._parserFSM, params);
        }
        if (!this._parseStatus) {
            this._fsm = null;
        }
        return this._fsm;
    }

    public List<SmcMessage> getMessages() {
        return this._messages;
    }

    boolean isValidHeader() {
        String context = this._fsm.getContext();
        String start = this._fsm.getStartState();
        return context != null && context.length() > 0 && start != null && start.length() > 0;
    }

    boolean isValidStartState(String name) {
        boolean retval = false;
        int index = name.indexOf("::");
        if (index >= 0 && name.indexOf("::", index + 1) < 0) {
            retval = true;
        }
        return retval;
    }

    boolean isDuplicateMap(String name) {
        return this._fsm.findMap(name) != null;
    }

    boolean isDuplicateState(String name) {
        return this._mapInProgress.isKnownState(name);
    }

    void warning(String errorMsg, int lineNumber) {
        this._messages.add(new SmcMessage(this._name, lineNumber, 0, errorMsg));
    }

    void error(String errorMsg, int lineNumber) {
        this._messages.add(new SmcMessage(this._name, lineNumber, 1, errorMsg));
        this._parseStatus = false;
    }

    int getLineNumber() {
        return this._lineNumber;
    }

    TargetLanguage getTargetLanguage() {
        return this._targetLanguage;
    }

    void setRawMode(String openChar, String closeChar, String dummy) {
        this._lexer.setRawMode(openChar.charAt(0), closeChar.charAt(0));
    }

    void setRawMode(String openChar, String closeChar) {
        this._lexer.setRawMode(openChar.charAt(0), closeChar.charAt(0));
    }

    void setRawMode2() {
        this._lexer.setRawMode(OPEN_CLAUSE_LIST, CLOSE_CLAUSE_LIST, QUOTE_LIST, ')', ',');
    }

    void setRawMode(String closeChars) {
        this._lexer.setRawMode(closeChars);
    }

    void setCookedMode() {
        this._lexer.setCookedMode();
    }

    void setHeaderLine(int lineNumber) {
        this._fsm.setHeaderLine(lineNumber);
    }

    void setSource(String source) {
        String src = this._fsm.getSource();
        if (src != null && src.length() > 0) {
            this.warning("%{ %} source previously specified, new source ignored.", this._lineNumber);
        } else {
            this._fsm.setSource(source);
        }
    }

    void setStartState(String stateName) {
        String start = this._fsm.getStartState();
        if (start != null && start.length() > 0) {
            this.warning("%start previously specified, new start state ignored.", this._lineNumber);
        } else {
            this._fsm.setStartState(stateName);
        }
    }

    void setContext(String name) {
        String context = this._fsm.getContext();
        if (context != null && context.length() > 0) {
            this.warning("%class previously specified, new context ignored.", this._lineNumber);
        } else {
            this._fsm.setContext(name);
        }
    }

    void setFsmClassName(String name) {
        this._fsm.setFsmClassName(name.trim());
    }

    void setPackageName(String name) {
        String pkg = this._fsm.getPackage();
        if (pkg != null && pkg.length() > 0) {
            this.warning("%package previously specified, new package ignored.", this._lineNumber);
        } else {
            this._fsm.setPackage(name.trim());
        }
    }

    void addImport(String name) {
        this._fsm.addImport(name.trim());
    }

    void addDeclare(String name) {
        this._fsm.addDeclare(name.trim());
    }

    void setHeader(String name) {
        String header = this._fsm.getHeader();
        if (header != null && header.length() > 0) {
            this.warning("%header previously specified, new header file ignored.", this._lineNumber);
        } else {
            this._fsm.setHeader(name.trim());
        }
    }

    void addInclude(String name) {
        this._fsm.addInclude(name.trim());
    }

    void setAccessLevel(String level) {
        String accessLevel = this._fsm.getAccessLevel();
        if (accessLevel != null && accessLevel.length() > 0) {
            this.warning("%access previously specified, new access level ignored.", this._lineNumber);
        } else {
            this._fsm.setAccessLevel(level.trim());
        }
    }

    void addMap() {
        if (this._mapInProgress == null) {
            this.error("There is no in-progress map to add", this._lineNumber);
        } else {
            if (!this._mapInProgress.hasDefaultState()) {
                SmcState DefaultState = new SmcState("Default", this._mapInProgress.getLineNumber(), this._mapInProgress);
                this._mapInProgress.addState(DefaultState);
            }
            this._fsm.addMap(this._mapInProgress);
            this._mapInProgress = null;
        }
    }

    void createMap(String name, int lineNumber) {
        if (this._mapInProgress != null) {
            this.error("Cannot create new map while still filling in previous map (" + this._mapInProgress.getName() + ").", lineNumber);
        } else {
            if (this._fsm.getFsmClassName() == "") {
                this._fsm.setFsmClassName(this._fsm.getContext() + "Context");
            }
            if (this._parserFSM.getDebugFlag()) {
                PrintStream os = this._parserFSM.getDebugStream();
                os.println("CREATE MAP   : " + name + "(" + Integer.toString(lineNumber) + ")");
            }
            this._mapInProgress = new SmcMap(name, lineNumber, this._fsm);
        }
    }

    void addState() {
        if (this._mapInProgress == null) {
            this.error("There is no in-progress map to which the state may be added.", this._lineNumber);
        } else if (this._stateInProgress == null) {
            this.error("There is no in-progrss state to add to the map.", this._lineNumber);
        } else {
            this._mapInProgress.addState(this._stateInProgress);
            this._stateInProgress = null;
        }
    }

    void createState(String name, int lineNumber) {
        if (this._stateInProgress != null) {
            this.error("Cannot create new state while still filling in previous state (" + this._stateInProgress.getName() + ").", lineNumber);
        } else {
            if (this._parserFSM.getDebugFlag()) {
                PrintStream os = this._parserFSM.getDebugStream();
                os.println("CREATE STATE : " + name + "(" + Integer.toString(lineNumber) + ")");
            }
            this._stateInProgress = new SmcState(name, lineNumber, this._mapInProgress);
        }
    }

    void setEntryAction(List<SmcAction> actions) {
        if (this._stateInProgress == null) {
            this.error("There is no in-progress state to receive the entry action.", this._lineNumber);
        } else if (this._stateInProgress.getEntryActions() != null) {
            this.warning("Entry action previously specified, new entry action ignored.", this._lineNumber);
        } else {
            this._stateInProgress.setEntryActions(actions);
        }
    }

    void setExitAction(List<SmcAction> actions) {
        if (this._stateInProgress == null) {
            this.error("There is no in-progress state to receive the exit action.", this._lineNumber);
        } else if (this._stateInProgress.getExitActions() != null) {
            this.warning("Exit action previously specified, new exit action ignored.", this._lineNumber);
        } else {
            this._stateInProgress.setExitActions(actions);
        }
    }

    void addTransition() {
        if (this._stateInProgress == null) {
            this.error("There is no in-progress state to which the transition may be added.", this._lineNumber);
        } else if (this._transitionInProgress == null) {
            this.error("There is no in-progress transition to add to the state.", this._lineNumber);
        } else {
            this._stateInProgress.addTransition(this._transitionInProgress);
            this._transitionInProgress = null;
        }
    }

    String getTransitionName() {
        return this._transitionInProgress != null ? this._transitionInProgress.getName() : this._transitionName;
    }

    void storeTransitionName(String name) {
        if (this._transitionName != null) {
            this.error("There already is a previously stored transition name - \"" + name + "\".", this._lineNumber);
        } else {
            this._transitionName = name;
        }
    }

    void createTransition(List<SmcParameter> params, int lineNumber) {
        if (this._transitionInProgress != null) {
            this.error("Cannot create new transition while still filling in previous transition (" + this._transitionInProgress.getName() + ").", lineNumber);
        } else if (this._stateInProgress == null) {
            this.error("There is no in-progress state to which the transition may be added.", lineNumber);
        } else if (this._transitionName == null) {
            this.error("There is no stored transition name.", lineNumber);
        } else {
            this._transitionInProgress = this._stateInProgress.findTransition(this._transitionName, params);
            if (this._transitionInProgress == null) {
                if (this._parserFSM.getDebugFlag()) {
                    PrintStream os = this._parserFSM.getDebugStream();
                    StringBuffer buffer = new StringBuffer(80);
                    buffer.append("CREATE TRANS : ");
                    buffer.append(this._transitionName);
                    buffer.append('(');
                    Iterator<SmcParameter> pit = params.iterator();
                    String sep = "";
                    while (pit.hasNext()) {
                        buffer.append(sep);
                        buffer.append(pit.next());
                        sep = ", ";
                    }
                    buffer.append(')');
                    buffer.append(" (");
                    buffer.append(lineNumber);
                    buffer.append(")");
                    os.println(buffer);
                }
                this._transitionInProgress = new SmcTransition(this._transitionName, params, lineNumber, this._stateInProgress);
            }
            this._transitionName = null;
        }
    }

    void createTransition(int lineNumber) {
        this.createTransition(new ArrayList<SmcParameter>(), lineNumber);
    }

    void addGuard() {
        if (this._transitionInProgress == null) {
            this.error("There is no in-progress transition to which the guard may be added.", this._lineNumber);
        } else if (this._guardInProgress == null) {
            this.error("There is no in-progress guard to add to the " + this._transitionInProgress.getName() + " transition.", this._lineNumber);
        } else {
            this._transitionInProgress.addGuard(this._guardInProgress);
            this._guardInProgress = null;
        }
    }

    void createGuard(String transition, String condition, int lineNumber) {
        if (this._guardInProgress != null) {
            this.error("Cannot create new guard while still filling in previous guard.", lineNumber);
        } else {
            if (this._parserFSM.getDebugFlag()) {
                PrintStream os = this._parserFSM.getDebugStream();
                os.println("CREATE GUARD : " + condition + "(" + Integer.toString(lineNumber) + ")");
            }
            this._guardInProgress = new SmcGuard(condition, lineNumber, this._transitionInProgress);
        }
    }

    void setTransType(SmcElement.TransType trans_type) {
        if (this._guardInProgress == null) {
            this.error("There is no in-progress guard to which to set the transition type.", this._lineNumber);
        } else {
            switch (trans_type) {
                case TRANS_SET: 
                case TRANS_PUSH: 
                case TRANS_POP: {
                    this._guardInProgress.setTransType(trans_type);
                    break;
                }
                default: {
                    this.error("Transition type must be either \"TRANS_SET\", \"TRANS_PUSH\" or \"TRANS_POP\".", this._lineNumber);
                }
            }
        }
    }

    void setEndState(String state) {
        if (this._guardInProgress == null) {
            this.error("There is no in-progress guard to which to add the end state.", this._lineNumber);
        } else {
            this._guardInProgress.setEndState(state);
        }
    }

    void setPushState(String name) {
        if (this._guardInProgress == null) {
            this.error("There is no in-progress guard to which to add the end state.", this._lineNumber);
        } else if (this._guardInProgress.getTransType() != SmcElement.TransType.TRANS_PUSH) {
            this.error("Cannot set push state on a non-push transition.", this._lineNumber);
        } else if (name.equals("nil")) {
            this.error("Cannot push to \"nil\" state.", this._lineNumber);
        } else {
            this._guardInProgress.setPushState(name);
        }
    }

    void setActions(List<SmcAction> actions) {
        if (this._guardInProgress == null) {
            this.error("There is no in-progress guard to which to add the action.", this._lineNumber);
        } else {
            this._guardInProgress.setActions(actions);
        }
    }

    void setPopArgs(String args) {
        if (this._guardInProgress == null) {
            this.error("There is no in-progress guard to which to add the action.", this._lineNumber);
        } else {
            this._guardInProgress.setPopArgs(args);
        }
    }

    void createParamList() {
        if (this._paramList == null) {
            this._paramList = new ArrayList<SmcParameter>();
        }
    }

    List<SmcParameter> getParamList() {
        List<SmcParameter> retval = this._paramList;
        this._paramList = null;
        return retval;
    }

    void createParameter(String name, int lineNumber) {
        if (this._paramInProgress != null) {
            this.error("Cannot create new parameter while still filling in previous one.", lineNumber);
        } else {
            String type = "";
            if (this._parserFSM.getDebugFlag()) {
                PrintStream os = this._parserFSM.getDebugStream();
                os.println("CREATE PARAM : " + name + "(" + Integer.toString(lineNumber) + ")");
            }
            if (this._targetLanguage == TargetLanguage.TCL) {
                type = "value";
            }
            this._paramInProgress = new SmcParameter(name, lineNumber, type);
        }
    }

    void setParamType(String type) {
        if (this._paramInProgress == null) {
            this.error("There is no in-progress parameter to which to add the type.", this._lineNumber);
        } else {
            this._paramInProgress.setType(type);
        }
    }

    void addParameter() {
        if (this._paramList == null) {
            this.error("There is no parameter list to which the parameter may be added.", this._lineNumber);
        } else if (this._paramInProgress == null) {
            this.error("There is no in-progress parameter to add to the list.", this._lineNumber);
        } else {
            this._paramList.add(this._paramInProgress);
            this._paramInProgress = null;
        }
    }

    void clearParameter() {
        this._paramInProgress = null;
    }

    void createActionList() {
        if (this._actionList != null) {
            this.error("Cannot create an action list when one already exists.", this._lineNumber);
        } else {
            this._actionList = new ArrayList<SmcAction>();
        }
    }

    List<SmcAction> getActionList() {
        List<SmcAction> retval = this._actionList;
        this._actionList = null;
        return retval;
    }

    void createAction(String name, int lineNumber) {
        if (this._actionInProgress != null) {
            this.error("Cannot create new action while still filling in previous one.", lineNumber);
        } else {
            if (this._parserFSM.getDebugFlag()) {
                PrintStream os = this._parserFSM.getDebugStream();
                os.println("CREATE ACTION: " + name + "(" + Integer.toString(lineNumber) + ")");
            }
            this._actionInProgress = new SmcAction(name, lineNumber);
        }
    }

    void setActionArgs(List<String> args) {
        if (this._actionInProgress == null) {
            this.error("There is no in-progress action to which to add the arguments.", this._lineNumber);
        } else {
            this._actionInProgress.setArguments(args);
        }
    }

    void addAction() {
        if (this._actionList == null) {
            this.error("There is no action list to which the action may be added.", this._lineNumber);
        } else if (this._actionInProgress == null) {
            this.error("There is no in-progress action to add to the list.", this._lineNumber);
        } else {
            this._actionList.add(this._actionInProgress);
            this._actionInProgress = null;
        }
    }

    boolean getProperty() {
        boolean retcode = false;
        if (this._actionInProgress == null) {
            this.error("There is no in-progress action, get property flag failed.", this._lineNumber);
        } else {
            retcode = this._actionInProgress.isProperty();
        }
        return retcode;
    }

    void setProperty(boolean flag) {
        if (this._actionInProgress == null) {
            this.error("There is no in-progress action, set property flag failed.", this._lineNumber);
        } else {
            this._actionInProgress.setProperty(flag);
        }
    }

    void clearActions() {
        if (this._actionList != null) {
            this._actionList.clear();
            this._actionList = null;
        }
    }

    void createArgList() {
        if (this._argList != null) {
            this.error("Cannot create an argument list when one already exists.", this._lineNumber);
        } else {
            this._argList = new ArrayList<String>();
        }
    }

    List<String> getArgsList() {
        List<String> retval = this._argList;
        this._argList = null;
        return retval;
    }

    void createArgument(String name, int lineNumber) {
        if (this._argInProgress != null) {
            this.error("Cannot create new argument while still filling in previous one.", lineNumber);
        } else {
            if (this._parserFSM.getDebugFlag()) {
                PrintStream os = this._parserFSM.getDebugStream();
                os.println("   CREATE ARG: " + name + "(" + Integer.toString(lineNumber) + ")");
            }
            this._argInProgress = name;
        }
    }

    void addArgument() {
        if (this._argList == null) {
            this.error("There is no argument list to which the argument may be added.", this._lineNumber);
        } else if (this._argInProgress == null) {
            this.error("There is no in-progress argument to add to the list.", this._lineNumber);
        } else {
            this._argList.add(this._argInProgress.trim());
            this._argInProgress = null;
        }
    }

    void clearArguments() {
        if (this._argList != null) {
            this._argList.clear();
            this._argList = null;
        }
    }

    static {
        String transName = "<not set>";
        OPEN_CLAUSE_LIST = new ArrayList<Character>();
        CLOSE_CLAUSE_LIST = new ArrayList<Character>();
        QUOTE_LIST = new ArrayList<Character>();
        OPEN_CLAUSE_LIST.add(new Character('('));
        OPEN_CLAUSE_LIST.add(new Character('{'));
        OPEN_CLAUSE_LIST.add(new Character('['));
        OPEN_CLAUSE_LIST.add(new Character('<'));
        CLOSE_CLAUSE_LIST.add(new Character(')'));
        CLOSE_CLAUSE_LIST.add(new Character('}'));
        CLOSE_CLAUSE_LIST.add(new Character(']'));
        CLOSE_CLAUSE_LIST.add(new Character('>'));
        QUOTE_LIST.add(new Character('\"'));
        QUOTE_LIST.add(new Character('\''));
        _TransMethod = new Method[32];
        try {
            Class<SmcParserContext> fsmClass = SmcParserContext.class;
            Class[] paramTypes = new Class[]{SmcLexer.Token.class};
            transName = "ENTRY";
            SmcParser._TransMethod[3] = fsmClass.getDeclaredMethod("ENTRY", paramTypes);
            transName = "EXIT";
            SmcParser._TransMethod[4] = fsmClass.getDeclaredMethod("EXIT", paramTypes);
            transName = "JUMP";
            SmcParser._TransMethod[30] = fsmClass.getDeclaredMethod("JUMP", paramTypes);
            transName = "POP";
            SmcParser._TransMethod[5] = fsmClass.getDeclaredMethod("POP", paramTypes);
            transName = "PUSH";
            SmcParser._TransMethod[6] = fsmClass.getDeclaredMethod("PUSH", paramTypes);
            transName = "WORD";
            SmcParser._TransMethod[7] = fsmClass.getDeclaredMethod("WORD", paramTypes);
            transName = "START_STATE";
            SmcParser._TransMethod[8] = fsmClass.getDeclaredMethod("START_STATE", paramTypes);
            transName = "MAP_NAME";
            SmcParser._TransMethod[9] = fsmClass.getDeclaredMethod("MAP_NAME", paramTypes);
            transName = "CLASS_NAME";
            SmcParser._TransMethod[10] = fsmClass.getDeclaredMethod("CLASS_NAME", paramTypes);
            transName = "HEADER_FILE";
            SmcParser._TransMethod[11] = fsmClass.getDeclaredMethod("HEADER_FILE", paramTypes);
            transName = "INCLUDE_FILE";
            SmcParser._TransMethod[12] = fsmClass.getDeclaredMethod("INCLUDE_FILE", paramTypes);
            transName = "PACKAGE_NAME";
            SmcParser._TransMethod[13] = fsmClass.getDeclaredMethod("PACKAGE_NAME", paramTypes);
            transName = "FSM_CLASS_NAME";
            SmcParser._TransMethod[31] = fsmClass.getDeclaredMethod("FSM_CLASS_NAME", paramTypes);
            transName = "IMPORT";
            SmcParser._TransMethod[14] = fsmClass.getDeclaredMethod("IMPORT", paramTypes);
            transName = "DECLARE";
            SmcParser._TransMethod[15] = fsmClass.getDeclaredMethod("DECLARE", paramTypes);
            transName = "LEFT_BRACE";
            SmcParser._TransMethod[16] = fsmClass.getDeclaredMethod("LEFT_BRACE", paramTypes);
            transName = "RIGHT_BRACE";
            SmcParser._TransMethod[17] = fsmClass.getDeclaredMethod("RIGHT_BRACE", paramTypes);
            transName = "LEFT_BRACKET";
            SmcParser._TransMethod[18] = fsmClass.getDeclaredMethod("LEFT_BRACKET", paramTypes);
            transName = "LEFT_PAREN";
            SmcParser._TransMethod[19] = fsmClass.getDeclaredMethod("LEFT_PAREN", paramTypes);
            transName = "RIGHT_PAREN";
            SmcParser._TransMethod[20] = fsmClass.getDeclaredMethod("RIGHT_PAREN", paramTypes);
            transName = "COMMA";
            SmcParser._TransMethod[21] = fsmClass.getDeclaredMethod("COMMA", paramTypes);
            transName = "COLON";
            SmcParser._TransMethod[22] = fsmClass.getDeclaredMethod("COLON", paramTypes);
            transName = "SEMICOLON";
            SmcParser._TransMethod[23] = fsmClass.getDeclaredMethod("SEMICOLON", paramTypes);
            transName = "SOURCE";
            SmcParser._TransMethod[24] = fsmClass.getDeclaredMethod("SOURCE", paramTypes);
            transName = "EOD";
            SmcParser._TransMethod[25] = fsmClass.getDeclaredMethod("EOD", paramTypes);
            transName = "SLASH";
            SmcParser._TransMethod[26] = fsmClass.getDeclaredMethod("SLASH", paramTypes);
            transName = "EQUAL";
            SmcParser._TransMethod[27] = fsmClass.getDeclaredMethod("EQUAL", paramTypes);
            transName = "ACCESS";
            SmcParser._TransMethod[28] = fsmClass.getDeclaredMethod("ACCESS", paramTypes);
            transName = "DOLLAR";
            SmcParser._TransMethod[29] = fsmClass.getDeclaredMethod("DOLLAR", paramTypes);
        }
        catch (NoSuchMethodException ex1) {
            System.err.println("INITIALIZATION ERROR! No such method as SmcParserContext." + transName + ".");
            System.exit(2);
        }
        catch (SecurityException ex2) {
            System.err.println("INITIALIZATION ERROR! Not allowed to access SmcParserContext." + transName + ".");
            System.exit(2);
        }
    }

    public static enum TargetLanguage {
        LANG_NOT_SET(""),
        C_PLUS_PLUS("{0}_sm"),
        JAVA("{0}Context"),
        TCL("{0}_sm"),
        VB("{0}_sm"),
        C_SHARP("{0}_sm"),
        PYTHON("{0}_sm"),
        TABLE("{0}_sm"),
        GRAPH("{0}_sm"),
        PERL("{0}_sm"),
        RUBY("{0}_sm"),
        C("{0}_sm"),
        OBJECTIVE_C("{0}_sm"),
        LUA("{0}_sm"),
        GROOVY("{0}Context"),
        SCALA("{0}Context"),
        PHP("{0}_sm");

        private final String _sourceNameFormat;

        private TargetLanguage(String format) {
            this._sourceNameFormat = format;
        }

        public String sourceFileName(String className) {
            return MessageFormat.format(this._sourceNameFormat, className);
        }
    }
}

