/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.parser;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.smc.parser.SmcLexerContext;

final class SmcLexer {
    private SmcLexerContext _lexerFSM;
    private InputStream _stream;
    private int _mode;
    private boolean _stopFlag;
    private char _currentChar;
    private Token _token;
    private StringBuilder _tokenBuffer;
    private int _lineNumber;
    private char[] _readBuffer;
    private int _bufferSize;
    private int _readIndex;
    private char _openChar;
    private char _closeChar;
    private List<Character> _openList;
    private List<Character> _closeList;
    private List<Character> _quoteList;
    private char _endChar;
    private char _separator;
    private String _closeChars;
    private static String[] _TypeName;
    private static Map<String, Integer> _KeywordMap;
    private static Map<String, Integer> _PercentKeywordMap;
    private static Method[] _TransMethod;
    private static final int MAX_BUFFER_LEN = 4096;
    private static final int BUFFER_OFFSET = 2;
    private static final int READ_BUFFER_LEN = 4098;
    static final int COOKED = 1;
    static final int RAW = 2;
    static final int RAW2 = 3;
    static final int RAW3 = 4;
    static final int TOKEN_NOT_SET = 0;
    static final int DONE_FAILED = 1;
    static final int DONE_SUCCESS = 2;
    static final int ENTRY = 3;
    static final int EXIT = 4;
    static final int POP = 5;
    static final int PUSH = 6;
    static final int WORD = 7;
    static final int START_STATE = 8;
    static final int MAP_NAME = 9;
    static final int CLASS_NAME = 10;
    static final int HEADER_FILE = 11;
    static final int INCLUDE_FILE = 12;
    static final int PACKAGE_NAME = 13;
    static final int IMPORT = 14;
    static final int DECLARE = 15;
    static final int LEFT_BRACE = 16;
    static final int RIGHT_BRACE = 17;
    static final int LEFT_BRACKET = 18;
    static final int LEFT_PAREN = 19;
    static final int RIGHT_PAREN = 20;
    static final int COMMA = 21;
    static final int COLON = 22;
    static final int SEMICOLON = 23;
    static final int SOURCE = 24;
    static final int EOD = 25;
    static final int SLASH = 26;
    static final int EQUAL = 27;
    static final int ACCESS = 28;
    static final int DOLLAR = 29;
    static final int JUMP = 30;
    static final int FSM_CLASS_NAME = 31;
    static final int TOKEN_COUNT = 32;
    private static final int KEYWORD_COUNT = 4;
    private static final int PERCENT_KEYWORD_COUNT = 9;
    private static final int MIN_ASCII_CHAR = 0;
    private static final int MAX_ASCII_CHAR = 128;
    private static final int NEW_LINE = 10;
    private static final char ESCAPE = '\\';

    SmcLexer(InputStream stream, boolean debugFlag) {
        this._stream = stream;
        this._token = new Token();
        this._tokenBuffer = new StringBuilder();
        this._lineNumber = 1;
        this._readBuffer = new char[4098];
        this._bufferSize = 0;
        this._readIndex = 0;
        this._lexerFSM = new SmcLexerContext(this);
        this._lexerFSM.setDebugFlag(debugFlag);
    }

    int getLineNumber() {
        return this._lineNumber;
    }

    Token nextToken() throws IOException, IllegalAccessException, InvocationTargetException {
        Token retval = this._mode == 1 ? this.nextCookedToken() : (this._mode == 2 ? this.nextRawToken() : (this._mode == 3 ? this.nextParamTypeToken() : this.nextRaw3Token()));
        return retval;
    }

    void setRawMode(char openChar, char closeChar) {
        this._mode = 2;
        this._openChar = openChar;
        this._closeChar = closeChar;
    }

    void setRawMode(List<Character> openList, List<Character> closeList, List<Character> quoteList, char endChar, char separator) {
        this._mode = 3;
        this._openList = openList;
        this._closeList = closeList;
        this._quoteList = quoteList;
        this._endChar = endChar;
        this._separator = separator;
    }

    void setRawMode(String closeChars) {
        this._mode = 4;
        this._closeChars = closeChars;
    }

    void setCookedMode() {
        this._mode = 1;
    }

    void startToken() {
        this._token.reset();
        this._tokenBuffer.delete(0, this._tokenBuffer.length());
        this._token.setLineNumber(this._lineNumber);
    }

    void addToToken() {
        this._tokenBuffer.append(this._currentChar);
    }

    void outputChar() {
        System.out.println();
        System.out.print("Unknown character: 0x");
        System.out.println(Integer.toHexString(this._currentChar));
    }

    void addToToken(String s) {
        this._tokenBuffer.append(s);
    }

    void endToken(int type) {
        this._token.setType(type);
        this._token.setValue(this._tokenBuffer.toString());
        this._stopFlag = true;
    }

    void badToken(String error_msg) {
        this._token.setType(1);
        this._token.setValue(error_msg + " (token: " + this._tokenBuffer.toString() + ")");
        this._stopFlag = true;
    }

    void checkKeyword() {
        String tokenStr = this._tokenBuffer.toString();
        this._token.setValue(tokenStr);
        this._stopFlag = true;
        if (_KeywordMap.containsKey(tokenStr)) {
            this._token.setType(_KeywordMap.get(tokenStr));
        } else if (tokenStr.length() > 0) {
            this._token.setType(7);
        } else {
            this.badToken("Zero-length word");
        }
    }

    void checkPercentKeyword() {
        String tokenStr = this._tokenBuffer.toString();
        this._token.setValue(tokenStr);
        this._stopFlag = true;
        if (_PercentKeywordMap.containsKey(tokenStr)) {
            this._token.setType(_PercentKeywordMap.get(tokenStr));
        } else {
            this.badToken("Unknown % directive");
        }
    }

    void ungetChar() {
        if (this._readIndex > 0) {
            --this._readIndex;
        }
    }

    Token nextCookedToken() {
        try {
            Object[] args = new Object[]{};
            this._stopFlag = false;
            while (!this._stopFlag) {
                this._currentChar = this.readChar();
                if (this._currentChar >= _TransMethod.length) {
                    this._lexerFSM.unicode();
                    continue;
                }
                if (this._currentChar == '\n') {
                    ++this._lineNumber;
                }
                _TransMethod[this._currentChar].invoke((Object)this._lexerFSM, args);
            }
        }
        catch (EOFException e) {
            this._token.setType(2);
            this._token.setValue("");
        }
        catch (InvocationTargetException invokex) {
            this.badToken("Unknown token");
        }
        catch (Exception jex) {
            this.badToken(jex.getMessage() + " (token: " + this._tokenBuffer.toString() + ")");
        }
        return this._token;
    }

    private Token nextRawToken() throws IOException {
        int startLine = this._lineNumber;
        this.startToken();
        try {
            int depth = 0;
            this._stopFlag = false;
            while (!this._stopFlag) {
                this._currentChar = this.readChar();
                if (this._currentChar == this._closeChar && depth == 0) {
                    this._stopFlag = true;
                    continue;
                }
                this._tokenBuffer.append(this._currentChar);
                if (this._mode == 4) continue;
                if (this._currentChar == this._closeChar) {
                    --depth;
                    continue;
                }
                if (this._currentChar == this._openChar) {
                    ++depth;
                    continue;
                }
                if (this._currentChar != '\n') continue;
                ++this._lineNumber;
            }
            this._token.setType(24);
            this._token.setValue(this._tokenBuffer.toString());
            this._token.setLineNumber(startLine);
        }
        catch (EOFException e) {
            StringBuilder msg = new StringBuilder();
            msg.append("User source code contains an unbalanced ");
            msg.append(this._openChar);
            msg.append(", ");
            msg.append(this._closeChar);
            msg.append(" pair.");
            this._token.setType(1);
            this._token.setValue(msg.toString());
        }
        return this._token;
    }

    private Token nextRaw3Token() throws IOException {
        int startLine = this._lineNumber;
        this.startToken();
        try {
            this._stopFlag = false;
            while (!this._stopFlag) {
                this._currentChar = this.readChar();
                if (this._currentChar == '\n') {
                    ++this._lineNumber;
                }
                if (this._closeChars.indexOf(this._currentChar) >= 0) {
                    this._stopFlag = true;
                    continue;
                }
                this._tokenBuffer.append(this._currentChar);
            }
            this._token.setType(24);
            this._token.setValue(this._tokenBuffer.toString());
            this._token.setLineNumber(startLine);
        }
        catch (EOFException e) {
            this._token.setType(24);
            this._token.setValue(this._tokenBuffer.toString());
            this._token.setLineNumber(startLine);
        }
        return this._token;
    }

    private Token nextParamTypeToken() throws IOException {
        int startLine = this._lineNumber;
        int tokenType = 24;
        this.startToken();
        try {
            LinkedList<Character> depth = new LinkedList<Character>();
            boolean quoteFlag = false;
            int quoteChar = 32;
            boolean escapeFlag = false;
            this._stopFlag = false;
            while (!this._stopFlag) {
                this._currentChar = this.readChar();
                if ((this._currentChar == this._endChar || this._currentChar == this._separator) && depth.isEmpty() && !quoteFlag) {
                    this._stopFlag = true;
                    this.ungetChar();
                    continue;
                }
                this._tokenBuffer.append(this._currentChar);
                if (escapeFlag) {
                    escapeFlag = false;
                    continue;
                }
                if (this._currentChar == '\\') {
                    escapeFlag = true;
                    continue;
                }
                int quoteIndex = this._quoteList.indexOf(Character.valueOf(this._currentChar));
                if (quoteIndex >= 0) {
                    if (!quoteFlag) {
                        quoteFlag = true;
                        quoteChar = this._currentChar;
                        continue;
                    }
                    if (this._currentChar != quoteChar) continue;
                    quoteFlag = false;
                    quoteChar = 32;
                    continue;
                }
                if (quoteFlag) continue;
                int closeIndex = this._closeList.indexOf(Character.valueOf(this._currentChar));
                if (closeIndex >= 0) {
                    if (depth.isEmpty()) {
                        tokenType = 1;
                        this._tokenBuffer.delete(0, this._tokenBuffer.length());
                        this._tokenBuffer.append("'");
                        this._tokenBuffer.append(this._currentChar);
                        this._tokenBuffer.append("' has no matching '");
                        this._tokenBuffer.append(this._openList.get(closeIndex));
                        this._tokenBuffer.append("'.");
                        continue;
                    }
                    Character openChar = (Character)depth.removeFirst();
                    int openIndex = this._openList.indexOf(openChar);
                    if (closeIndex == openIndex) continue;
                    tokenType = 1;
                    this._tokenBuffer.delete(0, this._tokenBuffer.length());
                    this._tokenBuffer.append("'");
                    this._tokenBuffer.append(this._currentChar);
                    this._tokenBuffer.append("' does not match '");
                    this._tokenBuffer.append(openChar);
                    this._tokenBuffer.append("'.");
                    continue;
                }
                if (this._openList.contains(Character.valueOf(this._currentChar))) {
                    depth.addFirst(Character.valueOf(this._currentChar));
                    continue;
                }
                if (this._currentChar != '\n') continue;
                ++this._lineNumber;
            }
        }
        catch (EOFException e) {
            tokenType = 1;
            this._tokenBuffer.delete(0, this._tokenBuffer.length());
            this._tokenBuffer.append("User source code contains ");
            this._tokenBuffer.append("an unbalanced open, closing ");
            this._tokenBuffer.append(" pair.");
        }
        this._token.setType(tokenType);
        this._token.setValue(this._tokenBuffer.toString());
        this._token.setLineNumber(startLine);
        return this._token;
    }

    private char readChar() throws IOException, EOFException {
        if (this._readIndex == this._bufferSize) {
            int size;
            int offset = 0;
            int c = 0;
            if (this._bufferSize > 2) {
                offset = 2;
                this._readBuffer[0] = this._readBuffer[this._bufferSize - 2];
                this._readBuffer[1] = this._readBuffer[this._bufferSize - 1];
            } else if (this._bufferSize > 1) {
                offset = 1;
                this._readBuffer[0] = this._readBuffer[this._bufferSize - 1];
            }
            int index = offset;
            for (size = 0; size < 4096 && (c = this._stream.read()) >= 0; ++size) {
                this._readBuffer[index] = (char)c;
                ++index;
            }
            if (size == 0 && c < 0) {
                this._bufferSize = 0;
                throw new EOFException("end-of-file reached");
            }
            this._bufferSize = size + offset;
            this._readIndex = offset;
        }
        char retval = this._readBuffer[this._readIndex];
        ++this._readIndex;
        return retval;
    }

    static {
        String transName = "<not set>";
        _TypeName = new String[32];
        SmcLexer._TypeName[0] = "TOKEN_NOT_SET";
        SmcLexer._TypeName[1] = "DONE_FAILED";
        SmcLexer._TypeName[2] = "DONE_SUCCESS";
        SmcLexer._TypeName[3] = "ENTRY";
        SmcLexer._TypeName[4] = "EXIT";
        SmcLexer._TypeName[5] = "POP";
        SmcLexer._TypeName[6] = "PUSH";
        SmcLexer._TypeName[7] = "WORD";
        SmcLexer._TypeName[8] = "START_STATE";
        SmcLexer._TypeName[9] = "MAP_NAME";
        SmcLexer._TypeName[10] = "CLASS_NAME";
        SmcLexer._TypeName[11] = "HEADER_FILE";
        SmcLexer._TypeName[12] = "INCLUDE_FILE";
        SmcLexer._TypeName[13] = "PACKAGE_NAME";
        SmcLexer._TypeName[31] = "FSM_CLASS_NAME";
        SmcLexer._TypeName[14] = "IMPORT";
        SmcLexer._TypeName[15] = "DECLARE";
        SmcLexer._TypeName[16] = "LEFT_BRACE";
        SmcLexer._TypeName[17] = "RIGHT_BRACE";
        SmcLexer._TypeName[18] = "LEFT_BRACKET";
        SmcLexer._TypeName[19] = "LEFT_PAREN";
        SmcLexer._TypeName[20] = "RIGHT_PAREN";
        SmcLexer._TypeName[21] = "COMMA";
        SmcLexer._TypeName[22] = "COLON";
        SmcLexer._TypeName[22] = "SEMICOLON";
        SmcLexer._TypeName[24] = "SOURCE";
        SmcLexer._TypeName[25] = "EOD";
        SmcLexer._TypeName[26] = "SLASH";
        SmcLexer._TypeName[27] = "EQUAL";
        SmcLexer._TypeName[28] = "ACCESS";
        SmcLexer._TypeName[29] = "DOLLAR";
        SmcLexer._TypeName[30] = "JUMP";
        _KeywordMap = new HashMap<String, Integer>(4);
        _KeywordMap.put("Entry", 3);
        _KeywordMap.put("Exit", 4);
        _KeywordMap.put("jump", 30);
        _KeywordMap.put("pop", 5);
        _KeywordMap.put("push", 6);
        _PercentKeywordMap = new HashMap<String, Integer>(9);
        _PercentKeywordMap.put("%start", 8);
        _PercentKeywordMap.put("%map", 9);
        _PercentKeywordMap.put("%class", 10);
        _PercentKeywordMap.put("%header", 11);
        _PercentKeywordMap.put("%include", 12);
        _PercentKeywordMap.put("%package", 13);
        _PercentKeywordMap.put("%fsmclass", 31);
        _PercentKeywordMap.put("%import", 14);
        _PercentKeywordMap.put("%declare", 15);
        _PercentKeywordMap.put("%access", 28);
        _TransMethod = new Method[128];
        try {
            int i;
            Class<SmcLexerContext> fsmClass = SmcLexerContext.class;
            Class[] paramTypes = new Class[]{};
            transName = "unicode";
            Method unicode = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "whitespace";
            Method whitespace = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "alpha";
            Method alpha = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "digit";
            Method digit = fsmClass.getDeclaredMethod(transName, paramTypes);
            for (i = 0; i < 128; ++i) {
                SmcLexer._TransMethod[i] = unicode;
            }
            SmcLexer._TransMethod[9] = whitespace;
            SmcLexer._TransMethod[11] = whitespace;
            SmcLexer._TransMethod[12] = whitespace;
            SmcLexer._TransMethod[28] = whitespace;
            SmcLexer._TransMethod[29] = whitespace;
            SmcLexer._TransMethod[30] = whitespace;
            SmcLexer._TransMethod[31] = whitespace;
            SmcLexer._TransMethod[32] = whitespace;
            SmcLexer._TransMethod[10] = fsmClass.getDeclaredMethod("EOL", paramTypes);
            SmcLexer._TransMethod[13] = _TransMethod[10];
            for (i = 97; i <= 122; ++i) {
                SmcLexer._TransMethod[i] = alpha;
            }
            for (i = 65; i <= 90; ++i) {
                SmcLexer._TransMethod[i] = alpha;
            }
            for (i = 48; i <= 57; ++i) {
                SmcLexer._TransMethod[i] = digit;
            }
            transName = "percent";
            SmcLexer._TransMethod[37] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "left_paren";
            SmcLexer._TransMethod[40] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "right_paren";
            SmcLexer._TransMethod[41] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "asterisk";
            SmcLexer._TransMethod[42] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "comma";
            SmcLexer._TransMethod[44] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "period";
            SmcLexer._TransMethod[46] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "slash";
            SmcLexer._TransMethod[47] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "colon";
            SmcLexer._TransMethod[58] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "semicolon";
            SmcLexer._TransMethod[59] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "left_bracket";
            SmcLexer._TransMethod[91] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "underscore";
            SmcLexer._TransMethod[95] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "left_brace";
            SmcLexer._TransMethod[123] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "right_brace";
            SmcLexer._TransMethod[125] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "equal";
            SmcLexer._TransMethod[61] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "dollar";
            SmcLexer._TransMethod[36] = fsmClass.getDeclaredMethod(transName, paramTypes);
        }
        catch (NoSuchMethodException ex1) {
            System.err.println("INITIALIZATION ERROR! No such method as SmcLexerContext." + transName + ".");
            System.exit(1);
        }
        catch (SecurityException ex2) {
            System.err.println("INITIALIZATION ERROR! Not allowed to access SmcLexerContext." + transName + ".");
            System.exit(1);
        }
    }

    final class Token {
        private int _type = 0;
        private String _value = null;
        private int _lineNumber = -1;

        Token() {
        }

        int getType() {
            return this._type;
        }

        void setType(int type) {
            this._type = type;
        }

        String getValue() {
            return this._value;
        }

        void setValue(String value) {
            this._value = value;
        }

        int getLineNumber() {
            return this._lineNumber;
        }

        void setLineNumber(int line_number) {
            this._lineNumber = line_number;
        }

        Token copy() {
            Token retval = new Token();
            retval.setType(this._type);
            retval.setValue(this._value);
            retval.setLineNumber(this._lineNumber);
            return retval;
        }

        public String toString() {
            String output = new String("{");
            output = output + _TypeName[this._type];
            output = output + ", " + this._value + "}";
            return output;
        }

        private void reset() {
            this._type = 0;
            this._value = null;
            this._lineNumber = -1;
        }
    }
}

