/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcVisitor;

public final class SmcTransition
extends SmcElement
implements Comparable<SmcTransition> {
    private SmcState _state;
    private List<SmcParameter> _parameters;
    private List<SmcGuard> _guards;

    public SmcTransition(String name, List<SmcParameter> parameters, int lineNumber, SmcState state) {
        super(name, lineNumber);
        this._state = state;
        this._parameters = parameters;
        this._guards = new ArrayList<SmcGuard>();
    }

    @Override
    public void accept(SmcVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public int compareTo(SmcTransition trans) throws ClassCastException {
        int retval = this._name.compareTo(trans.getName());
        if (retval == 0) {
            retval = this._compareParams(trans.getParameters());
        }
        return retval;
    }

    public SmcState getState() {
        return this._state;
    }

    public List<SmcParameter> getParameters() {
        return this._parameters;
    }

    public List<SmcGuard> getGuards() {
        return this._guards;
    }

    public boolean hasCtxtReference() {
        Iterator<SmcGuard> guardIt = this._guards.iterator();
        boolean retcode = false;
        while (guardIt.hasNext() && !retcode) {
            retcode = guardIt.next().hasCtxtReference();
        }
        return retcode;
    }

    public boolean hasNonNilEndState() {
        Iterator<SmcGuard> guardIt = this._guards.iterator();
        boolean retcode = false;
        while (guardIt.hasNext() && !retcode) {
            SmcGuard guard = guardIt.next();
            retcode = !guard.getEndState().equals("nil");
        }
        return retcode;
    }

    public void addGuard(SmcGuard guard) {
        this._guards.add(guard);
    }

    public boolean equals(Object obj) {
        boolean retval;
        try {
            SmcTransition trans = (SmcTransition)obj;
            retval = this._name.equals(trans.getName()) && this._compareParams(trans.getParameters()) == 0;
        }
        catch (Exception jex) {
            retval = false;
        }
        return retval;
    }

    public int compareTo(String name, List<SmcParameter> parameters) {
        int retval = this._name.compareTo(name);
        if (retval == 0) {
            retval = this._compareParams(parameters);
        }
        return retval;
    }

    public String toString() {
        StringBuffer retval = new StringBuffer(512);
        retval.append(this._name);
        retval.append("(");
        Iterator<SmcParameter> pit = this._parameters.iterator();
        String sep = "";
        while (pit.hasNext()) {
            retval.append(sep);
            retval.append(pit.next());
            sep = ", ";
        }
        retval.append(")");
        if (!this._guards.isEmpty()) {
            for (SmcGuard guard : this._guards) {
                retval.append("\n");
                retval.append(guard);
            }
        }
        return retval.toString();
    }

    private int _compareParams(List<SmcParameter> params) {
        int retval = this._parameters.size() - params.size();
        if (retval == 0) {
            Iterator<SmcParameter> pit1 = this._parameters.iterator();
            Iterator<SmcParameter> pit2 = params.iterator();
            retval = 0;
            while (pit1.hasNext() && pit2.hasNext() && retval == 0) {
                SmcParameter param1 = pit1.next();
                SmcParameter param2 = pit2.next();
                retval = param1.compareTo(param2);
            }
        }
        return retval;
    }
}

