/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.SmcVisitor;

public final class SmcState
extends SmcElement {
    private final SmcMap _map;
    private final String _className;
    private final String _instanceName;
    private List<SmcAction> _entryActions;
    private List<SmcAction> _exitActions;
    private List<SmcTransition> _transitions;

    public SmcState(String name, int lineNumber, SmcMap map) {
        super(name, lineNumber);
        this._map = map;
        this._instanceName = name.compareToIgnoreCase("Default") == 0 ? "DefaultState" : name;
        String firstLetter = name.substring(0, 1);
        String remainder = name.substring(1);
        this._className = firstLetter.toUpperCase() + remainder;
        this._entryActions = null;
        this._exitActions = null;
        this._transitions = new ArrayList<SmcTransition>();
    }

    @Override
    public void accept(SmcVisitor visitor) {
        visitor.visit(this);
    }

    public SmcMap getMap() {
        return this._map;
    }

    @Override
    public String getName() {
        return this._className + "." + this._instanceName;
    }

    public String getClassName() {
        return this._className;
    }

    public String getInstanceName() {
        return this._instanceName;
    }

    public List<SmcAction> getEntryActions() {
        return this._entryActions;
    }

    public List<SmcAction> getExitActions() {
        return this._exitActions;
    }

    public List<SmcTransition> getTransitions() {
        return this._transitions;
    }

    public SmcTransition findTransition(String name, List<SmcParameter> parameters) {
        Iterator<SmcTransition> transIt = this._transitions.iterator();
        SmcTransition retval = null;
        while (transIt.hasNext() && retval == null) {
            SmcTransition transition = transIt.next();
            if (!name.equals(transition.getName()) || transition.compareTo(name, parameters) != 0) continue;
            retval = transition;
        }
        return retval;
    }

    public void setEntryActions(List<SmcAction> actions) {
        this._entryActions = new ArrayList<SmcAction>(actions);
    }

    public void setExitActions(List<SmcAction> actions) {
        this._exitActions = new ArrayList<SmcAction>(actions);
    }

    public void addTransition(SmcTransition transition) {
        if (!this._transitions.contains(transition)) {
            this._transitions.add(transition);
        }
    }

    public String toString() {
        StringBuffer retval = new StringBuffer();
        retval.append(this._instanceName);
        if (this._entryActions != null && this._entryActions.size() > 0) {
            retval.append("\n\tEntry {");
            for (SmcAction action : this._entryActions) {
                retval.append(action);
                retval.append('\n');
            }
            retval.append("}");
        }
        if (this._exitActions != null && this._exitActions.size() > 0) {
            retval.append("\n\tExit {");
            for (SmcAction action : this._exitActions) {
                retval.append(action);
                retval.append('\n');
            }
            retval.append("}");
        }
        for (SmcTransition transition : this._transitions) {
            retval.append("\n");
            retval.append(transition);
        }
        return retval.toString();
    }
}

