/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.SmcVisitor;

public final class SmcMap
extends SmcElement {
    private SmcFSM _fsm;
    private List<SmcState> _states;
    private SmcState _defaultState;
    private static int _StateId = 0;

    public SmcMap(String name, int lineNumber, SmcFSM fsm) {
        super(name, lineNumber);
        this._fsm = fsm;
        this._defaultState = null;
        this._states = new ArrayList<SmcState>();
    }

    @Override
    public void accept(SmcVisitor visitor) {
        visitor.visit(this);
    }

    public SmcFSM getFSM() {
        return this._fsm;
    }

    public List<SmcState> getStates() {
        return this._states;
    }

    public boolean findState(SmcState state) {
        Iterator<SmcState> it = this._states.iterator();
        boolean retval = false;
        while (it.hasNext() && !retval) {
            SmcState state2 = it.next();
            if (!state.getInstanceName().equals(state2.getInstanceName())) continue;
            retval = true;
        }
        return retval;
    }

    public boolean isKnownState(String stateName) {
        boolean retval;
        if (stateName.compareToIgnoreCase("default") == 0) {
            retval = this.hasDefaultState();
        } else {
            Iterator<SmcState> it = this._states.iterator();
            retval = false;
            while (it.hasNext() && !retval) {
                SmcState state = it.next();
                retval = stateName.equals(state.getInstanceName());
            }
        }
        return retval;
    }

    public boolean hasDefaultState() {
        return this._defaultState != null;
    }

    public SmcState getDefaultState() {
        return this._defaultState;
    }

    public List<SmcState> getAllStates() {
        ArrayList<SmcState> retval = new ArrayList<SmcState>(this._states);
        if (this._defaultState != null) {
            retval.add(this._defaultState);
        }
        return retval;
    }

    public List<SmcTransition> getTransitions() {
        List<Object> retval = this._defaultState != null ? new ArrayList<SmcTransition>(this._defaultState.getTransitions()) : new ArrayList();
        for (SmcState state : this._states) {
            List<SmcTransition> transList = state.getTransitions();
            retval = SmcMap.merge(transList, retval, new Comparator<SmcTransition>(){

                @Override
                public int compare(SmcTransition o1, SmcTransition o2) {
                    return o1.compareTo(o2);
                }
            });
        }
        return retval;
    }

    public List<SmcTransition> getUndefinedDefaultTransitions() {
        List<Object> definedDefaultTransitions;
        ArrayList<SmcTransition> retval = new ArrayList<SmcTransition>();
        if (this._defaultState == null) {
            definedDefaultTransitions = new ArrayList();
        } else {
            definedDefaultTransitions = this._defaultState.getTransitions();
            Collections.sort(definedDefaultTransitions, new Comparator<SmcTransition>(){

                @Override
                public int compare(SmcTransition o1, SmcTransition o2) {
                    return o1.compareTo(o2);
                }
            });
        }
        for (SmcState state : this._states) {
            for (SmcTransition transition : state.getTransitions()) {
                if (!transition.getName().equals("Default") || definedDefaultTransitions.contains(transition) || retval.contains(transition)) continue;
                retval.add(transition);
            }
        }
        return retval;
    }

    public boolean hasEntryActions() {
        for (SmcState state : this._states) {
            List<SmcAction> actions = state.getEntryActions();
            if (actions == null || actions.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasExitActions() {
        for (SmcState state : this._states) {
            List<SmcAction> actions = state.getExitActions();
            if (actions == null || actions.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static int getNextStateId() {
        return _StateId++;
    }

    public void addState(SmcState state) {
        if (state.getInstanceName().compareTo("DefaultState") == 0) {
            this._defaultState = state;
        } else {
            this._states.add(state);
        }
    }

    public String toString() {
        String retval = "%map " + this._name;
        if (this._defaultState != null) {
            retval = retval + "\n" + this._defaultState;
        }
        for (SmcState state : this._states) {
            retval = retval + "\n" + state;
        }
        return retval;
    }
}

