/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.model;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.SmcVisitor;

public final class SmcGuard
extends SmcElement {
    private SmcTransition _transition;
    private String _condition;
    private SmcElement.TransType _transType;
    private String _endState;
    private String _pushState;
    private String _popArgs;
    private List<SmcAction> _actions;

    public SmcGuard(String cond, int lineNumber, SmcTransition transition) {
        super(transition.getName(), lineNumber);
        this._transition = transition;
        this._condition = cond;
        this._endState = "";
        this._pushState = "";
        this._actions = null;
        this._popArgs = "";
    }

    @Override
    public void accept(SmcVisitor visitor) {
        visitor.visit(this);
    }

    public SmcTransition getTransition() {
        return this._transition;
    }

    public String getCondition() {
        return this._condition;
    }

    public SmcElement.TransType getTransType() {
        return this._transType;
    }

    public String getEndState() {
        return this._endState;
    }

    public String getPushState() {
        return this._pushState;
    }

    public String getPopArgs() {
        return this._popArgs;
    }

    public boolean hasCtxtReference() {
        boolean retcode = false;
        if (this._condition != null && (this._condition.indexOf("ctxt ") >= 0 || this._condition.indexOf("ctxt.") >= 0 || this._condition.indexOf("ctxt->") >= 0 || this._condition.indexOf("ctxt:") >= 0) || this._hasActions() || this._transType == SmcElement.TransType.TRANS_POP && this._popArgs != null && (this._popArgs.indexOf("ctxt ") >= 0 || this._popArgs.indexOf("ctxt.") >= 0 || this._popArgs.indexOf("ctxt->") >= 0 || this._popArgs.indexOf("ctxt:") >= 0)) {
            retcode = true;
        }
        return retcode;
    }

    public List<SmcAction> getActions() {
        return this._actions;
    }

    public void setTransType(SmcElement.TransType transType) {
        this._transType = transType;
    }

    public void setEndState(String endState) {
        this._endState = endState;
    }

    public void setPushState(String state) {
        this._pushState = state;
    }

    public void setPopArgs(String args) {
        this._popArgs = args;
    }

    public void setActions(List<SmcAction> actions) {
        this._actions = new ArrayList<SmcAction>(actions);
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print(this._name);
        if (this._condition.length() > 0) {
            pw.print(" [");
            pw.print(this._condition);
            pw.print("]");
        }
        switch (this._transType) {
            case TRANS_NOT_SET: {
                pw.print(" not set");
                break;
            }
            case TRANS_SET: 
            case TRANS_PUSH: {
                pw.print(" set");
                break;
            }
            case TRANS_POP: {
                pw.print(" pop");
            }
        }
        pw.print(" ");
        pw.print(this._endState);
        if (this._transType == SmcElement.TransType.TRANS_PUSH) {
            pw.print("/");
            pw.print(" push(");
            pw.print(this._pushState);
            pw.print(")");
        }
        pw.println(" {");
        if (!this._actions.isEmpty()) {
            for (SmcAction action : this._actions) {
                pw.print("    ");
                pw.print(action);
                pw.println(";");
            }
        }
        pw.print("}");
        return sw.toString();
    }

    private String _scopeStateName(String stateName, String mapName) {
        StringWriter retval = new StringWriter();
        int index = stateName.indexOf("::");
        if (index < 0) {
            retval.write(mapName);
            retval.write(".");
            retval.write(stateName);
        } else {
            retval.write(stateName.substring(0, index));
            retval.write(46);
            retval.write(stateName.substring(index + 2));
        }
        return retval.toString();
    }

    private boolean _hasActions() {
        boolean retcode = false;
        if (this._actions != null && !this._actions.isEmpty()) {
            Iterator<SmcAction> ait = this._actions.iterator();
            while (ait.hasNext() && !retcode) {
                SmcAction action = ait.next();
                retcode = !action.isEmptyStateStack();
            }
        }
        return retcode;
    }
}

