/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.model;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.SmcVisitor;

public final class SmcFSM
extends SmcElement {
    private String _startState = "";
    private String _source = "";
    private String _context = "";
    private String _sourceFileName;
    private String _fsmClassName;
    private String _header;
    private List<String> _includeList;
    private String _package;
    private List<String> _importList;
    private List<String> _declareList;
    private String _accessLevel;
    private int _headerLine;
    private List<SmcMap> _maps;

    public SmcFSM(String name, String sourceFile) {
        super(name, 1);
        this._sourceFileName = sourceFile;
        this._fsmClassName = name + "Context";
        this._header = "";
        this._includeList = new ArrayList<String>();
        this._package = null;
        this._importList = new ArrayList<String>();
        this._declareList = new ArrayList<String>();
        this._accessLevel = "";
        this._headerLine = -1;
        this._maps = new ArrayList<SmcMap>();
    }

    @Override
    public void accept(SmcVisitor visitor) {
        visitor.visit(this);
    }

    public String getSource() {
        return this._source;
    }

    public int getHeaderLine() {
        return this._headerLine;
    }

    public String getStartState() {
        return this._startState;
    }

    public String getContext() {
        return this._context;
    }

    public String getSourceFileName() {
        return this._sourceFileName;
    }

    public String getFsmClassName() {
        return this._fsmClassName;
    }

    public String getHeader() {
        return this._header;
    }

    public List<String> getIncludes() {
        return this._includeList;
    }

    public String getPackage() {
        return this._package;
    }

    public List<String> getImports() {
        return this._importList;
    }

    public int getImportCount() {
        return this._importList.size();
    }

    public int getDeclareCount() {
        return this._declareList.size();
    }

    public List<String> getDeclarations() {
        return this._declareList;
    }

    public String getAccessLevel() {
        return this._accessLevel;
    }

    public SmcMap findMap(String name) {
        SmcMap retval = null;
        Iterator<SmcMap> mapIt = this._maps.iterator();
        retval = null;
        while (mapIt.hasNext() && retval == null) {
            SmcMap map = mapIt.next();
            if (map.getName().compareTo(name) != 0) continue;
            retval = map;
        }
        return retval;
    }

    public List<SmcMap> getMaps() {
        return this._maps;
    }

    public List<SmcTransition> getTransitions() {
        Comparator<SmcTransition> comparator = new Comparator<SmcTransition>(){

            @Override
            public int compare(SmcTransition o1, SmcTransition o2) {
                return o1.compareTo(o2);
            }
        };
        List<SmcTransition> retval = new ArrayList<SmcTransition>();
        for (SmcMap map : this._maps) {
            retval = SmcFSM.merge(map.getTransitions(), retval, comparator);
        }
        return retval;
    }

    public boolean hasEntryActions() {
        for (SmcMap map : this._maps) {
            if (!map.hasEntryActions()) continue;
            return true;
        }
        return false;
    }

    public boolean hasExitActions() {
        for (SmcMap map : this._maps) {
            if (!map.hasExitActions()) continue;
            return true;
        }
        return false;
    }

    public void setSource(String source) {
        this._source = source;
    }

    public void setHeaderLine(int lineNumber) {
        if (this._headerLine < 0) {
            this._headerLine = lineNumber;
        }
    }

    public void setStartState(String state) {
        this._startState = state;
    }

    public void setContext(String context) {
        this._context = context;
    }

    public void setFsmClassName(String fsmName) {
        this._fsmClassName = fsmName;
        this._sourceFileName = fsmName;
    }

    public void setHeader(String header) {
        char c = header.charAt(0);
        this._header = c != '\"' && c != '<' ? "\"" + header.trim() + "\"" : header.trim();
        this._includeList.add(this._header);
    }

    public void addInclude(String includeFile) {
        char c = includeFile.charAt(0);
        String filename = c != '\"' && c != '<' ? "\"" + includeFile.trim() + "\"" : includeFile.trim();
        this._includeList.add(filename);
    }

    public void setPackage(String pkg) {
        this._package = pkg;
    }

    public void addImport(String name) {
        this._importList.add(name);
    }

    public void addDeclare(String name) {
        this._declareList.add(name);
    }

    public void setAccessLevel(String accessLevel) {
        this._accessLevel = accessLevel;
    }

    public void addMap(SmcMap map) {
        this._maps.add(map);
    }

    public void dump(PrintStream stream) {
        stream.print("Start State: ");
        stream.println(this._startState);
        stream.print("     Source:");
        if (this._source.length() == 0) {
            stream.println(" none.");
        } else {
            stream.println();
            stream.println(this._source);
        }
        stream.print("    Context: ");
        stream.println(this._context);
        for (String include : this._includeList) {
            stream.print("     Include: ");
            stream.println(include);
        }
        stream.println("       Maps:");
        stream.println();
        for (SmcMap map : this._maps) {
            stream.println(map);
        }
    }
}

