/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcVisitor;

public final class SmcAction
extends SmcElement
implements Comparable<SmcAction> {
    private List<String> _arguments;
    private boolean _propertyFlag;
    private boolean _staticFlag;
    private static final String EMPTY_STATE_STACK = "emptystatestack";

    public SmcAction(String name, int lineNumber) {
        super(name, lineNumber);
        this._arguments = null;
        this._propertyFlag = false;
        this._staticFlag = false;
    }

    public SmcAction(String name, int lineNumber, boolean propertyFlag, List<String> arguments) throws IllegalArgumentException {
        super(name, lineNumber);
        if (propertyFlag && (arguments == null || arguments.size() != 1)) {
            throw new IllegalArgumentException("property must have exactly one argument");
        }
        this._arguments = arguments;
        this._propertyFlag = propertyFlag;
    }

    @Override
    public void accept(SmcVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public int compareTo(SmcAction action) {
        int retval = 0;
        if (this != action && (retval = this._name.compareTo(action.getName())) == 0) {
            Iterator<String> ait1 = this._arguments.iterator();
            Iterator<String> ait2 = action._arguments.iterator();
            while (ait1.hasNext() && ait2.hasNext() && retval == 0) {
                String s1 = ait1.next();
                String s2 = ait2.next();
                retval = s1.compareTo(s2);
            }
        }
        return retval;
    }

    public boolean isProperty() {
        return this._propertyFlag;
    }

    public boolean isStatic() {
        return this._staticFlag;
    }

    public boolean isEmptyStateStack() {
        return EMPTY_STATE_STACK.equalsIgnoreCase(this.getName());
    }

    public List<String> getArguments() {
        return this._arguments;
    }

    public void setProperty(boolean flag) {
        this._propertyFlag = flag;
    }

    public void setArguments(List<String> args) throws IllegalArgumentException {
        if (this._propertyFlag && (args == null || args.size() != 1)) {
            throw new IllegalArgumentException("property must have exactly one argument");
        }
        this._arguments = new ArrayList<String>(args);
    }

    public String toString() {
        StringBuffer retval = new StringBuffer(40);
        retval.append(this._name);
        if (this._propertyFlag) {
            retval.append(" = ");
            retval.append(this._arguments.get(0));
        } else {
            retval.append('(');
            Iterator<String> ait = this._arguments.iterator();
            String sep = "";
            while (ait.hasNext()) {
                retval.append(sep);
                retval.append(ait.next());
                sep = ", ";
            }
            retval.append(')');
        }
        return retval.toString();
    }
}

