/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.SmcVisitor;

public final class SmcVBGenerator
extends SmcCodeGenerator {
    public SmcVBGenerator(SmcOptions options) {
        super(options, "vb");
    }

    public void visit(SmcFSM fsm) {
        int index;
        String separator;
        String rawSource = fsm.getSource();
        String packageName = fsm.getPackage();
        String context = fsm.getContext();
        String fsmClassName = fsm.getFsmClassName();
        String startState = fsm.getStartState();
        List maps = fsm.getMaps();
        if (rawSource != null && rawSource.length() > 0) {
            this._source.println(rawSource);
            this._source.println();
        }
        if (this._reflectFlag) {
            if (!this._genericFlag) {
                this._source.println("Imports System.Collections");
            } else {
                this._source.println("Imports System.Collections.Generic");
            }
        }
        for (String imp : fsm.getImports()) {
            this._source.print("Imports ");
            this._source.println(imp);
        }
        if (this._serialFlag) {
            this._source.println("Imports System.Runtime.Serialization");
        }
        this._source.println();
        if (packageName != null && packageName.length() > 0) {
            this._source.print("Namespace ");
            this._source.println(packageName);
            this._source.println();
            this._indent = "    ";
        }
        if (this._serialFlag) {
            this._source.print(this._indent);
            this._source.print("<Serializable()> ");
        }
        this._source.print(this._indent);
        this._source.print("Public NotInheritable Class ");
        this._source.print(fsmClassName);
        this._source.println("");
        this._source.print(this._indent);
        this._source.println("    Inherits statemap.FSMContext");
        if (this._serialFlag) {
            this._source.print(this._indent);
            this._source.println("    Implements ISerializable");
        }
        this._source.println();
        this._source.print(this._indent);
        this._source.println("    '------------------------------------------------------------");
        this._source.print(this._indent);
        this._source.println("    ' Member data");
        this._source.print(this._indent);
        this._source.println("    '");
        this._source.print(this._indent);
        this._source.println();
        this._source.print(this._indent);
        this._source.println("    ' The associated application class instance.");
        this._source.print(this._indent);
        this._source.print("    Private _owner As ");
        this._source.println(context);
        this._source.println();
        if (this._serialFlag || this._reflectFlag) {
            this._source.print(this._indent);
            this._source.println("    '------------------------------------------------------------");
            this._source.print(this._indent);
            this._source.println("    ' Shared data");
            this._source.print(this._indent);
            this._source.println("    '");
            this._source.println();
            this._source.print(this._indent);
            this._source.print("    ' State instance array. ");
            this._source.println("Used to deserialize.");
            this._source.print(this._indent);
            this._source.print("    Private Shared ReadOnly _States() As ");
            this._source.print(context);
            this._source.println("State = _");
            this._source.print(this._indent);
            this._source.print("        {");
            separator = " _";
            for (SmcMap map : maps) {
                String mapName = map.getName();
                for (SmcState state : map.getStates()) {
                    this._source.println(separator);
                    this._source.print(this._indent);
                    this._source.print("            ");
                    this._source.print(mapName);
                    this._source.print('.');
                    this._source.print(state.getClassName());
                    separator = ", _";
                }
            }
            this._source.println(" _");
            this._source.print(this._indent);
            this._source.println("        }");
            this._source.println();
        }
        this._source.print(this._indent);
        this._source.println("    '------------------------------------------------------------");
        this._source.print(this._indent);
        this._source.println("    ' Properties");
        this._source.print(this._indent);
        this._source.println("    '");
        this._source.println();
        this._source.print(this._indent);
        this._source.print("    Public Property State() As ");
        this._source.print(context);
        this._source.println("State");
        this._source.print(this._indent);
        this._source.println("        Get");
        this._source.print(this._indent);
        this._source.println("            If state_ Is Nothing _");
        this._source.print(this._indent);
        this._source.println("            Then");
        this._source.print(this._indent);
        this._source.print("                Throw ");
        this._source.println("New statemap.StateUndefinedException()");
        this._source.print(this._indent);
        this._source.println("            End If");
        this._source.println();
        this._source.print(this._indent);
        this._source.println("            Return state_");
        this._source.print(this._indent);
        this._source.println("        End Get");
        this._source.println();
        this._source.print(this._indent);
        this._source.print("        Set(ByVal state As ");
        this._source.print(context);
        this._source.println("State)");
        this._source.println();
        this._source.print(this._indent);
        this._source.println("            state_ = state");
        this._source.print(this._indent);
        this._source.println("        End Set");
        this._source.print(this._indent);
        this._source.println("    End Property");
        this._source.println();
        this._source.print(this._indent);
        this._source.print("    Public Property Owner() As ");
        this._source.println(context);
        this._source.print(this._indent);
        this._source.println("        Get");
        this._source.print(this._indent);
        this._source.println("            Return _owner");
        this._source.print(this._indent);
        this._source.println("        End Get");
        this._source.print(this._indent);
        this._source.print("        Set(ByVal owner As ");
        this._source.print(context);
        this._source.println(")");
        this._source.println();
        this._source.print(this._indent);
        this._source.println("            If owner Is Nothing _");
        this._source.print(this._indent);
        this._source.println("            Then");
        this._source.print(this._indent);
        this._source.println("                Throw New NullReferenceException");
        this._source.print(this._indent);
        this._source.println("            End If");
        this._source.println();
        this._source.print(this._indent);
        this._source.println("            _owner = owner");
        this._source.print(this._indent);
        this._source.println("        End Set");
        this._source.print(this._indent);
        this._source.println("    End Property");
        this._source.println();
        if (this._reflectFlag) {
            this._source.print(this._indent);
            this._source.print("    Public ReadOnly Property States() As ");
            this._source.print(context);
            this._source.println("State()");
            this._source.print(this._indent);
            this._source.println("        Get");
            this._source.print(this._indent);
            this._source.println("            Return _States");
            this._source.print(this._indent);
            this._source.println("        End Get");
            this._source.print(this._indent);
            this._source.println("    End Property");
            this._source.println();
        }
        String vbState = (index = startState.indexOf("::")) >= 0 ? startState.substring(0, index) + "." + startState.substring(index + 2) : startState;
        this._source.print(this._indent);
        this._source.println("    '------------------------------------------------------------");
        this._source.print(this._indent);
        this._source.println("    ' Member methods");
        this._source.print(this._indent);
        this._source.println("    '");
        this._source.println();
        this._source.print(this._indent);
        this._source.print("    Public Sub New(ByRef owner As ");
        this._source.print(context);
        this._source.println(")");
        this._source.println();
        this._source.print(this._indent);
        this._source.print("        MyBase.New(");
        this._source.print(vbState);
        this._source.println(")");
        this._source.print(this._indent);
        this._source.println("        _owner = owner");
        this._source.print(this._indent);
        this._source.println("    End Sub");
        this._source.println();
        this._source.print(this._indent);
        this._source.println("    Public Overrides Sub EnterStartState()");
        this._source.println();
        this._source.print(this._indent);
        this._source.println("        State.Entry(Me)");
        this._source.print(this._indent);
        this._source.println("    End Sub");
        this._source.println();
        List transitions = fsm.getTransitions();
        for (SmcTransition trans : transitions) {
            String indent2;
            if (trans.getName().equals("Default")) continue;
            this._source.print(this._indent);
            this._source.print("    Public Sub ");
            this._source.print(trans.getName());
            this._source.print("(");
            List params = trans.getParameters();
            Iterator pit = params.iterator();
            separator = "";
            while (pit.hasNext()) {
                this._source.print(separator);
                ((SmcParameter)pit.next()).accept((SmcVisitor)this);
                separator = ", ";
            }
            this._source.println(")");
            this._source.println();
            if (this._syncFlag) {
                this._source.print(this._indent);
                this._source.println("        SyncLock Me");
                indent2 = this._indent + "            ";
            } else {
                indent2 = this._indent + "        ";
            }
            this._source.print(indent2);
            this._source.print("transition_ = \"");
            this._source.print(trans.getName());
            this._source.println("\"");
            this._source.print(indent2);
            this._source.print("State.");
            this._source.print(trans.getName());
            this._source.print("(Me");
            for (SmcParameter param : params) {
                this._source.print(", ");
                this._source.print(param.getName());
            }
            this._source.println(")");
            this._source.print(indent2);
            this._source.println("transition_ = \"\"");
            if (this._syncFlag) {
                this._source.print(this._indent);
                this._source.println("        End SyncLock");
            }
            this._source.print(this._indent);
            this._source.println("    End Sub");
            this._source.println();
        }
        if (this._serialFlag) {
            this._source.print(this._indent);
            this._source.print("    Public Function ValueOf(");
            this._source.print("ByVal stateId As Integer) As ");
            this._source.print(context);
            this._source.println("State");
            this._source.println();
            this._source.print(this._indent);
            this._source.println("        Return _States(stateId)");
            this._source.print(this._indent);
            this._source.println("    End Function");
            this._source.println();
            this._source.print(this._indent);
            this._source.print("    Private Sub GetObjectData(");
            this._source.println("ByVal info As SerializationInfo, _");
            this._source.print(this._indent);
            this._source.print("                              ");
            this._source.println("ByVal context As StreamingContext) _");
            this._source.print(this._indent);
            this._source.print("            ");
            this._source.println("Implements ISerializable.GetObjectData");
            this._source.println();
            this._source.print(this._indent);
            this._source.println("        Dim stackSize As Integer = 0");
            this._source.print(this._indent);
            this._source.println("        Dim index As Integer");
            this._source.print(this._indent);
            this._source.println("        Dim it As IEnumerator");
            this._source.println();
            this._source.print(this._indent);
            this._source.println("        If Not IsNothing(stateStack_) _");
            this._source.print(this._indent);
            this._source.println("        Then");
            this._source.print(this._indent);
            this._source.println("            stackSize = stateStack_.Count");
            this._source.print(this._indent);
            this._source.println("            it = stateStack_.GetEnumerator()");
            this._source.print(this._indent);
            this._source.println("        End If");
            this._source.println();
            this._source.print(this._indent);
            this._source.print("        ");
            this._source.println("info.AddValue(\"stackSize\", stackSize)");
            this._source.println();
            this._source.print(this._indent);
            this._source.println("        index = 0");
            this._source.print(this._indent);
            this._source.println("        While index < stackSize");
            this._source.print(this._indent);
            this._source.println("            it.MoveNext()");
            this._source.print(this._indent);
            this._source.println("            info.AddValue( _");
            this._source.print(this._indent);
            this._source.print("                ");
            this._source.println("String.Concat(\"stackItem\", index), _");
            this._source.print(this._indent);
            this._source.println("                              it.Current.Id)");
            this._source.print(this._indent);
            this._source.println("            index += 1");
            this._source.print(this._indent);
            this._source.println("        End While");
            this._source.println();
            this._source.print(this._indent);
            this._source.println("        info.AddValue(\"state\", state_.Id)");
            this._source.print(this._indent);
            this._source.println("    End Sub");
            this._source.println();
            this._source.print(this._indent);
            this._source.print("    Private Sub New(");
            this._source.println("ByVal info As SerializationInfo, _");
            this._source.print(this._indent);
            this._source.print("                    ");
            this._source.println("ByVal context As StreamingContext)");
            this._source.println();
            this._source.print(this._indent);
            this._source.println("        MyBase.New(Nothing)");
            this._source.println();
            this._source.print(this._indent);
            this._source.println("        Dim stackSize As Integer");
            this._source.print(this._indent);
            this._source.println("        Dim stateId As Integer");
            this._source.println();
            this._source.print(this._indent);
            this._source.print("        stackSize = ");
            this._source.println("info.GetInt32(\"stackSize\")");
            this._source.print(this._indent);
            this._source.println("        If stackSize > 0 _");
            this._source.print(this._indent);
            this._source.println("        Then");
            this._source.print(this._indent);
            this._source.println("            Dim index As Integer");
            this._source.println();
            this._source.print(this._indent);
            this._source.println("            stateStack_ = New Stack()");
            this._source.print(this._indent);
            this._source.println("            index = stackSize - 1");
            this._source.print(this._indent);
            this._source.println("            While index >= 0");
            this._source.print(this._indent);
            this._source.println("                stateId = _");
            this._source.print(this._indent);
            this._source.println("                    info.GetInt32( _");
            this._source.print(this._indent);
            this._source.print("                        ");
            this._source.println("String.Concat(\"stackItem\", index))");
            this._source.print(this._indent);
            this._source.print("                    ");
            this._source.println("stateStack_.Push(_States(stateId))");
            this._source.print(this._indent);
            this._source.println("                    index -= 1");
            this._source.print(this._indent);
            this._source.println("            End While");
            this._source.print(this._indent);
            this._source.println("        End If");
            this._source.println();
            this._source.print(this._indent);
            this._source.println("        stateId = info.GetInt32(\"state\")");
            this._source.print(this._indent);
            this._source.println("        state_ = _States(stateId)");
            this._source.println();
            this._source.print(this._indent);
            this._source.println("    End Sub");
            this._source.println();
        }
        this._source.print(this._indent);
        this._source.println("End Class");
        this._source.println();
        this._source.print(this._indent);
        this._source.print("Public MustInherit Class ");
        this._source.print(context);
        this._source.println("State");
        this._source.print(this._indent);
        this._source.println("    Inherits statemap.State");
        this._source.println();
        if (this._reflectFlag) {
            this._source.print(this._indent);
            this._source.println("    '------------------------------------------------------------");
            this._source.print(this._indent);
            this._source.println("    ' Properties");
            this._source.print(this._indent);
            this._source.println("    '");
            this._source.println();
            this._source.print(this._indent);
            this._source.print("    Public MustOverride ReadOnly ");
            this._source.print("Property Transitions() As IDictionary");
            if (this._genericFlag) {
                this._source.print("(Of String, Integer)");
            }
            this._source.println();
            this._source.println();
        }
        this._source.print(this._indent);
        this._source.println("    '------------------------------------------------------------");
        this._source.print(this._indent);
        this._source.println("    ' Member methods");
        this._source.print(this._indent);
        this._source.println("    '");
        this._source.println();
        this._source.print(this._indent);
        this._source.print("    Protected Sub New(");
        this._source.println("ByVal name As String, ByVal id As Integer)");
        this._source.println();
        this._source.print(this._indent);
        this._source.println("        MyBase.New(name, id)");
        this._source.print(this._indent);
        this._source.println("    End Sub");
        this._source.println();
        this._source.print(this._indent);
        this._source.print("    Public Overridable Sub Entry(");
        this._source.print("ByRef context As ");
        this._source.print(fsmClassName);
        this._source.println(")");
        this._source.print(this._indent);
        this._source.println("    End Sub");
        this._source.println();
        this._source.print(this._indent);
        this._source.print("    Public Overridable Sub Exit_(");
        this._source.print("ByRef context As ");
        this._source.print(fsmClassName);
        this._source.println(")");
        this._source.print(this._indent);
        this._source.println("    End Sub");
        this._source.println();
        for (SmcTransition trans : transitions) {
            if (trans.getName().equals("Default")) continue;
            this._source.print(this._indent);
            this._source.print("    Public Overridable Sub ");
            this._source.print(trans.getName());
            this._source.print("(ByRef context As ");
            this._source.print(fsmClassName);
            this._source.print("");
            for (SmcParameter param : trans.getParameters()) {
                this._source.print(", ");
                param.accept((SmcVisitor)this);
            }
            this._source.println(")");
            this._source.println();
            this._source.print(this._indent);
            this._source.println("        Default_(context)");
            this._source.print(this._indent);
            this._source.println("    End Sub");
            this._source.println();
        }
        this._source.print(this._indent);
        this._source.print("    Public Overridable Sub Default_(");
        this._source.print("ByRef context As ");
        this._source.print(fsmClassName);
        this._source.println(")");
        this._source.println();
        if (this._debugLevel >= 0) {
            this._source.println("#If TRACE Then");
            this._source.print(this._indent);
            this._source.print("        Trace.WriteLine(");
            this._source.println("\"TRANSITION   : Default\")");
            this._source.println("#End If");
            this._source.println();
        }
        this._source.print(this._indent);
        this._source.print("        Throw ");
        this._source.println("New statemap.TransitionUndefinedException( _");
        this._source.print(this._indent);
        this._source.println("            String.Concat(\"State: \", _");
        this._source.print(this._indent);
        this._source.println("               context.State.Name, _");
        this._source.print(this._indent);
        this._source.println("               \", Transition: \", _");
        this._source.print(this._indent);
        this._source.println("               context.GetTransition()))");
        this._source.print(this._indent);
        this._source.println("    End Sub");
        this._source.print(this._indent);
        this._source.println("End Class");
        for (SmcMap map : maps) {
            map.accept((SmcVisitor)this);
        }
        if (packageName != null && packageName.length() > 0) {
            this._source.println();
            this._source.println("End Namespace");
        }
    }

    public void visit(SmcMap map) {
        SmcState defaultState = map.getDefaultState();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        List states = map.getStates();
        ArrayList definedDefaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList();
        this._source.println();
        this._source.print(this._indent);
        this._source.print("Public MustInherit Class ");
        this._source.println(mapName);
        this._source.println();
        this._source.print(this._indent);
        this._source.println("    '------------------------------------------------------------");
        this._source.print(this._indent);
        this._source.println("    ' Shared data");
        this._source.print(this._indent);
        this._source.println("    '");
        this._source.println();
        for (SmcState state : states) {
            String stateName = state.getClassName();
            this._source.print(this._indent);
            this._source.print("    Public Shared ");
            this._source.print(state.getInstanceName());
            this._source.print(" As ");
            this._source.print(mapName);
            this._source.print('_');
            this._source.print(stateName);
            this._source.println(" = _");
            this._source.print(this._indent);
            this._source.print("        New ");
            this._source.print(mapName);
            this._source.print('_');
            this._source.print(stateName);
            this._source.print("(\"");
            this._source.print(mapName);
            this._source.print('.');
            this._source.print(stateName);
            this._source.print("\", ");
            this._source.print(map.getNextStateId());
            this._source.println(")");
        }
        this._source.print(this._indent);
        this._source.print("    Private Shared Default_ As ");
        this._source.print(mapName);
        this._source.println("_Default = _");
        this._source.print(this._indent);
        this._source.print("        New ");
        this._source.print(mapName);
        this._source.print("_Default(\"");
        this._source.print(mapName);
        this._source.println(".Default\", -1)");
        this._source.println();
        this._source.print(this._indent);
        this._source.println("End Class");
        this._source.println();
        this._source.print(this._indent);
        this._source.print("Public Class ");
        this._source.print(mapName);
        this._source.println("_Default");
        this._source.print(this._indent);
        this._source.print("    Inherits ");
        this._source.print(context);
        this._source.println("State");
        this._source.println();
        if (this._reflectFlag) {
            this._source.print(this._indent);
            this._source.println("    '------------------------------------------------------------");
            this._source.print(this._indent);
            this._source.println("    ' Properties");
            this._source.print(this._indent);
            this._source.println("    '");
            this._source.println();
            this._source.print(this._indent);
            this._source.print("    Public Overrides ReadOnly ");
            this._source.print("Property Transitions() As IDictionary");
            if (this._genericFlag) {
                this._source.print("(of String, Integer)");
            }
            this._source.println();
            this._source.print(this._indent);
            this._source.println("        Get");
            this._source.println();
            this._source.print(this._indent);
            this._source.println("            Return _transitions");
            this._source.print(this._indent);
            this._source.println("        End Get");
            this._source.print(this._indent);
            this._source.println("    End Property");
            this._source.println();
        }
        this._source.print(this._indent);
        this._source.println("    '------------------------------------------------------------");
        this._source.print(this._indent);
        this._source.println("    ' Member methods");
        this._source.print(this._indent);
        this._source.println("    '");
        this._source.println();
        this._source.print(this._indent);
        this._source.print("    Public Sub New(");
        this._source.println("ByVal name As String, ByVal id As Integer)");
        this._source.println();
        this._source.print(this._indent);
        this._source.println("        MyBase.New(name, id)");
        this._source.print(this._indent);
        this._source.println("    End Sub");
        this._source.println();
        for (SmcTransition transition : definedDefaultTransitions) {
            transition.accept((SmcVisitor)this);
        }
        if (this._reflectFlag) {
            List allTransitions = map.getFSM().getTransitions();
            this._source.println();
            this._source.print(this._indent);
            this._source.println("    '------------------------------------------------------------");
            this._source.print(this._indent);
            this._source.println("    ' Shared data");
            this._source.print(this._indent);
            this._source.println("    '");
            this._source.println();
            this._source.print(this._indent);
            this._source.print("    ");
            this._source.print("Private Shared _transitions As IDictionary");
            if (this._genericFlag) {
                this._source.print("(Of String, Integer)");
            }
            this._source.println();
            this._source.println();
            this._source.print(this._indent);
            this._source.println("    Shared Sub New()");
            this._source.println();
            this._source.print(this._indent);
            this._source.print("        ");
            this._source.print("_transitions = New ");
            if (!this._genericFlag) {
                this._source.print("Hashtable");
            } else {
                this._source.print("Dictionary(Of String, Integer)");
            }
            this._source.println("()");
            for (SmcTransition transition : allTransitions) {
                String transName = transition.getName();
                int transDefinition = definedDefaultTransitions.contains(transition) ? 2 : 0;
                this._source.print(this._indent);
                this._source.print("        ");
                this._source.print("_transitions.Add(\"");
                this._source.print(transName);
                this._source.print("\", ");
                this._source.print(transDefinition);
                this._source.println(")");
            }
            this._source.println();
            this._source.print(this._indent);
            this._source.println("    End Sub");
        }
        this._source.print(this._indent);
        this._source.println("End Class");
        for (SmcState state : states) {
            state.accept((SmcVisitor)this);
        }
    }

    public void visit(SmcState state) {
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String fsmClassName = map.getFSM().getFsmClassName();
        String mapName = map.getName();
        this._source.println();
        this._source.print(this._indent);
        this._source.print("Public NotInheritable Class ");
        this._source.print(mapName);
        this._source.print('_');
        this._source.println(state.getClassName());
        this._source.print(this._indent);
        this._source.print("    Inherits ");
        this._source.print(mapName);
        this._source.println("_Default");
        this._source.println();
        if (this._reflectFlag) {
            this._source.print(this._indent);
            this._source.println("    '------------------------------------------------------------");
            this._source.print(this._indent);
            this._source.println("    ' Properties");
            this._source.print(this._indent);
            this._source.println("    '");
            this._source.println();
            this._source.print(this._indent);
            this._source.print("    Public Overrides ReadOnly ");
            this._source.print("Property Transitions() As IDictionary");
            if (this._genericFlag) {
                this._source.print("(Of String, Integer)");
            }
            this._source.println();
            this._source.print(this._indent);
            this._source.println("        Get");
            this._source.println();
            this._source.print(this._indent);
            this._source.println("            Return _transitions");
            this._source.print(this._indent);
            this._source.println("        End Get");
            this._source.print(this._indent);
            this._source.println("    End Property");
            this._source.println();
        }
        this._source.print(this._indent);
        this._source.println("    '------------------------------------------------------------");
        this._source.print(this._indent);
        this._source.println("    ' Member methods");
        this._source.print(this._indent);
        this._source.println("    '");
        this._source.println();
        this._source.print(this._indent);
        this._source.print("    Public Sub New(");
        this._source.println("ByVal name As String, ByVal id As Integer)");
        this._source.println();
        this._source.print(this._indent);
        this._source.println("        MyBase.New(name, id)");
        this._source.print(this._indent);
        this._source.println("    End Sub");
        List actions = state.getEntryActions();
        if (actions != null && actions.size() > 0) {
            this._source.println();
            this._source.print(this._indent);
            this._source.print("    Public Overrides Sub Entry(");
            this._source.print("ByRef context As ");
            this._source.print(fsmClassName);
            this._source.println(")");
            this._source.println();
            this._source.print(this._indent);
            this._source.print("       Dim ctxt As ");
            this._source.print(context);
            this._source.println(" = context.Owner");
            this._source.println();
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
            this._source.print(this._indent);
            this._source.println("    End Sub");
        }
        if ((actions = state.getExitActions()) != null && actions.size() > 0) {
            this._source.println();
            this._source.print(this._indent);
            this._source.print("    Public Overrides Sub Exit(");
            this._source.print("ByRef context As ");
            this._source.print(fsmClassName);
            this._source.println(")");
            this._source.println();
            this._source.print(this._indent);
            this._source.print("        Dim ctxt As ");
            this._source.print(context);
            this._source.println(" = context.Owner");
            this._source.println();
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
            this._source.print(this._indent);
            this._source.println("    End Sub");
        }
        for (SmcTransition transition : state.getTransitions()) {
            transition.accept((SmcVisitor)this);
        }
        if (this._reflectFlag) {
            List allTransitions = map.getFSM().getTransitions();
            List stateTransitions = state.getTransitions();
            SmcState defaultState = map.getDefaultState();
            ArrayList defaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList();
            this._source.println();
            this._source.print(this._indent);
            this._source.println("    '------------------------------------------------------------");
            this._source.print(this._indent);
            this._source.println("    ' Shared data");
            this._source.print(this._indent);
            this._source.println("    '");
            this._source.println();
            this._source.print(this._indent);
            this._source.print("    ");
            this._source.print("Private Shared _transitions As IDictionary");
            if (this._genericFlag) {
                this._source.print("(Of String, Integer)");
            }
            this._source.println();
            this._source.println();
            this._source.print(this._indent);
            this._source.println("    Shared Sub New()");
            this._source.println();
            this._source.print(this._indent);
            this._source.print("        ");
            this._source.print("_transitions = New ");
            if (!this._genericFlag) {
                this._source.print("Hashtable");
            } else {
                this._source.print("Dictionary(Of String, Integer)");
            }
            this._source.println("()");
            for (SmcTransition transition : allTransitions) {
                String transName = transition.getName();
                int transDefinition = stateTransitions.contains(transition) ? 1 : (defaultTransitions.contains(transition) ? 2 : 0);
                this._source.print(this._indent);
                this._source.print("        ");
                this._source.print("_transitions.Add(\"");
                this._source.print(transName);
                this._source.print("\", ");
                this._source.print(transDefinition);
                this._source.println(")");
            }
            this._source.println();
            this._source.print(this._indent);
            this._source.println("    End Sub");
        }
        this._source.print(this._indent);
        this._source.println("End Class");
    }

    public void visit(SmcTransition transition) {
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String fsmClassName = map.getFSM().getFsmClassName();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        List parameters = transition.getParameters();
        List guards = transition.getGuards();
        boolean nullCondition = false;
        this._source.println();
        this._source.print(this._indent);
        this._source.print("    Public Overrides Sub ");
        if (transName.equals("Default")) {
            this._source.print("Default_");
        } else {
            this._source.print(transName);
        }
        this._source.print("(ByRef context As ");
        this._source.print(fsmClassName);
        this._source.print("");
        for (SmcParameter param : parameters) {
            this._source.print(", ");
            param.accept((SmcVisitor)this);
        }
        this._source.println(")");
        this._source.println();
        if (transition.hasCtxtReference()) {
            this._source.print(this._indent);
            this._source.print("        Dim ctxt As ");
            this._source.print(context);
            this._source.println(" = context.Owner");
        }
        if (this._debugLevel >= 0) {
            this._source.println("#If TRACE Then");
            this._source.print(this._indent);
            this._source.println("        Trace.WriteLine( _");
            this._source.print(this._indent);
            this._source.print("            \"LEAVING STATE   : ");
            this._source.print(mapName);
            this._source.print(".");
            this._source.print(stateName);
            this._source.println("\")");
            this._source.println("#End If");
            this._source.println();
        }
        Iterator git = guards.iterator();
        this._guardIndex = 0;
        this._guardCount = guards.size();
        while (git.hasNext()) {
            SmcGuard guard = (SmcGuard)git.next();
            if (guard.getCondition().length() == 0) {
                nullCondition = true;
            }
            guard.accept((SmcVisitor)this);
            ++this._guardIndex;
        }
        if (this._guardIndex > 0 && !nullCondition) {
            this._source.println();
            this._source.print(this._indent);
            this._source.println("        Else");
            this._source.print(this._indent);
            this._source.print("            MyBase.");
            this._source.print(transName);
            this._source.print("(context");
            for (SmcParameter param : parameters) {
                this._source.print(", ");
                this._source.print(param.getName());
            }
            this._source.println(")");
            this._source.print(this._indent);
            this._source.println("        End If");
        } else if (this._guardCount > 1) {
            this._source.print(this._indent);
            this._source.println("        End If");
            this._source.println();
        }
        this._source.print(this._indent);
        this._source.println("    End Sub");
    }

    public void visit(SmcGuard guard) {
        String indent2;
        String sep;
        Iterator pit;
        List parameters;
        String indent1;
        SmcTransition transition = guard.getTransition();
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        SmcElement.TransType transType = guard.getTransType();
        boolean loopbackFlag = false;
        String endStateName = guard.getEndState();
        String fqEndStateName = "";
        String pushStateName = guard.getPushState();
        String condition = guard.getCondition();
        List actions = guard.getActions();
        if (transType != SmcElement.TransType.TRANS_POP && endStateName.length() > 0 && !endStateName.equals("nil")) {
            endStateName = this.scopeStateName(endStateName, mapName);
        }
        stateName = this.scopeStateName(stateName, mapName);
        pushStateName = this.scopeStateName(pushStateName, mapName);
        loopbackFlag = this.isLoopback(transType, endStateName);
        if (this._guardCount > 1) {
            indent1 = this._indent + "            ";
            if (this._guardIndex == 0 && condition.length() > 0) {
                this._source.print(this._indent);
                this._source.print("        If ");
                this._source.print(condition);
                this._source.println(" _");
                this._source.print(this._indent);
                this._source.println("        Then");
            } else if (condition.length() > 0) {
                this._source.println();
                this._source.print(this._indent);
                this._source.print("        ElseIf ");
                this._source.print(condition);
                this._source.println(" _");
                this._source.print(this._indent);
                this._source.println("        Then");
            } else {
                this._source.println();
                this._source.print(this._indent);
                this._source.println("        Else");
            }
        } else if (condition.length() == 0) {
            indent1 = this._indent + "        ";
        } else {
            indent1 = this._indent + "            ";
            this._source.print(this._indent);
            this._source.print("        If ");
            this._source.print(condition);
            this._source.println(" _");
            this._source.print(this._indent);
            this._source.println("        Then");
        }
        if (actions.size() == 0) {
            fqEndStateName = endStateName;
        } else if (loopbackFlag) {
            fqEndStateName = "endState";
            this._source.print(this._indent);
            this._source.print("Dim ");
            this._source.print(fqEndStateName);
            this._source.print(" As ");
            this._source.print(context);
            this._source.println("State = context.State");
            this._source.println();
        } else {
            fqEndStateName = endStateName;
        }
        if (transType == SmcElement.TransType.TRANS_POP || !loopbackFlag) {
            if (this._debugLevel >= 1) {
                this._source.println("#If TRACE Then");
                this._source.print(indent1);
                this._source.println("Trace.WriteLine( _");
                this._source.print(indent1);
                this._source.print("    \"BEFORE EXIT     : ");
                this._source.print(stateName);
                this._source.println(".Exit_(context)\")");
                this._source.println("#End If");
                this._source.println();
            }
            this._source.print(indent1);
            this._source.println("context.State.Exit_(context)");
            if (this._debugLevel >= 1) {
                this._source.println("#If TRACE Then");
                this._source.print(indent1);
                this._source.println("Trace.WriteLine( _");
                this._source.print(indent1);
                this._source.print("    \"AFTER EXIT      : ");
                this._source.print(stateName);
                this._source.println(".Exit_(context)\")");
                this._source.println("#End If");
                this._source.println();
            }
        }
        if (this._debugLevel >= 0) {
            parameters = transition.getParameters();
            this._source.println("#If TRACE Then");
            this._source.print(indent1);
            this._source.println("Trace.WriteLine( _");
            this._source.print(indent1);
            this._source.print("    \"ENTER TRANSITION: ");
            this._source.print(stateName);
            this._source.print(".");
            this._source.print(transName);
            this._source.print("(");
            pit = parameters.iterator();
            sep = "";
            while (pit.hasNext()) {
                this._source.print(sep);
                ((SmcParameter)pit.next()).accept((SmcVisitor)this);
                sep = ", ";
            }
            this._source.println(")\")");
            this._source.println("#End If");
            this._source.println();
        }
        if (actions.size() == 0) {
            if (condition.length() > 0) {
                this._source.print(indent1);
                this._source.println("' No actions.");
            }
            indent2 = indent1;
        } else {
            this._source.print(indent1);
            this._source.println("context.ClearState()");
            if (!this._noCatchFlag) {
                this._source.print(indent1);
                this._source.println("Try");
                indent2 = indent1 + "    ";
            } else {
                indent2 = indent1;
            }
            String tempIndent = this._indent;
            this._indent = indent2;
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
            this._indent = tempIndent;
            if (!this._noCatchFlag) {
                this._source.print(indent1);
                this._source.println("Finally");
            }
        }
        if (this._debugLevel >= 0) {
            parameters = transition.getParameters();
            this._source.println("#If TRACE Then");
            this._source.print(indent2);
            this._source.println("Trace.WriteLine( _");
            this._source.print(indent2);
            this._source.print("    \"EXIT TRANSITION : ");
            this._source.print(stateName);
            this._source.print(".");
            this._source.print(transName);
            this._source.print("(");
            pit = parameters.iterator();
            sep = "";
            while (pit.hasNext()) {
                this._source.print(sep);
                ((SmcParameter)pit.next()).accept((SmcVisitor)this);
                sep = ", ";
            }
            this._source.println(")\")");
            this._source.println("#End If");
            this._source.println();
        }
        if (!(transType != SmcElement.TransType.TRANS_SET || actions.size() <= 0 && loopbackFlag)) {
            this._source.print(indent2);
            this._source.print("context.State = ");
            this._source.println(fqEndStateName);
        } else if (transType == SmcElement.TransType.TRANS_PUSH) {
            if (!loopbackFlag || actions.size() > 0) {
                this._source.print(indent2);
                this._source.print("context.State = ");
                this._source.println(fqEndStateName);
            }
            if (!loopbackFlag) {
                if (this._debugLevel >= 1) {
                    this._source.println("#If TRACE Then");
                    this._source.print(indent1);
                    this._source.println("Trace.WriteLine( _");
                    this._source.print(indent1);
                    this._source.print("    \"BEFORE ENTRY    : ");
                    this._source.print(stateName);
                    this._source.println(".Entry(context)\")");
                    this._source.println("#End If");
                    this._source.println();
                }
                this._source.print(indent2);
                this._source.println("context.State.Entry(context)");
                if (this._debugLevel >= 1) {
                    this._source.println("#If TRACE Then");
                    this._source.print(indent1);
                    this._source.println("Trace.WriteLine( _");
                    this._source.print(indent1);
                    this._source.print("    \"AFTER ENTRY     : ");
                    this._source.print(stateName);
                    this._source.println(".Entry(context)\")");
                    this._source.println("#End If");
                    this._source.println();
                }
            }
            this._source.print(indent2);
            this._source.print("context.PushState(");
            this._source.print(pushStateName);
            this._source.println(")");
        } else if (transType == SmcElement.TransType.TRANS_POP) {
            this._source.print(indent1);
            this._source.println("context.PopState()");
        }
        if (transType == SmcElement.TransType.TRANS_SET && !loopbackFlag || transType == SmcElement.TransType.TRANS_PUSH) {
            if (this._debugLevel >= 1) {
                this._source.println("#If TRACE Then");
                this._source.print(indent2);
                this._source.println("Trace.WriteLine( _");
                this._source.print(indent2);
                this._source.print("    \"BEFORE ENTRY    : ");
                this._source.print(stateName);
                this._source.println(".Entry(context)\")");
                this._source.println("#End If");
                this._source.println();
            }
            this._source.print(indent2);
            this._source.println("context.State.Entry(context)");
            if (this._debugLevel >= 1) {
                this._source.println("#If TRACE Then");
                this._source.print(indent2);
                this._source.println("Trace.WriteLine( _");
                this._source.print(indent2);
                this._source.print("    \"AFTER ENTRY     : ");
                this._source.print(stateName);
                this._source.println(".Entry(context)\")");
                this._source.println("#End If");
                this._source.println();
            }
        }
        if (actions.size() > 0 && !this._noCatchFlag) {
            this._source.print(indent1);
            this._source.println("End Try");
        }
        if (transType == SmcElement.TransType.TRANS_POP && !endStateName.equals("nil") && endStateName.length() > 0) {
            String popArgs = guard.getPopArgs();
            this._source.println();
            this._source.print(indent1);
            this._source.print("context.");
            this._source.print(endStateName);
            this._source.print("(");
            if (popArgs.length() > 0) {
                this._source.print(popArgs);
            }
            this._source.println(")");
        }
    }

    public void visit(SmcAction action) {
        String name = action.getName();
        List arguments = action.getArguments();
        this._source.print(this._indent);
        if (action.isEmptyStateStack()) {
            this._source.println("context.EmptyStateStack()");
        } else {
            if (!action.isStatic()) {
                this._source.print("ctxt.");
            }
            this._source.print(name);
            if (action.isProperty()) {
                String arg = (String)arguments.get(0);
                this._source.print(" = ");
                this._source.println(arg.substring(0, arg.indexOf(59)));
            } else {
                this._source.print("(");
                Iterator it = arguments.iterator();
                String sep = "";
                while (it.hasNext()) {
                    this._source.print(sep);
                    this._source.print((String)it.next());
                    sep = ", ";
                }
                this._source.println(")");
            }
        }
    }

    public void visit(SmcParameter parameter) {
        this._source.print("ByVal ");
        this._source.print(parameter.getName());
        this._source.print(" As ");
        this._source.print(parameter.getType());
    }
}

