/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.SmcVisitor;

public final class SmcTclGenerator
extends SmcCodeGenerator {
    private String _pkgScope;

    public SmcTclGenerator(SmcOptions options) {
        super(options, "tcl");
    }

    public void visit(SmcFSM fsm) {
        String mapName;
        String context = fsm.getContext();
        String fsmClassName = fsm.getFsmClassName();
        String rawSource = fsm.getSource();
        String packageName = fsm.getPackage();
        String startState = fsm.getStartState();
        List maps = fsm.getMaps();
        int index = 0;
        this._source.println("# ex: set ro:");
        this._source.println("# DO NOT EDIT.");
        this._source.println("# generated by smc (http://smc.sourceforge.net/)");
        this._source.print("# from file : ");
        this._source.print(this._srcfileBase);
        this._source.println(".sm");
        this._source.println();
        if (rawSource != null && rawSource.length() > 0) {
            this._source.println(rawSource);
            this._source.println();
        }
        for (String imp : fsm.getImports()) {
            this._source.print("package require ");
            this._source.print(imp);
            this._source.println(";");
        }
        this._source.println();
        if (packageName != null && packageName.length() > 0) {
            this._source.print("namespace eval ");
            this._source.print(packageName);
            this._source.println(" {");
            this._source.println();
            this._indent = "    ";
            this._pkgScope = "::" + packageName + "::";
        } else {
            this._indent = "";
            this._pkgScope = "";
        }
        this._source.print(this._indent);
        this._source.print("class ");
        this._source.print(fsmClassName);
        this._source.println(" {");
        this._source.print(this._indent);
        this._source.println("    inherit ::statemap::FSMContext;");
        this._source.println();
        this._source.print(this._indent);
        this._source.println("# Member functions.");
        this._source.println();
        this._source.print(this._indent);
        this._source.println("    constructor {owner} {");
        this._source.print(this._indent);
        this._source.print("        ::statemap::FSMContext::constructor ${");
        this._source.print(this._pkgScope);
        this._source.print(startState);
        this._source.println("};");
        this._source.print(this._indent);
        this._source.println("    } {");
        this._source.print(this._indent);
        this._source.println("        set _owner $owner;");
        this._source.print(this._indent);
        this._source.println("    }");
        List transitions = fsm.getTransitions();
        for (SmcTransition trans : transitions) {
            List params = trans.getParameters();
            if (trans.getName().equals("Default")) continue;
            this._source.println();
            this._source.print(this._indent);
            this._source.print("    public method ");
            this._source.print(trans.getName());
            this._source.print(" {");
            Iterator pit = params.iterator();
            String separator = "";
            while (pit.hasNext()) {
                this._source.print(separator);
                ((SmcParameter)pit.next()).accept((SmcVisitor)this);
                separator = " ";
            }
            this._source.println("} {");
            this._source.print(this._indent);
            this._source.print("        [getState] ");
            this._source.print(trans.getName());
            this._source.print(" $this");
            for (SmcParameter param : params) {
                this._source.print(" $");
                this._source.print(param.getName());
            }
            this._source.println(";");
            this._source.print(this._indent);
            this._source.println("        return -code ok;");
            this._source.print(this._indent);
            this._source.println("    }");
        }
        this._source.println();
        this._source.print(this._indent);
        this._source.println("    public method getOwner {} {");
        this._source.print(this._indent);
        this._source.println("        return -code ok $_owner;");
        this._source.print(this._indent);
        this._source.println("    }");
        if (this._serialFlag) {
            this._source.println();
            this._source.print(this._indent);
            this._source.println("    public method valueOf {id} {");
            this._source.print(this._indent);
            this._source.println("        if {$id < $MIN_ID || $id > $MAX_ID} {");
            this._source.print(this._indent);
            this._source.println("            set retcode error;");
            this._source.print(this._indent);
            this._source.print("            set retval ");
            this._source.println("\"$id is out of bounds\";");
            this._source.print(this._indent);
            this._source.println("        } else {");
            this._source.print(this._indent);
            this._source.println("            set retcode ok;");
            this._source.print(this._indent);
            this._source.println("            set retval $_States($id);");
            this._source.print(this._indent);
            this._source.println("        }");
            this._source.println();
            this._source.print(this._indent);
            this._source.println("        return -code $retcode $retval;");
            this._source.print(this._indent);
            this._source.println("    }");
        }
        if (this._reflectFlag) {
            this._source.println();
            this._source.print(this._indent);
            this._source.println("    public method getStates {} {");
            this._source.print(this._indent);
            this._source.println("        set retval [list];");
            this._source.println();
            this._source.print(this._indent);
            this._source.println("         foreach name [array names _States] {");
            this._source.print(this._indent);
            this._source.println("            lappend retval $_States($name);");
            this._source.print(this._indent);
            this._source.println("        }");
            this._source.println();
            this._source.print(this._indent);
            this._source.println("        return -code ok ${retval};");
            this._source.print(this._indent);
            this._source.println("    }");
        }
        this._source.println();
        this._source.print(this._indent);
        this._source.println("# Member data.");
        this._source.println();
        this._source.print(this._indent);
        this._source.println("    private variable _owner;");
        if (this._serialFlag) {
            this._source.print(this._indent);
            this._source.println("    private common MIN_ID;");
            this._source.print(this._indent);
            this._source.println("    private common MAX_ID;");
        }
        if (this._serialFlag || this._reflectFlag) {
            this._source.print(this._indent);
            this._source.println("    private common _States;");
        }
        this._source.print(this._indent);
        this._source.println("}");
        this._source.println();
        this._source.print(this._indent);
        this._source.print("class ");
        this._source.print(context);
        this._source.println("State {");
        this._source.print(this._indent);
        this._source.println("    inherit ::statemap::State;");
        this._source.println();
        this._source.print(this._indent);
        this._source.println("# Member functions.");
        this._source.println();
        this._source.print(this._indent);
        this._source.println("    constructor {name id} {");
        this._source.print(this._indent);
        this._source.println("        ::statemap::State::constructor $name $id;");
        this._source.print(this._indent);
        this._source.println("    } {}");
        this._source.println();
        this._source.print(this._indent);
        this._source.println("    public method Entry {context} {};");
        this._source.print(this._indent);
        this._source.println("    public method Exit {context} {};");
        for (SmcTransition trans : transitions) {
            String transName = trans.getName();
            if (transName.equals("Default")) continue;
            this._source.println();
            this._source.print(this._indent);
            this._source.print("    public method ");
            this._source.print(transName);
            this._source.print(" {context");
            for (SmcParameter param : trans.getParameters()) {
                this._source.print(" ");
                param.accept((SmcVisitor)this);
            }
            this._source.println("} {");
            this._source.print(this._indent);
            this._source.println("        Default $context;");
            this._source.print(this._indent);
            this._source.println("        return -code ok;");
            this._source.print(this._indent);
            this._source.println("    }");
        }
        this._source.println();
        this._source.print(this._indent);
        this._source.println("    public method Default {context} {");
        this._source.print(this._indent);
        this._source.println("        set transition [$context getTransition];");
        this._source.print(this._indent);
        this._source.print("        return -code error ");
        this._source.print("\"Transition \\\"$transition\\\" ");
        this._source.print("fell through to a ");
        this._source.println("non-existent default definition.\";");
        this._source.print(this._indent);
        this._source.println("    }");
        this._source.print(this._indent);
        this._source.println("}");
        this._source.println();
        for (SmcMap map : maps) {
            map.accept((SmcVisitor)this);
        }
        this._source.print(this._indent);
        this._source.println("# Static state declarations.");
        for (SmcMap map : maps) {
            mapName = map.getName();
            for (SmcState state : map.getStates()) {
                this._source.print(this._indent);
                this._source.print("set ");
                this._source.print(mapName);
                this._source.print("::");
                this._source.print(state.getInstanceName());
                this._source.print(" ");
                if (packageName != null && packageName.length() > 0) {
                    this._source.print(packageName);
                    this._source.print("::");
                }
                this._source.print("[");
                this._source.print(mapName);
                this._source.print("_");
                this._source.print(state.getClassName());
                this._source.print(" #auto \"");
                this._source.print(mapName);
                this._source.print("::");
                this._source.print(state.getClassName());
                this._source.print("\" ");
                this._source.print(index);
                this._source.println("];");
                ++index;
            }
        }
        if (this._reflectFlag) {
            this._source.println();
            this._source.print(this._indent);
            this._source.println("# Static state transitions.");
            for (SmcMap map : maps) {
                SmcState defaultState = map.getDefaultState();
                List defaultTransitions = defaultState.getTransitions();
                List<Object> stateTransitions = new ArrayList<SmcTransition>();
                this._reflectTransitions(defaultState, stateTransitions, defaultTransitions, transitions);
                for (SmcState state : map.getStates()) {
                    stateTransitions = state.getTransitions();
                    this._reflectTransitions(state, stateTransitions, defaultTransitions, transitions);
                    ++index;
                }
            }
        }
        if (this._serialFlag) {
            this._source.print(this._indent);
            this._source.print("set ");
            this._source.print(fsmClassName);
            this._source.println("::MIN_ID 0;");
            this._source.print(this._indent);
            this._source.print("set ");
            this._source.print(fsmClassName);
            this._source.print("::MAX_ID ");
            this._source.print(index - 1);
            this._source.println(";");
        }
        if (this._serialFlag || this._reflectFlag) {
            this._source.print(this._indent);
            this._source.print("array set ");
            this._source.print(fsmClassName);
            this._source.print("::_States [list");
            index = 0;
            for (SmcMap map : maps) {
                mapName = map.getName();
                for (SmcState state : map.getStates()) {
                    this._source.print(" ");
                    this._source.print(index);
                    this._source.print(" ${");
                    this._source.print(mapName);
                    this._source.print("::");
                    this._source.print(state.getInstanceName());
                    this._source.print("}");
                    ++index;
                }
            }
            this._source.println("];");
        }
        if (packageName != null && packageName.length() > 0) {
            this._source.println("}");
        }
        this._source.println();
        this._source.println("# Local variables:");
        this._source.println("#  buffer-read-only: t");
        this._source.println("# End:");
    }

    public void visit(SmcMap map) {
        SmcState defaultState = map.getDefaultState();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        List states = map.getStates();
        ArrayList definedDefaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList();
        this._source.print(this._indent);
        this._source.print("class ");
        this._source.print(mapName);
        this._source.println(" {");
        this._source.print(this._indent);
        this._source.println("# Member data.");
        this._source.println();
        for (SmcState state : states) {
            this._source.print(this._indent);
            this._source.print("    public common ");
            this._source.print(state.getClassName());
            this._source.println(" \"\";");
        }
        this._source.print(this._indent);
        this._source.println("}");
        this._source.println();
        this._source.print(this._indent);
        this._source.print("class ");
        this._source.print(mapName);
        this._source.println("_Default {");
        this._source.print(this._indent);
        this._source.print("    inherit ");
        this._source.print(context);
        this._source.println("State;");
        this._source.println();
        this._source.print(this._indent);
        this._source.println("# Member functions.");
        this._source.println();
        this._source.print(this._indent);
        this._source.println("    constructor {name id} {");
        this._source.print(this._indent);
        this._source.print("       ");
        this._source.print(context);
        this._source.println("State::constructor $name $id;");
        this._source.print(this._indent);
        this._source.println("    } {}");
        if (this._reflectFlag) {
            this._source.println();
            this._source.print(this._indent);
            this._source.println("    public method getTransitions {} {");
            this._source.print(this._indent);
            this._source.print("        ");
            this._source.println("return -code ok [array get _transitions];");
            this._source.println("    }");
        }
        if (defaultState != null) {
            for (SmcTransition transition : definedDefaultTransitions) {
                transition.accept((SmcVisitor)this);
            }
        }
        if (this._reflectFlag) {
            this._source.println();
            this._source.print(this._indent);
            this._source.println("# Member data.");
            this._source.println();
            this._source.print(this._indent);
            this._source.println("    public common _transitions;");
        }
        this._source.print(this._indent);
        this._source.println("}");
        this._source.println();
        for (SmcState state : states) {
            state.accept((SmcVisitor)this);
        }
        this._source.println();
    }

    public void visit(SmcState state) {
        List actions;
        String mapName = state.getMap().getName();
        String stateName = state.getClassName();
        this._source.print(this._indent);
        this._source.print("class ");
        this._source.print(mapName);
        this._source.print("_");
        this._source.print(stateName);
        this._source.println(" {");
        this._source.print(this._indent);
        this._source.print("    inherit ");
        this._source.print(mapName);
        this._source.println("_Default;");
        this._source.println();
        this._source.print(this._indent);
        this._source.println("    constructor {name id} {");
        this._source.print(this._indent);
        this._source.print("        ");
        this._source.print(mapName);
        this._source.println("_Default::constructor $name $id;");
        this._source.print(this._indent);
        this._source.println("    } {}");
        if (this._reflectFlag) {
            this._source.println();
            this._source.print(this._indent);
            this._source.println("    public method getTransitions {} {");
            this._source.print(this._indent);
            this._source.print("        ");
            this._source.println("return -code ok [array get _transitions];");
            this._source.println("    }");
        }
        if ((actions = state.getEntryActions()) != null && actions.size() > 0) {
            this._source.println();
            this._source.print(this._indent);
            this._source.println("    public method Entry {context} {");
            this._source.println("        set ctxt [$context getOwner];");
            this._source.println();
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
            this._source.println();
            this._source.print(this._indent);
            this._source.println("        return -code ok;");
            this._source.print(this._indent);
            this._source.println("    }");
        }
        if ((actions = state.getExitActions()) != null && actions.size() > 0) {
            this._source.println();
            this._source.print(this._indent);
            this._source.println("    public method Exit {context} {");
            this._source.println("        set ctxt [$context getOwner];");
            this._source.println();
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
            this._source.print(this._indent);
            this._source.println("        return -code ok;");
            this._source.print(this._indent);
            this._source.println("    }");
        }
        for (SmcTransition transition : state.getTransitions()) {
            transition.accept((SmcVisitor)this);
        }
        if (this._reflectFlag) {
            this._source.println();
            this._source.print(this._indent);
            this._source.println("# Member data.");
            this._source.println();
            this._source.print(this._indent);
            this._source.println("    public common _transitions;");
        }
        this._source.print(this._indent);
        this._source.println("}");
        this._source.println();
    }

    public void visit(SmcTransition transition) {
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        List parameters = transition.getParameters();
        List guards = transition.getGuards();
        boolean nullCondition = false;
        this._source.println();
        this._source.print(this._indent);
        this._source.print("    public method ");
        this._source.print(transName);
        this._source.print(" {context");
        for (SmcParameter param : parameters) {
            this._source.print(" ");
            param.accept((SmcVisitor)this);
        }
        this._source.println("} {");
        if (transition.hasCtxtReference()) {
            this._source.print(this._indent);
            this._source.println("        set ctxt [$context getOwner];");
        }
        if (stateName.equals("Default")) {
            this._source.print(this._indent);
            this._source.print("        set _transition \"");
            this._source.print(transName);
            this._source.println("\";");
        } else {
            this._source.println();
        }
        if (this._debugLevel >= 0) {
            this._source.print(this._indent);
            this._source.println("        if {[$context getDebugFlag] != 0} {");
            this._source.print(this._indent);
            this._source.print("            puts [$context getDebugStream] ");
            this._source.print("\"LEAVING STATE   : ");
            this._source.print(mapName);
            this._source.print("::");
            this._source.print(stateName);
            this._source.println("\";");
            this._source.print(this._indent);
            this._source.println("        }");
            this._source.println();
        }
        Iterator git = guards.iterator();
        this._guardIndex = 0;
        this._guardCount = guards.size();
        while (git.hasNext()) {
            SmcGuard guard = (SmcGuard)git.next();
            if (guard.getCondition().length() == 0) {
                nullCondition = true;
            }
            guard.accept((SmcVisitor)this);
            ++this._guardIndex;
        }
        if (this._guardIndex > 0 && !nullCondition) {
            if (this._guardCount == 1) {
                this._source.print(this._indent);
                this._source.print("        }");
            }
            this._source.println(" else {");
            this._source.print(this._indent);
            this._source.print("            ");
            this._source.print(mapName);
            this._source.print("_Default ");
            this._source.print(transName);
            this._source.print(" $context");
            for (SmcParameter param : parameters) {
                this._source.print(" ");
                this._source.print(param.getName());
            }
            this._source.println(";");
            this._source.print(this._indent);
            this._source.println("        }");
            this._source.println();
        } else {
            this._source.println();
        }
        this._source.print(this._indent);
        this._source.println("        return -code ok;");
        this._source.print(this._indent);
        this._source.println("    }");
    }

    public void visit(SmcGuard guard) {
        String indent3;
        String sep;
        Iterator pit;
        List parameters;
        String indent2;
        SmcTransition transition = guard.getTransition();
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        SmcElement.TransType transType = guard.getTransType();
        boolean loopbackFlag = false;
        String endStateName = guard.getEndState();
        String fqEndStateName = "";
        String pushStateName = guard.getPushState();
        String condition = guard.getCondition();
        List actions = guard.getActions();
        if (transType != SmcElement.TransType.TRANS_POP && endStateName.length() > 0 && !endStateName.equals("nil") && endStateName.indexOf("::") < 0) {
            endStateName = mapName + "::" + endStateName;
        }
        if (stateName.indexOf("::") < 0) {
            stateName = mapName + "::" + stateName;
        }
        if (pushStateName != null && pushStateName.length() > 0 && pushStateName.indexOf("::") < 0) {
            pushStateName = mapName + "::" + pushStateName;
        }
        loopbackFlag = this.isLoopback(transType, endStateName);
        if (this._guardCount > 1) {
            if (this._guardIndex == 0 && condition.length() > 0) {
                this._source.print(this._indent);
                this._source.print("        if {");
                this._source.print(condition);
                this._source.println("} {");
            } else if (condition.length() > 0) {
                this._source.print(" elseif {");
                this._source.print(condition);
                this._source.println("} {");
            } else {
                this._source.println(" else {");
            }
            indent2 = this._indent + "            ";
        } else if (condition.length() == 0) {
            indent2 = this._indent + "        ";
        } else {
            indent2 = this._indent + "            ";
            this._source.print(this._indent);
            this._source.print("        if {");
            this._source.print(condition);
            this._source.println("} {");
        }
        if (transType != SmcElement.TransType.TRANS_POP) {
            if (actions.size() == 0 && endStateName.length() != 0) {
                endStateName = "${" + this._pkgScope + endStateName + "}";
            } else if (actions.size() > 0) {
                if (loopbackFlag) {
                    endStateName = "${EndStateName}";
                    this._source.print(indent2);
                    this._source.println("set EndStateName [$context getState];");
                } else {
                    endStateName = "${" + this._pkgScope + endStateName + "}";
                }
            }
        }
        if (transType == SmcElement.TransType.TRANS_POP || !loopbackFlag) {
            if (this._debugLevel >= 1) {
                this._source.print(indent2);
                this._source.println("if {[$context getDebugFlag] != 0} {");
                this._source.print(indent2);
                this._source.print("    puts [$context getDebugStream] ");
                this._source.print("\"BEFORE EXIT     : \\[");
                this._source.print(stateName);
                this._source.println("\\] Exit $context\";");
                this._source.print(indent2);
                this._source.println("}");
                this._source.println();
            }
            this._source.print(indent2);
            this._source.println("[$context getState] Exit $context;");
            if (this._debugLevel >= 1) {
                this._source.println();
                this._source.print(indent2);
                this._source.println("if {[$context getDebugFlag] != 0} {");
                this._source.print(indent2);
                this._source.print("    puts [$context getDebugStream] ");
                this._source.print("\"AFTER EXIT      : \\[");
                this._source.print(stateName);
                this._source.println("\\] Exit $context\";");
                this._source.print(indent2);
                this._source.println("}");
                this._source.println();
            }
        }
        if (this._debugLevel >= 0) {
            parameters = transition.getParameters();
            this._source.print(indent2);
            this._source.println("if {[$context getDebugFlag] != 0} {");
            this._source.print(indent2);
            this._source.print("    puts [$context getDebugStream] ");
            this._source.print("\"ENTER TRANSITION: ");
            this._source.print(stateName);
            this._source.print(" ");
            this._source.print(transName);
            this._source.print("(");
            pit = parameters.iterator();
            sep = "";
            while (pit.hasNext()) {
                this._source.print(sep);
                ((SmcParameter)pit.next()).accept((SmcVisitor)this);
                sep = ", ";
            }
            this._source.println(")\";");
            this._source.print(indent2);
            this._source.println("}");
            this._source.println();
        }
        if (actions.size() == 0) {
            indent3 = indent2;
            if (condition.length() > 0) {
                this._source.print(indent2);
                this._source.println("# No actions.");
            }
        } else {
            this._source.print(indent2);
            this._source.println("$context clearState;");
            if (!this._noCatchFlag) {
                indent3 = indent2 + "    ";
                this._source.print(indent2);
                this._source.println("if [catch {");
            } else {
                indent3 = indent2;
            }
            String indent4 = this._indent;
            this._indent = indent3;
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
            this._indent = indent4;
            if (this._debugLevel >= 0) {
                parameters = transition.getParameters();
                this._source.print(indent3);
                this._source.println("if {[$context getDebugFlag] != 0} {");
                this._source.print(indent3);
                this._source.print("    puts [$context getDebugStream] ");
                this._source.print("\"EXIT TRANSITION : ");
                this._source.print(stateName);
                this._source.print(" ");
                this._source.print(transName);
                this._source.print("(");
                pit = parameters.iterator();
                sep = "";
                while (pit.hasNext()) {
                    this._source.print(sep);
                    ((SmcParameter)pit.next()).accept((SmcVisitor)this);
                    sep = ", ";
                }
                this._source.println(")\";");
                this._source.print(indent3);
                this._source.println("}");
                this._source.println();
            }
            if (!this._noCatchFlag) {
                this._source.print(indent2);
                this._source.println("} result] {");
                if (transType == SmcElement.TransType.TRANS_SET) {
                    this._source.print(indent3);
                    this._source.print("$context setState ");
                    this._source.print(endStateName);
                    this._source.println(";");
                } else if (transType == SmcElement.TransType.TRANS_PUSH) {
                    this._source.print(indent3);
                    this._source.print("$context setState ");
                    this._source.print(endStateName);
                    this._source.println(";");
                    if (!loopbackFlag) {
                        if (this._debugLevel >= 1) {
                            this._source.println();
                            this._source.print(indent3);
                            this._source.println("if {[$context getDebugFlag] != 0} {");
                            this._source.print(indent3);
                            this._source.print("    puts [$context getDebugStream] ");
                            this._source.print("\"BEFORE ENTRY    : \\[");
                            this._source.print(stateName);
                            this._source.println("\\] Entry $context\";");
                            this._source.print(indent3);
                            this._source.println("}");
                            this._source.println();
                        }
                        this._source.println();
                        this._source.print(indent3);
                        this._source.println("[$context getState] Entry $context;");
                        this._source.println();
                        if (this._debugLevel >= 1) {
                            this._source.println();
                            this._source.print(indent3);
                            this._source.println("if {[$context getDebugFlag] != 0} {");
                            this._source.print(indent3);
                            this._source.print("    puts [$context getDebugStream] ");
                            this._source.print("\"AFTER ENTRY     : \\[");
                            this._source.print(stateName);
                            this._source.println("\\] Exit $context\";");
                            this._source.print(indent3);
                            this._source.println("}");
                            this._source.println();
                        }
                    }
                    this._source.print(indent3);
                    this._source.print("$context pushState ${");
                    this._source.print(this._pkgScope);
                    this._source.print(pushStateName);
                    this._source.println("};");
                } else if (transType == SmcElement.TransType.TRANS_POP) {
                    this._source.print(indent3);
                    this._source.println("$context popState;");
                }
                this._source.print(indent3);
                this._source.println("error $result;");
                this._source.print(indent2);
                this._source.println("} else {");
            }
        }
        if (!(transType != SmcElement.TransType.TRANS_SET || actions.size() <= 0 && loopbackFlag)) {
            this._source.print(indent3);
            this._source.print("$context setState ");
            this._source.print(endStateName);
            this._source.println(";");
        } else if (transType == SmcElement.TransType.TRANS_PUSH) {
            if (!loopbackFlag || actions.size() > 0) {
                this._source.print(indent3);
                this._source.print("$context setState ");
                this._source.print(endStateName);
                this._source.println(";");
            }
            if (!loopbackFlag) {
                if (this._debugLevel >= 1) {
                    this._source.println();
                    this._source.print(indent3);
                    this._source.println("if {[$context getDebugFlag] != 0} {");
                    this._source.print(indent3);
                    this._source.print("    puts [$context getDebugStream] ");
                    this._source.print("\"BEFORE ENTRY    : \\[");
                    this._source.print(stateName);
                    this._source.println("\\] Exit $context\";");
                    this._source.print(indent3);
                    this._source.println("}");
                    this._source.println();
                }
                this._source.println();
                this._source.print(indent3);
                this._source.println("[$context getState] Entry $context;");
                this._source.println();
                if (this._debugLevel >= 1) {
                    this._source.println();
                    this._source.print(indent3);
                    this._source.println("if {[$context getDebugFlag] != 0} {");
                    this._source.print(indent3);
                    this._source.print("    puts [$context getDebugStream] ");
                    this._source.print("\"AFTER ENTRY     : \\[");
                    this._source.print(stateName);
                    this._source.println("\\] Entry $context\";");
                    this._source.print(indent3);
                    this._source.println("}");
                    this._source.println();
                }
            }
            this._source.print(indent3);
            this._source.print("$context pushState ${");
            this._source.print(this._pkgScope);
            this._source.print(pushStateName);
            this._source.println("};");
        } else if (transType == SmcElement.TransType.TRANS_POP) {
            this._source.print(indent3);
            this._source.println("$context popState;");
        }
        if (actions.size() > 0 && !this._noCatchFlag) {
            this._source.print(indent2);
            this._source.println("}");
        }
        if (transType == SmcElement.TransType.TRANS_SET && !loopbackFlag || transType == SmcElement.TransType.TRANS_PUSH) {
            if (this._debugLevel >= 1) {
                this._source.println();
                this._source.print(indent2);
                this._source.println("if {[$context getDebugFlag] != 0} {");
                this._source.print(indent2);
                this._source.print("    puts [$context getDebugStream] ");
                this._source.print("\"BEFORE ENTRY    : \\[");
                this._source.print(stateName);
                this._source.println("\\] Entry $context\";");
                this._source.print(indent2);
                this._source.println("}");
                this._source.println();
            }
            this._source.print(indent2);
            this._source.println("[$context getState] Entry $context;");
            if (this._debugLevel >= 1) {
                this._source.println();
                this._source.print(indent2);
                this._source.println("if {[$context getDebugFlag] != 0} {");
                this._source.print(indent2);
                this._source.print("    puts [$context getDebugStream] ");
                this._source.print("\"AFTER ENTRY     : \\[");
                this._source.print(stateName);
                this._source.println("\\] Entry $context\";");
                this._source.print(indent2);
                this._source.println("}");
                this._source.println();
            }
        }
        if (transType == SmcElement.TransType.TRANS_POP && !endStateName.equals("nil") && endStateName.length() > 0) {
            String popArgs = guard.getPopArgs();
            this._source.println();
            this._source.print(indent2);
            this._source.print("$context ");
            this._source.print(endStateName);
            if (popArgs.length() > 0) {
                this._source.print(" ");
                this._source.print(popArgs);
            }
            this._source.println(";");
        }
        if (this._guardCount > 1) {
            this._source.print(this._indent);
            this._source.print("        }");
        }
    }

    public void visit(SmcAction action) {
        String name = action.getName();
        this._source.print(this._indent);
        if (action.isEmptyStateStack()) {
            this._source.println("$context emptyStateStack;");
        } else {
            this._source.print("$ctxt ");
            this._source.print(name);
            for (String arg : action.getArguments()) {
                this._source.print(" ");
                this._source.print(arg);
            }
            this._source.println(";");
        }
    }

    public void visit(SmcParameter parameter) {
        if (parameter.getType().equals("value")) {
            this._source.print("$");
        }
        this._source.print(parameter.getName());
    }

    private void _reflectTransitions(SmcState state, List<SmcTransition> stateTransitions, List<SmcTransition> defaultTransitions, List<SmcTransition> allTransitions) {
        this._source.print(this._indent);
        this._source.print("array set ");
        this._source.print(state.getMap().getName());
        this._source.print("_");
        this._source.print(state.getClassName());
        this._source.print("::_transitions {");
        Iterator<SmcTransition> it = allTransitions.iterator();
        String sep = "";
        while (it.hasNext()) {
            SmcTransition transition = it.next();
            String transName = transition.getName();
            int transDefinition = stateTransitions.contains(transition) ? 1 : (defaultTransitions.contains(transition) ? 2 : 0);
            this._source.print(sep);
            this._source.print("\"");
            this._source.print(transName);
            this._source.print("\" ");
            this._source.print(transDefinition);
            sep = " ";
        }
        this._source.println("};");
    }
}

