/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.util.Iterator;
import java.util.List;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.SmcVisitor;

public final class SmcTableGenerator
extends SmcCodeGenerator {
    public SmcTableGenerator(SmcOptions options) {
        super(options, "html");
    }

    public void visit(SmcFSM fsm) {
        this._source.println("<html>");
        this._source.println("  <head>");
        this._source.print("    <title>");
        this._source.print(this._srcfileBase);
        this._source.println("</title>");
        this._source.println("  </head>");
        this._source.println();
        this._source.println("  <body>");
        Iterator mit = fsm.getMaps().iterator();
        String separator = "";
        while (mit.hasNext()) {
            this._source.print(separator);
            ((SmcMap)mit.next()).accept((SmcVisitor)this);
            separator = "    <p>\n";
        }
        this._source.println("  </body>");
        this._source.println("</html>");
    }

    public void visit(SmcMap map) {
        List params;
        String transName;
        String mapName = map.getName();
        List transitions = map.getTransitions();
        int transitionCount = transitions.size() + 1;
        SmcTransition defaultTransition = null;
        this._source.println("    <table align=center border=3 cellspacing=2 cellpadding=2>");
        this._source.println("      <caption align=\"top\">");
        this._source.print("        ");
        this._source.print(mapName);
        this._source.println(" Finite State Machine");
        this._source.println("      </caption>");
        this._source.println("      <tr>");
        this._source.println("        <th rowspan=2>");
        this._source.println("          State");
        this._source.println("        </th>");
        this._source.println("        <th colspan=2>");
        this._source.println("          Actions");
        this._source.println("        </th>");
        this._source.print("        <th colspan=");
        this._source.print(transitionCount);
        this._source.println(">");
        this._source.println("          Transition");
        this._source.println("        </th>");
        this._source.println("      </tr>");
        this._source.println("      <tr>");
        this._source.println("        <th>");
        this._source.println("          Entry");
        this._source.println("        </th>");
        this._source.println("        <th>");
        this._source.println("         Exit");
        this._source.println("        </th>");
        for (SmcTransition transition : transitions) {
            transName = transition.getName();
            params = transition.getParameters();
            if (transName.equals("Default")) continue;
            this._source.println("        <th>");
            this._source.print("          ");
            this._source.println(transName);
            if (!params.isEmpty()) {
                this._source.println("          <br>");
                this._source.print("          (");
                Iterator it = params.iterator();
                boolean firstFlag = true;
                while (it.hasNext()) {
                    if (!firstFlag) {
                        this._source.println(',');
                        this._source.println("          <br>");
                        this._source.print("          ");
                    }
                    ((SmcParameter)it.next()).accept((SmcVisitor)this);
                    firstFlag = false;
                }
                this._source.println(")");
            }
            this._source.println("        </th>");
        }
        this._source.println("        <th>");
        this._source.println("          <b>Default</b>");
        this._source.println("        </th>");
        this._source.println("      </tr>");
        for (SmcState state : map.getStates()) {
            this._source.println("      <tr>");
            state.accept((SmcVisitor)this);
            for (SmcTransition transition : transitions) {
                transName = transition.getName();
                params = transition.getParameters();
                if (transName.equals("Default")) {
                    defaultTransition = state.findTransition(transName, params);
                    continue;
                }
                this._source.println("        <td>");
                transition = state.findTransition(transName, params);
                if (transition != null) {
                    this._source.print("          <pre>");
                    transition.accept((SmcVisitor)this);
                    this._source.println("          </pre>");
                }
                this._source.println("        </td>");
            }
            this._source.println("        <td>");
            if (defaultTransition != null) {
                this._source.print("          <pre>");
                defaultTransition.accept((SmcVisitor)this);
                this._source.println("          </pre>");
            }
            this._source.println("        </td>");
            this._source.println("      </tr>");
        }
        this._source.println("    </table>");
    }

    public void visit(SmcState state) {
        this._source.println("        <td>");
        this._source.print("          ");
        this._source.println(state.getInstanceName());
        this._source.println("        </td>");
        this._source.println("        <td>");
        List actions = state.getEntryActions();
        if (actions != null && !actions.isEmpty()) {
            this._source.println("          <pre>");
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
            this._source.println("          </pre>");
        }
        this._source.println("        </td>");
        this._source.println("        <td>");
        actions = state.getExitActions();
        if (actions != null && !actions.isEmpty()) {
            this._source.println("          <pre>");
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
            this._source.println("          </pre>");
        }
        this._source.println("        </td>");
    }

    public void visit(SmcTransition transition) {
        for (SmcGuard guard : transition.getGuards()) {
            this._source.println();
            guard.accept((SmcVisitor)this);
        }
    }

    public void visit(SmcGuard guard) {
        SmcTransition transition = guard.getTransition();
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String mapName = map.getName();
        String stateName = state.getClassName();
        SmcElement.TransType transType = guard.getTransType();
        String condition = guard.getCondition();
        String endStateName = guard.getEndState();
        List actions = guard.getActions();
        if (condition.length() > 0) {
            this._source.print('[');
            this._source.print(condition);
            this._source.println(']');
        }
        if (transType == SmcElement.TransType.TRANS_POP) {
            this._source.print("  pop(");
            if (!endStateName.equals("nil") && endStateName.length() > 0) {
                String popArgs = guard.getPopArgs();
                this._source.print(endStateName);
                if (popArgs.length() > 0) {
                    this._source.print(", ");
                    this._source.print(popArgs.trim());
                }
            }
            this._source.println(")");
        } else if (transType == SmcElement.TransType.TRANS_PUSH) {
            this._source.print("  push(");
            if (endStateName.equals("nil")) {
                this._source.print(mapName);
                this._source.print("::");
                this._source.print(stateName);
            } else {
                this._source.print(endStateName);
            }
            this._source.println(")");
        } else {
            this._source.print("  ");
            if (endStateName.equals("nil")) {
                this._source.println(stateName);
            } else {
                this._source.println(endStateName);
            }
        }
        if (actions.size() == 0) {
            this._source.println("  {}");
        } else {
            this._source.println("  {");
            this._indent = "    ";
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
            this._source.println("  }");
        }
    }

    public void visit(SmcAction action) {
        this._source.print(this._indent);
        this._source.print(action.getName());
        this._source.print("(");
        Iterator it = action.getArguments().iterator();
        String sep = "";
        while (it.hasNext()) {
            this._source.print(sep);
            this._source.print(((String)it.next()).trim());
            sep = ", ";
        }
        this._source.println(");");
    }

    public void visit(SmcParameter parameter) {
        this._source.print(parameter.getType());
    }
}

