/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.SmcVisitor;

public final class SmcPythonGenerator
extends SmcCodeGenerator {
    public SmcPythonGenerator(SmcOptions options) {
        super(options, "py");
    }

    public void visit(SmcFSM fsm) {
        String context = fsm.getContext();
        String rawSource = fsm.getSource();
        String startState = fsm.getStartState();
        List maps = fsm.getMaps();
        this._source.println("# ex: set ro:");
        this._source.println("# DO NOT EDIT.");
        this._source.println("# generated by smc (http://smc.sourceforge.net/)");
        this._source.print("# from file : ");
        this._source.print(this._srcfileBase);
        this._source.println(".sm");
        this._source.println();
        if (rawSource != null && rawSource.length() > 0) {
            this._source.println(rawSource);
            this._source.println();
        }
        this._source.println("import statemap");
        this._source.println();
        for (String imp : fsm.getImports()) {
            this._source.print("import ");
            this._source.println(imp);
        }
        this._source.println();
        this._source.print("class ");
        this._source.print(context);
        this._source.println("State(statemap.State):");
        this._source.println();
        this._source.println("    def Entry(self, fsm):");
        this._source.println("        pass");
        this._source.println();
        this._source.println("    def Exit(self, fsm):");
        this._source.println("        pass");
        this._source.println();
        List transitions = fsm.getTransitions();
        for (SmcTransition trans : transitions) {
            List params = trans.getParameters();
            if (trans.getName().equals("Default")) continue;
            this._source.print("    def ");
            this._source.print(trans.getName());
            this._source.print("(self, fsm");
            for (SmcParameter param : params) {
                this._source.print(", ");
                param.accept((SmcVisitor)this);
            }
            this._source.println("):");
            this._source.println("        self.Default(fsm)");
            this._source.println();
        }
        this._source.println("    def Default(self, fsm):");
        if (this._debugLevel >= 0) {
            this._source.println("        if fsm.getDebugFlag() == True:");
            this._source.println("            fsm.getDebugStream().write('TRANSITION   : Default\\n')");
        }
        this._source.println("        msg = \"\\n\\tState: %s\\n\\tTransition: %s\" % (");
        this._source.println("            fsm.getState().getName(), fsm.getTransition())");
        this._source.println("        raise statemap.TransitionUndefinedException, msg");
        if (this._reflectFlag) {
            this._source.println();
            this._source.println("    def getTransitions (self):");
            this._source.println("        return self._transitions");
        }
        for (SmcMap map : maps) {
            map.accept((SmcVisitor)this);
        }
        int index = startState.indexOf("::");
        String pythonState = index >= 0 ? startState.substring(0, index) + "." + startState.substring(index + 2) : startState;
        this._source.println();
        this._source.print("class ");
        this._source.print(context);
        this._source.println("_sm(statemap.FSMContext):");
        this._source.println();
        this._source.println("    def __init__(self, owner):");
        this._source.print("        statemap.FSMContext.__init__(self, ");
        this._source.print(pythonState);
        this._source.println(")");
        this._source.println("        self._owner = owner");
        this._source.println();
        this._source.println("    def __getattr__(self, attrib):");
        this._source.println("        def trans_sm(*arglist):");
        this._source.println("            self._transition = attrib");
        this._source.println("            getattr(self.getState(), attrib)(self, *arglist)");
        this._source.println("            self._transition = None");
        this._source.println("        return trans_sm");
        this._source.println();
        this._source.println("    def enterStartState(self):");
        this._source.println("        self._state.Entry(self)");
        this._source.println();
        this._source.println("    def getOwner(self):");
        this._source.println("        return self._owner");
        this._source.println();
        if (this._reflectFlag) {
            this._source.println("    _States = (");
            for (SmcMap map : maps) {
                String mapName = map.getName();
                for (SmcState state : map.getStates()) {
                    this._source.print("        ");
                    this._source.print(mapName);
                    this._source.print(".");
                    this._source.print(state.getClassName());
                    this._source.println(",");
                }
            }
            this._source.println("    )");
            this._source.println("    def getStates(self):");
            this._source.println("        return _States");
            this._source.println();
            this._source.println("    _transitions = (");
            for (SmcTransition trans : transitions) {
                this._source.print("        '");
                this._source.print(trans.getName());
                this._source.println("',");
            }
            this._source.println("    )");
            this._source.println("    def getTransitions(self):");
            this._source.println("        return _transitions");
            this._source.println();
        }
        this._source.println("# Local variables:");
        this._source.println("#  buffer-read-only: t");
        this._source.println("# End:");
    }

    public void visit(SmcMap map) {
        SmcState defaultState = map.getDefaultState();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        List states = map.getStates();
        boolean needPass = true;
        ArrayList definedDefaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList();
        this._source.println();
        this._source.print("class ");
        this._source.print(mapName);
        this._source.print("_Default(");
        this._source.print(context);
        this._source.println("State):");
        for (SmcTransition transition : definedDefaultTransitions) {
            needPass = false;
            transition.accept((SmcVisitor)this);
        }
        if (needPass && !this._reflectFlag) {
            this._source.println("    pass");
        }
        if (this._reflectFlag) {
            List allTransitions = map.getFSM().getTransitions();
            this._source.println();
            this._source.println("    _transitions = dict(");
            for (SmcTransition transition : allTransitions) {
                String transName = transition.getName();
                int transDefinition = definedDefaultTransitions.contains(transition) ? 2 : 0;
                this._source.print("        ");
                this._source.print(transName);
                this._source.print(" = ");
                this._source.print(transDefinition);
                this._source.println(",");
            }
            this._source.println("    )");
        }
        for (SmcState state : states) {
            state.accept((SmcVisitor)this);
        }
        this._source.println();
        this._source.print("class ");
        this._source.print(mapName);
        this._source.println("(object):");
        this._source.println();
        for (SmcState state : states) {
            this._source.print("    ");
            this._source.print(state.getInstanceName());
            this._source.print(" = ");
            this._source.print(mapName);
            this._source.print('_');
            this._source.print(state.getClassName());
            this._source.print("('");
            this._source.print(mapName);
            this._source.print('.');
            this._source.print(state.getClassName());
            this._source.print("', ");
            this._source.print(map.getNextStateId());
            this._source.println(")");
        }
        this._source.print("    Default = ");
        this._source.print(mapName);
        this._source.print("_Default('");
        this._source.print(mapName);
        this._source.println(".Default', -1)");
    }

    public void visit(SmcState state) {
        String indent2;
        SmcMap map = state.getMap();
        String mapName = map.getName();
        String stateName = state.getClassName();
        boolean needPass = true;
        this._source.println();
        this._source.print("class ");
        this._source.print(mapName);
        this._source.print('_');
        this._source.print(stateName);
        this._source.print("(");
        this._source.print(mapName);
        this._source.println("_Default):");
        List actions = state.getEntryActions();
        if (actions != null && actions.size() > 0) {
            needPass = false;
            this._source.println();
            this._source.println("    def Entry(self, fsm):");
            this._source.println("        ctxt = fsm.getOwner()");
            indent2 = this._indent;
            this._indent = "        ";
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
            this._indent = indent2;
        }
        if ((actions = state.getExitActions()) != null && actions.size() > 0) {
            needPass = false;
            this._source.println();
            this._source.println("    def Exit(self, fsm):");
            this._source.println("        ctxt = fsm.getOwner()");
            indent2 = this._indent;
            this._indent = "        ";
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
            this._indent = indent2;
        }
        for (SmcTransition transition : state.getTransitions()) {
            needPass = false;
            transition.accept((SmcVisitor)this);
        }
        if (needPass && !this._reflectFlag) {
            this._source.println("    pass");
        }
        if (this._reflectFlag) {
            List allTransitions = map.getFSM().getTransitions();
            List stateTransitions = state.getTransitions();
            SmcState defaultState = map.getDefaultState();
            ArrayList defaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList();
            this._source.println();
            this._source.println("    _transitions = dict(");
            for (SmcTransition transition : allTransitions) {
                String transName = transition.getName();
                int transDefinition = stateTransitions.contains(transition) ? 1 : (defaultTransitions.contains(transition) ? 2 : 0);
                this._source.print("        ");
                this._source.print(transName);
                this._source.print(" = ");
                this._source.print(transDefinition);
                this._source.println(",");
            }
            this._source.println("    )");
        }
    }

    public void visit(SmcTransition transition) {
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        List parameters = transition.getParameters();
        List guards = transition.getGuards();
        boolean nullCondition = false;
        this._source.println();
        this._source.print("    def ");
        this._source.print(transName);
        this._source.print("(self, fsm");
        for (SmcParameter param : parameters) {
            this._source.print(", ");
            param.accept((SmcVisitor)this);
        }
        this._source.println("):");
        if (transition.hasCtxtReference()) {
            this._source.println("        ctxt = fsm.getOwner()");
        }
        if (this._debugLevel >= 0) {
            this._source.println("        if fsm.getDebugFlag() == True:");
            this._source.print("            fsm.getDebugStream().write(\"");
            this._source.print("LEAVING STATE   : ");
            this._source.print(mapName);
            this._source.print(".");
            this._source.print(stateName);
            this._source.println("\\n\")");
            this._source.println();
        }
        this._indent = "        ";
        Iterator git = guards.iterator();
        this._guardIndex = 0;
        this._guardCount = guards.size();
        while (git.hasNext()) {
            SmcGuard guard = (SmcGuard)git.next();
            if (guard.getCondition().length() == 0) {
                nullCondition = true;
            }
            guard.accept((SmcVisitor)this);
            ++this._guardIndex;
        }
        if (this._guardIndex > 0 && !nullCondition) {
            this._source.println("        else:");
            this._source.print("            ");
            this._source.print(mapName);
            this._source.print("_Default.");
            this._source.print(transName);
            this._source.print("(self, fsm");
            for (SmcParameter param : parameters) {
                this._source.print(", ");
                param.accept((SmcVisitor)this);
            }
            this._source.println(")");
            this._source.print("        ");
        } else if (this._guardCount > 1) {
            this._source.println();
        }
    }

    public void visit(SmcGuard guard) {
        String indent3;
        String sep;
        Iterator pit;
        List parameters;
        String indent2;
        SmcTransition transition = guard.getTransition();
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        SmcElement.TransType transType = guard.getTransType();
        boolean loopbackFlag = false;
        String endStateName = guard.getEndState();
        String fqEndStateName = "";
        String pushStateName = guard.getPushState();
        String condition = guard.getCondition();
        List actions = guard.getActions();
        if (transType != SmcElement.TransType.TRANS_POP && endStateName.length() > 0 && !endStateName.equals("nil")) {
            endStateName = this.scopeStateName(endStateName, mapName);
        }
        stateName = this.scopeStateName(stateName, mapName);
        pushStateName = this.scopeStateName(pushStateName, mapName);
        loopbackFlag = this.isLoopback(transType, endStateName);
        if (this._guardCount > 1) {
            indent2 = this._indent + "    ";
            if (this._guardIndex == 0 && condition.length() > 0) {
                this._source.print(this._indent);
                this._source.print("if ");
                this._source.print(condition);
                this._source.println(" :");
            } else if (condition.length() > 0) {
                this._source.print(this._indent);
                this._source.print("elif ");
                this._source.print(condition);
                this._source.println(" :");
            } else {
                this._source.print(this._indent);
                this._source.println("else:");
            }
        } else if (condition.length() == 0) {
            indent2 = this._indent;
        } else {
            indent2 = this._indent + "    ";
            this._source.print(this._indent);
            this._source.print("if ");
            this._source.print(condition);
            this._source.println(" :");
        }
        if (actions.size() == 0 && endStateName.length() != 0) {
            fqEndStateName = endStateName;
        } else if (actions.size() > 0) {
            if (loopbackFlag) {
                fqEndStateName = "endState";
                this._source.print(indent2);
                this._source.print(fqEndStateName);
                this._source.println(" = fsm.getState()");
            } else {
                fqEndStateName = endStateName;
            }
        }
        if (transType == SmcElement.TransType.TRANS_POP || !loopbackFlag) {
            if (this._debugLevel >= 1) {
                this._source.print(indent2);
                this._source.println("if fsm.getDebugFlag() == True:");
                this._source.print(indent2);
                this._source.print("    fsm.getDebugStream().write(");
                this._source.print("\"BEFORE EXIT     : ");
                this._source.print(stateName);
                this._source.println(".Exit(fsm)\\n\")");
                this._source.println();
            }
            this._source.print(indent2);
            this._source.println("fsm.getState().Exit(fsm)");
            if (this._debugLevel >= 1) {
                this._source.print(indent2);
                this._source.println("if fsm.getDebugFlag() == True:");
                this._source.print(indent2);
                this._source.print("    fsm.getDebugStream().write(");
                this._source.print("\"AFTER EXIT      : ");
                this._source.print(stateName);
                this._source.println(".Exit(fsm)\\n\")");
                this._source.println();
            }
        }
        if (this._debugLevel >= 0) {
            parameters = transition.getParameters();
            this._source.print(indent2);
            this._source.println("if fsm.getDebugFlag() == True:");
            this._source.print(indent2);
            this._source.print("    fsm.getDebugStream().write(\"");
            this._source.print("ENTER TRANSITION: ");
            this._source.print(stateName);
            this._source.print(".");
            this._source.print(transName);
            this._source.print("(");
            pit = parameters.iterator();
            sep = "";
            while (pit.hasNext()) {
                this._source.print(sep);
                ((SmcParameter)pit.next()).accept((SmcVisitor)this);
                sep = ", ";
            }
            this._source.println(")\\n\")");
            this._source.println();
        }
        if (actions.isEmpty()) {
            List entryActions = state.getEntryActions();
            List exitActions = state.getExitActions();
            if (condition.length() > 0 || this._guardCount > 1) {
                this._source.print(indent2);
                this._source.println("# No actions.");
                this._source.print(indent2);
                this._source.println("pass");
            } else if (this._guardCount == 1 && (entryActions == null || entryActions.isEmpty()) && (exitActions == null || exitActions.isEmpty()) && transType != SmcElement.TransType.TRANS_PUSH && transType != SmcElement.TransType.TRANS_POP && loopbackFlag && this._debugLevel == -1) {
                this._source.print(indent2);
                this._source.println("# No actions.");
                this._source.print(indent2);
                this._source.println("pass");
            }
            indent3 = indent2;
        } else {
            this._source.print(indent2);
            this._source.println("fsm.clearState()");
            if (!this._noCatchFlag) {
                this._source.print(indent2);
                this._source.println("try:");
                indent3 = indent2 + "    ";
            } else {
                indent3 = indent2;
            }
            String indent4 = this._indent;
            this._indent = indent3;
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
            this._indent = indent4;
            if (!this._noCatchFlag) {
                this._source.print(indent2);
                this._source.println("finally:");
            }
        }
        if (this._debugLevel >= 0) {
            parameters = transition.getParameters();
            this._source.print(indent3);
            this._source.println("if fsm.getDebugFlag() == True:");
            this._source.print(indent3);
            this._source.print("    fsm.getDebugStream().write(\"");
            this._source.print("EXIT TRANSITION : ");
            this._source.print(stateName);
            this._source.print(".");
            this._source.print(transName);
            this._source.print("(");
            pit = parameters.iterator();
            sep = "";
            while (pit.hasNext()) {
                this._source.print(sep);
                ((SmcParameter)pit.next()).accept((SmcVisitor)this);
                sep = ", ";
            }
            this._source.println(")\\n\")");
            this._source.println();
        }
        if (!(transType != SmcElement.TransType.TRANS_SET || actions.isEmpty() && loopbackFlag)) {
            this._source.print(indent3);
            this._source.print("fsm.setState(");
            this._source.print(fqEndStateName);
            this._source.println(")");
        } else if (transType == SmcElement.TransType.TRANS_PUSH) {
            if (!loopbackFlag || !actions.isEmpty()) {
                this._source.print(indent3);
                this._source.print("fsm.setState(");
                this._source.print(fqEndStateName);
                this._source.println(")");
            }
            if (!loopbackFlag) {
                if (this._debugLevel >= 1) {
                    this._source.print(indent2);
                    this._source.println("if fsm.getDebugFlag() == True:");
                    this._source.print(indent2);
                    this._source.print("    fsm.getDebugStream().write(\"");
                    this._source.print("BEFORE ENTRY    : ");
                    this._source.print(stateName);
                    this._source.println(".Entry(fsm)\\n\")");
                    this._source.println();
                }
                this._source.print(indent3);
                this._source.println("fsm.getState().Entry(fsm)");
                if (this._debugLevel >= 1) {
                    this._source.print(indent2);
                    this._source.println("if fsm.getDebugFlag() == True:");
                    this._source.print(indent2);
                    this._source.print("    fsm.getDebugStream().write(");
                    this._source.print("\"AFTER ENTRY     : ");
                    this._source.print(stateName);
                    this._source.println(".Entry(fsm)\\n\")");
                    this._source.println();
                }
            }
            this._source.print(indent3);
            this._source.print("fsm.pushState(");
            this._source.print(pushStateName);
            this._source.println(")");
        } else if (transType == SmcElement.TransType.TRANS_POP) {
            this._source.print(indent3);
            this._source.println("fsm.popState()");
        }
        if (transType == SmcElement.TransType.TRANS_SET && !loopbackFlag || transType == SmcElement.TransType.TRANS_PUSH) {
            if (this._debugLevel >= 1) {
                this._source.print(indent2);
                this._source.println("if fsm.getDebugFlag() == True:");
                this._source.print(indent2);
                this._source.print("    fsm.getDebugStream().write(");
                this._source.print("\"BEFORE ENTRY    : ");
                this._source.print(stateName);
                this._source.println(".Entry(fsm)\\n\")");
                this._source.println();
            }
            this._source.print(indent3);
            this._source.println("fsm.getState().Entry(fsm)");
            if (this._debugLevel >= 1) {
                this._source.print(indent2);
                this._source.println("if fsm.getDebugFlag() == True:");
                this._source.print(indent2);
                this._source.print("    fsm.getDebugStream().write(");
                this._source.print("\"AFTER ENTRY     : ");
                this._source.print(stateName);
                this._source.println(".Entry(fsm)\\n\")");
                this._source.println();
            }
        }
        if (transType == SmcElement.TransType.TRANS_POP && !endStateName.equals("nil") && endStateName.length() > 0) {
            String popArgs = guard.getPopArgs();
            this._source.print(indent2);
            this._source.print("fsm.");
            this._source.print(endStateName);
            this._source.print("(");
            if (popArgs.length() > 0) {
                this._source.print(popArgs);
                this._source.println();
                this._source.print(indent2);
                this._source.println(")");
            } else {
                this._source.println(")");
            }
        }
    }

    public void visit(SmcAction action) {
        String name = action.getName();
        this._source.print(this._indent);
        if (action.isEmptyStateStack()) {
            this._source.println("fsm.emptyStateStack()");
        } else {
            this._source.print("ctxt.");
            this._source.print(name);
            this._source.print("(");
            Iterator it = action.getArguments().iterator();
            String sep = "";
            while (it.hasNext()) {
                this._source.print(sep);
                this._source.print((String)it.next());
                sep = ", ";
            }
            this._source.println(")");
        }
    }

    public void visit(SmcParameter parameter) {
        this._source.print(parameter.getName());
    }
}

