/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.SmcVisitor;

public final class SmcPhpGenerator
extends SmcCodeGenerator {
    public SmcPhpGenerator(SmcOptions options) {
        super(options, "php");
    }

    public void visit(SmcFSM fsm) {
        List params;
        String context = fsm.getContext();
        String rawSource = fsm.getSource();
        String startState = fsm.getStartState();
        List maps = fsm.getMaps();
        this._source.println("<?php");
        this._source.println("/*");
        this._source.println(" ex: set ro:");
        this._source.println(" DO NOT EDIT.");
        this._source.println(" generated by smc (http://smc.sourceforge.net/)");
        this._source.print(" from file : ");
        this._source.print(this._srcfileBase);
        this._source.println(".sm");
        this._source.println("*/");
        this._source.println();
        if (rawSource != null && rawSource.length() > 0) {
            this._source.println(rawSource);
            this._source.println();
        }
        this._source.println("require_once 'StateMachine/statemap.php';");
        this._source.println();
        for (String imp : fsm.getImports()) {
            this._source.print("require_once '");
            this._source.print(imp);
            this._source.println("';");
        }
        this._source.println();
        this._source.print("class ");
        this._source.print(context);
        this._source.println("State extends State {");
        this._source.println();
        this._source.println("    public function Entry($fsm) {");
        this._source.println("    }");
        this._source.println();
        this._source.println("    public function Exit_($fsm) {");
        this._source.println("    }");
        this._source.println();
        List transitions = fsm.getTransitions();
        for (SmcTransition trans : transitions) {
            params = trans.getParameters();
            if (trans.getName().equals("Default")) continue;
            this._source.print("    public function ");
            this._source.print(trans.getName());
            this._source.print("($fsm");
            for (SmcParameter param : params) {
                this._source.print(", ");
                param.accept((SmcVisitor)this);
            }
            this._source.println(") {");
            this._source.println("        $this->Default_($fsm);");
            this._source.println("    }");
            this._source.println();
        }
        this._source.println("    public function Default_($fsm) {");
        if (this._debugLevel >= 0) {
            this._source.println("        if ($fsm->getDebugFlag() == true) {");
            this._source.println("            fwrite($fsm->getDebugStream(), \"TRANSITION   : Default\\n\");");
            this._source.println("        }");
        }
        this._source.println("        $state = $fsm->getState()->getName();");
        this._source.println("        $transition = $fsm->getTransition();");
        this._source.println("        $msg = \"\\n\\tState: $state\\n\\tTransition: $transition\";");
        this._source.println("        throw new TransitionUndefinedException($msg);");
        this._source.println("    }");
        this._source.println("}");
        for (SmcMap map : maps) {
            map.accept((SmcVisitor)this);
        }
        this._source.println();
        this._source.print("class ");
        this._source.print(context);
        this._source.println("_sm extends FSMContext {");
        this._source.println();
        String phpState = this.phpStateName(startState);
        this._source.println("    public function __construct($owner) {");
        this._source.print("        parent::__construct(");
        this._source.print(phpState);
        this._source.println(");");
        this._source.println("        $this->_owner = $owner;");
        this._source.println("    }");
        this._source.println();
        for (SmcTransition trans : transitions) {
            String transName = trans.getName();
            params = trans.getParameters();
            if (transName.equals("Default")) continue;
            this._source.print("    public function ");
            this._source.print(transName);
            this._source.print("(");
            params = trans.getParameters();
            Iterator pit = params.iterator();
            String separator = "";
            while (pit.hasNext()) {
                this._source.print(separator);
                ((SmcParameter)pit.next()).accept((SmcVisitor)this);
                separator = ", ";
            }
            this._source.println(") {");
            this._source.print("        $this->_transition = \"");
            this._source.print(transName);
            this._source.println("\";");
            this._source.print("        $this->getState()->");
            this._source.print(transName);
            this._source.print("($this");
            pit = params.iterator();
            while (pit.hasNext()) {
                this._source.print(", ");
                this._source.print(((SmcParameter)pit.next()).getName());
            }
            this._source.println(");");
            this._source.println("        $this->_transition = NULL;");
            this._source.println("    }");
            this._source.println();
        }
        this._source.println("    public function getState() {");
        this._source.println("        if ($this->_state == NULL) {");
        this._source.println("            throw new StateUndefinedException();");
        this._source.println("        }");
        this._source.println("        return $this->_state;");
        this._source.println("    }");
        this._source.println();
        this._source.println("    public function enterStartState() {");
        this._source.println("        $this->_state->Entry($this);");
        this._source.println("    }");
        this._source.println();
        this._source.println("    public function getOwner() {");
        this._source.println("        return $this->_owner;");
        this._source.println("    }");
        this._source.println();
        if (this._reflectFlag) {
            this._source.println("    public function getStates() {");
            this._source.println("        return array(");
            for (SmcMap map : maps) {
                String mapName = map.getName();
                this._source.print("            ");
                this._source.print(mapName);
                this._source.print("::$Default");
                this._source.println(",");
                for (SmcState state : map.getStates()) {
                    this._source.print("            ");
                    this._source.print(mapName);
                    this._source.print("::$");
                    this._source.print(state.getClassName());
                    this._source.println(",");
                }
            }
            this._source.println("        );");
            this._source.println("    }");
            this._source.println();
            this._source.println("    public function getTransitions() {");
            this._source.println("        return array(");
            for (SmcTransition trans : transitions) {
                this._source.print("            '");
                this._source.print(trans.getName());
                this._source.println("',");
            }
            this._source.println("        );");
            this._source.println("    }");
            this._source.println();
        }
        this._source.println("}");
        this._source.println();
        this._source.println("/*");
        this._source.println(" Local variables:");
        this._source.println("  buffer-read-only: t");
        this._source.println(" End:");
        this._source.println("*/");
        this._source.println("?>");
    }

    public void visit(SmcMap map) {
        SmcState defaultState = map.getDefaultState();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        List states = map.getStates();
        boolean needPass = true;
        ArrayList definedDefaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList();
        this._source.println();
        this._source.print("class ");
        this._source.print(mapName);
        this._source.print("_Default extends ");
        this._source.print(context);
        this._source.println("State {");
        for (SmcTransition transition : definedDefaultTransitions) {
            transition.accept((SmcVisitor)this);
        }
        if (this._reflectFlag) {
            List allTransitions = map.getFSM().getTransitions();
            this._source.println();
            this._source.println("    public function getTransitions() {");
            this._source.println("        return array(");
            for (SmcTransition transition : allTransitions) {
                String transName = transition.getName();
                int transDefinition = definedDefaultTransitions.contains(transition) ? 2 : 0;
                this._source.print("            '");
                this._source.print(transName);
                this._source.print("' => ");
                this._source.print(transDefinition);
                this._source.println(",");
            }
            this._source.println("        );");
            this._source.println("    }");
        }
        this._source.println();
        this._source.println("}");
        for (SmcState state : states) {
            state.accept((SmcVisitor)this);
        }
        this._source.println();
        this._source.print("class ");
        this._source.print(mapName);
        this._source.println(" {");
        for (SmcState state : states) {
            this._source.print("    public static $");
            this._source.print(state.getInstanceName());
            this._source.println(";");
        }
        this._source.println("    public static $Default_;");
        this._source.println("}");
        for (SmcState state : states) {
            this._source.print(mapName);
            this._source.print("::$");
            this._source.print(state.getInstanceName());
            this._source.print(" = new ");
            this._source.print(mapName);
            this._source.print('_');
            this._source.print(state.getClassName());
            this._source.print("('");
            this._source.print(mapName);
            this._source.print('.');
            this._source.print(state.getClassName());
            this._source.print("', ");
            this._source.print(map.getNextStateId());
            this._source.println(");");
        }
        this._source.print(mapName);
        this._source.print("::$Default_");
        this._source.print(" = new ");
        this._source.print(mapName);
        this._source.print("_Default('");
        this._source.print(mapName);
        this._source.println(".Default_', -1);");
    }

    public void visit(SmcState state) {
        String indent2;
        SmcMap map = state.getMap();
        String mapName = map.getName();
        String stateName = state.getClassName();
        boolean needPass = true;
        this._source.println();
        this._source.print("class ");
        this._source.print(mapName);
        this._source.print('_');
        this._source.print(stateName);
        this._source.print(" extends ");
        this._source.print(mapName);
        this._source.println("_Default {");
        List actions = state.getEntryActions();
        if (actions != null && actions.size() > 0) {
            needPass = false;
            this._source.println();
            this._source.println("    public function Entry($fsm) {");
            this._source.println("        $ctxt = $fsm->getOwner();");
            indent2 = this._indent;
            this._indent = "        ";
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
            this._indent = indent2;
            this._source.println("    }");
        }
        if ((actions = state.getExitActions()) != null && actions.size() > 0) {
            needPass = false;
            this._source.println();
            this._source.println("    public function Exit_($fsm) {");
            this._source.println("        $ctxt = $fsm->getOwner();");
            indent2 = this._indent;
            this._indent = "        ";
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
            this._indent = indent2;
            this._source.println("    }");
        }
        for (SmcTransition transition : state.getTransitions()) {
            transition.accept((SmcVisitor)this);
        }
        if (this._reflectFlag) {
            List allTransitions = map.getFSM().getTransitions();
            List stateTransitions = state.getTransitions();
            SmcState defaultState = map.getDefaultState();
            ArrayList defaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList();
            this._source.println();
            this._source.println("    public function getTransitions() {");
            this._source.println("        return array(");
            for (SmcTransition transition : allTransitions) {
                String transName = transition.getName();
                int transDefinition = stateTransitions.contains(transition) ? 1 : (defaultTransitions.contains(transition) ? 2 : 0);
                this._source.print("            '");
                this._source.print(transName);
                this._source.print("' => ");
                this._source.print(transDefinition);
                this._source.println(",");
            }
            this._source.println("        );");
            this._source.println("    }");
        }
        this._source.println();
        this._source.println("}");
    }

    public void visit(SmcTransition transition) {
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        List parameters = transition.getParameters();
        List guards = transition.getGuards();
        boolean nullCondition = false;
        this._source.println();
        this._source.print("    public function ");
        this._source.print(this.sanitizeKeyword(transName));
        this._source.print("($fsm");
        for (SmcParameter param : parameters) {
            this._source.print(", ");
            param.accept((SmcVisitor)this);
        }
        this._source.println(") {");
        if (transition.hasCtxtReference()) {
            this._source.println("        $ctxt = $fsm->getOwner();");
        }
        if (this._debugLevel >= 0) {
            this._source.println("        if ($fsm->getDebugFlag() == true) {");
            this._source.print("            fwrite($fsm->getDebugStream(), ");
            this._source.print("\"LEAVING STATE   : ");
            this._source.print(mapName);
            this._source.print("::\\$");
            this._source.print(stateName);
            this._source.println("\\n\");");
            this._source.println("        }");
        }
        this._indent = "        ";
        Iterator git = guards.iterator();
        this._guardIndex = 0;
        this._guardCount = guards.size();
        while (git.hasNext()) {
            SmcGuard guard = (SmcGuard)git.next();
            if (guard.getCondition().length() == 0) {
                nullCondition = true;
            }
            guard.accept((SmcVisitor)this);
            ++this._guardIndex;
        }
        if (this._guardIndex > 0 && !nullCondition) {
            this._source.println("        } else {");
            this._source.print("            ");
            this._source.print("parent::");
            this._source.print(transName);
            this._source.print("($fsm");
            for (SmcParameter param : parameters) {
                this._source.print(", ");
                this._source.print(param.getName());
            }
            this._source.println(");");
            this._source.println("        }");
        } else if (this._guardCount > 1) {
            this._source.println();
        }
        this._source.print("    }");
    }

    public void visit(SmcGuard guard) {
        String indent3;
        String sep;
        Iterator pit;
        List parameters;
        String indent2;
        SmcTransition transition = guard.getTransition();
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        SmcElement.TransType transType = guard.getTransType();
        boolean loopbackFlag = false;
        String endStateName = guard.getEndState();
        String fqEndStateName = "";
        String pushStateName = guard.getPushState();
        String condition = guard.getCondition();
        List actions = guard.getActions();
        if (transType != SmcElement.TransType.TRANS_POP && endStateName.length() > 0 && !endStateName.equals("nil") && endStateName.indexOf("::") < 0) {
            endStateName = mapName + "::" + endStateName;
        }
        endStateName = this.phpStateName(endStateName);
        if (stateName.indexOf("::") < 0) {
            stateName = mapName + "::" + stateName;
        }
        stateName = this.phpStateName(stateName);
        if (pushStateName != null && pushStateName.length() > 0 && pushStateName.indexOf("::") < 0) {
            pushStateName = mapName + "::" + pushStateName;
        }
        pushStateName = this.phpStateName(pushStateName);
        loopbackFlag = this.isLoopback(transType, endStateName);
        if (this._guardCount > 1) {
            indent2 = this._indent + "    ";
            if (this._guardIndex == 0 && condition.length() > 0) {
                this._source.print(this._indent);
                this._source.print("if (");
                this._source.print(condition);
                this._source.println(") {");
            } else if (condition.length() > 0) {
                this._source.print(this._indent);
                this._source.print("} elseif (");
                this._source.print(condition);
                this._source.println(") {");
            } else {
                this._source.println("else {");
            }
        } else if (condition.length() == 0) {
            indent2 = this._indent;
        } else {
            indent2 = this._indent + "    ";
            this._source.print(this._indent);
            this._source.print("if (");
            this._source.print(condition);
            this._source.println(") {");
        }
        if (actions.size() == 0 && endStateName.length() != 0) {
            fqEndStateName = endStateName;
        } else if (actions.size() > 0) {
            if (loopbackFlag) {
                fqEndStateName = "$endState";
                this._source.print(indent2);
                this._source.print(fqEndStateName);
                this._source.println(" = $fsm->getState();");
            } else {
                fqEndStateName = endStateName;
            }
        }
        if (transType == SmcElement.TransType.TRANS_POP || !loopbackFlag) {
            if (this._debugLevel >= 1) {
                this._source.print(indent2);
                this._source.println("if ($fsm->getDebugFlag() == true) {");
                this._source.print(indent2);
                this._source.print("    fwrite($fsm->getDebugStream(), \"");
                this._source.print("BEFORE EXIT     : ");
                this._source.print(stateName);
                this._source.println("->Exit_($fsm)\\n\");");
                this._source.print(indent2);
                this._source.println("}");
            }
            this._source.print(indent2);
            this._source.println("$fsm->getState()->Exit_($fsm);");
            if (this._debugLevel >= 1) {
                this._source.print(indent2);
                this._source.println("if ($fsm->getDebugFlag() == true) {");
                this._source.print(indent2);
                this._source.print("    fwrite($fsm->getDebugStream(), \"");
                this._source.print("AFTER EXIT      : ");
                this._source.print(stateName);
                this._source.println("->Exit_($fsm)\\n\");");
                this._source.print(indent2);
                this._source.println("}");
            }
        }
        if (this._debugLevel >= 0) {
            parameters = transition.getParameters();
            this._source.print(indent2);
            this._source.println("if ($fsm->getDebugFlag()) {");
            this._source.print(indent2);
            this._source.print("    fwrite($fsm->getDebugStream(), \"");
            this._source.print("ENTER TRANSITION: ");
            this._source.print(stateName);
            this._source.print("->");
            this._source.print(transName);
            this._source.print("(");
            pit = parameters.iterator();
            sep = "";
            while (pit.hasNext()) {
                this._source.print(sep);
                ((SmcParameter)pit.next()).accept((SmcVisitor)this);
                sep = ", ";
            }
            this._source.print(");");
            this._source.println("\\n\");");
            this._source.print(indent2);
            this._source.println("}");
        }
        if (actions.isEmpty()) {
            List entryActions = state.getEntryActions();
            List exitActions = state.getExitActions();
            if (condition.length() > 0 || this._guardCount > 1) {
                this._source.print(indent2);
                this._source.println("# No actions.");
            } else if (this._guardCount == 1 && (entryActions == null || entryActions.isEmpty()) && (exitActions == null || exitActions.isEmpty()) && transType != SmcElement.TransType.TRANS_PUSH && transType != SmcElement.TransType.TRANS_POP && loopbackFlag && this._debugLevel == -1) {
                this._source.print(indent2);
                this._source.println("# No actions.");
                this._source.print(indent2);
            }
            indent3 = indent2;
        } else {
            this._source.print(indent2);
            this._source.println("$fsm->clearState();");
            if (!this._noCatchFlag) {
                this._source.print(indent2);
                this._source.println("$exception = NULL;");
                this._source.print(indent2);
                this._source.println("try {");
                indent3 = indent2 + "    ";
            } else {
                indent3 = indent2;
            }
            String indent4 = this._indent;
            this._indent = indent3;
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
            this._indent = indent4;
            if (!this._noCatchFlag) {
                this._source.print(indent2);
                this._source.println("}");
                this._source.print(indent2);
                this._source.println("catch (Exception $exception) {}");
            }
        }
        if (this._debugLevel >= 0) {
            parameters = transition.getParameters();
            this._source.print(indent2);
            this._source.println("if ($fsm->getDebugFlag()) {");
            this._source.print(indent2);
            this._source.print("    fwrite($fsm->getDebugStream(), \"");
            this._source.print("EXIT TRANSITION : ");
            this._source.print(stateName);
            this._source.print("->");
            this._source.print(transName);
            this._source.print("(");
            pit = parameters.iterator();
            sep = "";
            while (pit.hasNext()) {
                this._source.print(sep);
                ((SmcParameter)pit.next()).accept((SmcVisitor)this);
                sep = ", ";
            }
            this._source.print(");");
            this._source.println("\\n\");");
            this._source.print(indent2);
            this._source.println("}");
        }
        if (!(transType != SmcElement.TransType.TRANS_SET || actions.isEmpty() && loopbackFlag)) {
            this._source.print(indent2);
            this._source.print("$fsm->setState(");
            this._source.print(fqEndStateName);
            this._source.println(");");
        } else if (transType == SmcElement.TransType.TRANS_PUSH) {
            if (!loopbackFlag || !actions.isEmpty()) {
                this._source.print(indent2);
                this._source.print("$fsm->setState(");
                this._source.print(fqEndStateName);
                this._source.println(");");
            }
            if (!loopbackFlag) {
                if (this._debugLevel >= 1) {
                    this._source.print(indent2);
                    this._source.println("if ($fsm->getDebugFlag() == true) {");
                    this._source.print(indent2);
                    this._source.print("    fwrite($fsm->getDebugStream(), \"");
                    this._source.print("BEFORE ENTRY    : ");
                    this._source.print(stateName);
                    this._source.println("->Entry($fsm);\\n\");");
                    this._source.print(indent2);
                    this._source.println("}");
                }
                this._source.print(indent2);
                this._source.println("$fsm->getState()->Entry($fsm);");
                if (this._debugLevel >= 1) {
                    this._source.print(indent2);
                    this._source.println("if ($fsm->getDebugFlag() == true) {");
                    this._source.print(indent2);
                    this._source.print("    fwrite($fsm->getDebugStream(), \"");
                    this._source.print("AFTER ENTRY     : ");
                    this._source.print(stateName);
                    this._source.println("->Entry($fsm);\\n\");");
                    this._source.print(indent2);
                    this._source.println("}");
                }
            }
            this._source.print(indent2);
            this._source.print("$fsm->pushState(");
            this._source.print(pushStateName);
            this._source.println(");");
        } else if (transType == SmcElement.TransType.TRANS_POP) {
            this._source.print(indent2);
            this._source.println("$fsm->popState();");
        }
        if (transType == SmcElement.TransType.TRANS_SET && !loopbackFlag || transType == SmcElement.TransType.TRANS_PUSH) {
            if (this._debugLevel >= 1) {
                this._source.print(indent2);
                this._source.println("if ($fsm->getDebugFlag() == true) {");
                this._source.print(indent2);
                this._source.print("    fwrite($fsm->getDebugStream(), \"");
                this._source.print("BEFORE ENTRY    : ");
                this._source.print(stateName);
                this._source.println("->Entry($fsm);\\n\");");
                this._source.print(indent2);
                this._source.println("}");
            }
            this._source.print(indent2);
            this._source.println("$fsm->getState()->Entry($fsm);");
            if (this._debugLevel >= 1) {
                this._source.print(indent2);
                this._source.println("if ($fsm->getDebugFlag() == true) {");
                this._source.print(indent2);
                this._source.print("    fwrite($fsm->getDebugStream(), \"");
                this._source.print("AFTER ENTRY     : ");
                this._source.print(stateName);
                this._source.println("->Entry($fsm);\\n\");");
                this._source.print(indent2);
                this._source.println("}");
            }
        }
        if (actions.size() > 0 && !this._noCatchFlag) {
            this._source.print(indent2);
            this._source.println("if ($exception != NULL) {");
            this._source.print(indent2);
            this._source.println("    throw $exception;");
            this._source.print(indent2);
            this._source.println("}");
        }
        if (transType == SmcElement.TransType.TRANS_POP && !endStateName.equals("nil") && endStateName.length() > 0) {
            String popArgs = guard.getPopArgs();
            this._source.print(indent2);
            this._source.print("$fsm->");
            this._source.print(endStateName);
            this._source.print("(");
            if (popArgs.length() > 0) {
                this._source.print(popArgs);
                this._source.println();
                this._source.print(indent2);
                this._source.println(");");
            } else {
                this._source.println(");");
            }
        }
        if (this._guardCount > 1) {
            this._source.print(this._indent);
            this._source.print("}");
        }
    }

    public void visit(SmcAction action) {
        String name = action.getName();
        this._source.print(this._indent);
        if (action.isEmptyStateStack()) {
            this._source.println("$fsm->emptyStateStack();");
        } else {
            if (!action.isStatic()) {
                this._source.print("$ctxt->");
            }
            this._source.print(name);
            this._source.print("(");
            Iterator it = action.getArguments().iterator();
            String sep = "";
            while (it.hasNext()) {
                this._source.print(sep);
                this._source.print((String)it.next());
                sep = ", ";
            }
            this._source.println(");");
        }
    }

    public void visit(SmcParameter parameter) {
        String type = parameter.getType();
        if (type.equals("")) {
            this._source.print(parameter.getName());
        } else {
            this._source.print(type);
            this._source.print(" ");
            this._source.print(parameter.getName());
        }
    }

    private String phpStateName(String state) {
        int index = state.indexOf("::");
        String retval = state;
        if (index >= 0) {
            retval = state.substring(0, index) + "::$" + state.substring(index + 2);
        }
        return retval;
    }

    private String sanitizeKeyword(String transName) {
        String retval = transName;
        if (transName.equalsIgnoreCase("Default")) {
            retval = transName + "_";
        }
        return retval;
    }
}

