/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.SmcVisitor;

public final class SmcPerlGenerator
extends SmcCodeGenerator {
    public SmcPerlGenerator(SmcOptions options) {
        super(options, "pm");
    }

    public void visit(SmcFSM fsm) {
        String packageName = fsm.getPackage();
        String context = fsm.getContext();
        String rawSource = fsm.getSource();
        String startState = fsm.getStartState();
        List maps = fsm.getMaps();
        this._source.println("# ex: set ro:");
        this._source.println("# DO NOT EDIT.");
        this._source.println("# generated by smc (http://smc.sourceforge.net/)");
        this._source.print("# from file : ");
        this._source.print(this._srcfileBase);
        this._source.println(".sm");
        this._source.println();
        if (rawSource != null && rawSource.length() > 0) {
            this._source.println(rawSource);
            this._source.println();
        }
        if (packageName != null && packageName.length() > 0) {
            context = packageName + "::" + context;
            startState = packageName + "::" + startState;
        }
        this._source.println("use strict;");
        this._source.println("use warnings;");
        this._source.println();
        this._source.println("use DFA::Statemap;");
        for (String imp : fsm.getImports()) {
            this._source.print("use ");
            this._source.print(imp);
            this._source.println(";");
        }
        this._source.println();
        this._source.print("package ");
        this._source.print(context);
        this._source.println("State;");
        this._source.println("    use base qw(DFA::Statemap::State);");
        this._source.println();
        this._source.println("    use Carp;");
        this._source.println();
        this._source.println("    sub Entry {}");
        this._source.println();
        this._source.println("    sub Exit {}");
        this._source.println();
        this._source.println("    my %meth = (");
        List transitions = fsm.getTransitions();
        for (SmcTransition trans : transitions) {
            String transName = trans.getName();
            if (transName.equals("Default")) continue;
            this._source.print("        ");
            this._source.print(transName);
            this._source.println(" => undef,");
        }
        this._source.println("    );");
        this._source.println();
        this._source.println("    sub AUTOLOAD {");
        this._source.println("        my $self = shift;");
        this._source.println("        use vars qw( $AUTOLOAD );");
        this._source.println("        (my $method = $AUTOLOAD) =~ s/^.*:://;");
        this._source.println("        return unless exists $meth{$method};");
        this._source.println("        $self->Default(@_);");
        this._source.println("    }");
        this._source.println();
        this._source.println("    sub Default {");
        this._source.println("        my $self = shift;");
        this._source.println("        my ($fsm) = @_;");
        if (this._debugLevel >= 0) {
            this._source.println("        if ($fsm->getDebugFlag()) {");
            this._source.println("            my $fh = $fsm->getDebugStream();");
            this._source.println("            print $fh \"TRANSITION   : Default\\n\";");
            this._source.println("        }");
            this._source.println("        confess \"TransitionUndefinedException\\n\",");
        } else {
            this._source.println("        croak \"TransitionUndefinedException\\n\",");
        }
        this._source.println("            \"State: \", $fsm->getState()->getName(),\"\\n\",");
        this._source.println("            \"Transition: \", $fsm->getTransition(),\"\\n\";");
        this._source.println("    }");
        for (SmcMap map : maps) {
            map.accept((SmcVisitor)this);
        }
        this._source.println();
        this._source.print("package ");
        this._source.print(context);
        this._source.println("_sm;");
        this._source.println("    use base qw(DFA::Statemap::FSMContext);");
        this._source.println();
        this._source.println("    use Carp;");
        this._source.println();
        this._source.println("    sub new {");
        this._source.println("        my $proto = shift;");
        this._source.println("        my $class = ref($proto) || $proto;");
        this._source.print("        my $self = $class->SUPER::new($");
        this._source.print(startState);
        this._source.println(");");
        this._source.println("        my ($owner) = @_;");
        this._source.println("        $self->{_owner} = $owner;");
        this._source.println("        return $self;");
        this._source.println("    }");
        this._source.println();
        this._source.println("    sub AUTOLOAD {");
        this._source.println("        my $self = shift;");
        this._source.println("        use vars qw( $AUTOLOAD );");
        this._source.println("        (my $method = $AUTOLOAD) =~ s/^.*:://;");
        this._source.println("        return unless exists $meth{$method};");
        this._source.println("        $self->{_transition} = $method;");
        this._source.println("        $self->getState()->$method($self, @_);");
        this._source.println("        $self->{_transition} = undef;");
        this._source.println("    }");
        this._source.println();
        this._source.println("    sub enterStartState {");
        this._source.println("        my $self = shift;");
        this._source.println("        $self->{_state}->Entry($self);");
        this._source.println("    }");
        this._source.println();
        this._source.println("    sub getOwner {");
        this._source.println("        my $self = shift;");
        this._source.println("        return $self->{_owner};");
        this._source.println("    }");
        this._source.println();
        if (this._reflectFlag) {
            this._source.println("    sub getStates {");
            this._source.println("        my $self = shift;");
            this._source.println("        return (");
            for (SmcMap map : maps) {
                String mapName = map.getName();
                for (SmcState state : map.getStates()) {
                    this._source.print("            $");
                    this._source.print(mapName);
                    this._source.print("::");
                    this._source.print(state.getClassName());
                    this._source.println(",");
                }
            }
            this._source.println("        );");
            this._source.println("    }");
            this._source.println();
            this._source.println("    sub getTransitions {");
            this._source.println("        my $self = shift;");
            this._source.println("        return (");
            for (SmcTransition trans : transitions) {
                this._source.print("            '");
                this._source.print(trans.getName());
                this._source.println("',");
            }
            this._source.println("        );");
            this._source.println("    }");
            this._source.println();
        }
        this._source.println("1;");
        this._source.println();
        this._source.println("# Local variables:");
        this._source.println("#  buffer-read-only: t");
        this._source.println("# End:");
    }

    public void visit(SmcMap map) {
        SmcState defaultState = map.getDefaultState();
        String packageName = map.getFSM().getPackage();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        List states = map.getStates();
        if (packageName != null && packageName.length() > 0) {
            mapName = packageName + "::" + mapName;
            context = packageName + "::" + context;
        }
        ArrayList definedDefaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList();
        this._source.println();
        this._source.print("package ");
        this._source.print(mapName);
        this._source.println(";");
        this._source.println();
        this._source.println("use vars qw(");
        for (SmcState state : states) {
            this._source.print("    $");
            this._source.println(state.getInstanceName());
        }
        this._source.println("    $Default");
        this._source.println(");");
        this._source.println();
        this._source.print("package ");
        this._source.print(mapName);
        this._source.println("_Default;");
        this._source.print("    use base qw(");
        this._source.print(context);
        this._source.println("State);");
        for (SmcTransition transition : definedDefaultTransitions) {
            transition.accept((SmcVisitor)this);
        }
        if (this._reflectFlag) {
            List allTransitions = map.getFSM().getTransitions();
            this._source.println();
            this._source.println("    sub getTransitions {");
            this._source.println("        return {");
            for (SmcTransition transition : allTransitions) {
                String transName = transition.getName();
                int transDefinition = definedDefaultTransitions.contains(transition) ? 2 : 0;
                this._source.print("            '");
                this._source.print(transName);
                this._source.print("' => ");
                this._source.print(transDefinition);
                this._source.println(",");
            }
            this._source.println("        };");
            this._source.println("    }");
        }
        for (SmcState state : states) {
            state.accept((SmcVisitor)this);
        }
        this._source.println();
        this._source.print("package ");
        this._source.print(mapName);
        this._source.println(';');
        this._source.println();
        this._source.println("sub BEGIN {");
        for (SmcState state : states) {
            this._source.print("    $");
            this._source.print(state.getInstanceName());
            this._source.print(" = new ");
            this._source.print(mapName);
            this._source.print('_');
            this._source.print(state.getClassName());
            this._source.print("('");
            this._source.print(mapName);
            this._source.print('.');
            this._source.print(state.getClassName());
            this._source.print("', ");
            this._source.print(map.getNextStateId());
            this._source.println(");");
        }
        this._source.print("    $Default = new ");
        this._source.print(mapName);
        this._source.print("_Default('");
        this._source.print(mapName);
        this._source.println(".Default', -1);");
        this._source.println("}");
    }

    public void visit(SmcState state) {
        String indent2;
        SmcMap map = state.getMap();
        String packageName = map.getFSM().getPackage();
        String mapName = map.getName();
        String stateName = state.getClassName();
        if (packageName != null && packageName.length() > 0) {
            mapName = packageName + "::" + mapName;
        }
        this._source.println();
        this._source.print("package ");
        this._source.print(mapName);
        this._source.print('_');
        this._source.print(stateName);
        this._source.println(";");
        this._source.print("    use base qw(");
        this._source.print(mapName);
        this._source.println("_Default);");
        List actions = state.getEntryActions();
        if (actions != null && actions.size() > 0) {
            this._source.println();
            this._source.println("    sub Entry {");
            this._source.println("        my $self = shift;");
            this._source.println("        my ($fsm) = @_;");
            this._source.println("        my $ctxt = $fsm->getOwner();");
            indent2 = this._indent;
            this._indent = "        ";
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
            this._indent = indent2;
            this._source.println("    }");
        }
        if ((actions = state.getExitActions()) != null && actions.size() > 0) {
            this._source.println();
            this._source.println("    sub Exit {");
            this._source.println("        my $self = shift;");
            this._source.println("        my ($fsm) = @_;");
            this._source.println("        my $ctxt = $fsm->getOwner();");
            indent2 = this._indent;
            this._indent = "        ";
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
            this._indent = indent2;
            this._source.println("    }");
        }
        for (SmcTransition transition : state.getTransitions()) {
            transition.accept((SmcVisitor)this);
        }
        if (this._reflectFlag) {
            List allTransitions = map.getFSM().getTransitions();
            List stateTransitions = state.getTransitions();
            SmcState defaultState = map.getDefaultState();
            ArrayList defaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList();
            this._source.println();
            this._source.println("    sub getTransitions {");
            this._source.println("        return {");
            for (SmcTransition transition : allTransitions) {
                String transName = transition.getName();
                int transDefinition = stateTransitions.contains(transition) ? 1 : (defaultTransitions.contains(transition) ? 2 : 0);
                this._source.print("            '");
                this._source.print(transName);
                this._source.print("' => ");
                this._source.print(transDefinition);
                this._source.println(",");
            }
            this._source.println("        };");
            this._source.println("    }");
        }
    }

    public void visit(SmcTransition transition) {
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String packageName = map.getFSM().getPackage();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        List parameters = transition.getParameters();
        List guards = transition.getGuards();
        boolean nullCondition = false;
        if (packageName != null && packageName.length() > 0) {
            mapName = packageName + "::" + mapName;
        }
        this._source.println();
        this._source.print("    sub ");
        this._source.print(transName);
        this._source.println(" {");
        this._source.println("        my $self = shift;");
        this._source.print("        my ($fsm");
        for (SmcParameter param : parameters) {
            this._source.print(", ");
            this._source.print(param.getName());
        }
        this._source.println(") = @_;");
        if (transition.hasCtxtReference()) {
            this._source.println("        my $ctxt = $fsm->getOwner();");
        }
        if (this._debugLevel >= 0) {
            this._source.println("        if ($fsm->getDebugFlag()) {");
            this._source.println("            my $fh = $fsm->getDebugStream();");
            this._source.print("            print $fh \"LEAVING STATE   : ");
            this._source.print(mapName);
            this._source.print("::");
            this._source.print(stateName);
            this._source.println("\\n\";");
            this._source.println("        }");
        }
        this._indent = "    ";
        Iterator git = guards.iterator();
        this._guardIndex = 0;
        this._guardCount = guards.size();
        while (git.hasNext()) {
            SmcGuard guard = (SmcGuard)git.next();
            if (guard.getCondition().length() == 0) {
                nullCondition = true;
            }
            guard.accept((SmcVisitor)this);
            ++this._guardIndex;
        }
        if (this._guardIndex > 0 && !nullCondition) {
            if (this._guardCount == 1) {
                this._source.println("        }");
            }
            this._source.println("        else {");
            this._source.print("            ");
            this._source.print("$self->SUPER::");
            this._source.print(transName);
            this._source.print("($fsm");
            for (SmcParameter param : parameters) {
                this._source.print(", ");
                this._source.print(param.getName());
            }
            this._source.println(");");
            this._source.println("        }");
        } else if (this._guardCount > 1) {
            this._source.println();
        }
        this._source.println("    }");
    }

    public void visit(SmcGuard guard) {
        String indent3;
        String sep;
        Iterator pit;
        List parameters;
        String indent2;
        SmcTransition transition = guard.getTransition();
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String packageName = map.getFSM().getPackage();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        SmcElement.TransType transType = guard.getTransType();
        boolean loopbackFlag = false;
        String endStateName = guard.getEndState();
        String fqEndStateName = "";
        String pushStateName = guard.getPushState();
        String condition = guard.getCondition();
        List actions = guard.getActions();
        if (packageName != null && packageName.length() > 0) {
            mapName = packageName + "::" + mapName;
            context = packageName + "::" + context;
        }
        if (transType != SmcElement.TransType.TRANS_POP && endStateName.length() > 0 && !endStateName.equals("nil") && endStateName.indexOf("::") < 0) {
            endStateName = mapName + "::" + endStateName;
        }
        if (stateName.indexOf("::") < 0) {
            stateName = mapName + "::" + stateName;
        }
        if (pushStateName != null && pushStateName.length() > 0) {
            if (pushStateName.indexOf("::") < 0) {
                pushStateName = mapName + "::" + pushStateName;
            } else if (packageName != null && packageName.length() > 0) {
                pushStateName = packageName + "::" + pushStateName;
            }
        }
        loopbackFlag = this.isLoopback(transType, endStateName);
        if (this._guardCount > 1) {
            indent2 = this._indent + "        ";
            if (this._guardIndex == 0 && condition.length() > 0) {
                this._source.print(this._indent);
                this._source.print("    if (");
                this._source.print(condition);
                this._source.println(") {");
            } else if (condition.length() > 0) {
                this._source.println();
                this._source.print(this._indent);
                this._source.print("    elsif (");
                this._source.print(condition);
                this._source.println(") {");
            } else {
                this._source.println();
                this._source.print(this._indent);
                this._source.println("    else {");
            }
        } else if (condition.length() == 0) {
            indent2 = this._indent + "    ";
        } else {
            indent2 = this._indent + "        ";
            this._source.print(this._indent);
            this._source.print("    if (");
            this._source.print(condition);
            this._source.println(") {");
        }
        if (actions.size() == 0 && endStateName.length() != 0) {
            fqEndStateName = endStateName;
        } else if (actions.size() > 0) {
            if (loopbackFlag) {
                fqEndStateName = "endState";
                this._source.print(indent2);
                this._source.print("my $");
                this._source.print(fqEndStateName);
                this._source.println(" = $fsm->getState();");
            } else {
                fqEndStateName = endStateName;
            }
        }
        if (transType == SmcElement.TransType.TRANS_POP || !loopbackFlag) {
            if (this._debugLevel >= 1) {
                this._source.print(indent2);
                this._source.println("if ($fsm->getDebugFlag()) {");
                this._source.print(indent2);
                this._source.println("    my $fh = $fsm->getDebugStream();");
                this._source.print(indent2);
                this._source.print("    print $fh \"");
                this._source.print("BEFORE EXIT     : ");
                this._source.print(stateName);
                this._source.println("->Exit($fsm)\\n\";");
                this._source.print(indent2);
                this._source.println("}");
            }
            this._source.print(indent2);
            this._source.println("$fsm->getState()->Exit($fsm);");
            if (this._debugLevel >= 1) {
                this._source.print(indent2);
                this._source.println("if ($fsm->getDebugFlag()) {");
                this._source.print(indent2);
                this._source.println("    my $fh = $fsm->getDebugStream();");
                this._source.print(indent2);
                this._source.print("    print $fh \"");
                this._source.print("AFTER EXIT      : ");
                this._source.print(stateName);
                this._source.println("->Exit($fsm)\\n\";");
                this._source.print(indent2);
                this._source.println("}");
            }
        }
        if (this._debugLevel >= 0) {
            parameters = transition.getParameters();
            this._source.print(indent2);
            this._source.println("if ($fsm->getDebugFlag()) {");
            this._source.print(indent2);
            this._source.println("    my $fh = $fsm->getDebugStream();");
            this._source.print(indent2);
            this._source.print("    print $fh \"");
            this._source.print("ENTER TRANSITION: ");
            this._source.print(stateName);
            this._source.print("->");
            this._source.print(transName);
            this._source.print("(");
            pit = parameters.iterator();
            sep = "";
            while (pit.hasNext()) {
                this._source.print(sep);
                this._source.print(((SmcParameter)pit.next()).getName());
                sep = ", ";
            }
            this._source.print(")");
            this._source.println("\\n\";");
            this._source.print(indent2);
            this._source.println("}");
        }
        if (actions.isEmpty()) {
            List entryActions = state.getEntryActions();
            List exitActions = state.getExitActions();
            if (condition.length() > 0) {
                this._source.print(indent2);
                this._source.println("# No actions.");
            }
            indent3 = indent2;
        } else {
            this._source.print(indent2);
            this._source.println("$fsm->clearState();");
            if (!this._noCatchFlag) {
                this._source.print(indent2);
                this._source.println("eval {");
                indent3 = indent2 + "    ";
            } else {
                indent3 = indent2;
            }
            String indent4 = this._indent;
            this._indent = indent3;
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
            this._indent = indent4;
            if (this._debugLevel >= 0) {
                parameters = transition.getParameters();
                this._source.print(indent2);
                this._source.println("if ($fsm->getDebugFlag()) {");
                this._source.print(indent2);
                this._source.println("    my $fh = $fsm->getDebugStream();");
                this._source.print(indent2);
                this._source.print("    print $fh \"");
                this._source.print("EXIT TRANSITION : ");
                this._source.print(stateName);
                this._source.print("->");
                this._source.print(transName);
                this._source.print("(");
                pit = parameters.iterator();
                sep = "";
                while (pit.hasNext()) {
                    this._source.print(sep);
                    this._source.print(((SmcParameter)pit.next()).getName());
                    sep = ", ";
                }
                this._source.print(")");
                this._source.println("\\n\";");
                this._source.print(indent2);
                this._source.println("}");
            }
            if (!this._noCatchFlag) {
                this._source.print(indent2);
                this._source.println("};");
                this._source.print(indent2);
                this._source.println("warn $@ if ($@);");
            }
        }
        if (this._debugLevel >= 0) {
            parameters = transition.getParameters();
            this._source.print(indent3);
            this._source.println("if ($fsm->getDebugFlag()) {");
            this._source.print(indent3);
            this._source.println("    my $fh = $fsm->getDebugStream();");
            this._source.print(indent2);
            this._source.print("    print $fh \"");
            this._source.print("EXIT TRANSITION : ");
            this._source.print(stateName);
            this._source.print("->");
            this._source.print(transName);
            this._source.print("(");
            pit = parameters.iterator();
            sep = "";
            while (pit.hasNext()) {
                this._source.print(sep);
                this._source.print(((SmcParameter)pit.next()).getName());
                sep = ", ";
            }
            this._source.print(")");
            this._source.println("\\n\";");
            this._source.print(indent3);
            this._source.println("}");
        }
        if (!(transType != SmcElement.TransType.TRANS_SET || actions.size() <= 0 && loopbackFlag)) {
            this._source.print(indent2);
            this._source.print("$fsm->setState($");
            this._source.print(fqEndStateName);
            this._source.println(");");
        } else if (transType == SmcElement.TransType.TRANS_PUSH) {
            if (!loopbackFlag || actions.size() > 0) {
                this._source.print(indent2);
                this._source.print("$fsm->setState($");
                this._source.print(fqEndStateName);
                this._source.println(");");
            }
            if (!loopbackFlag) {
                if (this._debugLevel >= 1) {
                    this._source.print(indent2);
                    this._source.println("if ($fsm->getDebugFlag()) {");
                    this._source.print(indent2);
                    this._source.println("    my $fh = $fsm->getDebugStream();");
                    this._source.print(indent2);
                    this._source.print("    print $fh \"");
                    this._source.print("BEFORE ENTRY    : ");
                    this._source.print(stateName);
                    this._source.println("->Entry($fsm)\\n\";");
                    this._source.print(indent2);
                    this._source.println("}");
                }
                this._source.print(indent2);
                this._source.println("$fsm->getState()->Entry($fsm);");
                if (this._debugLevel >= 1) {
                    this._source.print(indent2);
                    this._source.println("if ($fsm->getDebugFlag()) {");
                    this._source.print(indent2);
                    this._source.println("    my $fh = $fsm->getDebugStream();");
                    this._source.print(indent2);
                    this._source.print("    print $fh \"");
                    this._source.print("AFTER ENTRY     : ");
                    this._source.print(stateName);
                    this._source.println("->Entry($fsm)\\n\";");
                    this._source.print(indent2);
                    this._source.println("}");
                }
            }
            this._source.print(indent2);
            this._source.print("$fsm->pushState($");
            this._source.print(pushStateName);
            this._source.println(");");
        } else if (transType == SmcElement.TransType.TRANS_POP) {
            this._source.print(indent2);
            this._source.println("$fsm->popState();");
        }
        if (transType == SmcElement.TransType.TRANS_SET && !loopbackFlag || transType == SmcElement.TransType.TRANS_PUSH) {
            if (this._debugLevel >= 1) {
                this._source.print(indent2);
                this._source.println("if ($fsm->getDebugFlag()) {");
                this._source.print(indent2);
                this._source.println("    my $fh = $fsm->getDebugStream();");
                this._source.print(indent2);
                this._source.print("    print $fh \"");
                this._source.print("BEFORE ENTRY    : ");
                this._source.print(stateName);
                this._source.println("->Entry($fsm)\\n\";");
                this._source.print(indent2);
                this._source.println("}");
            }
            this._source.print(indent2);
            this._source.println("$fsm->getState()->Entry($fsm);");
            if (this._debugLevel >= 1) {
                this._source.print(indent2);
                this._source.println("if ($fsm->getDebugFlag()) {");
                this._source.print(indent2);
                this._source.println("    my $fh = $fsm->getDebugStream();");
                this._source.print(indent2);
                this._source.print("    print $fh \"");
                this._source.print("AFTER ENTRY     : ");
                this._source.print(stateName);
                this._source.println("->Entry($fsm)\\n\";");
                this._source.print(indent2);
                this._source.println("}");
            }
        }
        if (transType == SmcElement.TransType.TRANS_POP && !endStateName.equals("nil") && endStateName.length() > 0) {
            String popArgs = guard.getPopArgs();
            this._source.print(indent2);
            this._source.print("$fsm->");
            this._source.print(endStateName);
            this._source.print("(");
            if (popArgs.length() > 0) {
                this._source.print(popArgs);
                this._source.println();
                this._source.print(indent2);
                this._source.println(");");
            } else {
                this._source.println(");");
            }
        }
        if (this._guardCount > 1) {
            this._source.print(this._indent);
            this._source.print("    }");
        }
    }

    public void visit(SmcAction action) {
        String name = action.getName();
        this._source.print(this._indent);
        if (action.isEmptyStateStack()) {
            this._source.println("$fsm->emptyStateStack();");
        } else {
            this._source.print("$ctxt->");
            this._source.print(name);
            this._source.print("(");
            Iterator it = action.getArguments().iterator();
            String sep = "";
            while (it.hasNext()) {
                this._source.print(sep);
                this._source.print((String)it.next());
                sep = ", ";
            }
            this._source.println(");");
        }
    }
}

