/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.util.Iterator;
import java.util.List;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.SmcVisitor;

public final class SmcObjCGenerator
extends SmcCodeGenerator {
    public SmcObjCGenerator(SmcOptions options) {
        super(options, "m");
    }

    public void visit(SmcFSM fsm) {
        String packageName = fsm.getPackage();
        String rawSource = fsm.getSource();
        String context = fsm.getContext();
        String fsmClassName = fsm.getFsmClassName();
        String fqStateName = fsm.getStartState();
        boolean packageDepth = false;
        this._source.println("/*");
        this._source.println(" * ex: set ro:");
        this._source.println(" * DO NOT EDIT.");
        this._source.println(" * generated by smc (http://smc.sourceforge.net/)");
        this._source.print(" * from file : ");
        this._source.print(this._srcfileBase);
        this._source.println(".sm");
        this._source.println(" */");
        this._source.println();
        if (rawSource != null && rawSource.length() > 0) {
            this._source.println(rawSource);
            this._source.println();
        }
        for (String include : fsm.getIncludes()) {
            this._source.print("#import ");
            this._source.println(include);
        }
        this._source.print("#import \"");
        this._source.print(this._srcfileBase);
        this._source.println(".h\"");
        this._source.print(this._indent);
        this._source.println("// Class declarations.");
        Iterator mapIt = fsm.getMaps().iterator();
        int index = 0;
        while (mapIt.hasNext()) {
            SmcMap map = (SmcMap)mapIt.next();
            String mapName = map.getName();
            this._source.print(this._indent);
            this._source.print("@implementation ");
            this._source.println(mapName);
            for (SmcState state : map.getStates()) {
                this._source.print(this._indent);
                this._source.print("+ (");
                this._source.print(mapName);
                this._source.print("_");
                this._source.print(state.getClassName());
                this._source.print("*)");
                this._source.print(state.getInstanceName());
                this._source.println(";");
                this._source.print(this._indent);
                this._source.println("{");
                this._source.print(this._indent);
                this._source.print("    ");
                this._source.print("static ");
                this._source.print(mapName);
                this._source.print("_");
                this._source.print(state.getClassName());
                this._source.print(" *g");
                this._source.print(mapName);
                this._source.print("_");
                this._source.print(state.getClassName());
                this._source.println(" = nil;");
                this._source.print(this._indent);
                this._source.print("    if (!g");
                this._source.print(mapName);
                this._source.print("_");
                this._source.print(state.getClassName());
                this._source.println(")");
                this._source.print(this._indent);
                this._source.println("    {");
                this._source.print(this._indent);
                this._source.print("        g");
                this._source.print(mapName);
                this._source.print("_");
                this._source.print(state.getClassName());
                this._source.print(" = [[");
                this._source.print(mapName);
                this._source.print("_");
                this._source.print(state.getClassName());
                this._source.print(" alloc] initWithName:@\"");
                this._source.print(mapName);
                this._source.print("::");
                this._source.print(state.getClassName());
                this._source.print("\" stateId:");
                this._source.print(index);
                this._source.println("];");
                this._source.print(this._indent);
                this._source.println("    }");
                this._source.print(this._indent);
                this._source.print("    ");
                this._source.print("return g");
                this._source.print(mapName);
                this._source.print("_");
                this._source.print(state.getClassName());
                this._source.println(";");
                this._source.print(this._indent);
                this._source.println("}");
                this._source.println();
                ++index;
            }
            this._source.println("@end");
        }
        List transList = fsm.getTransitions();
        this._source.println();
        this._source.print(this._indent);
        this._source.print("@implementation ");
        this._source.print(context);
        this._source.println("State");
        this._source.print(this._indent);
        this._source.print("- (void)Entry:(");
        this._source.print(fsmClassName);
        this._source.println("*)context");
        this._source.print(this._indent);
        this._source.println("{");
        this._source.print(this._indent);
        this._source.println("}");
        this._source.print(this._indent);
        this._source.print("- (void)Exit:(");
        this._source.print(fsmClassName);
        this._source.println("*)context");
        this._source.print(this._indent);
        this._source.println("{");
        this._source.print(this._indent);
        this._source.println("}");
        for (SmcTransition trans : transList) {
            if (trans.getName().equals("Default")) continue;
            this._source.print(this._indent);
            this._source.print("- (void)");
            this._source.print(trans.getName());
            this._source.print(":(");
            this._source.print(fsmClassName);
            this._source.print("*)context");
            for (SmcParameter param : trans.getParameters()) {
                this._source.print(" :");
                param.accept((SmcVisitor)this);
            }
            this._source.println(";");
            this._source.print(this._indent);
            this._source.println("{");
            this._source.print(this._indent);
            this._source.println("    [self Default:context];");
            this._source.print(this._indent);
            this._source.println("}");
        }
        this._source.println();
        this._source.print(this._indent);
        this._source.print("- (void)Default:(");
        this._source.print(fsmClassName);
        this._source.println("*)context;");
        this._source.print(this._indent);
        this._source.println("{");
        if (this._debugLevel >= 0) {
            this._source.print(this._indent);
            this._source.println("    if ( [context debugFlag] )");
            this._source.print(this._indent);
            this._source.print("{");
            this._source.print(this._indent);
            this._source.print("        TRACE(@");
            this._source.println("\"TRANSITION   : Default\\n\\r\");");
            this._source.print(this._indent);
            this._source.println("    }");
        }
        this._source.print(this._indent);
        this._source.println("    NSAssert( NO, @\"Default transition\" );");
        this._source.print(this._indent);
        this._source.println("}");
        this._source.println("@end");
        this._source.println();
        mapIt = fsm.getMaps().iterator();
        while (mapIt.hasNext()) {
            ((SmcMap)mapIt.next()).accept((SmcVisitor)this);
        }
        this._source.print(this._indent);
        this._source.print("@implementation ");
        this._source.print(fsmClassName);
        this._source.println("");
        if (fqStateName.indexOf("::") >= 0) {
            fqStateName = this.convertScope(fqStateName);
        }
        this._source.print(this._indent);
        this._source.print("- (id)initWithOwner:(");
        this._source.print(context);
        this._source.print("*)");
        this._source.println("owner;");
        this._source.print(this._indent);
        this._source.println("{");
        this._source.print(this._indent);
        this._source.print("    ");
        this._source.print("self = [super initWithState:");
        this._source.print(fqStateName);
        this._source.println("];");
        this._source.print(this._indent);
        this._source.print("    ");
        this._source.println("if (!self)");
        this._source.print(this._indent);
        this._source.println("{");
        this._source.print(this._indent);
        this._source.print("        ");
        this._source.println("return nil;");
        this._source.print(this._indent);
        this._source.println("    }");
        this._source.print(this._indent);
        this._source.print("    ");
        this._source.println("_owner = owner;");
        this._source.print(this._indent);
        this._source.print("    ");
        this._source.println("return self;");
        this._source.print(this._indent);
        this._source.println("}");
        this._source.print(this._indent);
        this._source.print("- (id)initWithOwner:(");
        this._source.print(context);
        this._source.print("*)");
        this._source.println("owner state:(SMCState*)aState;");
        this._source.print(this._indent);
        this._source.println("{");
        this._source.print(this._indent);
        this._source.print("    ");
        this._source.println("self = [super initWithState: aState];");
        this._source.print(this._indent);
        this._source.print("    ");
        this._source.println("if (!self)");
        this._source.print(this._indent);
        this._source.println("{");
        this._source.print(this._indent);
        this._source.print("        ");
        this._source.println("return nil;");
        this._source.print(this._indent);
        this._source.println("    }");
        this._source.print(this._indent);
        this._source.print("    ");
        this._source.println("_owner = owner;");
        this._source.print(this._indent);
        this._source.print("    ");
        this._source.println("return self;");
        this._source.print(this._indent);
        this._source.println("}");
        this._source.print(this._indent);
        this._source.print("- (");
        this._source.print(context);
        this._source.println("State*)state;");
        this._source.print(this._indent);
        this._source.println("{");
        this._source.print(this._indent);
        this._source.print("    ");
        this._source.print("return (");
        this._source.print(context);
        this._source.println("State*)_state;");
        this._source.print(this._indent);
        this._source.println("}");
        this._source.print(this._indent);
        this._source.print("- (");
        this._source.print(context);
        this._source.println("*)owner;");
        this._source.print(this._indent);
        this._source.println("{");
        this._source.print(this._indent);
        this._source.print("    ");
        this._source.println("return _owner;");
        this._source.print(this._indent);
        this._source.println("}");
        this._source.print(this._indent);
        this._source.println("- (void)enterStartState;");
        this._source.print(this._indent);
        this._source.println("{");
        this._source.print(this._indent);
        this._source.println("    [[self state] Entry:self];");
        this._source.print(this._indent);
        this._source.println("}");
        for (SmcTransition trans : transList) {
            if (trans.getName().equals("Default")) continue;
            this._source.println();
            this._source.print(this._indent);
            this._source.print("- (void)");
            this._source.print(trans.getName());
            List params = trans.getParameters();
            Iterator pit = params.iterator();
            String separator = ":";
            while (pit.hasNext()) {
                this._source.print(separator);
                ((SmcParameter)pit.next()).accept((SmcVisitor)this);
                separator = " :";
            }
            this._source.println(";");
            this._source.print(this._indent);
            this._source.println("{");
            if (this._debugLevel >= 0) {
                this._source.print(this._indent);
                this._source.print("    [self setTransition:@\"");
                this._source.print(trans.getName());
                this._source.println("\"];");
            }
            this._source.print(this._indent);
            this._source.print("    [[self state] ");
            this._source.print(trans.getName());
            this._source.print(":self");
            pit = params.iterator();
            while (pit.hasNext()) {
                this._source.print(" :");
                this._source.print(((SmcParameter)pit.next()).getName());
            }
            this._source.println("];");
            if (this._debugLevel >= 0) {
                this._source.print(this._indent);
                this._source.println("    [self setTransition:nil];");
            }
            this._source.print(this._indent);
            this._source.println("}");
        }
        this._source.print(this._indent);
        this._source.println("@end");
        this._source.println();
        this._source.println("/*");
        this._source.println(" * Local variables:");
        this._source.println(" *  buffer-read-only: t");
        this._source.println(" * End:");
        this._source.println(" */");
    }

    public void visit(SmcMap map) {
        this._source.println();
        this._source.print(this._indent);
        this._source.print("@implementation ");
        this._source.print(map.getName());
        this._source.println("_Default");
        if (map.hasDefaultState()) {
            SmcState defaultState = map.getDefaultState();
            for (SmcTransition transition : defaultState.getTransitions()) {
                transition.accept((SmcVisitor)this);
            }
        }
        this._source.println("@end");
        for (SmcState state : map.getStates()) {
            state.accept((SmcVisitor)this);
        }
    }

    public void visit(SmcState state) {
        String indent2;
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String fsmClassName = map.getFSM().getFsmClassName();
        String mapName = map.getName();
        String className = state.getClassName();
        this._source.print(this._indent);
        this._source.print("@implementation ");
        this._source.print(mapName);
        this._source.print("_");
        this._source.println(className);
        List actions = state.getEntryActions();
        if (actions != null && actions.size() > 0) {
            this._source.print(this._indent);
            this._source.print("- (void)Entry:(");
            this._source.print(fsmClassName);
            this._source.println("*)context;");
            this._source.println();
            this._source.println("{");
            this._source.print(this._indent);
            this._source.print("    ");
            this._source.print(context);
            this._source.println(" *ctxt = [context owner];");
            this._source.println();
            indent2 = this._indent;
            this._indent = this._indent + "    ";
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
            this._indent = indent2;
            this._source.print(this._indent);
            this._source.println("}");
        }
        if ((actions = state.getExitActions()) != null && actions.size() > 0) {
            this._source.print(this._indent);
            this._source.print("- (void)Exit:(");
            this._source.print(fsmClassName);
            this._source.println("*)context;");
            this._source.println();
            this._source.println("{");
            this._source.print(this._indent);
            this._source.print("    ");
            this._source.print(context);
            this._source.println(" *ctxt = [context owner];");
            this._source.println();
            indent2 = this._indent;
            this._indent = this._indent + "    ";
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
            this._indent = indent2;
            this._source.print(this._indent);
            this._source.println("}");
        }
        for (SmcTransition transition : state.getTransitions()) {
            transition.accept((SmcVisitor)this);
        }
        this._source.print(this._indent);
        this._source.println("@end");
        this._source.println();
    }

    public void visit(SmcTransition transition) {
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String fsmClassName = map.getFSM().getFsmClassName();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        boolean nullCondition = false;
        List guards = transition.getGuards();
        String fqStateName = stateName.indexOf("::") < 0 ? "[" + mapName + " " + stateName + "]" : stateName;
        this._source.println();
        this._source.print(this._indent);
        this._source.print("- (void)");
        this._source.print(transName);
        this._source.print(":(");
        this._source.print(fsmClassName);
        this._source.print("*)context");
        for (SmcParameter param : transition.getParameters()) {
            this._source.print(" :");
            param.accept((SmcVisitor)this);
        }
        this._source.println(";");
        this._source.print(this._indent);
        this._source.println("{");
        if (transition.hasCtxtReference()) {
            this._source.print(this._indent);
            this._source.print("    ");
            this._source.print(context);
            this._source.println(" *ctxt = [context owner];");
        }
        if (this._debugLevel >= 0) {
            this._source.print(this._indent);
            this._source.println("    if ( [context debugFlag] )");
            this._source.print(this._indent);
            this._source.println("    {");
            this._source.print(this._indent);
            this._source.print("        TRACE(@\"LEAVING STATE   : ");
            this._source.print(mapName);
            this._source.print("::");
            this._source.print(stateName);
            this._source.println("\\n\\r\");");
            this._source.print(this._indent);
            this._source.println("    }");
        }
        Iterator git = guards.iterator();
        this._guardIndex = 0;
        this._guardCount = guards.size();
        while (git.hasNext()) {
            SmcGuard guard = (SmcGuard)git.next();
            if (guard.getCondition().length() == 0) {
                nullCondition = true;
            }
            guard.accept((SmcVisitor)this);
            ++this._guardIndex;
        }
        if (this._guardIndex > 0 && !nullCondition) {
            if (this._guardCount == 1) {
                this._source.print(this._indent);
                this._source.println("    }");
            }
            this._source.print(this._indent);
            this._source.println("    else");
            this._source.print(this._indent);
            this._source.println("    {");
            this._source.print(this._indent);
            this._source.print("         [super ");
            this._source.print(transName);
            this._source.print(":context");
            for (SmcParameter param : transition.getParameters()) {
                this._source.print(" :");
                this._source.print(param.getName());
            }
            this._source.println("];");
            this._source.print(this._indent);
            this._source.println("    }");
        } else if (this._guardCount > 1) {
            this._source.println();
        }
        this._source.print(this._indent);
        this._source.println("}");
    }

    public void visit(SmcGuard guard) {
        String indent3;
        String sep;
        Iterator pit;
        String indent2;
        SmcTransition transition = guard.getTransition();
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        SmcElement.TransType transType = guard.getTransType();
        boolean loopbackFlag = false;
        String indent4 = "";
        String endStateName = guard.getEndState();
        String fqEndStateName = "";
        String pushStateName = guard.getPushState();
        String condition = guard.getCondition();
        List actions = guard.getActions();
        if (transType != SmcElement.TransType.TRANS_POP && endStateName.length() > 0 && !endStateName.equals("nil") && endStateName.indexOf("::") < 0) {
            endStateName = mapName + "::" + endStateName;
        }
        if (endStateName.indexOf("::") >= 0) {
            endStateName = this.convertScope(endStateName);
        }
        if (stateName.indexOf("::") >= 0) {
            stateName = this.convertScope(stateName);
        }
        loopbackFlag = this.isLoopback(transType, endStateName);
        if (pushStateName != null && pushStateName.length() > 0 && pushStateName.indexOf("::") < 0) {
            pushStateName = "[" + mapName + " " + pushStateName + "]";
        }
        if (pushStateName.indexOf("::") >= 0) {
            pushStateName = this.convertScope(pushStateName);
        }
        if (this._guardCount > 1) {
            indent2 = this._indent + "        ";
            if (this._guardIndex == 0 && condition.length() > 0) {
                this._source.print(this._indent);
                this._source.print("    if (");
                this._source.print(condition);
                this._source.println(")");
                this._source.print(this._indent);
                this._source.println("    {");
            } else if (condition.length() > 0) {
                this._source.println();
                this._source.print(this._indent);
                this._source.print("    else if (");
                this._source.print(condition);
                this._source.println(")");
                this._source.println(this._indent);
                this._source.println("    {");
            } else {
                this._source.println();
                this._source.print(this._indent);
                this._source.println("    else");
                this._source.print(this._indent);
                this._source.println("    {");
            }
        } else if (condition.length() == 0) {
            indent2 = this._indent + "    ";
        } else {
            this._source.print(this._indent);
            this._source.print("    if (");
            this._source.print(condition);
            this._source.println(")");
            this._source.print(this._indent);
            this._source.println("    {");
            indent2 = this._indent + "        ";
        }
        if (actions.size() == 0 && endStateName.length() > 0) {
            fqEndStateName = endStateName;
        } else if (actions.size() > 0) {
            if (loopbackFlag) {
                fqEndStateName = "EndStateName";
                this._source.print(indent2);
                this._source.print(context);
                this._source.print("State* ");
                this._source.print(fqEndStateName);
                this._source.println(" = [context state];");
                this._source.println();
            } else {
                fqEndStateName = endStateName;
            }
        }
        if (transType == SmcElement.TransType.TRANS_POP || !loopbackFlag) {
            if (this._debugLevel >= 1) {
                this._source.print(indent2);
                this._source.println("if ( [context debugFlag] )");
                this._source.print(indent2);
                this._source.print("{");
                this._source.print(indent2);
                this._source.print("    TRACE(@\"BEFORE EXIT     : ");
                this._source.print(stateName);
                this._source.println("\\n\\r\");");
                this._source.print(indent2);
                this._source.print("}");
            }
            this._source.print(indent2);
            this._source.println("[[context state] Exit:context];");
            if (this._debugLevel >= 1) {
                this._source.print(indent2);
                this._source.println("if ( [context debugFlag] )");
                this._source.print(indent2);
                this._source.print("{");
                this._source.print(indent2);
                this._source.print("    TRACE(@\"AFTER EXIT      : ");
                this._source.print(stateName);
                this._source.println("\\n\\r\");");
                this._source.print(indent2);
                this._source.print("}");
            }
        }
        if (this._debugLevel >= 0) {
            this._source.print(indent2);
            this._source.println("if ( [context debugFlag] )");
            this._source.print(indent2);
            this._source.println("{");
            this._source.print(indent2);
            this._source.print("    TRACE(@\"ENTER TRANSITION: ");
            this._source.print(mapName);
            this._source.print(" ");
            this._source.print(transName);
            this._source.print("(");
            pit = transition.getParameters().iterator();
            sep = "";
            while (pit.hasNext()) {
                this._source.print(sep);
                ((SmcParameter)pit.next()).accept((SmcVisitor)this);
                sep = " ";
            }
            this._source.println(")\\n\\r\");");
            this._source.print(indent2);
            this._source.println("}");
        }
        if (actions.isEmpty()) {
            if (condition.length() > 0) {
                this._source.print(indent2);
                this._source.println("// No actions.");
            }
            indent3 = indent2;
        } else {
            this._source.print(indent2);
            this._source.println("[context clearState];");
            indent3 = indent2;
            indent4 = this._indent;
            this._indent = indent3;
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
            this._indent = indent4;
        }
        if (this._debugLevel >= 0) {
            this._source.print(indent3);
            this._source.println("if ( [context debugFlag] )");
            this._source.print(indent3);
            this._source.println("{");
            this._source.print(indent3);
            this._source.print("    TRACE(@\"EXIT TRANSITION : ");
            this._source.print(mapName);
            this._source.print(" ");
            this._source.print(transName);
            this._source.print("(");
            pit = transition.getParameters().iterator();
            sep = "";
            while (pit.hasNext()) {
                this._source.print(sep);
                ((SmcParameter)pit.next()).accept((SmcVisitor)this);
                sep = " ";
            }
            this._source.println(")\\n\\r\");");
            this._source.print(indent3);
            this._source.println("}");
        }
        if (!(transType != SmcElement.TransType.TRANS_SET || actions.isEmpty() && loopbackFlag)) {
            this._source.print(indent3);
            this._source.print("[context setState:");
            this._source.print(fqEndStateName);
            this._source.println("];");
        } else if (transType == SmcElement.TransType.TRANS_PUSH) {
            if (!loopbackFlag || actions.size() > 0) {
                this._source.print(indent3);
                this._source.print("[context setState:");
                this._source.print(fqEndStateName);
                this._source.println("];");
            }
            if (!loopbackFlag) {
                if (this._debugLevel >= 1) {
                    this._source.print(indent3);
                    this._source.println("if ( [context debugFlag] )");
                    this._source.print(indent3);
                    this._source.print("{");
                    this._source.print(indent3);
                    this._source.print("    TRACE(@\"BEFORE ENTRY    : ");
                    this._source.print(stateName);
                    this._source.println("\\n\\r\");");
                    this._source.print(indent3);
                    this._source.print("}");
                }
                this._source.println();
                this._source.print(indent3);
                this._source.println("[[context state] Entry:context];");
                if (this._debugLevel >= 1) {
                    this._source.print(indent3);
                    this._source.println("if ( [context debugFlag] )");
                    this._source.print(indent3);
                    this._source.print("{");
                    this._source.print(indent3);
                    this._source.print("    TRACE(@\"AFTER ENTRY     : ");
                    this._source.print(stateName);
                    this._source.println("\\n\\r\");");
                    this._source.print(indent3);
                    this._source.print("}");
                }
            }
            this._source.print(indent3);
            this._source.print("[context pushState:");
            this._source.print(pushStateName);
            this._source.println("];");
        } else if (transType == SmcElement.TransType.TRANS_POP) {
            this._source.print(indent3);
            this._source.println("[context popState];");
        }
        if (transType == SmcElement.TransType.TRANS_SET && !loopbackFlag || transType == SmcElement.TransType.TRANS_PUSH) {
            if (this._debugLevel >= 1) {
                this._source.print(indent2);
                this._source.println("if ( [context debugFlag] )");
                this._source.print(indent2);
                this._source.print("{");
                this._source.print(indent2);
                this._source.print("    TRACE(@\"BEFORE ENTRY    : ");
                this._source.print(stateName);
                this._source.println("\\n\\r\");");
                this._source.print(indent2);
                this._source.print("}");
            }
            this._source.print(indent2);
            this._source.println("[[context state] Entry:context];");
            if (this._debugLevel >= 1) {
                this._source.print(indent2);
                this._source.println("if ( [context debugFlag] )");
                this._source.print(indent2);
                this._source.print("{");
                this._source.print(indent2);
                this._source.print("    TRACE(@\"AFTER ENTRY     : ");
                this._source.print(stateName);
                this._source.println("\\n\\r\");");
                this._source.print(indent2);
                this._source.print("}");
            }
        }
        if (transType == SmcElement.TransType.TRANS_POP && !endStateName.equals("nil") && endStateName.length() > 0) {
            String popArgs = guard.getPopArgs();
            int popLength = popArgs.length();
            this._source.print(indent2);
            this._source.print("[context ");
            this._source.print(endStateName);
            if (popLength > 0) {
                int cur = 0;
                int comma = popArgs.indexOf(44);
                while (comma >= 0) {
                    this._source.print(':');
                    this._source.print(popArgs.substring(cur, comma));
                    cur = comma + 1;
                    comma = popArgs.indexOf(44, cur);
                }
                if (cur < popLength) {
                    this._source.print(':');
                    this._source.print(popArgs.substring(cur));
                }
            }
            this._source.println("];");
        }
        if (this._guardCount > 1) {
            this._source.print(this._indent);
            this._source.print("    }");
        }
    }

    public void visit(SmcAction action) {
        String name = action.getName();
        String sep = ":";
        this._source.print(this._indent);
        if (action.isEmptyStateStack()) {
            this._source.println("[context emptyStateStack];");
        } else {
            this._source.print("[ctxt ");
            this._source.print(name);
            for (String arg : action.getArguments()) {
                if (arg.trim().length() <= 0) continue;
                this._source.print(sep);
                this._source.print(arg);
            }
            this._source.println("];");
        }
    }

    public void visit(SmcParameter parameter) {
        this._source.print("(");
        this._source.print(parameter.getType());
        this._source.print(")");
        this._source.print(parameter.getName());
    }

    private String convertScope(String s) {
        int index = s.indexOf("::");
        return "[" + s.substring(0, index) + " " + s.substring(index + 2) + "]";
    }
}

