/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.SmcVisitor;

public final class SmcLuaGenerator
extends SmcCodeGenerator {
    public SmcLuaGenerator(SmcOptions options) {
        super(options, "lua");
    }

    public void visit(SmcFSM fsm) {
        String mapName;
        List params;
        String packageName = fsm.getPackage();
        String context = fsm.getContext();
        String fsmClassName = fsm.getFsmClassName();
        String rawSource = fsm.getSource();
        String startState = fsm.getStartState();
        List maps = fsm.getMaps();
        boolean packageDepth = false;
        this._source.println("-- ex: set ro:");
        this._source.println("-- DO NOT EDIT.");
        this._source.println("-- generated by smc (http://smc.sourceforge.net/)");
        this._source.print("-- from file : ");
        this._source.print(this._srcfileBase);
        this._source.println(".sm");
        this._source.println();
        this._source.println("module(..., package.seeall)");
        this._source.println();
        this._source.println("require 'statemap'");
        if (rawSource != null && rawSource.length() > 0) {
            this._source.println(rawSource);
            this._source.println();
        }
        for (String imp : fsm.getImports()) {
            this._source.print("require '");
            this._source.print(imp);
            this._source.println("'");
        }
        this._source.println();
        this._source.print("local ");
        this._source.print(context);
        this._source.println("State = statemap.State:class()");
        this._source.println();
        this._source.print("function ");
        this._source.print(context);
        this._source.println("State:Entry (fsm) end");
        this._source.println();
        this._source.print("function ");
        this._source.print(context);
        this._source.println("State:Exit (fsm) end");
        this._source.println();
        List transitions = fsm.getTransitions();
        for (SmcTransition trans : transitions) {
            params = trans.getParameters();
            if (trans.getName().equals("Default")) continue;
            this._source.print("function ");
            this._source.print(context);
            this._source.print("State:");
            this._source.print(trans.getName());
            this._source.print(" (fsm");
            for (SmcParameter param : params) {
                this._source.print(", ");
                this._source.print(param.getName());
            }
            this._source.println(")");
            this._source.println("    self:Default(fsm)");
            this._source.println("end");
            this._source.println();
        }
        this._source.print("function ");
        this._source.print(context);
        this._source.println("State:Default (fsm)");
        if (this._debugLevel >= 0) {
            this._source.println("    if fsm:getDebugFlag() then");
            this._source.println("        fsm:getDebugStream():write(\"TRANSITION   : Default\\n\")");
            this._source.println("    end");
        }
        this._source.println("    local msg = string.format(\"Undefined Transition\\nState: %s\\nTransition: %s\\n\",");
        this._source.println("                              fsm:getState():getName(),");
        this._source.println("                              fsm:getTransition())");
        this._source.println("    error(msg)");
        this._source.println("end");
        if (this._reflectFlag) {
            this._source.println();
            this._source.print("function ");
            this._source.print(context);
            this._source.println("State:getTransitions ()");
            this._source.println("    return self._transitions");
            this._source.println("end");
        }
        this._source.println();
        for (SmcMap map : maps) {
            mapName = map.getName();
            this._source.print("local ");
            this._source.print(mapName);
            this._source.println(" = {}");
        }
        for (SmcMap map : maps) {
            map.accept((SmcVisitor)this);
        }
        this._source.println();
        this._source.print(fsmClassName);
        this._source.println(" = statemap.FSMContext:class()");
        this._source.println();
        this._source.print("function ");
        this._source.print(fsmClassName);
        this._source.println(":_init ()");
        int index = startState.indexOf("::");
        String luaState = index >= 0 ? startState.substring(0, index) + "." + startState.substring(index + 2) : startState;
        this._source.print("    self:setState(");
        this._source.print(luaState);
        this._source.println(")");
        this._source.println("end");
        this._source.println();
        for (SmcTransition trans : transitions) {
            String transName = trans.getName();
            params = trans.getParameters();
            if (transName.equals("Default")) continue;
            this._source.print("function ");
            this._source.print(fsmClassName);
            this._source.print(":");
            this._source.print(transName);
            this._source.print(" (");
            if (params.size() != 0) {
                this._source.print("...");
            }
            this._source.println(")");
            this._source.print("    self._transition = '");
            this._source.print(transName);
            this._source.println("'");
            this._source.print("    self:getState():");
            this._source.print(transName);
            this._source.print("(self");
            if (params.size() != 0) {
                this._source.print(", ...");
            }
            this._source.println(")");
            this._source.println("    self._transition = nil");
            this._source.println("end");
            this._source.println();
        }
        this._source.print("function ");
        this._source.print(fsmClassName);
        this._source.println(":enterStartState ()");
        this._source.println("    self:getState():Entry(self)");
        this._source.println("end");
        this._source.println();
        this._source.print("function ");
        this._source.print(fsmClassName);
        this._source.println(":getOwner ()");
        this._source.println("    return self._owner");
        this._source.println("end");
        this._source.println();
        if (this._reflectFlag) {
            this._source.println("AppClassContext._States = {");
            for (SmcMap map : maps) {
                mapName = map.getName();
                for (SmcState state : map.getStates()) {
                    this._source.print("    ");
                    this._source.print(mapName);
                    this._source.print(".");
                    this._source.print(state.getClassName());
                    this._source.println(",");
                }
            }
            this._source.println("}");
            this._source.println("function AppClassContext:getStates ()");
            this._source.println("    return self._States");
            this._source.println("end");
            this._source.println();
            this._source.println("AppClassContext._transitions = {");
            for (SmcTransition trans : transitions) {
                this._source.print("    '");
                this._source.print(trans.getName());
                this._source.println("',");
            }
            this._source.println("}");
            this._source.println("function AppClassContext:getTransitions ()");
            this._source.println("    return self._transitions");
            this._source.println("end");
            this._source.println();
        }
        this._source.println("-- Local variables:");
        this._source.println("--  buffer-read-only: t");
        this._source.println("-- End:");
    }

    public void visit(SmcMap map) {
        SmcState defaultState = map.getDefaultState();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        List states = map.getStates();
        ArrayList definedDefaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList();
        this._source.println();
        this._source.print(mapName);
        this._source.print(".Default = ");
        this._source.print(context);
        this._source.print("State:new('");
        this._source.print(mapName);
        this._source.println(".Default', -1)");
        for (SmcTransition transition : definedDefaultTransitions) {
            transition.accept((SmcVisitor)this);
        }
        if (this._reflectFlag) {
            List allTransitions = map.getFSM().getTransitions();
            this._source.println();
            this._source.print(mapName);
            this._source.println(".Default._transitions = {");
            for (SmcTransition transition : allTransitions) {
                String transName = transition.getName();
                int transDefinition = definedDefaultTransitions.contains(transition) ? 2 : 0;
                this._source.print("    ");
                this._source.print(transName);
                this._source.print(" = ");
                this._source.print(transDefinition);
                this._source.println(",");
            }
            this._source.println("}");
        }
        for (SmcState state : states) {
            state.accept((SmcVisitor)this);
        }
    }

    public void visit(SmcState state) {
        String indent2;
        SmcMap map = state.getMap();
        String mapName = map.getName();
        String stateName = state.getClassName();
        this._source.println();
        this._source.print(mapName);
        this._source.print('.');
        this._source.print(stateName);
        this._source.print(" = ");
        this._source.print(mapName);
        this._source.print(".Default:new('");
        this._source.print(mapName);
        this._source.print('.');
        this._source.print(stateName);
        this._source.print("', ");
        this._source.print(map.getNextStateId());
        this._source.println(")");
        List actions = state.getEntryActions();
        if (actions != null && actions.size() > 0) {
            this._source.println();
            this._source.print("function ");
            this._source.print(mapName);
            this._source.print('.');
            this._source.print(stateName);
            this._source.println(":Entry (fsm)");
            this._source.println("    local ctxt = fsm:getOwner()");
            indent2 = this._indent;
            this._indent = this._indent + "    ";
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
            this._indent = indent2;
            this._source.println("end");
        }
        if ((actions = state.getExitActions()) != null && actions.size() > 0) {
            this._source.println();
            this._source.print("function ");
            this._source.print(mapName);
            this._source.print('.');
            this._source.print(stateName);
            this._source.println(":Exit (fsm)");
            this._source.print(this._indent);
            this._source.println("    local ctxt = fsm:getOwner()");
            indent2 = this._indent;
            this._indent = this._indent + "    ";
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
            this._indent = indent2;
            this._source.print(this._indent);
            this._source.println("end");
        }
        for (SmcTransition transition : state.getTransitions()) {
            transition.accept((SmcVisitor)this);
        }
        if (this._reflectFlag) {
            List allTransitions = map.getFSM().getTransitions();
            List stateTransitions = state.getTransitions();
            SmcState defaultState = map.getDefaultState();
            ArrayList defaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList();
            this._source.println();
            this._source.print(mapName);
            this._source.print(".");
            this._source.print(stateName);
            this._source.println("._transitions = {");
            for (SmcTransition transition : allTransitions) {
                String transName = transition.getName();
                int transDefinition = stateTransitions.contains(transition) ? 1 : (defaultTransitions.contains(transition) ? 2 : 0);
                this._source.print("    ");
                this._source.print(transName);
                this._source.print(" = ");
                this._source.print(transDefinition);
                this._source.println(",");
            }
            this._source.println("}");
        }
    }

    public void visit(SmcTransition transition) {
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String packageName = map.getFSM().getPackage();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        List parameters = transition.getParameters();
        List guards = transition.getGuards();
        boolean nullCondition = false;
        this._source.println();
        this._source.print("function ");
        this._source.print(mapName);
        this._source.print('.');
        this._source.print(stateName);
        this._source.print(':');
        this._source.print(transName);
        this._source.print(" (fsm");
        for (SmcParameter param : parameters) {
            this._source.print(", ");
            this._source.print(param.getName());
        }
        this._source.println(")");
        if (transition.hasCtxtReference()) {
            this._source.println("    local ctxt = fsm:getOwner()");
        }
        if (this._debugLevel >= 0) {
            this._source.println("    if fsm:getDebugFlag() then");
            this._source.print("        fsm:getDebugStream():write(");
            this._source.print("\"LEAVING STATE   : ");
            this._source.print(mapName);
            this._source.print(".");
            this._source.print(stateName);
            this._source.println("\\n\")");
            this._source.println("    end");
        }
        String indent2 = this._indent;
        this._indent = this._indent + "    ";
        Iterator git = guards.iterator();
        this._guardIndex = 0;
        this._guardCount = guards.size();
        while (git.hasNext()) {
            SmcGuard guard = (SmcGuard)git.next();
            if (guard.getCondition().length() == 0) {
                nullCondition = true;
            }
            guard.accept((SmcVisitor)this);
            ++this._guardIndex;
        }
        this._indent = indent2;
        if (this._guardIndex > 0 && !nullCondition) {
            this._source.print(this._indent);
            this._source.println("    else");
            this._source.print(this._indent);
            this._source.print("        ");
            this._source.print(mapName);
            this._source.print(".Default:");
            this._source.print(transName);
            this._source.print("(fsm");
            for (SmcParameter param : parameters) {
                this._source.print(", ");
                this._source.print(param.getName());
            }
            this._source.println(")");
            this._source.print(this._indent);
            this._source.println("    end");
        } else if (this._guardCount > 1) {
            this._source.print(this._indent);
            this._source.println("    end");
        }
        this._source.println("end");
    }

    public void visit(SmcGuard guard) {
        String indent3;
        String trArgName;
        String sep;
        Iterator pit;
        List parameters;
        String indent2;
        SmcTransition transition = guard.getTransition();
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String packageName = map.getFSM().getPackage();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        SmcElement.TransType transType = guard.getTransType();
        boolean loopbackFlag = false;
        String endStateName = guard.getEndState();
        String fqEndStateName = "";
        String pushStateName = guard.getPushState();
        String condition = guard.getCondition();
        List actions = guard.getActions();
        if (transType != SmcElement.TransType.TRANS_POP && endStateName.length() > 0 && !endStateName.equals("nil")) {
            endStateName = this.scopeStateName(endStateName, mapName);
        }
        stateName = this.scopeStateName(stateName, mapName);
        pushStateName = this.scopeStateName(pushStateName, mapName);
        loopbackFlag = this.isLoopback(transType, endStateName);
        if (this._guardCount > 1) {
            indent2 = this._indent + "    ";
            if (this._guardIndex == 0 && condition.length() > 0) {
                this._source.print(this._indent);
                this._source.print("if ");
                this._source.print(condition);
                this._source.println(" then");
            } else if (condition.length() > 0) {
                this._source.print(this._indent);
                this._source.print("elseif ");
                this._source.print(condition);
                this._source.println(" then");
            } else {
                this._source.print(this._indent);
                this._source.println("else");
            }
        } else if (condition.length() == 0) {
            indent2 = this._indent;
        } else {
            indent2 = this._indent + "        ";
            this._source.print(this._indent);
            this._source.print("    if ");
            this._source.print(condition);
            this._source.println(" then");
        }
        if (actions.size() == 0 && endStateName.length() != 0) {
            fqEndStateName = endStateName;
        } else if (actions.size() > 0) {
            if (loopbackFlag) {
                fqEndStateName = "endState";
                this._source.print(indent2);
                this._source.print("local ");
                this._source.print(fqEndStateName);
                this._source.println(" = fsm:getState()");
            } else {
                fqEndStateName = endStateName;
            }
        }
        if (transType == SmcElement.TransType.TRANS_POP || !loopbackFlag) {
            if (this._debugLevel >= 1) {
                this._source.print(indent2);
                this._source.println("if fsm:getDebugFlag() then");
                this._source.print(indent2);
                this._source.print("    fsm:getDebugStream():write(\"");
                this._source.print("BEFORE EXIT     : ");
                if (packageName != null && packageName.length() > 0) {
                    this._source.print(packageName);
                    this._source.print(".");
                }
                this._source.print(stateName);
                this._source.println(".Exit(fsm)\\n\")");
                this._source.print(indent2);
                this._source.println("end");
            }
            this._source.print(indent2);
            this._source.println("fsm:getState():Exit(fsm)");
            if (this._debugLevel >= 1) {
                this._source.print(indent2);
                this._source.println("if fsm:getDebugFlag() then");
                this._source.print(indent2);
                this._source.print("    fsm:getDebugStream():write(\"");
                this._source.print("AFTER EXIT      : ");
                if (packageName != null && packageName.length() > 0) {
                    this._source.print(packageName);
                    this._source.print(".");
                }
                this._source.print(stateName);
                this._source.println(".Exit(fsm)\\n\")");
                this._source.print(indent2);
                this._source.println("end");
            }
        }
        if (this._debugLevel >= 0) {
            parameters = transition.getParameters();
            this._source.print(indent2);
            this._source.println("if fsm:getDebugFlag() then");
            this._source.print(indent2);
            this._source.print("    fsm:getDebugStream():write(\"");
            this._source.print("ENTER TRANSITION: ");
            if (packageName != null && packageName.length() > 0) {
                this._source.print(packageName);
                this._source.print(".");
            }
            this._source.print(stateName);
            this._source.print(":");
            this._source.print(transName);
            this._source.print("(");
            pit = parameters.iterator();
            sep = "";
            while (pit.hasNext()) {
                trArgName = ((SmcParameter)pit.next()).getName();
                this._source.print(sep);
                this._source.print(trArgName);
                this._source.print("=\" .. tostring(");
                this._source.print(trArgName);
                this._source.print(") .. \"");
                sep = ", ";
            }
            this._source.print(")");
            this._source.println("\\n\")");
            this._source.print(indent2);
            this._source.println("end");
        }
        if (actions.size() == 0) {
            if (condition.length() > 0) {
                this._source.print(indent2);
                this._source.println("-- No actions.");
            }
            indent3 = indent2;
        } else {
            this._source.print(indent2);
            this._source.println("fsm:clearState()");
            if (!this._noCatchFlag) {
                this._source.print(indent2);
                this._source.println("local r, msg = pcall(");
                this._source.print(indent2);
                this._source.println("    function ()");
                indent3 = indent2 + "        ";
            } else {
                indent3 = indent2;
            }
            String indent4 = this._indent;
            this._indent = indent3;
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
            this._indent = indent4;
            if (!this._noCatchFlag) {
                this._source.print(indent2);
                this._source.println("    end");
                this._source.print(indent2);
                this._source.println(")");
                if (this._debugLevel >= 1) {
                    this._source.print(indent2);
                    this._source.println("if not r then");
                    this._source.print(indent2);
                    this._source.println("    fsm:getDebugStream():write(msg)");
                    this._source.print(indent2);
                    this._source.println("end");
                }
            }
        }
        if (this._debugLevel >= 0) {
            parameters = transition.getParameters();
            this._source.print(indent3);
            this._source.println("if fsm:getDebugFlag() then");
            this._source.print(indent3);
            this._source.print("    fsm:getDebugStream():write(\"");
            this._source.print("EXIT TRANSITION : ");
            if (packageName != null && packageName.length() > 0) {
                this._source.print(packageName);
                this._source.print(".");
            }
            this._source.print(stateName);
            this._source.print(":");
            this._source.print(transName);
            this._source.print("(");
            pit = parameters.iterator();
            sep = "";
            while (pit.hasNext()) {
                trArgName = ((SmcParameter)pit.next()).getName();
                this._source.print(sep);
                this._source.print(trArgName);
                this._source.print("=\" .. tostring(");
                this._source.print(trArgName);
                this._source.print(") .. \"");
                sep = ", ";
            }
            this._source.print(")");
            this._source.println("\\n\")");
            this._source.print(indent3);
            this._source.println("end");
        }
        if (!(transType != SmcElement.TransType.TRANS_SET || actions.size() <= 0 && loopbackFlag)) {
            this._source.print(indent2);
            this._source.print("fsm:setState(");
            this._source.print(fqEndStateName);
            this._source.println(")");
        } else if (transType == SmcElement.TransType.TRANS_PUSH) {
            if (!loopbackFlag || actions.size() > 0) {
                this._source.print(indent2);
                this._source.print("fsm:setState(");
                this._source.print(fqEndStateName);
                this._source.println(")");
            }
            if (!loopbackFlag) {
                if (this._debugLevel >= 1) {
                    this._source.print(indent2);
                    this._source.println("if fsm:getDebugFlag() then");
                    this._source.print(indent2);
                    this._source.print("    fsm:getDebugStream():write(\"");
                    this._source.print("BEFORE ENTRY    : ");
                    if (packageName != null && packageName.length() > 0) {
                        this._source.print(packageName);
                        this._source.print(".");
                    }
                    this._source.print(stateName);
                    this._source.println(":Entry(fsm)\\n\")");
                    this._source.print(indent2);
                    this._source.println("end");
                }
                this._source.print(indent2);
                this._source.println("fsm:getState():Entry(fsm)");
                if (this._debugLevel >= 1) {
                    this._source.print(indent2);
                    this._source.println("if fsm:getDebugFlag() then");
                    this._source.print(indent2);
                    this._source.print("    fsm:getDebugStream():write(\"");
                    this._source.print("AFTER ENTRY     : ");
                    if (packageName != null && packageName.length() > 0) {
                        this._source.print(packageName);
                        this._source.print(".");
                    }
                    this._source.print(stateName);
                    this._source.println(":Entry(fsm)\\n\")");
                    this._source.print(indent2);
                    this._source.println("end");
                }
            }
            this._source.print(indent2);
            this._source.print("fsm:pushState(");
            this._source.print(pushStateName);
            this._source.println(")");
        } else if (transType == SmcElement.TransType.TRANS_POP) {
            this._source.print(indent2);
            this._source.println("fsm:popState()");
        }
        if (transType == SmcElement.TransType.TRANS_SET && !loopbackFlag || transType == SmcElement.TransType.TRANS_PUSH) {
            if (this._debugLevel >= 1) {
                this._source.print(indent2);
                this._source.println("if fsm:getDebugFlag() then");
                this._source.print(indent2);
                this._source.print("    fsm:getDebugStream():write(\"");
                this._source.print("BEFORE ENTRY    : ");
                if (packageName != null && packageName.length() > 0) {
                    this._source.print(packageName);
                    this._source.print(".");
                }
                this._source.print(stateName);
                this._source.println(":Entry(fsm)\\n\")");
                this._source.print(indent2);
                this._source.println("end");
            }
            this._source.print(indent2);
            this._source.println("fsm:getState():Entry(fsm)");
            if (this._debugLevel >= 1) {
                this._source.print(indent2);
                this._source.println("if fsm:getDebugFlag() then");
                this._source.print(indent2);
                this._source.print("    fsm:getDebugStream():write(\"");
                this._source.print("AFTER ENTRY     : ");
                if (packageName != null && packageName.length() > 0) {
                    this._source.print(packageName);
                    this._source.print(".");
                }
                this._source.print(stateName);
                this._source.println(":Entry(fsm)\\n\")");
                this._source.print(indent2);
                this._source.println("end");
            }
        }
        if (transType == SmcElement.TransType.TRANS_POP && !endStateName.equals("nil") && endStateName.length() > 0) {
            String popArgs = guard.getPopArgs();
            this._source.print(indent2);
            this._source.print("fsm:");
            this._source.print(endStateName);
            this._source.print("(");
            if (popArgs.length() > 0) {
                this._source.print(popArgs);
                this._source.println();
                this._source.print(indent2);
                this._source.println(")");
            } else {
                this._source.println(")");
            }
        }
    }

    public void visit(SmcAction action) {
        String name = action.getName();
        this._source.print(this._indent);
        if (action.isEmptyStateStack()) {
            this._source.println("fsm:emptyStateStack()");
        } else {
            this._source.print("ctxt:");
            this._source.print(name);
            this._source.print("(");
            Iterator it = action.getArguments().iterator();
            String sep = "";
            while (it.hasNext()) {
                this._source.print(sep);
                this._source.print((String)it.next());
                sep = ", ";
            }
            this._source.println(")");
        }
    }
}

