/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.SmcVisitor;

public final class SmcJavaGenerator
extends SmcCodeGenerator {
    public SmcJavaGenerator(SmcOptions options) {
        super(options, "java");
    }

    public void visit(SmcFSM fsm) {
        String separator;
        String rawSource = fsm.getSource();
        String packageName = fsm.getPackage();
        String context = fsm.getContext();
        String fsmClassName = fsm.getFsmClassName();
        String startState = fsm.getStartState();
        List maps = fsm.getMaps();
        List transitions = fsm.getTransitions();
        this._source.println("/*");
        this._source.println(" * ex: set ro:");
        this._source.println(" * DO NOT EDIT.");
        this._source.println(" * generated by smc (http://smc.sourceforge.net/)");
        this._source.print(" * from file : ");
        this._source.print(this._srcfileBase);
        this._source.println(".sm");
        this._source.println(" */");
        this._source.println();
        if (rawSource != null && rawSource.length() > 0) {
            this._source.println(rawSource);
            this._source.println();
        }
        if (packageName != null && packageName.length() > 0) {
            this._source.print("package ");
            this._source.print(packageName);
            this._source.println(";");
            this._source.println();
        }
        for (String imp : fsm.getImports()) {
            this._source.print("import ");
            this._source.print(imp);
            this._source.println(";");
        }
        if (this._debugLevel >= 0) {
            this._source.println("import java.io.PrintStream;");
        }
        if (this._reflectFlag) {
            this._source.println("import java.util.HashMap;");
            this._source.println("import java.util.Map;");
            this._source.println("import java.util.Set;");
            this._source.println("import java.util.TreeSet;");
        }
        this._source.println();
        this._source.print(this._accessLevel);
        this._source.print(" class ");
        this._source.print(fsmClassName);
        this._source.println("");
        this._source.println("    extends statemap.FSMContext");
        if (this._serialFlag) {
            this._source.println("    implements java.io.Serializable");
        }
        this._source.println("{");
        this._source.println("//---------------------------------------------------------------");
        this._source.println("// Member methods.");
        this._source.println("//");
        this._source.println();
        int index = startState.indexOf("::");
        String javaState = index >= 0 ? startState.substring(0, index) + "." + startState.substring(index + 2) : startState;
        this._source.print("    ");
        this._source.print(this._accessLevel);
        this._source.print(" ");
        this._source.print(fsmClassName);
        this._source.print("(");
        this._source.print(context);
        this._source.println(" owner)");
        this._source.println("    {");
        this._source.print("        super (");
        this._source.print(javaState);
        this._source.println(");");
        this._source.println();
        this._source.println("        _owner = owner;");
        if (this._reflectFlag) {
            this.reflectionSets(maps, transitions);
        }
        this._source.println("    }");
        this._source.println();
        this._source.print("    ");
        this._source.print(this._accessLevel);
        this._source.print(" ");
        this._source.print(fsmClassName);
        this._source.print("(");
        this._source.print(context);
        this._source.print(" owner, ");
        this._source.print(context);
        this._source.println("State initState)");
        this._source.println("    {");
        this._source.println("        super (initState);");
        this._source.println();
        this._source.println("        _owner = owner;");
        if (this._reflectFlag) {
            this.reflectionSets(maps, transitions);
        }
        this._source.println("    }");
        this._source.println();
        this._source.print("    public ");
        if (this._syncFlag) {
            this._source.print("synchronized ");
        }
        this._source.println("void enterStartState()");
        this._source.println("    {");
        this._source.println("        getState().Entry(this);");
        this._source.println("        return;");
        this._source.println("    }");
        this._source.println();
        for (SmcTransition trans : transitions) {
            if (trans.getName().equals("Default")) continue;
            this._source.print("    public ");
            if (this._syncFlag) {
                this._source.print("synchronized ");
            }
            this._source.print("void ");
            this._source.print(trans.getName());
            this._source.print("(");
            List params = trans.getParameters();
            Iterator pit = params.iterator();
            separator = "";
            while (pit.hasNext()) {
                this._source.print(separator);
                ((SmcParameter)pit.next()).accept((SmcVisitor)this);
                separator = ", ";
            }
            this._source.println(")");
            this._source.println("    {");
            this._source.print("        _transition = \"");
            this._source.print(trans.getName());
            this._source.println("\";");
            this._source.print("        getState().");
            this._source.print(trans.getName());
            this._source.print("(this");
            pit = params.iterator();
            while (pit.hasNext()) {
                this._source.print(", ");
                this._source.print(((SmcParameter)pit.next()).getName());
            }
            this._source.println(");");
            this._source.println("        _transition = \"\";");
            this._source.println("        return;");
            this._source.println("    }");
            this._source.println();
        }
        if (this._serialFlag) {
            this._source.print("    public ");
            this._source.print(context);
            this._source.println("State valueOf(int stateId)");
            this._source.println("        throws ArrayIndexOutOfBoundsException");
            this._source.println("    {");
            this._source.println("        return (_States[stateId]);");
            this._source.println("    }");
            this._source.println();
        }
        this._source.print("    public ");
        this._source.print(context);
        this._source.println("State getState()");
        this._source.println("        throws statemap.StateUndefinedException");
        this._source.println("    {");
        this._source.println("        if (_state == null)");
        this._source.println("        {");
        this._source.println("            throw(");
        this._source.println("                new statemap.StateUndefinedException());");
        this._source.println("        }");
        this._source.println();
        this._source.print("        return ((");
        this._source.print(context);
        this._source.println("State) _state);");
        this._source.println("    }");
        this._source.println();
        this._source.print("    protected ");
        this._source.print(context);
        this._source.println(" getOwner()");
        this._source.println("    {");
        this._source.println("        return (_owner);");
        this._source.println("    }");
        this._source.println();
        this._source.print("    public void setOwner(");
        this._source.print(context);
        this._source.println(" owner)");
        this._source.println("    {");
        this._source.println("        if (owner == null)");
        this._source.println("        {");
        this._source.println("            throw (");
        this._source.println("                new NullPointerException(");
        this._source.println("                    \"null owner\"));");
        this._source.println("        }");
        this._source.println("        else");
        this._source.println("        {");
        this._source.println("            _owner = owner;");
        this._source.println("        }");
        this._source.println();
        this._source.println("        return;");
        this._source.println("    }");
        this._source.println();
        if (this._reflectFlag) {
            this._source.print("    public ");
            this._source.print(context);
            this._source.println("State[] getStates()");
            this._source.println("    {");
            this._source.println("        return (_States);");
            this._source.println("    }");
            this._source.println();
            this._source.print("    public Set");
            if (this._genericFlag) {
                this._source.print("<String>");
            }
            this._source.println(" getTransitions()");
            this._source.println("    {");
            this._source.println("        return (_transitions);");
            this._source.println("    }");
            this._source.println();
        }
        if (this._serialFlag) {
            this._source.print("    private void writeObject(");
            this._source.println("java.io.ObjectOutputStream ostream)");
            this._source.println("        throws java.io.IOException");
            this._source.println("    {");
            this._source.println("        int size =");
            this._source.print("            ");
            this._source.println("(_stateStack == null ? 0 : _stateStack.size());");
            this._source.println("        int i;");
            this._source.println();
            this._source.println("        ostream.writeInt(size);");
            this._source.println();
            this._source.println("        for (i = 0; i < size; ++i)");
            this._source.println("        {");
            this._source.println("            ostream.writeInt(");
            this._source.print("                ((");
            this._source.print(context);
            this._source.println("State) _stateStack.get(i)).getId());");
            this._source.println("        }");
            this._source.println();
            this._source.println("        ostream.writeInt(_state.getId());");
            this._source.println();
            this._source.println("        return;");
            this._source.println("    }");
            this._source.println();
            this._source.print("    private void readObject(");
            this._source.println("java.io.ObjectInputStream istream)");
            this._source.println("        throws java.io.IOException");
            this._source.println("    {");
            this._source.println("        int size;");
            this._source.println();
            this._source.println("        size = istream.readInt();");
            this._source.println();
            this._source.println("        if (size == 0)");
            this._source.println("        {");
            this._source.println("            _stateStack = null;");
            this._source.println("        }");
            this._source.println("        else");
            this._source.println("        {");
            this._source.println("            int i;");
            this._source.println();
            this._source.println("            _stateStack =");
            this._source.println("                new java.util.Stack<statemap.State>();");
            this._source.println();
            this._source.println("            for (i = 0; i < size; ++i)");
            this._source.println("            {");
            this._source.print("                _stateStack.add(i, _States[");
            this._source.println("istream.readInt()]);");
            this._source.println("            }");
            this._source.println("        }");
            this._source.println();
            this._source.println("        _state = _States[istream.readInt()];");
            this._source.println();
            this._source.println("        return;");
            this._source.println("    }");
            this._source.println();
        }
        this._source.println("//---------------------------------------------------------------");
        this._source.println("// Member data.");
        this._source.println("//");
        this._source.println();
        this._source.print("    transient private ");
        this._source.print(context);
        this._source.println(" _owner;");
        if (this._reflectFlag) {
            this._source.print("    final Set");
            if (this._genericFlag) {
                this._source.print("<String>");
            }
            this._source.println(" _transitions;");
        }
        if (this._serialFlag || this._reflectFlag) {
            this._source.print("    transient private static ");
            this._source.print(context);
            this._source.println("State[] _States =");
            this._source.println("    {");
            separator = "";
            for (SmcMap map : maps) {
                String mapName = map.getName();
                for (SmcState state : map.getStates()) {
                    this._source.print(separator);
                    this._source.print("        ");
                    this._source.print(mapName);
                    this._source.print(".");
                    this._source.print(state.getClassName());
                    separator = ",\n";
                }
            }
            this._source.println();
            this._source.println("    };");
        }
        this._source.println();
        this._source.print("    ");
        this._source.print(this._accessLevel);
        this._source.print(" static abstract class ");
        this._source.print(context);
        this._source.println("State");
        this._source.println("        extends statemap.State");
        this._source.println("    {");
        this._source.println("    //-----------------------------------------------------------");
        this._source.println("    // Member methods.");
        this._source.println("    //");
        this._source.println();
        if (this._reflectFlag) {
            this._source.print("        ");
            this._source.print("public abstract Map");
            if (this._genericFlag) {
                this._source.print("<String, Integer>");
            }
            this._source.println(" getTransitions();");
            this._source.println();
        }
        this._source.print("        protected ");
        this._source.print(context);
        this._source.println("State(String name, int id)");
        this._source.println("        {");
        this._source.println("            super (name, id);");
        this._source.println("        }");
        this._source.println();
        this._source.print("        protected void Entry(");
        this._source.print(fsmClassName);
        this._source.println(" context) {}");
        this._source.print("        protected void Exit(");
        this._source.print(fsmClassName);
        this._source.println(" context) {}");
        this._source.println();
        for (SmcTransition trans : transitions) {
            String transName = trans.getName();
            if (transName.equals("Default")) continue;
            this._source.print("        protected void ");
            this._source.print(transName);
            this._source.print("(");
            this._source.print(fsmClassName);
            this._source.print(" context");
            for (SmcParameter param : trans.getParameters()) {
                this._source.print(", ");
                param.accept((SmcVisitor)this);
            }
            this._source.println(")");
            this._source.println("        {");
            this._source.println("            Default(context);");
            this._source.println("        }");
            this._source.println();
        }
        this._source.print("        protected void Default(");
        this._source.print(fsmClassName);
        this._source.println(" context)");
        this._source.println("        {");
        if (this._debugLevel >= 0) {
            this._source.println("            if (context.getDebugFlag() == true)");
            this._source.println("            {");
            this._source.println("                PrintStream str = ");
            this._source.println("                    context.getDebugStream();");
            this._source.println();
            this._source.println("                str.println(");
            this._source.println("                    \"TRANSITION   : Default\");");
            this._source.println("            }");
            this._source.println();
        }
        this._source.println("            throw (");
        this._source.println("                new statemap.TransitionUndefinedException(");
        this._source.println("                    \"State: \" +");
        this._source.println("                    context.getState().getName() +");
        this._source.println("                    \", Transition: \" +");
        this._source.println("                    context.getTransition()));");
        this._source.println("        }");
        this._source.println();
        this._source.println("    //-----------------------------------------------------------");
        this._source.println("    // Member data.");
        this._source.println("    //");
        this._source.println("    }");
        for (SmcMap map : maps) {
            map.accept((SmcVisitor)this);
        }
        this._source.println("}");
        this._source.println();
        this._source.println("/*");
        this._source.println(" * Local variables:");
        this._source.println(" *  buffer-read-only: t");
        this._source.println(" * End:");
        this._source.println(" */");
    }

    public void visit(SmcMap map) {
        SmcState defaultState = map.getDefaultState();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        List states = map.getStates();
        ArrayList definedDefaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList();
        this._source.println();
        this._source.print("    /* package */ static abstract class ");
        this._source.println(mapName);
        this._source.println("    {");
        this._source.println("    //-----------------------------------------------------------");
        this._source.println("    // Member methods.");
        this._source.println("    //");
        this._source.println();
        this._source.println("    //-----------------------------------------------------------");
        this._source.println("    // Member data.");
        this._source.println("    //");
        this._source.println();
        this._source.println("        //-------------------------------------------------------");
        this._source.println("        // Constants.");
        this._source.println("        //");
        for (SmcState state : states) {
            this._source.print("        public static final ");
            this._source.print(mapName);
            this._source.print('_');
            this._source.print(state.getClassName());
            this._source.print(' ');
            this._source.print(state.getInstanceName());
            this._source.println(" =");
            this._source.print("            new ");
            this._source.print(mapName);
            this._source.print('_');
            this._source.print(state.getClassName());
            this._source.print("(\"");
            this._source.print(mapName);
            this._source.print('.');
            this._source.print(state.getClassName());
            this._source.print("\", ");
            this._source.print(map.getNextStateId());
            this._source.println(");");
        }
        this._source.print("        private static final ");
        this._source.print(mapName);
        this._source.println("_Default Default =");
        this._source.print("            new ");
        this._source.print(mapName);
        this._source.print("_Default(\"");
        this._source.print(mapName);
        this._source.println(".Default\", -1);");
        this._source.println();
        this._source.println("    }");
        this._source.println();
        this._source.print("    protected static class ");
        this._source.print(mapName);
        this._source.println("_Default");
        this._source.print("        extends ");
        this._source.print(context);
        this._source.println("State");
        this._source.println("    {");
        this._source.println("    //-----------------------------------------------------------");
        this._source.println("    // Member methods.");
        this._source.println("    //");
        this._source.println();
        if (this._reflectFlag) {
            this._source.print("        ");
            this._source.print("public Map");
            if (this._genericFlag) {
                this._source.print("<String, Integer>");
            }
            this._source.println(" getTransitions()");
            this._source.println("        {");
            this._source.println("            return (_transitions);");
            this._source.println("        }");
            this._source.println();
        }
        this._source.print("        protected ");
        this._source.print(mapName);
        this._source.println("_Default(String name, int id)");
        this._source.println("        {");
        this._source.println("            super (name, id);");
        this._source.println("        }");
        this._indent = "        ";
        for (SmcTransition trans : definedDefaultTransitions) {
            trans.accept((SmcVisitor)this);
        }
        this._source.println("    //-----------------------------------------------------------");
        this._source.println("    // Member data.");
        this._source.println("    //");
        if (this._reflectFlag) {
            List allTransitions = map.getFSM().getTransitions();
            this._source.println();
            this._source.println("        //---------------------------------------------------");
            this._source.println("        // Statics.");
            this._source.println("        //");
            this._source.print("        ");
            this._source.print("private static Map");
            if (this._genericFlag) {
                this._source.print("<String, Integer>");
            }
            this._source.println(" _transitions;");
            this._source.println();
            this._source.println("        static");
            this._source.println("        {");
            this._source.print("            ");
            this._source.print("_transitions = new HashMap");
            if (this._genericFlag) {
                this._source.print("<String, Integer>");
            }
            this._source.println("();");
            for (SmcTransition transition : allTransitions) {
                String transName = transition.getName();
                String transDefinition = definedDefaultTransitions.contains(transition) ? "statemap.State.TRANSITION_DEFINED_DEFAULT" : "statemap.State.TRANSITION_UNDEFINED";
                this._source.print("            ");
                this._source.print("_transitions.put(\"");
                this._source.print(transName);
                this._source.print("\", ");
                this._source.print(transDefinition);
                this._source.println(");");
            }
            this._source.println("        }");
        }
        this._source.println("    }");
        for (SmcState state : states) {
            state.accept((SmcVisitor)this);
        }
    }

    public void visit(SmcState state) {
        String indent2;
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String fsmClassName = map.getFSM().getFsmClassName();
        String mapName = map.getName();
        String stateName = state.getClassName();
        this._source.println();
        this._source.print("    private static final class ");
        this._source.print(mapName);
        this._source.print('_');
        this._source.println(stateName);
        this._source.print("        extends ");
        this._source.print(mapName);
        this._source.println("_Default");
        this._source.println("    {");
        this._source.println("    //-------------------------------------------------------");
        this._source.println("    // Member methods.");
        this._source.println("    //");
        this._source.println();
        if (this._reflectFlag) {
            this._source.print("        ");
            this._source.print("public Map");
            if (this._genericFlag) {
                this._source.print("<String, Integer>");
            }
            this._source.println(" getTransitions()");
            this._source.println("        {");
            this._source.print("            ");
            this._source.println("return (_transitions);");
            this._source.println("        }");
            this._source.println();
        }
        this._source.print("        private ");
        this._source.print(mapName);
        this._source.print('_');
        this._source.print(stateName);
        this._source.println("(String name, int id)");
        this._source.println("        {");
        this._source.println("            super (name, id);");
        this._source.println("        }");
        List actions = state.getEntryActions();
        if (actions != null && actions.size() > 0) {
            this._source.println();
            this._source.print("        protected void Entry(");
            this._source.print(fsmClassName);
            this._source.println(" context)");
            this._source.println("            {");
            this._source.print("                ");
            this._source.print(context);
            this._source.println(" ctxt = context.getOwner();");
            this._source.println();
            indent2 = this._indent;
            this._indent = "            ";
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
            this._indent = indent2;
            this._source.println("            return;");
            this._source.println("        }");
        }
        if ((actions = state.getExitActions()) != null && actions.size() > 0) {
            this._source.println();
            this._source.print("        protected void Exit(");
            this._source.print(fsmClassName);
            this._source.println(" context)");
            this._source.println("            {");
            this._source.print("            ");
            this._source.print(context);
            this._source.println(" ctxt = context.getOwner();");
            this._source.println();
            indent2 = this._indent;
            this._indent = "            ";
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
            this._source.println("            return;");
            this._source.println("        }");
        }
        this._indent = "        ";
        for (SmcTransition transition : state.getTransitions()) {
            transition.accept((SmcVisitor)this);
        }
        this._source.println();
        this._source.println("    //-------------------------------------------------------");
        this._source.println("    // Member data.");
        this._source.println("    //");
        if (this._reflectFlag) {
            List allTransitions = map.getFSM().getTransitions();
            List stateTransitions = state.getTransitions();
            SmcState defaultState = map.getDefaultState();
            ArrayList defaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList();
            this._source.println();
            this._source.println("        //---------------------------------------------------");
            this._source.println("        // Statics.");
            this._source.println("        //");
            this._source.print("        ");
            this._source.print("private static Map");
            if (this._genericFlag) {
                this._source.print("<String, Integer>");
            }
            this._source.println(" _transitions;");
            this._source.println();
            this._source.println("        static");
            this._source.println("        {");
            this._source.print("            ");
            this._source.print("_transitions = new HashMap");
            if (this._genericFlag) {
                this._source.print("<String, Integer>");
            }
            this._source.println("();");
            for (SmcTransition transition : allTransitions) {
                String transName = transition.getName();
                String transDefinition = stateTransitions.contains(transition) ? "statemap.State.TRANSITION_DEFINED_LOCALLY" : (defaultTransitions.contains(transition) ? "statemap.State.TRANSITION_DEFINED_DEFAULT" : "statemap.State.TRANSITION_UNDEFINED");
                this._source.print("            ");
                this._source.print("_transitions.put(\"");
                this._source.print(transName);
                this._source.print("\", ");
                this._source.print(transDefinition);
                this._source.println(");");
            }
            this._source.println("        }");
        }
        this._source.println("    }");
    }

    public void visit(SmcTransition transition) {
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String fsmClassName = map.getFSM().getFsmClassName();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        List parameters = transition.getParameters();
        List guards = transition.getGuards();
        boolean nullCondition = false;
        this._source.println();
        this._source.print(this._indent);
        this._source.print("protected void ");
        this._source.print(transName);
        this._source.print("(");
        this._source.print(fsmClassName);
        this._source.print(" context");
        for (SmcParameter parameter : parameters) {
            this._source.print(", ");
            parameter.accept((SmcVisitor)this);
        }
        this._source.println(")");
        this._source.print(this._indent);
        this._source.println("{");
        if (transition.hasCtxtReference()) {
            this._source.print(this._indent);
            this._source.print("    ");
            this._source.print(context);
            this._source.println(" ctxt = context.getOwner();");
        }
        this._source.println();
        if (this._debugLevel >= 0) {
            this._source.print(this._indent);
            this._source.println("    if (context.getDebugFlag() == true)");
            this._source.print(this._indent);
            this._source.println("    {");
            this._source.print(this._indent);
            this._source.print("        PrintStream str = ");
            this._source.println("context.getDebugStream();");
            this._source.println();
            this._source.print(this._indent);
            this._source.print("        str.println(\"LEAVING STATE   : ");
            this._source.print(mapName);
            this._source.print('.');
            this._source.print(stateName);
            this._source.println("\");");
            this._source.print(this._indent);
            this._source.println("    }");
        }
        Iterator git = guards.iterator();
        this._guardIndex = 0;
        this._guardCount = guards.size();
        while (git.hasNext()) {
            SmcGuard guard = (SmcGuard)git.next();
            if (guard.getCondition().length() == 0) {
                nullCondition = true;
            }
            guard.accept((SmcVisitor)this);
            ++this._guardIndex;
        }
        if (this._guardIndex > 0 && !nullCondition) {
            if (this._guardCount == 1) {
                this._source.print(this._indent);
                this._source.println("    }");
            }
            this._source.print(this._indent);
            this._source.println("    else");
            this._source.print(this._indent);
            this._source.println("    {");
            this._source.print(this._indent);
            this._source.print("        super.");
            this._source.print(transName);
            this._source.print("(context");
            for (SmcParameter param : parameters) {
                this._source.print(", ");
                this._source.print(param.getName());
            }
            this._source.println(");");
            this._source.print(this._indent);
            this._source.println("    }");
            this._source.println();
        } else if (this._guardCount > 1) {
            this._source.println();
            this._source.println();
        }
        this._source.print(this._indent);
        this._source.println("    return;");
        this._source.print(this._indent);
        this._source.println("}");
    }

    public void visit(SmcGuard guard) {
        String indent3;
        String sep;
        Iterator pit;
        String indent4;
        List parameters;
        String indent2;
        boolean hasActions;
        SmcTransition transition = guard.getTransition();
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        SmcElement.TransType transType = guard.getTransType();
        boolean loopbackFlag = false;
        String endStateName = guard.getEndState();
        String fqEndStateName = "";
        String pushStateName = guard.getPushState();
        String condition = guard.getCondition();
        List actions = guard.getActions();
        boolean bl = hasActions = !actions.isEmpty();
        if (transType != SmcElement.TransType.TRANS_POP && endStateName.length() > 0 && !endStateName.equals("nil")) {
            endStateName = this.scopeStateName(endStateName, mapName);
        }
        stateName = this.scopeStateName(stateName, mapName);
        pushStateName = this.scopeStateName(pushStateName, mapName);
        loopbackFlag = this.isLoopback(transType, endStateName);
        if (this._guardCount > 1) {
            indent2 = this._indent + "        ";
            if (this._guardIndex == 0 && condition.length() > 0) {
                this._source.print(this._indent);
                this._source.print("    if (");
                this._source.print(condition);
                this._source.println(")");
                this._source.print(this._indent);
                this._source.println("    {");
            } else if (condition.length() > 0) {
                this._source.println();
                this._source.print(this._indent);
                this._source.print("    else if (");
                this._source.print(condition);
                this._source.println(")");
                this._source.print(this._indent);
                this._source.println("    {");
            } else {
                this._source.println();
                this._source.print(this._indent);
                this._source.println("    else");
                this._source.print(this._indent);
                this._source.println("    {");
            }
        } else if (condition.length() == 0) {
            indent2 = this._indent + "    ";
        } else {
            indent2 = this._indent + "        ";
            this._source.print(this._indent);
            this._source.print("    if (");
            this._source.print(condition);
            this._source.println(")");
            this._source.print(this._indent);
            this._source.println("    {");
        }
        if (!hasActions || !loopbackFlag) {
            fqEndStateName = endStateName;
        } else {
            fqEndStateName = "endState";
            this._source.print(indent2);
            this._source.print(context);
            this._source.print("State ");
            this._source.print(fqEndStateName);
            this._source.println(" = context.getState();");
        }
        this._source.println();
        if (transType == SmcElement.TransType.TRANS_POP || !loopbackFlag) {
            if (this._debugLevel >= 1) {
                this._source.print(this._indent);
                this._source.println("    if (context.getDebugFlag() == true)");
                this._source.print(this._indent);
                this._source.println("    {");
                this._source.print(this._indent);
                this._source.print("        PrintStream str = ");
                this._source.println("context.getDebugStream();");
                this._source.println();
                this._source.print(this._indent);
                this._source.print("        str.println(\"BEFORE EXIT     : ");
                this._source.print(mapName);
                this._source.print('.');
                this._source.print(stateName);
                this._source.println(".Exit(context)\");");
                this._source.print(this._indent);
                this._source.println("    }");
                this._source.println();
            }
            this._source.print(indent2);
            this._source.println("(context.getState()).Exit(context);");
            if (this._debugLevel >= 1) {
                this._source.print(this._indent);
                this._source.println("    if (context.getDebugFlag() == true)");
                this._source.print(this._indent);
                this._source.println("    {");
                this._source.print(this._indent);
                this._source.print("        PrintStream str = ");
                this._source.println("context.getDebugStream();");
                this._source.println();
                this._source.print(this._indent);
                this._source.print("        str.println(\"AFTER EXIT      : ");
                this._source.print(mapName);
                this._source.print('.');
                this._source.print(stateName);
                this._source.println(".Exit(context)\");");
                this._source.print(this._indent);
                this._source.println("    }");
                this._source.println();
            }
        }
        if (this._debugLevel >= 0) {
            parameters = transition.getParameters();
            indent4 = this._indent;
            if (!this._noCatchFlag) {
                this._indent = indent2;
            }
            this._source.print(this._indent);
            this._source.println("if (context.getDebugFlag() == true)");
            this._source.print(this._indent);
            this._source.println("{");
            this._source.print(this._indent);
            this._source.print("    PrintStream str = ");
            this._source.println("context.getDebugStream();");
            this._source.println();
            this._source.print(this._indent);
            this._source.print("    str.println(\"ENTER TRANSITION: ");
            this._source.print(mapName);
            this._source.print('.');
            this._source.print(stateName);
            this._source.print('.');
            this._source.print(transName);
            this._source.print('(');
            pit = parameters.iterator();
            sep = "";
            while (pit.hasNext()) {
                this._source.print(sep);
                ((SmcParameter)pit.next()).accept((SmcVisitor)this);
                sep = ", ";
            }
            this._source.print(')');
            this._source.println("\");");
            this._source.print(this._indent);
            this._source.println("}");
            this._source.println();
            this._indent = indent4;
        }
        if (!hasActions) {
            if (condition.length() > 0) {
                this._source.print(indent2);
                this._source.println("// No actions.");
            }
            indent3 = indent2;
        } else {
            this._source.print(indent2);
            this._source.println("context.clearState();");
            if (!this._noCatchFlag) {
                this._source.print(indent2);
                this._source.println("try");
                this._source.print(indent2);
                this._source.println('{');
                indent3 = indent2 + "    ";
            } else {
                indent3 = indent2;
            }
            indent4 = this._indent;
            this._indent = indent3;
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
            this._indent = indent4;
            if (!this._noCatchFlag) {
                this._source.print(indent2);
                this._source.println('}');
                this._source.print(indent2);
                this._source.println("finally");
                this._source.print(indent2);
                this._source.println('{');
            }
        }
        if (this._debugLevel >= 0) {
            parameters = transition.getParameters();
            indent4 = this._indent;
            this._indent = indent3;
            this._source.print(this._indent);
            this._source.println("if (context.getDebugFlag() == true)");
            this._source.print(this._indent);
            this._source.println("{");
            this._source.print(this._indent);
            this._source.print("    PrintStream str = ");
            this._source.println("context.getDebugStream();");
            this._source.println();
            this._source.print(this._indent);
            this._source.print("    str.println(\"EXIT TRANSITION : ");
            this._source.print(mapName);
            this._source.print('.');
            this._source.print(stateName);
            this._source.print('.');
            this._source.print(transName);
            this._source.print('(');
            pit = parameters.iterator();
            sep = "";
            while (pit.hasNext()) {
                this._source.print(sep);
                ((SmcParameter)pit.next()).accept((SmcVisitor)this);
                sep = ", ";
            }
            this._source.print(')');
            this._source.println("\");");
            this._source.print(this._indent);
            this._source.println("}");
            this._source.println();
            this._indent = indent4;
        }
        if (transType == SmcElement.TransType.TRANS_SET && (hasActions || !loopbackFlag)) {
            this._source.print(indent3);
            this._source.print("context.setState(");
            this._source.print(fqEndStateName);
            this._source.println(");");
        } else if (transType == SmcElement.TransType.TRANS_PUSH) {
            if (!loopbackFlag || hasActions) {
                this._source.print(indent3);
                this._source.print("context.setState(");
                this._source.print(fqEndStateName);
                this._source.println(");");
            }
            if (!loopbackFlag) {
                this._source.print(indent3);
                this._source.println("(context.getState()).Entry(context);");
            }
            this._source.print(indent3);
            this._source.print("context.pushState(");
            this._source.print(pushStateName);
            this._source.println(");");
        } else if (transType == SmcElement.TransType.TRANS_POP) {
            this._source.print(indent3);
            this._source.println("context.popState();");
        }
        if (transType == SmcElement.TransType.TRANS_SET && !loopbackFlag || transType == SmcElement.TransType.TRANS_PUSH) {
            if (this._debugLevel >= 1) {
                this._source.println();
                this._source.print(indent3);
                this._source.println("if (context.getDebugFlag() == true)");
                this._source.print(indent3);
                this._source.println("{");
                this._source.print(indent3);
                this._source.print("    PrintStream str = ");
                this._source.println("context.getDebugStream();");
                this._source.println();
                this._source.print(indent3);
                this._source.print("    str.println(\"BEFORE ENTRY    : ");
                this._source.print(mapName);
                this._source.print('.');
                this._source.print(stateName);
                this._source.println(".Entry(context)\");");
                this._source.print(indent3);
                this._source.println("}");
                this._source.println();
            }
            this._source.print(indent3);
            this._source.println("(context.getState()).Entry(context);");
            if (this._debugLevel >= 1) {
                this._source.println();
                this._source.print(indent3);
                this._source.println("if (context.getDebugFlag() == true)");
                this._source.print(indent3);
                this._source.println("{");
                this._source.print(indent3);
                this._source.print("    PrintStream str = ");
                this._source.println("context.getDebugStream();");
                this._source.println();
                this._source.print(indent3);
                this._source.print("    str.println(\"AFTER ENTRY     : ");
                this._source.print(mapName);
                this._source.print('.');
                this._source.print(stateName);
                this._source.println(".Entry(context)\");");
                this._source.print(indent3);
                this._source.println("}");
                this._source.println();
            }
        }
        if (hasActions && !this._noCatchFlag) {
            this._source.print(indent2);
            this._source.println('}');
        }
        if (transType == SmcElement.TransType.TRANS_POP && !endStateName.equals("nil") && endStateName.length() > 0) {
            String popArgs = guard.getPopArgs();
            this._source.println();
            this._source.print(indent2);
            this._source.print("context.");
            this._source.print(endStateName);
            this._source.print("(");
            if (popArgs.length() > 0) {
                this._source.print(popArgs);
            }
            this._source.println(");");
        }
        if (this._guardCount > 1) {
            this._source.print(this._indent);
            this._source.print("    }");
        }
    }

    public void visit(SmcAction action) {
        String name = action.getName();
        this._source.print(this._indent);
        if (action.isEmptyStateStack()) {
            this._source.println("context.emptyStateStack();");
        } else {
            if (!action.isStatic()) {
                this._source.print("ctxt.");
            }
            this._source.print(name);
            this._source.print("(");
            Iterator it = action.getArguments().iterator();
            String sep = "";
            while (it.hasNext()) {
                this._source.print(sep);
                this._source.print((String)it.next());
                sep = ", ";
            }
            this._source.println(");");
        }
    }

    public void visit(SmcParameter parameter) {
        this._source.print(parameter.getType());
        this._source.print(' ');
        this._source.print(parameter.getName());
    }

    private void reflectionSets(List<SmcMap> maps, List<SmcTransition> transitions) {
        this._source.print("        _transitions = new TreeSet");
        if (this._genericFlag) {
            this._source.print("<String>");
        }
        this._source.println("();");
        this._source.println();
        for (SmcTransition trans : transitions) {
            this._source.print("        _transitions.add(\"");
            this._source.print(trans.getName());
            this._source.println("\");");
        }
    }
}

