/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.util.Iterator;
import java.util.List;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.SmcVisitor;

public final class SmcHeaderObjCGenerator
extends SmcCodeGenerator {
    public SmcHeaderObjCGenerator(SmcOptions options) {
        super(options, "h");
    }

    public void visit(SmcFSM fsm) {
        String packageName = fsm.getPackage();
        String context = fsm.getContext();
        String fsmClassName = fsm.getFsmClassName();
        boolean packageDepth = false;
        this._source.println("/*");
        this._source.println(" * ex: set ro:");
        this._source.println(" * DO NOT EDIT.");
        this._source.println(" * generated by smc (http://smc.sourceforge.net/)");
        this._source.print(" * from file : ");
        this._source.print(this._srcfileBase);
        this._source.println(".sm");
        this._source.println(" */");
        this._source.println();
        this._source.println();
        this._source.println("#import \"statemap.h\"");
        this._source.println();
        this._source.print(this._indent);
        this._source.println("// Forward declarations.");
        for (SmcMap map : fsm.getMaps()) {
            String mapName = map.getName();
            this._source.print(this._indent);
            this._source.print("@class ");
            this._source.print(mapName);
            this._source.println(";");
            for (SmcState state : map.getStates()) {
                this._source.print(this._indent);
                this._source.print("@class ");
                this._source.print(mapName);
                this._source.print("_");
                this._source.print(state.getClassName());
                this._source.println(";");
            }
            this._source.print(this._indent);
            this._source.print("@class ");
            this._source.print(mapName);
            this._source.println("_Default;");
        }
        this._source.print(this._indent);
        this._source.print("@class ");
        this._source.print(context);
        this._source.println("State;");
        this._source.print(this._indent);
        this._source.print("@class ");
        this._source.print(fsmClassName);
        this._source.println(";");
        this._source.print(this._indent);
        this._source.print("@class ");
        this._source.print(context);
        this._source.println(";");
        for (String declaration : fsm.getDeclarations()) {
            this._source.print(this._indent);
            this._source.print(declaration);
            if (!declaration.endsWith(";")) {
                this._source.print(";");
            }
            this._source.println();
        }
        this._source.println();
        this._source.print(this._indent);
        this._source.print("@interface ");
        this._source.print(context);
        this._source.println("State : SMCState");
        this._source.println("{");
        this._source.println("}");
        this._source.print(this._indent);
        this._source.print("- (void)Entry:(");
        this._source.print(fsmClassName);
        this._source.println("*)context;");
        this._source.print(this._indent);
        this._source.print("- (void)Exit:(");
        this._source.print(fsmClassName);
        this._source.println("*)context;");
        this._source.println();
        List transList = fsm.getTransitions();
        for (SmcTransition trans : transList) {
            if (trans.getName().equals("Default")) continue;
            this._source.print(this._indent);
            this._source.print("- (void)");
            this._source.print(trans.getName());
            this._source.print(":(");
            this._source.print(fsmClassName);
            this._source.print("*)context");
            for (SmcParameter param : trans.getParameters()) {
                this._source.print(" :");
                param.accept((SmcVisitor)this);
            }
            this._source.println(";");
        }
        this._source.println("");
        this._source.print(this._indent);
        this._source.print("- (void)Default:(");
        this._source.print(fsmClassName);
        this._source.println("*)context;");
        this._source.print(this._indent);
        this._source.println("@end");
        this._source.println();
        for (SmcMap map : fsm.getMaps()) {
            map.accept((SmcVisitor)this);
        }
        this._source.print(this._indent);
        this._source.print("@interface ");
        this._source.print(fsmClassName);
        this._source.println(" : SMCFSMContext");
        this._source.print(this._indent);
        this._source.println("{");
        this._source.print(this._indent);
        this._source.print("    ");
        this._source.print(context);
        this._source.println(" *_owner;");
        this._source.print(this._indent);
        this._source.println("}");
        this._source.print(this._indent);
        this._source.print("- (id)initWithOwner:(");
        this._source.print(context);
        this._source.print("*)");
        this._source.println("owner;");
        this._source.print(this._indent);
        this._source.print("- (id)initWithOwner:(");
        this._source.print(context);
        this._source.print("*)");
        this._source.println("owner state:(SMCState*)aState;");
        this._source.print(this._indent);
        this._source.print("- (");
        this._source.print(context);
        this._source.println("*)owner;");
        this._source.print(this._indent);
        this._source.print("- (");
        this._source.print(context);
        this._source.println("State*)state;");
        this._source.println();
        this._source.print(this._indent);
        this._source.println("- (void)enterStartState;");
        this._source.println();
        for (SmcTransition trans : transList) {
            if (trans.getName().equals("Default")) continue;
            this._source.print(this._indent);
            this._source.print("- (void)");
            this._source.print(trans.getName());
            Iterator pit = trans.getParameters().iterator();
            String separator = ":";
            while (pit.hasNext()) {
                SmcParameter param = (SmcParameter)pit.next();
                this._source.print(separator);
                param.accept((SmcVisitor)this);
                separator = " :";
            }
            this._source.println(";");
        }
        this._source.print(this._indent);
        this._source.println("@end");
        this._source.println();
        this._source.println();
        this._source.println("/*");
        this._source.println(" * Local variables:");
        this._source.println(" *  buffer-read-only: t");
        this._source.println(" * End:");
        this._source.println(" */");
    }

    public void visit(SmcMap map) {
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        this._source.print(this._indent);
        this._source.print("@interface ");
        this._source.print(mapName);
        this._source.println(" : NSObject");
        this._source.print(this._indent);
        this._source.println("{");
        this._source.println("}");
        for (SmcState state : map.getStates()) {
            String stateName = state.getClassName();
            this._source.print(this._indent);
            this._source.print("+ (");
            this._source.print(mapName);
            this._source.print("_");
            this._source.print(stateName);
            this._source.print("*)");
            this._source.print(stateName);
            this._source.println(";");
        }
        this._source.print(this._indent);
        this._source.println("@end");
        this._source.println();
        this._source.print(this._indent);
        this._source.print("@interface ");
        this._source.print(mapName);
        this._source.print("_Default : ");
        this._source.print(context);
        this._source.println("State");
        this._source.print(this._indent);
        this._source.println("{");
        this._source.print(this._indent);
        this._source.println("}");
        if (map.hasDefaultState()) {
            SmcState defaultState = map.getDefaultState();
            for (SmcTransition transition : defaultState.getTransitions()) {
                transition.accept((SmcVisitor)this);
            }
        }
        this._source.print(this._indent);
        this._source.println("@end");
        this._source.println();
        for (SmcState state : map.getStates()) {
            state.accept((SmcVisitor)this);
        }
    }

    public void visit(SmcState state) {
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String fsmClassName = map.getFSM().getFsmClassName();
        String mapName = map.getName();
        String stateName = state.getClassName();
        this._source.print(this._indent);
        this._source.print("@interface ");
        this._source.print(mapName);
        this._source.print('_');
        this._source.print(stateName);
        this._source.print(" : ");
        this._source.print(mapName);
        this._source.println("_Default");
        this._source.print(this._indent);
        this._source.println("{");
        this._source.println("}");
        List actions = state.getEntryActions();
        if (actions != null && actions.size() > 0) {
            this._source.print(this._indent);
            this._source.print(" -(void)Entry:(");
            this._source.print(fsmClassName);
            this._source.println("*)context;");
        }
        if ((actions = state.getExitActions()) != null && actions.size() > 0) {
            this._source.print(this._indent);
            this._source.print(" -(void)Entry:(");
            this._source.print(fsmClassName);
            this._source.println("*)context;");
        }
        for (SmcTransition transition : state.getTransitions()) {
            transition.accept((SmcVisitor)this);
        }
        this._source.print(this._indent);
        this._source.println("@end");
        this._source.println();
    }

    public void visit(SmcTransition transition) {
        SmcState state = transition.getState();
        String stateName = state.getClassName();
        this._source.print(this._indent);
        this._source.print("- (void)");
        this._source.print(transition.getName());
        this._source.print(":(");
        this._source.print(state.getMap().getFSM().getFsmClassName());
        this._source.print("*)context");
        for (SmcParameter parameter : transition.getParameters()) {
            this._source.print(" :");
            parameter.accept((SmcVisitor)this);
        }
        this._source.println(";");
    }

    public void visit(SmcParameter parameter) {
        this._source.print("(");
        this._source.print(parameter.getType());
        this._source.print(")");
        this._source.print(parameter.getName());
    }
}

