/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.SmcVisitor;

public final class SmcHeaderGenerator
extends SmcCodeGenerator {
    public SmcHeaderGenerator(SmcOptions options) {
        super(options, "h");
    }

    public void visit(SmcFSM fsm) {
        List params;
        String packageName = fsm.getPackage();
        String context = fsm.getContext();
        String fsmClassName = fsm.getFsmClassName();
        int packageDepth = 0;
        String srcfileCaps = this._srcfileBase.replace('\\', '_');
        srcfileCaps = srcfileCaps.replace('/', '_');
        srcfileCaps = srcfileCaps.toUpperCase();
        this._source.print("#ifndef _H_");
        this._source.println(srcfileCaps);
        this._source.print("#define _H_");
        this._source.println(srcfileCaps);
        this._source.println();
        this._source.println("/*");
        this._source.println(" * ex: set ro:");
        this._source.println(" * DO NOT EDIT.");
        this._source.println(" * generated by smc (http://smc.sourceforge.net/)");
        this._source.print(" * from file : ");
        this._source.print(this._srcfileBase);
        this._source.println(".sm");
        this._source.println(" */");
        this._source.println();
        if (!this._noStreamsFlag) {
            this._source.println();
            this._source.println("#define SMC_USES_IOSTREAMS");
        }
        if (this._noExceptionFlag) {
            this._source.println();
            this._source.println("#define SMC_NO_EXCEPTIONS");
        }
        this._source.println();
        this._source.println("#include <statemap.h>");
        this._source.println();
        this._indent = "";
        if (packageName != null && packageName.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(packageName, "::");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                ++packageDepth;
                this._source.print(this._indent);
                this._source.print("namespace ");
                this._source.println(token);
                this._source.print(this._indent);
                this._source.println("{");
                this._indent = this._indent + "    ";
            }
        }
        this._source.print(this._indent);
        this._source.println("// Forward declarations.");
        for (SmcMap map : fsm.getMaps()) {
            String mapName = map.getName();
            this._source.print(this._indent);
            this._source.print("class ");
            this._source.print(mapName);
            this._source.println(";");
            for (SmcState state : map.getStates()) {
                this._source.print(this._indent);
                this._source.print("class ");
                this._source.print(mapName);
                this._source.print("_");
                this._source.print(state.getClassName());
                this._source.println(";");
            }
            this._source.print(this._indent);
            this._source.print("class ");
            this._source.print(mapName);
            this._source.println("_Default;");
        }
        this._source.print(this._indent);
        this._source.print("class ");
        this._source.print(context);
        this._source.println("State;");
        this._source.print(this._indent);
        this._source.print("class ");
        this._source.print(fsmClassName);
        this._source.println(";");
        this._source.print(this._indent);
        this._source.print("class ");
        this._source.print(context);
        this._source.println(";");
        for (String declaration : fsm.getDeclarations()) {
            this._source.print(this._indent);
            this._source.print(declaration);
            if (!declaration.endsWith(";")) {
                this._source.print(";");
            }
            this._source.println();
        }
        this._source.println();
        this._source.print(this._indent);
        this._source.print("class ");
        this._source.print(context);
        this._source.println("State :");
        this._source.print(this._indent);
        this._source.println("    public statemap::State");
        this._source.print(this._indent);
        this._source.println("{");
        this._source.print(this._indent);
        this._source.println("public:");
        this._source.println();
        this._source.print(this._indent);
        this._source.print("    ");
        this._source.print(context);
        this._source.println("State(const char *name, int stateId)");
        this._source.print(this._indent);
        this._source.println("    : statemap::State(name, stateId)");
        this._source.print(this._indent);
        this._source.println("    {};");
        this._source.println();
        this._source.print(this._indent);
        this._source.print("    virtual void Entry(");
        this._source.print(fsmClassName);
        this._source.println("&) {};");
        this._source.print(this._indent);
        this._source.print("    virtual void Exit(");
        this._source.print(fsmClassName);
        this._source.println("&) {};");
        this._source.println();
        List transList = fsm.getTransitions();
        for (SmcTransition trans : transList) {
            if (trans.getName().equals("Default")) continue;
            this._source.print(this._indent);
            this._source.print("    virtual void ");
            this._source.print(trans.getName());
            this._source.print("(");
            this._source.print(fsmClassName);
            this._source.print("& context");
            params = trans.getParameters();
            for (SmcParameter param : params) {
                this._source.print(", ");
                param.accept((SmcVisitor)this);
            }
            this._source.println(");");
        }
        this._source.println();
        this._source.print(this._indent);
        this._source.println("protected:");
        this._source.println();
        this._source.print(this._indent);
        this._source.print("    virtual void Default(");
        this._source.print(fsmClassName);
        this._source.println("& context);");
        this._source.print(this._indent);
        this._source.println("};");
        this._source.println();
        for (SmcMap map : fsm.getMaps()) {
            map.accept((SmcVisitor)this);
        }
        this._source.print(this._indent);
        this._source.print("class ");
        this._source.print(fsmClassName);
        this._source.println(" :");
        this._source.print(this._indent);
        this._source.println("    public statemap::FSMContext");
        this._source.print(this._indent);
        this._source.println("{");
        this._source.print(this._indent);
        this._source.println("public:");
        this._source.println();
        this._source.print(this._indent);
        this._source.print("    ");
        this._source.print(fsmClassName);
        this._source.print("(");
        this._source.print(context);
        this._source.println("& owner)");
        this._source.print(this._indent);
        this._source.print("    : FSMContext(");
        this._source.print(fsm.getStartState());
        this._source.println("),");
        this._source.print(this._indent);
        this._source.println("      _owner(owner)");
        this._source.print(this._indent);
        this._source.println("    {};");
        this._source.println();
        this._source.print(this._indent);
        this._source.print("    ");
        this._source.print(fsmClassName);
        this._source.print("(");
        this._source.print(context);
        this._source.println("& owner, const statemap::State& state)");
        this._source.print(this._indent);
        this._source.println("    : FSMContext(state),");
        this._source.print(this._indent);
        this._source.println("      _owner(owner)");
        this._source.print(this._indent);
        this._source.println("    {};");
        this._source.println();
        this._source.print(this._indent);
        this._source.println("    virtual void enterStartState()");
        this._source.print(this._indent);
        this._source.println("    {");
        this._source.print(this._indent);
        this._source.println("        getState().Entry(*this);");
        this._source.print(this._indent);
        this._source.println("        return;");
        this._source.print(this._indent);
        this._source.println("    }");
        this._source.println();
        this._source.print(this._indent);
        this._source.print("    ");
        this._source.print(context);
        this._source.println("& getOwner() const");
        this._source.print(this._indent);
        this._source.println("    {");
        this._source.print(this._indent);
        this._source.println("        return (_owner);");
        this._source.print(this._indent);
        this._source.println("    };");
        this._source.println();
        this._source.print(this._indent);
        this._source.print("    ");
        this._source.print(context);
        this._source.println("State& getState() const");
        this._source.print(this._indent);
        this._source.println("    {");
        this._source.print(this._indent);
        this._source.println("        if (_state == NULL)");
        this._source.print(this._indent);
        this._source.println("        {");
        if (!this._noExceptionFlag) {
            this._source.print(this._indent);
            this._source.print("            throw ");
            this._source.println("statemap::StateUndefinedException();");
        } else {
            this._source.print(this._indent);
            this._source.println("            assert(1 == 0);");
        }
        this._source.print(this._indent);
        this._source.println("        }");
        this._source.println();
        this._source.print(this._indent);
        this._source.print("        return (");
        this._source.print(this._castType);
        this._source.print("<");
        this._source.print(context);
        this._source.println("State&>(*_state));");
        this._source.print(this._indent);
        this._source.println("    };");
        for (SmcTransition trans : transList) {
            if (trans.getName().equals("Default")) continue;
            this._source.println();
            this._source.print(this._indent);
            this._source.print("    void ");
            this._source.print(trans.getName());
            this._source.print("(");
            params = trans.getParameters();
            Iterator pit = params.iterator();
            String separator = "";
            while (pit.hasNext()) {
                this._source.print(separator);
                ((SmcParameter)pit.next()).accept((SmcVisitor)this);
                separator = ", ";
            }
            this._source.println(")");
            this._source.print(this._indent);
            this._source.println("    {");
            if (this._debugLevel >= 0) {
                this._source.print(this._indent);
                this._source.print("        setTransition(\"");
                this._source.print(trans.getName());
                this._source.println("\");");
            }
            this._source.print(this._indent);
            this._source.print("        (getState()).");
            this._source.print(trans.getName());
            this._source.print("(*this");
            for (SmcParameter param : params) {
                this._source.print(", ");
                this._source.print(param.getName());
            }
            this._source.println(");");
            if (this._debugLevel >= 0) {
                this._source.print(this._indent);
                this._source.println("        setTransition(NULL);");
            }
            this._source.print(this._indent);
            this._source.println("    };");
        }
        if (this._serialFlag) {
            this._source.println();
            this._source.print(this._indent);
            this._source.print("    static ");
            this._source.print(context);
            this._source.println("State& valueOf(int stateId);");
        }
        this._source.println();
        this._source.print(this._indent);
        this._source.println("private:");
        this._source.println();
        this._source.print(this._indent);
        this._source.print("    ");
        this._source.print(context);
        this._source.println("& _owner;");
        if (this._serialFlag) {
            this._source.println();
            this._source.print(this._indent);
            this._source.println("private:");
            this._source.println();
            this._source.print(this._indent);
            this._source.println("    const static int MIN_INDEX;");
            this._source.print(this._indent);
            this._source.println("    const static int MAX_INDEX;");
            this._source.print(this._indent);
            this._source.print("    static ");
            this._source.print(context);
            this._source.println("State* _States[];");
        }
        this._source.print(this._indent);
        this._source.println("};");
        if (packageName != null && packageName.length() > 0) {
            for (int i = packageDepth - 1; i >= 0; --i) {
                for (int j = 0; j < i; ++j) {
                    this._source.print("    ");
                }
                this._source.println("}");
                this._source.println();
            }
        } else {
            this._source.println();
        }
        this._source.println();
        this._source.println("/*");
        this._source.println(" * Local variables:");
        this._source.println(" *  buffer-read-only: t");
        this._source.println(" * End:");
        this._source.println(" */");
        this._source.println();
        this._source.print("#endif // _H_");
        this._source.println(srcfileCaps);
    }

    public void visit(SmcMap map) {
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        this._source.print(this._indent);
        this._source.print("class ");
        this._source.println(mapName);
        this._source.print(this._indent);
        this._source.println("{");
        this._source.print(this._indent);
        this._source.println("public:");
        this._source.println();
        for (SmcState state : map.getStates()) {
            String stateName = state.getClassName();
            this._source.print(this._indent);
            this._source.print("    static ");
            this._source.print(mapName);
            this._source.print("_");
            this._source.print(stateName);
            this._source.print(" ");
            this._source.print(stateName);
            this._source.println(";");
        }
        this._source.print(this._indent);
        this._source.println("};");
        this._source.println();
        this._source.print(this._indent);
        this._source.print("class ");
        this._source.print(mapName);
        this._source.println("_Default :");
        this._source.print(this._indent);
        this._source.print("    public ");
        this._source.print(context);
        this._source.println("State");
        this._source.print(this._indent);
        this._source.println("{");
        this._source.print(this._indent);
        this._source.println("public:");
        this._source.println();
        this._source.print(this._indent);
        this._source.print("    ");
        this._source.print(mapName);
        this._source.println("_Default(const char *name, int stateId)");
        this._source.print(this._indent);
        this._source.print("    : ");
        this._source.print(context);
        this._source.println("State(name, stateId)");
        this._source.print(this._indent);
        this._source.println("    {};");
        this._source.println();
        if (map.hasDefaultState()) {
            SmcState defaultState = map.getDefaultState();
            for (SmcTransition transition : defaultState.getTransitions()) {
                transition.accept((SmcVisitor)this);
            }
        }
        this._source.print(this._indent);
        this._source.println("};");
        this._source.println();
        for (SmcState state : map.getStates()) {
            state.accept((SmcVisitor)this);
        }
    }

    public void visit(SmcState state) {
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String fsmClassName = map.getFSM().getFsmClassName();
        String mapName = map.getName();
        String stateName = state.getClassName();
        this._source.print(this._indent);
        this._source.print("class ");
        this._source.print(mapName);
        this._source.print('_');
        this._source.print(stateName);
        this._source.println(" :");
        this._source.print(this._indent);
        this._source.print("    public ");
        this._source.print(mapName);
        this._source.println("_Default");
        this._source.print(this._indent);
        this._source.println("{");
        this._source.print(this._indent);
        this._source.print("public:");
        this._source.println();
        this._source.print(this._indent);
        this._source.print("    ");
        this._source.print(mapName);
        this._source.print('_');
        this._source.print(stateName);
        this._source.println("(const char *name, int stateId)");
        this._source.print(this._indent);
        this._source.print("    : ");
        this._source.print(mapName);
        this._source.println("_Default(name, stateId)");
        this._source.print(this._indent);
        this._source.println("    {};");
        this._source.println();
        List actions = state.getEntryActions();
        if (actions != null && actions.size() > 0) {
            this._source.print(this._indent);
            this._source.print("    void Entry(");
            this._source.print(fsmClassName);
            this._source.println("&);");
        }
        if ((actions = state.getExitActions()) != null && actions.size() > 0) {
            this._source.print(this._indent);
            this._source.print("    void Exit(");
            this._source.print(fsmClassName);
            this._source.println("&);");
        }
        for (SmcTransition transition : state.getTransitions()) {
            transition.accept((SmcVisitor)this);
        }
        this._source.print(this._indent);
        this._source.println("};");
        this._source.println();
    }

    public void visit(SmcTransition transition) {
        SmcState state = transition.getState();
        String stateName = state.getClassName();
        String virtual = "";
        if (stateName.equals("Default")) {
            virtual = "virtual ";
        }
        this._source.print(this._indent);
        this._source.print("    ");
        this._source.print(virtual);
        this._source.print("void ");
        this._source.print(transition.getName());
        this._source.print("(");
        this._source.print(state.getMap().getFSM().getFsmClassName());
        this._source.print("& context");
        for (SmcParameter param : transition.getParameters()) {
            this._source.print(", ");
            param.accept((SmcVisitor)this);
        }
        this._source.println(");");
    }

    public void visit(SmcParameter parameter) {
        this._source.print(parameter.getType());
        this._source.print(" ");
        this._source.print(parameter.getName());
    }
}

