/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.util.List;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.SmcVisitor;

public final class SmcHeaderCGenerator
extends SmcCodeGenerator {
    public SmcHeaderCGenerator(SmcOptions options) {
        super(options, "h");
    }

    public void visit(SmcFSM fsm) {
        List params;
        String packageName = fsm.getPackage();
        String context = fsm.getContext();
        String fsmClassName = fsm.getFsmClassName();
        this._source.println("/*");
        this._source.println(" * ex: set ro:");
        this._source.println(" * DO NOT EDIT.");
        this._source.println(" * generated by smc (http://smc.sourceforge.net/)");
        this._source.print(" * from file : ");
        this._source.print(this._srcfileBase);
        this._source.println(".sm");
        this._source.println(" */");
        this._source.println();
        if (packageName != null && packageName.length() > 0) {
            context = packageName + "_" + context;
        }
        String srcfileCaps = this._srcfileBase.replace('\\', '_');
        srcfileCaps = srcfileCaps.replace('/', '_');
        srcfileCaps = srcfileCaps.toUpperCase();
        this._source.print("#ifndef _H_");
        this._source.println(srcfileCaps);
        this._source.print("#define _H_");
        this._source.println(srcfileCaps);
        this._source.println();
        this._source.println("#include <statemap.h>");
        this._source.println();
        for (String declaration : fsm.getDeclarations()) {
            this._source.print(declaration);
            if (!declaration.endsWith(";")) {
                this._source.print(";");
            }
            this._source.println();
        }
        this._source.println();
        this._source.print("struct ");
        this._source.print(context);
        this._source.println(";");
        this._source.print("struct ");
        this._source.print(fsmClassName);
        this._source.println(";");
        this._source.println();
        this._source.print("struct ");
        this._source.print(context);
        this._source.println("State");
        this._source.println("{");
        if (fsm.hasEntryActions()) {
            this._source.print("    void(*Entry)(struct ");
            this._source.print(fsmClassName);
            this._source.println("*);");
        }
        if (fsm.hasExitActions()) {
            this._source.print("    void(*Exit)(struct ");
            this._source.print(fsmClassName);
            this._source.println("*);");
        }
        this._source.println();
        List transList = fsm.getTransitions();
        for (SmcTransition trans : transList) {
            if (trans.getName().equals("Default")) continue;
            this._source.print("    void(*");
            this._source.print(trans.getName());
            this._source.print(")(struct ");
            this._source.print(fsmClassName);
            this._source.print("*");
            params = trans.getParameters();
            for (SmcParameter param : params) {
                this._source.print(", ");
                this._source.print(param.getType());
            }
            this._source.println(");");
        }
        this._source.println();
        this._source.print("    void(*Default)(struct ");
        this._source.print(fsmClassName);
        this._source.println("*);");
        this._source.println();
        this._source.println("    STATE_MEMBERS");
        this._source.println("};");
        this._source.println();
        for (SmcMap map : fsm.getMaps()) {
            map.accept((SmcVisitor)this);
        }
        this._source.println();
        this._source.print("struct ");
        this._source.print(fsmClassName);
        this._source.println("");
        this._source.println("{");
        this._source.print("    FSM_MEMBERS(");
        this._source.print(context);
        this._source.println(")");
        this._source.print("    struct ");
        this._source.print(context);
        this._source.println(" *_owner;");
        this._source.println("};");
        this._source.println();
        this._source.print("extern void ");
        this._source.print(fsmClassName);
        this._source.print("_Init");
        this._source.print("(struct ");
        this._source.print(fsmClassName);
        this._source.print("*, struct ");
        this._source.print(context);
        this._source.println("*);");
        if (fsm.hasEntryActions()) {
            this._source.print("extern void ");
            this._source.print(fsmClassName);
            this._source.print("_EnterStartState(struct ");
            this._source.print(fsmClassName);
            this._source.println("*);");
        }
        for (SmcTransition trans : transList) {
            if (trans.getName().equals("Default")) continue;
            this._source.print("extern void ");
            this._source.print(fsmClassName);
            this._source.print("_");
            this._source.print(trans.getName());
            this._source.print("(struct ");
            this._source.print(fsmClassName);
            this._source.print("*");
            params = trans.getParameters();
            for (SmcParameter param : params) {
                this._source.print(", ");
                this._source.print(param.getType());
            }
            this._source.println(");");
        }
        this._source.println();
        this._source.println("#endif");
        this._source.println();
        this._source.println("/*");
        this._source.println(" * Local variables:");
        this._source.println(" *  buffer-read-only: t");
        this._source.println(" * End:");
        this._source.println(" */");
    }

    public void visit(SmcMap map) {
        String packageName = map.getFSM().getPackage();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        if (packageName != null && packageName.length() > 0) {
            context = packageName + "_" + context;
        }
        for (SmcState state : map.getStates()) {
            this._source.print("extern const struct ");
            this._source.print(context);
            this._source.print("State ");
            if (packageName != null && packageName.length() > 0) {
                this._source.print(packageName);
                this._source.print("_");
            }
            this._source.print(mapName);
            this._source.print("_");
            this._source.print(state.getInstanceName());
            this._source.println(";");
        }
    }
}

