/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.SmcVisitor;

public final class SmcGroovyGenerator
extends SmcCodeGenerator {
    public SmcGroovyGenerator(SmcOptions options) {
        super(options, "groovy");
    }

    public void visit(SmcFSM fsm) {
        String rawSource = fsm.getSource();
        String packageName = fsm.getPackage();
        String context = fsm.getContext();
        String fsmClassName = fsm.getFsmClassName();
        String startState = fsm.getStartState();
        List maps = fsm.getMaps();
        this._source.println("// ex: set ro:");
        this._source.println("// DO NOT EDIT.");
        this._source.println("// generated by smc (http://smc.sourceforge.net/)");
        this._source.print("// from file : ");
        this._source.print(this._srcfileBase);
        this._source.println(".sm");
        if (rawSource != null && rawSource.length() > 0) {
            this._source.println();
            this._source.println(rawSource);
        }
        if (packageName != null && packageName.length() > 0) {
            this._source.println();
            this._source.print("package ");
            this._source.println(packageName);
        }
        this._source.println();
        for (String imp : fsm.getImports()) {
            this._source.print("import ");
            this._source.println(imp);
        }
        this._source.println();
        this._source.print("class ");
        this._source.print(fsmClassName);
        this._source.print(" extends statemap.FSMContext");
        if (this._serialFlag) {
            this._source.print(" implements Serializable");
        }
        this._source.println(" {");
        this._source.println();
        this._source.println("    def owner");
        this._source.println();
        int index = startState.indexOf("::");
        String javaState = index >= 0 ? startState.substring(0, index) + "." + startState.substring(index + 2) : startState;
        this._source.print("    def ");
        this._source.print(fsmClassName);
        this._source.println(" (owner) {");
        this._source.print("        super(");
        this._source.print(javaState);
        this._source.println(")");
        this._source.println();
        this._source.println("        this.owner = owner");
        this._source.println("    }");
        this._source.println();
        this._source.print("    def ");
        this._source.print(fsmClassName);
        this._source.println(" (owner, initState) {");
        this._source.println("        super(initState)");
        this._source.println();
        this._source.println("        this.owner = owner");
        this._source.println("    }");
        this._source.println();
        this._source.println("    def enterStartState() {");
        this._source.println("        state.Entry(this)");
        this._source.println("    }");
        this._source.println();
        List transitions = fsm.getTransitions();
        for (SmcTransition trans : transitions) {
            if (trans.getName().equals("Default")) continue;
            if (this._syncFlag) {
                this._source.print("    synchronized void ");
            } else {
                this._source.print("    def ");
            }
            this._source.print(trans.getName());
            this._source.print(" (");
            List params = trans.getParameters();
            Iterator pit = params.iterator();
            String separator = "";
            while (pit.hasNext()) {
                this._source.print(separator);
                ((SmcParameter)pit.next()).accept((SmcVisitor)this);
                separator = ", ";
            }
            this._source.println(") {");
            this._source.print("        transition = '");
            this._source.print(trans.getName());
            this._source.println("'");
            this._source.print("        state.");
            this._source.print(trans.getName());
            this._source.print("(this");
            pit = params.iterator();
            while (pit.hasNext()) {
                this._source.print(", ");
                this._source.print(((SmcParameter)pit.next()).getName());
            }
            this._source.println(")");
            this._source.println("        transition = ''");
            this._source.println("    }");
            this._source.println();
        }
        if (this._reflectFlag) {
            boolean firstFlag = true;
            this._source.println("    final states = [");
            for (SmcMap map : maps) {
                String mapName = map.getName();
                for (SmcState state : map.getStates()) {
                    if (firstFlag) {
                        firstFlag = false;
                    } else {
                        this._source.println(",");
                    }
                    this._source.print("        ");
                    this._source.print(mapName);
                    this._source.print(".");
                    this._source.print(state.getClassName());
                }
            }
            this._source.println();
            this._source.println("    ]");
            this._source.println();
            this._source.println("    final transitions = [");
            firstFlag = true;
            for (SmcTransition trans : transitions) {
                if (firstFlag) {
                    firstFlag = false;
                } else {
                    this._source.println(",");
                }
                this._source.print("        '");
                this._source.print(trans.getName());
                this._source.print("'");
            }
            this._source.println();
            this._source.println("    ]");
        }
        this._source.println("}");
        this._source.println();
        this._source.print("private class ");
        this._source.print(context);
        this._source.println("State extends statemap.State {");
        this._source.println();
        this._source.println("    def Entry (context) {}");
        this._source.println("    def Exit (context) {}");
        this._source.println();
        for (SmcTransition trans : transitions) {
            String transName = trans.getName();
            if (transName.equals("Default")) continue;
            this._source.print("    def ");
            this._source.print(transName);
            this._source.print(" (context");
            for (SmcParameter param : trans.getParameters()) {
                this._source.print(", ");
                param.accept((SmcVisitor)this);
            }
            this._source.println(") {");
            this._source.println("        Default(context)");
            this._source.println("    }");
            this._source.println();
        }
        this._source.println("    def Default (context) {");
        if (this._debugLevel >= 0) {
            this._source.println("        if (context.debugFlag)");
            this._source.println("            context.debugStream.println 'TRANSITION   : Default'");
            this._source.println();
        }
        this._source.println("        throw new statemap.TransitionUndefinedException(");
        this._source.println("                'State: ' + context.state.name +");
        this._source.println("                ', Transition: ' + context.transition)");
        this._source.println("    }");
        this._source.println();
        this._source.println("}");
        this._source.println();
        for (SmcMap map : maps) {
            map.accept((SmcVisitor)this);
        }
        this._source.println();
        this._source.println("// Local variables:");
        this._source.println("//  buffer-read-only: t");
        this._source.println("// End:");
    }

    public void visit(SmcMap map) {
        SmcState defaultState = map.getDefaultState();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        List states = map.getStates();
        ArrayList definedDefaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList();
        this._source.print("private class ");
        this._source.print(mapName);
        this._source.print("_Default extends ");
        this._source.print(context);
        this._source.println("State {");
        this._indent = "    ";
        for (SmcTransition trans : definedDefaultTransitions) {
            trans.accept((SmcVisitor)this);
        }
        if (this._reflectFlag) {
            List allTransitions = map.getFSM().getTransitions();
            this._source.println();
            this._source.print("    def transitions = [");
            String sep = "";
            for (SmcTransition transition : allTransitions) {
                String transName = transition.getName();
                int transDefinition = definedDefaultTransitions.contains(transition) ? 2 : 0;
                this._source.println(sep);
                this._source.print("        ");
                this._source.print(transName);
                this._source.print(":");
                this._source.print(transDefinition);
                sep = ",";
            }
            this._source.println();
            this._source.println("    ]");
            this._source.println();
        }
        this._source.println("}");
        for (SmcState state : states) {
            state.accept((SmcVisitor)this);
        }
        this._source.println();
        this._source.print("class ");
        this._source.print(mapName);
        this._source.println(" {");
        for (SmcState state : states) {
            this._source.print("    static final ");
            this._source.print(state.getInstanceName());
            this._source.print(" = new ");
            this._source.print(mapName);
            this._source.print('_');
            this._source.print(state.getClassName());
            this._source.print("(name:'");
            this._source.print(mapName);
            this._source.print('.');
            this._source.print(state.getClassName());
            this._source.print("', id:");
            this._source.print(map.getNextStateId());
            this._source.println(")");
        }
        this._source.print("    static final Default = new ");
        this._source.print(mapName);
        this._source.print("_Default(name:'");
        this._source.print(mapName);
        this._source.println(".Default', id:-1)");
        this._source.println("}");
        this._source.println();
    }

    public void visit(SmcState state) {
        String indent2;
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        String stateName = state.getClassName();
        this._source.println();
        this._source.print("private class ");
        this._source.print(mapName);
        this._source.print('_');
        this._source.print(stateName);
        this._source.print(" extends ");
        this._source.print(mapName);
        this._source.println("_Default {");
        List actions = state.getEntryActions();
        if (actions != null && actions.size() > 0) {
            this._source.println();
            this._source.println("    def Entry (context) {");
            this._source.println("        def ctxt = context.owner");
            this._source.println();
            indent2 = this._indent;
            this._indent = "        ";
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
            this._indent = indent2;
            this._source.println("    }");
        }
        if ((actions = state.getExitActions()) != null && actions.size() > 0) {
            this._source.println();
            this._source.println("    def Exit (context) {");
            this._source.println("        def ctxt = context.owner");
            this._source.println();
            indent2 = this._indent;
            this._indent = "        ";
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
            this._source.println("    }");
        }
        this._indent = "    ";
        for (SmcTransition transition : state.getTransitions()) {
            transition.accept((SmcVisitor)this);
        }
        if (this._reflectFlag) {
            List allTransitions = map.getFSM().getTransitions();
            List stateTransitions = state.getTransitions();
            SmcState defaultState = map.getDefaultState();
            ArrayList defaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList();
            this._source.println();
            this._source.print("    final transitions = [");
            String sep = "";
            for (SmcTransition transition : allTransitions) {
                String transName = transition.getName();
                int transDefinition = stateTransitions.contains(transition) ? 1 : (defaultTransitions.contains(transition) ? 2 : 0);
                this._source.println(sep);
                this._source.print("        ");
                this._source.print(transName);
                this._source.print(":");
                this._source.print(transDefinition);
                sep = ",";
            }
            this._source.println();
            this._source.println("    ]");
            this._source.println();
        }
        this._source.println("}");
    }

    public void visit(SmcTransition transition) {
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        List parameters = transition.getParameters();
        List guards = transition.getGuards();
        boolean nullCondition = false;
        this._source.println();
        this._source.print(this._indent);
        this._source.print("def ");
        this._source.print(transName);
        this._source.print("(context");
        for (SmcParameter parameter : parameters) {
            this._source.print(", ");
            parameter.accept((SmcVisitor)this);
        }
        this._source.println(") {");
        if (transition.hasCtxtReference()) {
            this._source.print(this._indent);
            this._source.print("    ");
            this._source.println("def ctxt = context.owner");
            this._source.println();
        }
        if (this._debugLevel >= 0) {
            this._source.print(this._indent);
            this._source.println("    if (context.debugFlag)");
            this._source.print(this._indent);
            this._source.print("        context.debugStream.println(");
            this._source.print("'LEAVING STATE   : ");
            this._source.print(mapName);
            this._source.print('.');
            this._source.print(stateName);
            this._source.println("')");
        }
        Iterator git = guards.iterator();
        this._guardIndex = 0;
        this._guardCount = guards.size();
        while (git.hasNext()) {
            SmcGuard guard = (SmcGuard)git.next();
            if (guard.getCondition().length() == 0) {
                nullCondition = true;
            }
            guard.accept((SmcVisitor)this);
            ++this._guardIndex;
        }
        if (this._guardIndex > 0 && !nullCondition) {
            if (this._guardCount == 1) {
                this._source.print(this._indent);
                this._source.println("    }");
            }
            this._source.print(this._indent);
            this._source.println("    else {");
            this._source.print(this._indent);
            this._source.print("        super.");
            this._source.print(transName);
            this._source.print("(context");
            for (SmcParameter param : parameters) {
                this._source.print(", ");
                this._source.print(param.getName());
            }
            this._source.println(")");
            this._source.print(this._indent);
            this._source.println("    }");
            this._source.println();
        } else if (this._guardCount > 1) {
            this._source.println();
            this._source.println();
        }
        this._source.print(this._indent);
        this._source.println("}");
    }

    public void visit(SmcGuard guard) {
        String indent4;
        String indent3;
        String sep;
        Iterator pit;
        List parameters;
        String indent2;
        boolean hasActions;
        SmcTransition transition = guard.getTransition();
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        SmcElement.TransType transType = guard.getTransType();
        boolean loopbackFlag = false;
        String endStateName = guard.getEndState();
        String fqEndStateName = "";
        String pushStateName = guard.getPushState();
        String condition = guard.getCondition();
        List actions = guard.getActions();
        boolean bl = hasActions = !actions.isEmpty();
        if (transType != SmcElement.TransType.TRANS_POP && endStateName.length() > 0 && !endStateName.equals("nil")) {
            endStateName = this.scopeStateName(endStateName, mapName);
        }
        stateName = this.scopeStateName(stateName, mapName);
        pushStateName = this.scopeStateName(pushStateName, mapName);
        loopbackFlag = this.isLoopback(transType, endStateName);
        if (this._guardCount > 1) {
            indent2 = this._indent + "        ";
            if (this._guardIndex == 0 && condition.length() > 0) {
                this._source.print(this._indent);
                this._source.print("    if (");
                this._source.print(condition);
                this._source.println(") {");
            } else if (condition.length() > 0) {
                this._source.println();
                this._source.print(this._indent);
                this._source.print("    else if (");
                this._source.print(condition);
                this._source.println(") {");
            } else {
                this._source.println();
                this._source.print(this._indent);
                this._source.println("    else {");
            }
        } else if (condition.length() == 0) {
            indent2 = this._indent + "    ";
        } else {
            indent2 = this._indent + "        ";
            this._source.print(this._indent);
            this._source.print("    if (");
            this._source.print(condition);
            this._source.println(") {");
        }
        if (!hasActions) {
            fqEndStateName = endStateName;
        } else if (loopbackFlag) {
            fqEndStateName = "endState";
            this._source.print(indent2);
            this._source.print("def ");
            this._source.print(fqEndStateName);
            this._source.println(" = context.state");
        } else {
            fqEndStateName = endStateName;
        }
        this._source.println();
        if (transType == SmcElement.TransType.TRANS_POP || !loopbackFlag) {
            if (this._debugLevel >= 1) {
                this._source.print(indent2);
                this._source.println("if (context.debugFlag)");
                this._source.print(indent2);
                this._source.print("    context.debugStream.println('");
                this._source.print("BEFORE EXIT     : ");
                this._source.print(stateName);
                this._source.println(".Exit(context)')");
                this._source.println();
            }
            this._source.print(indent2);
            this._source.println("context.state.Exit(context)");
            if (this._debugLevel >= 1) {
                this._source.print(indent2);
                this._source.println("if (context.debugFlag)");
                this._source.print(indent2);
                this._source.print("    context.debugStream.println('");
                this._source.print("AFTER EXIT      : ");
                this._source.print(stateName);
                this._source.println(".Exit(context)')");
                this._source.println();
            }
        }
        if (this._debugLevel >= 0) {
            parameters = transition.getParameters();
            this._source.print(this._indent);
            this._source.println("    if (context.debugFlag)");
            this._source.print(this._indent);
            this._source.print("        context.debugStream.println(");
            this._source.print("'ENTER TRANSITION: ");
            this._source.print(stateName);
            this._source.print('.');
            this._source.print(transName);
            this._source.print('(');
            pit = parameters.iterator();
            sep = "";
            while (pit.hasNext()) {
                this._source.print(sep);
                ((SmcParameter)pit.next()).accept((SmcVisitor)this);
                sep = ", ";
            }
            this._source.print(')');
            this._source.println("')");
            this._source.println();
        }
        if (!hasActions) {
            if (condition.length() > 0) {
                this._source.print(indent2);
                this._source.println("// No actions.");
            }
            indent3 = indent2;
        } else {
            this._source.print(indent2);
            this._source.println("context.clearState()");
            if (!this._noCatchFlag) {
                this._source.print(indent2);
                this._source.println("try {");
                indent3 = indent2 + "    ";
            } else {
                indent3 = indent2;
            }
            indent4 = this._indent;
            this._indent = indent3;
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
            this._indent = indent4;
            if (!this._noCatchFlag) {
                this._source.print(indent2);
                this._source.println('}');
                this._source.print(indent2);
                this._source.println("finally {");
            }
        }
        if (this._debugLevel >= 0) {
            parameters = transition.getParameters();
            indent4 = this._indent;
            this._indent = indent3;
            this._source.print(this._indent);
            this._source.println("if (context.debugFlag)");
            this._source.print(this._indent);
            this._source.print("    context.debugStream.println(");
            this._source.print("'EXIT TRANSITION : ");
            this._source.print(stateName);
            this._source.print('.');
            this._source.print(transName);
            this._source.print('(');
            pit = parameters.iterator();
            sep = "";
            while (pit.hasNext()) {
                this._source.print(sep);
                ((SmcParameter)pit.next()).accept((SmcVisitor)this);
                sep = ", ";
            }
            this._source.print(')');
            this._source.println("')");
            this._source.println();
            this._indent = indent4;
        }
        if (transType == SmcElement.TransType.TRANS_SET && (hasActions || !loopbackFlag)) {
            this._source.print(indent3);
            this._source.print("context.setState(");
            this._source.print(fqEndStateName);
            this._source.println(")");
        } else if (transType == SmcElement.TransType.TRANS_PUSH) {
            if (!loopbackFlag || hasActions) {
                this._source.print(indent3);
                this._source.print("context.setState(");
                this._source.print(fqEndStateName);
                this._source.println(")");
            }
            if (!loopbackFlag) {
                if (this._debugLevel >= 1) {
                    this._source.print(indent3);
                    this._source.println("if (context.debugFlag)");
                    this._source.print(indent3);
                    this._source.print("    context.debugStream.println('");
                    this._source.print("BEFORE ENTRY    : ");
                    this._source.print(stateName);
                    this._source.println(".Entry(context)')");
                    this._source.println();
                }
                this._source.print(indent3);
                this._source.println("context.state.Entry(context)");
                if (this._debugLevel >= 1) {
                    this._source.print(indent3);
                    this._source.println("if (context.debugFlag)");
                    this._source.print(indent3);
                    this._source.print("    context.debugStream.println('");
                    this._source.print("AFTER ENTRY     : ");
                    this._source.print(stateName);
                    this._source.println(".Entry(context)')");
                    this._source.println();
                }
            }
            this._source.print(indent3);
            this._source.print("context.pushState(");
            this._source.print(pushStateName);
            this._source.println(")");
        } else if (transType == SmcElement.TransType.TRANS_POP) {
            this._source.print(indent3);
            this._source.println("context.popState()");
        }
        if (transType == SmcElement.TransType.TRANS_SET && !loopbackFlag || transType == SmcElement.TransType.TRANS_PUSH) {
            if (this._debugLevel >= 1) {
                this._source.print(indent3);
                this._source.println("if (context.debugFlag)");
                this._source.print(indent3);
                this._source.print("    context.debugStream.println('");
                this._source.print("BEFORE ENTRY    : ");
                this._source.print(stateName);
                this._source.println(".Entry(context)')");
                this._source.println();
            }
            this._source.print(indent3);
            this._source.println("context.state.Entry(context)");
            if (this._debugLevel >= 1) {
                this._source.print(indent3);
                this._source.println("if (context.debugFlag)");
                this._source.print(indent3);
                this._source.print("    context.debugStream.println('");
                this._source.print("AFTER ENTRY     : ");
                this._source.print(stateName);
                this._source.println(".Entry(context)')");
                this._source.println();
            }
        }
        if (hasActions && !this._noCatchFlag) {
            this._source.print(indent2);
            this._source.println('}');
        }
        if (transType == SmcElement.TransType.TRANS_POP && !endStateName.equals("nil") && endStateName.length() > 0) {
            String popArgs = guard.getPopArgs();
            this._source.println();
            this._source.print(indent2);
            this._source.print("context.");
            this._source.print(endStateName);
            this._source.print("(");
            if (popArgs.length() > 0) {
                this._source.print(popArgs);
            }
            this._source.println(")");
        }
        if (this._guardCount > 1) {
            this._source.print(this._indent);
            this._source.print("    }");
        }
    }

    public void visit(SmcAction action) {
        String name = action.getName();
        this._source.print(this._indent);
        if (action.isEmptyStateStack()) {
            this._source.println("context.emptyStateStack()");
        } else {
            this._source.print("ctxt.");
            this._source.print(name);
            this._source.print("(");
            Iterator it = action.getArguments().iterator();
            String sep = "";
            while (it.hasNext()) {
                this._source.print(sep);
                this._source.print((String)it.next());
                sep = ", ";
            }
            this._source.println(")");
        }
    }

    public void visit(SmcParameter parameter) {
        String type = parameter.getType();
        if (type.equals("")) {
            this._source.print(parameter.getName());
        } else {
            this._source.print(type);
            this._source.print(" ");
            this._source.print(parameter.getName());
        }
    }
}

