/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.SmcVisitor;

public final class SmcGraphGenerator
extends SmcCodeGenerator {
    String _indent_action = "&nbsp;&nbsp;&nbsp;";

    public SmcGraphGenerator(SmcOptions options) {
        super(options, "dot");
    }

    public void visit(SmcFSM fsm) {
        this._source.print("digraph ");
        this._source.print(this._srcfileBase);
        this._source.println(" {");
        this._source.println();
        this._source.println("    node");
        this._source.println("        [shape=Mrecord width=1.5];");
        this._source.println();
        for (SmcMap map : fsm.getMaps()) {
            String mapName = map.getName();
            this._source.print("    subgraph cluster_");
            this._source.print(mapName);
            this._source.println(" {");
            this._source.println();
            this._source.print("        label=\"");
            this._source.print(mapName);
            this._source.println("\";");
            this._source.println();
            map.accept((SmcVisitor)this);
            this._source.println("    }");
            this._source.println();
        }
        this._source.println("}");
    }

    public void visit(SmcMap map) {
        String pushStateName;
        String mapName = map.getName();
        SmcState defaultState = map.getDefaultState();
        String startStateName = map.getFSM().getStartState();
        HashMap<String, String> pushEntryMap = new HashMap<String, String>();
        HashMap<String, String> popTransMap = new HashMap<String, String>();
        HashMap<String, String> pushStateMap = new HashMap<String, String>();
        boolean needEnd = false;
        this._source.println("        //");
        this._source.println("        // States (Nodes)");
        this._source.println("        //");
        this._source.println();
        for (SmcState state : map.getStates()) {
            state.accept((SmcVisitor)this);
        }
        if (defaultState != null && !defaultState.getTransitions().isEmpty()) {
            defaultState.accept((SmcVisitor)this);
        }
        for (SmcState state : map.getAllStates()) {
            for (SmcTransition transition : state.getTransitions()) {
                for (SmcGuard guard : transition.getGuards()) {
                    String popArgs;
                    String endStateName = guard.getEndState();
                    SmcElement.TransType transType = guard.getTransType();
                    if (transType == SmcElement.TransType.TRANS_PUSH) {
                        int index;
                        pushStateName = guard.getPushState();
                        if (endStateName.equals("nil")) {
                            endStateName = state.getInstanceName();
                        }
                        String pushMapName = (index = pushStateName.indexOf("::")) >= 0 ? pushStateName.substring(0, index) : mapName;
                        pushStateMap.put(mapName + "::" + endStateName + "::" + pushMapName, pushMapName);
                        continue;
                    }
                    if (transType != SmcElement.TransType.TRANS_POP) continue;
                    String popKey = endStateName;
                    String popVal = endStateName;
                    if (this._graphLevel == 2 && (popArgs = guard.getPopArgs()) != null && popArgs.length() > 0) {
                        popKey = popKey + ", ";
                        popVal = popVal + ", ";
                        popKey = popKey + SmcGraphGenerator._escape(SmcGraphGenerator._normalize(popArgs));
                        popVal = popVal + SmcGraphGenerator._escape(popArgs).replaceAll("\\n", "\\\\\\l");
                    }
                    popTransMap.put(popKey, popVal);
                    needEnd = true;
                }
            }
        }
        for (String pname : popTransMap.keySet()) {
            this._source.print("        \"");
            this._source.print(mapName);
            this._source.print("::pop(");
            this._source.print(pname);
            this._source.println(")\"");
            this._source.println("            [label=\"\" width=1]");
            this._source.println();
        }
        if (needEnd) {
            this._source.print("        \"");
            this._source.print(mapName);
            this._source.println("::%end\"");
            this._source.println("            [label=\"\" shape=doublecircle style=filled fillcolor=black width=0.15];");
            this._source.println();
        }
        for (String pname : pushStateMap.keySet()) {
            this._source.print("        \"");
            this._source.print(pname);
            this._source.println("\"");
            this._source.print("            [label=\"{");
            this._source.print((String)pushStateMap.get(pname));
            this._source.println("|O-O\\r}\"]");
            this._source.println();
        }
        if (startStateName.indexOf(mapName) == 0) {
            this._source.println("        \"%start\"");
            this._source.println("            [label=\"\" shape=circle style=filled fillcolor=black width=0.25];");
            this._source.println();
        }
        for (SmcMap map2 : map.getFSM().getMaps()) {
            for (SmcState state : map2.getAllStates()) {
                for (SmcTransition transition : state.getTransitions()) {
                    for (SmcGuard guard : transition.getGuards()) {
                        if (guard.getTransType() != SmcElement.TransType.TRANS_PUSH || (pushStateName = guard.getPushState()).indexOf(mapName) != 0) continue;
                        pushEntryMap.put(pushStateName, "");
                    }
                }
            }
        }
        for (String pname : pushEntryMap.keySet()) {
            this._source.print("        \"push(");
            this._source.print(pname);
            this._source.println(")\"");
            this._source.println("            [label=\"\" shape=plaintext];");
            this._source.println();
        }
        this._source.println("        //");
        this._source.println("        // Transitions (Edges)");
        this._source.println("        //");
        for (SmcState state : map.getStates()) {
            for (SmcTransition transition : state.getTransitions()) {
                transition.accept((SmcVisitor)this);
            }
        }
        if (defaultState != null) {
            for (SmcTransition transition : defaultState.getTransitions()) {
                transition.accept((SmcVisitor)this);
            }
        }
        for (String pname : popTransMap.keySet()) {
            this._source.println();
            this._source.print("        \"");
            this._source.print(mapName);
            this._source.print("::pop(");
            this._source.print(pname);
            this._source.print(")\" -> \"");
            this._source.print(mapName);
            this._source.println("::%end\"");
            this._source.print("            [label=\"pop(");
            this._source.print((String)popTransMap.get(pname));
            this._source.println(");\\l\"];");
        }
        for (String pname : pushStateMap.keySet()) {
            this._source.println();
            this._source.print("        \"");
            this._source.print(pname);
            this._source.print("\" -> \"");
            this._source.print(pname.substring(0, pname.lastIndexOf("::")));
            this._source.println("\"");
            this._source.println("            [label=\"pop/\"]");
        }
        if (startStateName.indexOf(mapName) == 0) {
            this._source.println();
            this._source.print("        \"%start\" -> \"");
            this._source.print(startStateName);
            this._source.println("\"");
        }
        for (String pname : pushEntryMap.keySet()) {
            this._source.println();
            this._source.print("        \"push(");
            this._source.print(pname);
            this._source.print(")\" -> \"");
            this._source.print(pname);
            this._source.println("\"");
            this._source.println("            [arrowtail=odot];");
        }
    }

    public void visit(SmcState state) {
        String mapName = state.getMap().getName();
        String instanceName = state.getInstanceName();
        this._source.print("        \"");
        this._source.print(mapName);
        this._source.print("::");
        this._source.print(instanceName);
        this._source.println("\"");
        this._source.print("            [label=\"{");
        if (instanceName.equals("DefaultState")) {
            this._source.print("&laquo; Default &raquo;");
        } else {
            this._source.print(instanceName);
        }
        if (this._graphLevel >= 1) {
            boolean empty = true;
            List actions = state.getEntryActions();
            if (actions != null) {
                if (empty) {
                    this._source.print("|");
                    empty = false;
                }
                this._source.print("Entry/\\l");
                for (SmcAction action : actions) {
                    this._source.print(this._indent_action);
                    action.accept((SmcVisitor)this);
                }
            }
            if ((actions = state.getExitActions()) != null) {
                if (empty) {
                    this._source.print("|");
                    empty = false;
                }
                this._source.print("Exit/\\l");
                for (SmcAction action : actions) {
                    this._source.print(this._indent_action);
                    action.accept((SmcVisitor)this);
                }
            }
            empty = true;
            for (SmcTransition transition : state.getTransitions()) {
                for (SmcGuard guard : transition.getGuards()) {
                    String endStateName = guard.getEndState();
                    SmcElement.TransType transType = guard.getTransType();
                    if (!this.isLoopback(transType, endStateName) || transType == SmcElement.TransType.TRANS_PUSH) continue;
                    String transName = transition.getName();
                    String condition = guard.getCondition();
                    String pushStateName = guard.getPushState();
                    actions = guard.getActions();
                    if (empty) {
                        this._source.print("|");
                        empty = false;
                    }
                    this._source.print(transName);
                    if (this._graphLevel == 2) {
                        List parameters = transition.getParameters();
                        this._source.print("(");
                        Iterator pit = parameters.iterator();
                        String sep = "";
                        while (pit.hasNext()) {
                            this._source.print(sep);
                            ((SmcParameter)pit.next()).accept((SmcVisitor)this);
                            sep = ", ";
                        }
                        this._source.print(")");
                    }
                    if (condition != null && condition.length() > 0) {
                        String tmp = SmcGraphGenerator._escape(condition);
                        tmp = tmp.replaceAll("\\n", "\\\\\\l");
                        tmp = tmp.replaceAll(">", "\\\\>");
                        tmp = tmp.replaceAll("<", "\\\\<");
                        tmp = tmp.replaceAll("\\|", "\\\\|");
                        this._source.print("\\l\\[");
                        this._source.print(tmp);
                        this._source.print("\\]");
                    }
                    this._source.print("/\\l");
                    if (actions != null) {
                        for (SmcAction action : actions) {
                            this._source.print(this._indent_action);
                            action.accept((SmcVisitor)this);
                        }
                    }
                    if (transType != SmcElement.TransType.TRANS_PUSH) continue;
                    this._source.print(this._indent_action);
                    this._source.print("push(");
                    this._source.print(pushStateName);
                    this._source.print(")\\l");
                }
            }
        }
        this._source.println("}\"];");
        this._source.println();
    }

    public void visit(SmcTransition transition) {
        for (SmcGuard guard : transition.getGuards()) {
            guard.accept((SmcVisitor)this);
        }
    }

    public void visit(SmcGuard guard) {
        SmcTransition transition = guard.getTransition();
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String mapName = map.getName();
        String stateName = state.getInstanceName();
        String transName = transition.getName();
        SmcElement.TransType transType = guard.getTransType();
        String endStateName = guard.getEndState();
        String pushStateName = guard.getPushState();
        String condition = guard.getCondition();
        List actions = guard.getActions();
        if (this.isLoopback(transType, endStateName) && transType != SmcElement.TransType.TRANS_PUSH) {
            return;
        }
        this._source.println();
        this._source.print("        \"");
        this._source.print(mapName);
        this._source.print("::");
        this._source.print(stateName);
        this._source.print("\" -> ");
        if (transType != SmcElement.TransType.TRANS_POP) {
            if (endStateName.equals("nil")) {
                endStateName = stateName;
            }
            if (endStateName.indexOf("::") < 0) {
                endStateName = mapName + "::" + endStateName;
            }
            this._source.print("\"");
            this._source.print(endStateName);
            if (transType == SmcElement.TransType.TRANS_PUSH) {
                int index = pushStateName.indexOf("::");
                this._source.print("::");
                if (index < 0) {
                    this._source.print(mapName);
                } else {
                    this._source.print(pushStateName.substring(0, pushStateName.indexOf("::")));
                }
            }
            this._source.println("\"");
        } else {
            String popArgs = guard.getPopArgs();
            this._source.print("\"");
            this._source.print(mapName);
            this._source.print("::pop(");
            this._source.print(endStateName);
            if (this._graphLevel == 2 && popArgs != null && popArgs.length() > 0) {
                this._source.print(", ");
                this._source.print(SmcGraphGenerator._escape(SmcGraphGenerator._normalize(popArgs)));
            }
            this._source.println(")\"");
        }
        this._source.print("            [label=\"");
        this._source.print(transName);
        if (this._graphLevel == 2) {
            List parameters = transition.getParameters();
            this._source.print("(");
            Iterator pit = parameters.iterator();
            String sep = "";
            while (pit.hasNext()) {
                this._source.print(sep);
                ((SmcParameter)pit.next()).accept((SmcVisitor)this);
                sep = ", ";
            }
            this._source.print(")");
        }
        if (this._graphLevel > 0 && condition != null && condition.length() > 0) {
            String continueLine = "\\\\";
            this._source.print("\\l\\[");
            this._source.print(SmcGraphGenerator._escape(condition).replaceAll("\\n", "\\\\\\l"));
            this._source.print("\\]");
        }
        this._source.print("/\\l");
        if (this._graphLevel > 0 && actions != null) {
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
        }
        if (transType == SmcElement.TransType.TRANS_PUSH) {
            this._source.print("push(");
            this._source.print(pushStateName);
            this._source.print(")\\l");
        }
        this._source.println("\"];");
    }

    public void visit(SmcAction action) {
        if (this._graphLevel >= 1) {
            this._source.print(action.getName());
            if (this._graphLevel == 2) {
                this._source.print("(");
                Iterator it = action.getArguments().iterator();
                String sep = "";
                while (it.hasNext()) {
                    String arg = ((String)it.next()).trim();
                    this._source.print(sep);
                    arg = arg.replaceAll("\\\\", "\\\\\\\\");
                    this._source.print(arg.replaceAll("\"", "\\\\\""));
                    sep = ", ";
                }
                this._source.print(")");
            }
            this._source.print(";\\l");
        }
    }

    public void visit(SmcParameter parameter) {
        this._source.print(parameter.getName());
        if (!parameter.getType().equals("")) {
            this._source.print(": ");
            this._source.print(parameter.getType());
        }
    }

    private static String _escape(String s) {
        String retval;
        if (s.indexOf(92) < 0 && s.indexOf(34) < 0) {
            retval = s;
        } else {
            StringBuffer buffer = new StringBuffer(s.length() * 2);
            int length = s.length();
            for (int index = 0; index < length; ++index) {
                char c = s.charAt(index);
                if (c == '\\' || c == '\"') {
                    buffer.append('\\');
                }
                buffer.append(c);
            }
            retval = buffer.toString();
        }
        return retval;
    }

    private static String _normalize(String s) {
        int length = s.length();
        boolean space = false;
        StringBuffer buffer = new StringBuffer(length);
        for (int index = 0; index < length; ++index) {
            char c = s.charAt(index);
            if (space) {
                if (c == ' ' || c == '\t' || c == '\n') continue;
                buffer.append(c);
                space = false;
                continue;
            }
            if (c == ' ' || c == '\t' || c == '\n') {
                buffer.append(' ');
                space = true;
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString().trim();
    }
}

