/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.SmcVisitor;

public final class SmcCppGenerator
extends SmcCodeGenerator {
    public SmcCppGenerator(SmcOptions options) {
        super(options, "cpp");
    }

    public void visit(SmcFSM fsm) {
        String mapName;
        SmcMap map;
        String packageName = fsm.getPackage();
        String rawSource = fsm.getSource();
        String context = fsm.getContext();
        String fsmClassName = fsm.getFsmClassName();
        int packageDepth = 0;
        this._source.println("/*");
        this._source.println(" * ex: set ro:");
        this._source.println(" * DO NOT EDIT.");
        this._source.println(" * generated by smc (http://smc.sourceforge.net/)");
        this._source.print(" * from file : ");
        this._source.print(this._srcfileBase);
        this._source.println(".sm");
        this._source.println(" */");
        this._source.println();
        if (rawSource != null && rawSource.length() > 0) {
            this._source.println(rawSource);
            this._source.println();
        }
        for (String include : fsm.getIncludes()) {
            this._source.print("#include ");
            this._source.println(include);
        }
        this._source.print("#include \"");
        if (this._srcDirectory == null && this._headerDirectory != null || this._srcDirectory != null && this._headerDirectory != null && !this._srcDirectory.equals(this._headerDirectory)) {
            this._source.print(this._headerDirectory);
        } else if (this._srcDirectory != null) {
            this._source.print(this._srcDirectory);
        }
        this._source.print(this._srcfileBase);
        this._source.println(".h\"");
        this._source.println();
        this._source.println("using namespace statemap;");
        for (String imp : fsm.getImports()) {
            this._source.print("using namespace ");
            this._source.print(imp);
            this._source.println(";");
        }
        this._source.println();
        if (packageName != null && packageName.length() > 0) {
            this._indent = "";
            StringTokenizer tokenizer = new StringTokenizer(packageName, "::");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                ++packageDepth;
                this._source.print(this._indent);
                this._source.print("namespace ");
                this._source.println(token);
                this._source.print(this._indent);
                this._source.println("{");
                this._indent = this._indent + "    ";
            }
        }
        this._source.print(this._indent);
        this._source.println("// Static class declarations.");
        Iterator mapIt = fsm.getMaps().iterator();
        int index = 0;
        while (mapIt.hasNext()) {
            map = (SmcMap)mapIt.next();
            mapName = map.getName();
            for (SmcState state : map.getStates()) {
                this._source.print(this._indent);
                this._source.print(mapName);
                this._source.print("_");
                this._source.print(state.getClassName());
                this._source.print(" ");
                this._source.print(mapName);
                this._source.print("::");
                this._source.print(state.getInstanceName());
                this._source.print("(\"");
                this._source.print(mapName);
                this._source.print("::");
                this._source.print(state.getClassName());
                this._source.print("\", ");
                this._source.print(index);
                this._source.println(");");
                ++index;
            }
        }
        if (this._serialFlag) {
            this._source.println();
            this._source.print(this._indent);
            this._source.print("const int ");
            this._source.print(fsmClassName);
            this._source.println("::MIN_INDEX = 0;");
            this._source.print(this._indent);
            this._source.print("const int ");
            this._source.print(fsmClassName);
            this._source.print("::MAX_INDEX = ");
            this._source.print(--index);
            this._source.println(";");
            this._source.print(this._indent);
            this._source.print(context);
            this._source.print("State* ");
            this._source.print(fsmClassName);
            this._source.println("::_States[] = ");
            this._source.print("{");
            mapIt = fsm.getMaps().iterator();
            String separator = "";
            while (mapIt.hasNext()) {
                map = (SmcMap)mapIt.next();
                mapName = map.getName();
                for (SmcState state : map.getStates()) {
                    this._source.print(separator);
                    this._source.println();
                    this._source.print(this._indent);
                    this._source.print("    &");
                    this._source.print(mapName);
                    this._source.print("::");
                    this._source.print(state.getClassName());
                    separator = ",";
                }
            }
            this._source.println();
            this._source.print(this._indent);
            this._source.println("};");
        }
        if (this._serialFlag) {
            this._source.println();
            this._source.print(this._indent);
            this._source.print(context);
            this._source.print("State& ");
            this._source.print(fsmClassName);
            this._source.println("::valueOf(int stateId)");
            this._source.print(this._indent);
            this._source.println("{");
            this._source.print(this._indent);
            this._source.print("    if (stateId < MIN_INDEX || ");
            this._source.println("stateId > MAX_INDEX)");
            this._source.print(this._indent);
            this._source.println("    {");
            if (this._noExceptionFlag) {
                this._source.print(this._indent);
                this._source.println("        assert(1==0);");
            } else {
                this._source.print(this._indent);
                this._source.println("        throw (");
                this._source.print(this._indent);
                this._source.println("            IndexOutOfBoundsException(");
                this._source.print(this._indent);
                this._source.print("                stateId, MIN_INDEX, ");
                this._source.println("MAX_INDEX));");
            }
            this._source.print(this._indent);
            this._source.println("    }");
            this._source.println();
            this._source.print(this._indent);
            this._source.print("    return (static_cast<");
            this._source.print(context);
            this._source.print("State&>(*(");
            this._source.println("_States[stateId])));");
            this._source.print(this._indent);
            this._source.println("}");
        }
        List transList = fsm.getTransitions();
        for (SmcTransition trans : transList) {
            if (trans.getName().equals("Default")) continue;
            this._source.println();
            this._source.print(this._indent);
            this._source.print("void ");
            this._source.print(context);
            this._source.print("State::");
            this._source.print(trans.getName());
            this._source.print("(");
            this._source.print(fsmClassName);
            this._source.print("& context");
            List params = trans.getParameters();
            for (SmcParameter param : params) {
                this._source.print(", ");
                param.accept((SmcVisitor)this);
            }
            this._source.println(")");
            this._source.print(this._indent);
            this._source.println("{");
            this._source.print(this._indent);
            this._source.println("    Default(context);");
            this._source.print(this._indent);
            this._source.println("    return;");
            this._source.print(this._indent);
            this._source.println("}");
        }
        this._source.println();
        this._source.print(this._indent);
        this._source.print("void ");
        this._source.print(context);
        this._source.print("State::Default(");
        this._source.print(fsmClassName);
        this._source.println("& context)");
        this._source.print(this._indent);
        this._source.println("{");
        if (this._debugLevel >= 0) {
            this._source.print(this._indent);
            this._source.println("    if (context.getDebugFlag() == true)");
            this._source.print(this._indent);
            this._source.println("    {");
            if (this._noStreamsFlag) {
                this._source.print(this._indent);
                this._source.print("        TRACE(");
                this._source.println("\"TRANSITION   : Default\\n\\r\");");
            } else {
                this._source.print(this._indent);
                this._source.print("        std::ostream& str = ");
                this._source.println("context.getDebugStream();");
                this._source.println();
                this._source.print(this._indent);
                this._source.println("        str << \"TRANSITION   : Default\"");
                this._source.print(this._indent);
                this._source.println("            << std::endl;");
            }
            this._source.print(this._indent);
            this._source.println("    }");
            this._source.println();
        }
        if (!this._noExceptionFlag) {
            this._source.print(this._indent);
            this._source.println("    throw (");
            this._source.print(this._indent);
            this._source.println("        TransitionUndefinedException(");
            this._source.print(this._indent);
            this._source.println("            context.getState().getName(),");
            this._source.print(this._indent);
            this._source.println("            context.getTransition()));");
            this._source.println();
        } else {
            this._source.print(this._indent);
            this._source.println("    assert(1==0);");
            this._source.println();
        }
        this._source.print(this._indent);
        this._source.println("    return;");
        this._source.print(this._indent);
        this._source.println("}");
        mapIt = fsm.getMaps().iterator();
        while (mapIt.hasNext()) {
            ((SmcMap)mapIt.next()).accept((SmcVisitor)this);
        }
        if (packageName != null && packageName.length() > 0) {
            for (int i = packageDepth - 1; i >= 0; --i) {
                for (int j = 0; j < i; ++j) {
                    this._source.print("    ");
                }
                this._source.println("}");
            }
        }
        this._source.println();
        this._source.println("/*");
        this._source.println(" * Local variables:");
        this._source.println(" *  buffer-read-only: t");
        this._source.println(" * End:");
        this._source.println(" */");
    }

    public void visit(SmcMap map) {
        if (map.hasDefaultState()) {
            SmcState defaultState = map.getDefaultState();
            for (SmcTransition trans : defaultState.getTransitions()) {
                trans.accept((SmcVisitor)this);
            }
        }
        for (SmcState state : map.getStates()) {
            state.accept((SmcVisitor)this);
        }
    }

    public void visit(SmcState state) {
        String indent2;
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String fsmClassName = map.getFSM().getFsmClassName();
        String mapName = map.getName();
        String className = state.getClassName();
        List actions = state.getEntryActions();
        if (actions != null && !actions.isEmpty()) {
            this._source.println();
            this._source.print(this._indent);
            this._source.print("void ");
            this._source.print(mapName);
            this._source.print("_");
            this._source.print(className);
            this._source.print("::Entry(");
            this._source.print(fsmClassName);
            this._source.println("& context)");
            this._source.println();
            this._source.println("{");
            this._source.print(this._indent);
            this._source.print("    ");
            this._source.print(context);
            this._source.println("& ctxt(context.getOwner());");
            this._source.println();
            indent2 = this._indent;
            this._indent = this._indent + "    ";
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
            this._indent = indent2;
            this._source.print(this._indent);
            this._source.println("    return;");
            this._source.print(this._indent);
            this._source.println("}");
        }
        if ((actions = state.getExitActions()) != null && !actions.isEmpty()) {
            this._source.println();
            this._source.print(this._indent);
            this._source.print("void ");
            this._source.print(mapName);
            this._source.print("_");
            this._source.print(className);
            this._source.print("::Exit(");
            this._source.print(fsmClassName);
            this._source.println("& context)");
            this._source.println();
            this._source.println("{");
            this._source.print(this._indent);
            this._source.print("    ");
            this._source.print(context);
            this._source.println("& ctxt(context.getOwner());");
            this._source.println();
            indent2 = this._indent;
            this._indent = this._indent + "    ";
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
            this._indent = indent2;
            this._source.print(this._indent);
            this._source.println("    return;");
            this._source.print(this._indent);
            this._source.println("}");
        }
        for (SmcTransition trans : state.getTransitions()) {
            trans.accept((SmcVisitor)this);
        }
    }

    public void visit(SmcTransition transition) {
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String fsmClassName = map.getFSM().getFsmClassName();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        boolean nullCondition = false;
        List guards = transition.getGuards();
        String fqStateName = stateName.indexOf("::") < 0 ? mapName + "::" + stateName : stateName;
        this._source.println();
        this._source.print(this._indent);
        this._source.print("void ");
        this._source.print(mapName);
        this._source.print("_");
        this._source.print(stateName);
        this._source.print("::");
        this._source.print(transName);
        this._source.print("(");
        this._source.print(fsmClassName);
        this._source.print("& context");
        for (SmcParameter param : transition.getParameters()) {
            this._source.print(", ");
            param.accept((SmcVisitor)this);
        }
        this._source.println(")");
        this._source.print(this._indent);
        this._source.println("{");
        if (transition.hasCtxtReference()) {
            this._source.print(this._indent);
            this._source.print("    ");
            this._source.print(context);
            this._source.println("& ctxt(context.getOwner());");
        }
        this._source.println();
        if (this._debugLevel >= 0) {
            this._source.print(this._indent);
            this._source.println("    if (context.getDebugFlag() == true)");
            this._source.print(this._indent);
            this._source.println("    {");
            if (this._noStreamsFlag) {
                this._source.print(this._indent);
                this._source.print("        TRACE(\"LEAVING STATE   : ");
                this._source.print(fqStateName);
                this._source.println("\\n\\r\");");
            } else {
                this._source.print(this._indent);
                this._source.print("        std::ostream& str = ");
                this._source.println("context.getDebugStream();");
                this._source.println();
                this._source.print(this._indent);
                this._source.print("        str << \"LEAVING STATE   : ");
                this._source.print(fqStateName);
                this._source.println("\"");
                this._source.println("            << std::endl;");
            }
            this._source.print(this._indent);
            this._source.println("    }");
            this._source.println();
        }
        Iterator git = guards.iterator();
        this._guardIndex = 0;
        this._guardCount = guards.size();
        while (git.hasNext()) {
            SmcGuard guard = (SmcGuard)git.next();
            if (guard.getCondition().length() == 0) {
                nullCondition = true;
            }
            guard.accept((SmcVisitor)this);
            ++this._guardIndex;
        }
        if (this._guardIndex > 0 && !nullCondition) {
            if (this._guardCount == 1) {
                this._source.print(this._indent);
                this._source.println("    }");
            }
            this._source.print(this._indent);
            this._source.println("    else");
            this._source.print(this._indent);
            this._source.println("    {");
            this._source.print(this._indent);
            this._source.print("         ");
            this._source.print(mapName);
            this._source.print("_Default::");
            this._source.print(transName);
            this._source.print("(context");
            for (SmcParameter param : transition.getParameters()) {
                this._source.print(", ");
                this._source.print(param.getName());
            }
            this._source.println(");");
            this._source.print(this._indent);
            this._source.println("    }");
        } else if (this._guardCount > 1) {
            this._source.println();
        }
        this._source.println();
        this._source.print(this._indent);
        this._source.println("    return;");
        this._source.print(this._indent);
        this._source.println("}");
    }

    public void visit(SmcGuard guard) {
        String indent3;
        String sep;
        Iterator pit;
        List parameters;
        String transName;
        String indent2;
        SmcTransition transition = guard.getTransition();
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        String stateName = state.getClassName();
        SmcElement.TransType transType = guard.getTransType();
        boolean loopbackFlag = false;
        String indent4 = "";
        String endStateName = guard.getEndState();
        String fqEndStateName = "";
        String pushStateName = guard.getPushState();
        String condition = guard.getCondition();
        List actions = guard.getActions();
        if (transType != SmcElement.TransType.TRANS_POP && endStateName.length() > 0 && !endStateName.equals("nil") && endStateName.indexOf("::") < 0) {
            endStateName = mapName + "::" + endStateName;
        }
        if (stateName.indexOf("::") < 0) {
            stateName = mapName + "::" + stateName;
        }
        loopbackFlag = this.isLoopback(transType, endStateName);
        if (pushStateName != null && pushStateName.length() > 0 && pushStateName.indexOf("::") < 0) {
            pushStateName = mapName + "::" + pushStateName;
        }
        if (this._guardCount > 1) {
            indent2 = this._indent + "        ";
            if (this._guardIndex == 0 && condition.length() > 0) {
                this._source.print(this._indent);
                this._source.print("    if (");
                this._source.print(condition);
                this._source.println(")");
                this._source.print(this._indent);
                this._source.println("    {");
            } else if (condition.length() > 0) {
                this._source.println();
                this._source.print(this._indent);
                this._source.print("    else if (");
                this._source.print(condition);
                this._source.println(")");
                this._source.println(this._indent);
                this._source.println("    {");
            } else {
                this._source.println();
                this._source.print(this._indent);
                this._source.println("    else");
                this._source.print(this._indent);
                this._source.println("    {");
            }
        } else if (condition.length() == 0) {
            indent2 = this._indent + "    ";
        } else {
            this._source.print(this._indent);
            this._source.print("    if (");
            this._source.print(condition);
            this._source.println(")");
            this._source.print(this._indent);
            this._source.println("    {");
            indent2 = this._indent + "        ";
        }
        if (actions.size() == 0 && endStateName.length() > 0) {
            fqEndStateName = endStateName;
        } else if (actions.size() > 0) {
            if (loopbackFlag) {
                fqEndStateName = "endState";
                this._source.print(indent2);
                this._source.print(context);
                this._source.print("State& ");
                this._source.print(fqEndStateName);
                this._source.println(" = context.getState();");
                this._source.println();
            } else {
                fqEndStateName = endStateName;
            }
        }
        if (transType == SmcElement.TransType.TRANS_POP || !loopbackFlag) {
            if (this._debugLevel >= 1) {
                this._source.print(indent2);
                this._source.println("if (context.getDebugFlag() == true)");
                this._source.print(indent2);
                this._source.println("{");
                if (this._noStreamsFlag) {
                    this._source.print(indent2);
                    this._source.print("    TRACE(\"BEFORE EXIT     : ");
                    this._source.print(stateName);
                    this._source.println("::Exit(context)\\n\\r\");");
                } else {
                    this._source.print(indent2);
                    this._source.print("    std::ostream& str = ");
                    this._source.println("context.getDebugStream();");
                    this._source.println();
                    this._source.print(indent2);
                    this._source.print("    str << \"BEFORE EXIT     : ");
                    this._source.print(stateName);
                    this._source.println("::Exit(context)\"");
                    this._source.println("        << std::endl;");
                }
                this._source.print(indent2);
                this._source.println("}");
                this._source.println();
            }
            this._source.print(indent2);
            this._source.println("(context.getState()).Exit(context);");
            if (this._debugLevel >= 1) {
                this._source.print(indent2);
                this._source.println("if (context.getDebugFlag() == true)");
                this._source.print(indent2);
                this._source.println("{");
                if (this._noStreamsFlag) {
                    this._source.print(indent2);
                    this._source.print("    TRACE(\"AFTER EXIT      : ");
                    this._source.print(stateName);
                    this._source.println("::Exit(context)\\n\\r\");");
                } else {
                    this._source.print(indent2);
                    this._source.print("    std::ostream& str = ");
                    this._source.println("context.getDebugStream();");
                    this._source.println();
                    this._source.print(indent2);
                    this._source.print("    str << \"AFTER EXIT      : ");
                    this._source.print(stateName);
                    this._source.println("::Exit(context)\"");
                    this._source.println("            << std::endl;");
                }
                this._source.print(indent2);
                this._source.println("}");
                this._source.println();
            }
        }
        if (this._debugLevel >= 0) {
            transName = transition.getName();
            parameters = transition.getParameters();
            this._source.print(indent2);
            this._source.println("if (context.getDebugFlag() == true)");
            this._source.print(indent2);
            this._source.println("{");
            if (this._noStreamsFlag) {
                this._source.print(indent2);
                this._source.print("    TRACE(\"ENTER TRANSITION: ");
                this._source.print(stateName);
                this._source.print("::");
                this._source.print(transName);
                this._source.print("(");
                pit = parameters.iterator();
                sep = "";
                while (pit.hasNext()) {
                    this._source.print(sep);
                    ((SmcParameter)pit.next()).accept((SmcVisitor)this);
                    sep = ", ";
                }
                this._source.println(")\\n\\r\");");
            } else {
                this._source.print(indent2);
                this._source.print("    std::ostream& str = ");
                this._source.println("context.getDebugStream();");
                this._source.println();
                this._source.print(indent2);
                this._source.print("    str << \"ENTER TRANSITION: ");
                this._source.print(stateName);
                this._source.print("::");
                this._source.print(transName);
                this._source.print("(");
                pit = parameters.iterator();
                sep = "";
                while (pit.hasNext()) {
                    this._source.print(sep);
                    ((SmcParameter)pit.next()).accept((SmcVisitor)this);
                    sep = ", ";
                }
                this._source.println(")\"");
                this._source.print(indent2);
                this._source.println("        << std::endl;");
            }
            this._source.print(indent2);
            this._source.println("}");
            this._source.println();
        }
        if (actions.size() > 0) {
            this._source.print(indent2);
            this._source.println("context.clearState();");
        }
        if (actions.isEmpty()) {
            if (condition.length() > 0) {
                this._source.print(indent2);
                this._source.println("// No actions.");
            }
            indent3 = indent2;
        } else {
            if (!this._noCatchFlag) {
                this._source.print(indent2);
                this._source.println("try");
                this._source.print(indent2);
                this._source.println("{");
                indent3 = indent2 + "    ";
            } else {
                indent3 = indent2;
            }
            indent4 = this._indent;
            this._indent = indent3;
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
            this._indent = indent4;
        }
        if (this._debugLevel >= 0) {
            transName = transition.getName();
            parameters = transition.getParameters();
            indent3 = !this._noCatchFlag && !actions.isEmpty() ? indent2 + "    " : indent2;
            this._source.print(indent3);
            this._source.println("if (context.getDebugFlag() == true)");
            this._source.print(indent3);
            this._source.println("{");
            if (this._noStreamsFlag) {
                this._source.print(indent3);
                this._source.print("    TRACE(\"EXIT TRANSITION : ");
                this._source.print(stateName);
                this._source.print("::");
                this._source.print(transName);
                this._source.print("(");
                pit = parameters.iterator();
                sep = "";
                while (pit.hasNext()) {
                    this._source.print(sep);
                    ((SmcParameter)pit.next()).accept((SmcVisitor)this);
                    sep = ", ";
                }
                this._source.println(")\\n\\r\");");
            } else {
                this._source.print(indent3);
                this._source.print("    std::ostream& str = ");
                this._source.println("context.getDebugStream();");
                this._source.println();
                this._source.print(indent3);
                this._source.print("    str << \"EXIT TRANSITION : ");
                this._source.print(stateName);
                this._source.print("::");
                this._source.print(transName);
                this._source.print("(");
                pit = parameters.iterator();
                sep = "";
                while (pit.hasNext()) {
                    this._source.print(sep);
                    ((SmcParameter)pit.next()).accept((SmcVisitor)this);
                    sep = ", ";
                }
                this._source.println(")\"");
                this._source.print(indent3);
                this._source.println("        << std::endl;");
            }
            this._source.print(indent3);
            this._source.println("}");
            this._source.println();
        }
        if (!(transType != SmcElement.TransType.TRANS_SET || actions.size() <= 0 && loopbackFlag)) {
            this._source.print(indent3);
            this._source.print("context.setState(");
            this._source.print(fqEndStateName);
            this._source.println(");");
        } else if (transType == SmcElement.TransType.TRANS_PUSH) {
            if (!loopbackFlag || actions.size() > 0) {
                this._source.print(indent3);
                this._source.print("context.setState(");
                this._source.print(fqEndStateName);
                this._source.println(");");
            }
            if (!loopbackFlag) {
                if (this._debugLevel >= 1) {
                    this._source.println();
                    this._source.print(indent3);
                    this._source.println("if (context.getDebugFlag() == true)");
                    this._source.print(indent3);
                    this._source.println("{");
                    if (this._noStreamsFlag) {
                        this._source.print(indent3);
                        this._source.print("    TRACE(\"BEFORE ENTRY    : ");
                        this._source.print(stateName);
                        this._source.println("::Entry(context)\\n\\r\");");
                    } else {
                        this._source.print(indent3);
                        this._source.print("    std::ostream& str = ");
                        this._source.println("context.getDebugStream();");
                        this._source.println();
                        this._source.print(indent3);
                        this._source.print("    str << \"BEFORE ENTRY    : ");
                        this._source.print(stateName);
                        this._source.println("::Entry(context)\"");
                        this._source.println("        << std::endl;");
                    }
                    this._source.print(indent3);
                    this._source.println("}");
                }
                this._source.println();
                this._source.print(indent3);
                this._source.println("(context.getState()).Entry(context);");
                if (this._debugLevel >= 1) {
                    this._source.println();
                    this._source.print(indent3);
                    this._source.println("if (context.getDebugFlag() == true)");
                    this._source.print(indent3);
                    this._source.println("{");
                    if (this._noStreamsFlag) {
                        this._source.print(indent3);
                        this._source.print("    TRACE(\"AFTER ENTRY     : ");
                        this._source.print(stateName);
                        this._source.println("::Entry(context)\\n\\r\");");
                    } else {
                        this._source.print(indent3);
                        this._source.print("    std::ostream& str = ");
                        this._source.println("context.getDebugStream();");
                        this._source.println();
                        this._source.print(indent3);
                        this._source.print("    str << \"AFTER ENTRY     : ");
                        this._source.print(stateName);
                        this._source.println("::Entry(context)\"");
                        this._source.println("        << std::endl;");
                    }
                    this._source.print(indent3);
                    this._source.println("}");
                }
            }
            this._source.print(indent3);
            this._source.print("context.pushState(");
            this._source.print(pushStateName);
            this._source.println(");");
        } else if (transType == SmcElement.TransType.TRANS_POP) {
            this._source.print(indent3);
            this._source.println("context.popState();");
        }
        if (!actions.isEmpty() && !this._noCatchFlag) {
            this._source.print(indent2);
            this._source.println("}");
            this._source.print(indent2);
            this._source.println("catch (...)");
            this._source.print(indent2);
            this._source.println("{");
            if (transType == SmcElement.TransType.TRANS_SET) {
                this._source.print(indent3);
                this._source.print("context.setState(");
                this._source.print(fqEndStateName);
                this._source.println(");");
            } else if (transType == SmcElement.TransType.TRANS_PUSH) {
                this._source.print(indent3);
                this._source.print("context.setState(");
                this._source.print(fqEndStateName);
                this._source.println(");");
                if (!loopbackFlag) {
                    if (this._debugLevel >= 1) {
                        this._source.println();
                        this._source.print(indent3);
                        this._source.println("if (context.getDebugFlag() == true)");
                        this._source.print(indent3);
                        this._source.println("{");
                        if (this._noStreamsFlag) {
                            this._source.print(indent3);
                            this._source.print("    TRACE(\"BEFORE ENTRY    : ");
                            this._source.print(stateName);
                            this._source.println("::Entry(context)\\n\\r\");");
                        } else {
                            this._source.print(indent3);
                            this._source.print("    std::ostream& str = ");
                            this._source.println("context.getDebugStream();");
                            this._source.println();
                            this._source.print(indent2);
                            this._source.print("    str << \"BEFORE ENTRY    : ");
                            this._source.print(stateName);
                            this._source.println("::Entry(context)\"");
                            this._source.println("        << std::endl;");
                        }
                        this._source.print(indent3);
                        this._source.println("}");
                        this._source.println();
                    }
                    this._source.println();
                    this._source.print(indent3);
                    this._source.println("(context.getState()).Entry(context);");
                    if (this._debugLevel >= 1) {
                        this._source.print(indent3);
                        this._source.println("    if (context.getDebugFlag() == true)");
                        this._source.print(indent3);
                        this._source.println("    {");
                        if (this._noStreamsFlag) {
                            this._source.print(indent3);
                            this._source.print("        TRACE(\"AFTER ENTRY     : ");
                            this._source.print(stateName);
                            this._source.println("::Entry(context)\\n\\r\");");
                        } else {
                            this._source.print(indent3);
                            this._source.print("        std::ostream& str = ");
                            this._source.println("context.getDebugStream();");
                            this._source.println();
                            this._source.print(indent2);
                            this._source.print("        str << \"AFTER ENTRY     : ");
                            this._source.print(stateName);
                            this._source.println("::Entry(context)\"");
                            this._source.println("            << std::endl;");
                        }
                        this._source.print(indent3);
                        this._source.println("    }");
                        this._source.println();
                    }
                }
                this._source.print(indent3);
                this._source.print("context.pushState(");
                this._source.print(pushStateName);
                this._source.println(");");
            } else if (transType == SmcElement.TransType.TRANS_POP) {
                this._source.print(indent3);
                this._source.println("context.popState();");
            }
            if (!this._noExceptionFlag) {
                this._source.print(indent3);
                this._source.println("throw;");
                this._source.print(indent2);
            }
            this._source.println("}");
        }
        if (transType == SmcElement.TransType.TRANS_SET && !loopbackFlag || transType == SmcElement.TransType.TRANS_PUSH) {
            if (this._debugLevel >= 1) {
                this._source.print(indent2);
                this._source.println("if (context.getDebugFlag() == true)");
                this._source.print(indent2);
                this._source.println("{");
                if (this._noStreamsFlag) {
                    this._source.print(indent2);
                    this._source.print("    TRACE(\"BEFORE ENTRY    : ");
                    this._source.print(stateName);
                    this._source.println("::Entry(context)\\n\\r\");");
                } else {
                    this._source.print(indent2);
                    this._source.print("    std::ostream& str = ");
                    this._source.println("context.getDebugStream();");
                    this._source.println();
                    this._source.print(indent2);
                    this._source.print("    str << \"BEFORE ENTRY    : ");
                    this._source.print(stateName);
                    this._source.println("::Entry(context)\"");
                    this._source.println("        << std::endl;");
                }
                this._source.print(indent2);
                this._source.println("}");
            }
            this._source.print(indent2);
            this._source.println("(context.getState()).Entry(context);");
            if (this._debugLevel >= 1) {
                this._source.println();
                this._source.print(indent2);
                this._source.println("if (context.getDebugFlag() == true)");
                this._source.print(indent2);
                this._source.println("{");
                if (this._noStreamsFlag) {
                    this._source.print(indent2);
                    this._source.print("    TRACE(\"AFTER ENTRY     : ");
                    this._source.print(stateName);
                    this._source.println("::Entry(context)\\n\\r\");");
                } else {
                    this._source.print(indent2);
                    this._source.print("    std::ostream& str = ");
                    this._source.println("context.getDebugStream();");
                    this._source.println();
                    this._source.print(indent2);
                    this._source.print("    str << \"AFTER ENTRY     : ");
                    this._source.print(stateName);
                    this._source.println("::Entry(context)\"");
                    this._source.println("        << std::endl;");
                }
                this._source.print(indent2);
                this._source.println("}");
                this._source.println();
            }
        }
        if (transType == SmcElement.TransType.TRANS_POP && !endStateName.equals("nil") && endStateName.length() > 0) {
            String popArgs = guard.getPopArgs();
            this._source.print(indent2);
            this._source.print("context.");
            this._source.print(endStateName);
            this._source.print("(");
            if (popArgs.length() > 0) {
                this._source.print(popArgs);
            }
            this._source.println(");");
        }
        if (this._guardCount > 1) {
            this._source.print(this._indent);
            this._source.print("    }");
        }
    }

    public void visit(SmcAction action) {
        String name = action.getName();
        this._source.print(this._indent);
        if (action.isEmptyStateStack()) {
            this._source.println("context.emptyStateStack();");
        } else {
            if (!action.isStatic()) {
                this._source.print("ctxt.");
            }
            this._source.print(name);
            this._source.print('(');
            Iterator it = action.getArguments().iterator();
            String sep = "";
            while (it.hasNext()) {
                this._source.print(sep);
                this._source.print((String)it.next());
                sep = ", ";
            }
            this._source.println(");");
        }
    }

    public void visit(SmcParameter parameter) {
        this._source.print(parameter.getType());
        this._source.print(" ");
        this._source.print(parameter.getName());
    }
}

