/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.io.PrintStream;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcVisitor;

public abstract class SmcCodeGenerator
extends SmcVisitor {
    protected PrintStream _source;
    protected final String _srcfileBase;
    protected final String _srcDirectory;
    protected final String _headerDirectory;
    protected final String _castType;
    protected final int _graphLevel;
    protected String _indent;
    protected int _guardCount;
    protected int _guardIndex;
    protected final boolean _serialFlag;
    protected final int _debugLevel;
    protected final boolean _noExceptionFlag;
    protected final boolean _noCatchFlag;
    protected final boolean _noStreamsFlag;
    protected final boolean _reflectFlag;
    protected final boolean _syncFlag;
    protected final boolean _genericFlag;
    protected final String _accessLevel;
    private static String _suffix;
    public static final int NO_DEBUG_OUTPUT = -1;
    public static final int DEBUG_LEVEL_0 = 0;
    public static final int DEBUG_LEVEL_1 = 1;
    public static final int NO_GRAPH_LEVEL = -1;
    public static final int GRAPH_LEVEL_0 = 0;
    public static final int GRAPH_LEVEL_1 = 1;
    public static final int GRAPH_LEVEL_2 = 2;
    private static final String SOURCE_PATH_FORMAT = "{0}{1}.{2}";

    protected SmcCodeGenerator(SmcOptions options, String suffix) {
        this._srcfileBase = options.srcfileBase();
        this._srcDirectory = options.srcDirectory();
        this._headerDirectory = options.headerDirectory();
        this._castType = options.castType();
        this._graphLevel = options.graphLevel();
        this._serialFlag = options.serialFlag();
        this._debugLevel = options.debugLevel();
        this._noExceptionFlag = options.noExceptionFlag();
        this._noCatchFlag = options.noCatchFlag();
        this._noStreamsFlag = options.noStreamsFlag();
        this._reflectFlag = options.reflectFlag();
        this._syncFlag = options.syncFlag();
        this._genericFlag = options.genericFlag();
        this._accessLevel = options.accessLevel();
        _suffix = suffix;
        this._source = null;
        this._indent = "";
        this._guardCount = 0;
        this._guardIndex = 0;
    }

    public String sourceFile(String path, String basename, String suffix) {
        MessageFormat formatter = new MessageFormat(SOURCE_PATH_FORMAT);
        Object[] args = new Object[]{path, basename, suffix == null ? _suffix : suffix};
        return formatter.format(args);
    }

    protected boolean isLoopback(SmcElement.TransType transType, String endState) {
        return (transType == SmcElement.TransType.TRANS_SET || transType == SmcElement.TransType.TRANS_PUSH) && endState.equals("nil");
    }

    protected boolean allNilEndStates(List<SmcGuard> guards) {
        boolean retcode = true;
        Iterator<SmcGuard> git = guards.iterator();
        while (git.hasNext() && retcode) {
            SmcGuard guard = git.next();
            retcode = guard.getTransType() == SmcElement.TransType.TRANS_SET && guard.getEndState().equals("nil");
        }
        return retcode;
    }

    public void setSource(PrintStream source) {
        this._source = source;
    }

    public static String escape(String s) {
        String retval;
        if (s.indexOf(92) < 0 && s.indexOf(34) < 0) {
            retval = s;
        } else {
            StringBuffer buffer = new StringBuffer(s.length() * 2);
            int length = s.length();
            for (int index = 0; index < length; ++index) {
                char c = s.charAt(index);
                if (c == '\\' || c == '\"') {
                    buffer.append('\\');
                }
                buffer.append(c);
            }
            retval = buffer.toString();
        }
        return retval;
    }

    protected String scopeStateName(String stateName, String mapName) {
        StringWriter retval = new StringWriter();
        int index = stateName.indexOf("::");
        if (index < 0) {
            retval.write(mapName);
            retval.write(".");
            retval.write(stateName);
        } else {
            retval.write(stateName.substring(0, index));
            retval.write(46);
            retval.write(stateName.substring(index + 2));
        }
        return retval.toString();
    }
}

