/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.SmcVisitor;

public final class SmcCSharpGenerator
extends SmcCodeGenerator {
    public SmcCSharpGenerator(SmcOptions options) {
        super(options, "cs");
    }

    public void visit(SmcFSM fsm) {
        String separator;
        String transName;
        String indent2;
        String rawSource = fsm.getSource();
        String packageName = fsm.getPackage();
        String context = fsm.getContext();
        String fsmClassName = fsm.getFsmClassName();
        String startState = fsm.getStartState();
        String accessLevel = fsm.getAccessLevel();
        List maps = fsm.getMaps();
        if (accessLevel == null || accessLevel.length() == 0) {
            accessLevel = "public";
        }
        if (rawSource != null && rawSource.length() > 0) {
            this._source.println(rawSource);
            this._source.println();
        }
        this._source.println("using System;");
        if (this._debugLevel >= 0) {
            this._source.println("using System.Diagnostics;");
        }
        if (this._serialFlag) {
            this._source.println("using System.Runtime.Serialization;");
            this._source.println("using System.Security;");
            this._source.println("using System.Security.Permissions;");
        }
        if (this._reflectFlag) {
            if (this._genericFlag) {
                this._source.println("using System.Collections.Generic;");
            } else {
                this._source.println("using System.Collections;");
            }
        }
        this._source.println();
        for (String imp : fsm.getImports()) {
            this._source.print("using ");
            this._source.print(imp);
            this._source.println(";");
        }
        if (packageName != null && packageName.length() > 0) {
            this._source.print("namespace ");
            this._source.println(packageName);
            this._source.println("{");
            this._indent = "    ";
        }
        if (this._serialFlag) {
            this._source.print(this._indent);
            this._source.println("[Serializable]");
        }
        this._source.print(this._indent);
        this._source.print(accessLevel);
        this._source.print(" sealed class ");
        this._source.print(fsmClassName);
        this._source.println(" :");
        this._source.print(this._indent);
        this._source.print("    statemap.FSMContext");
        if (!this._serialFlag) {
            this._source.println();
        } else {
            this._source.println(',');
            this._source.print(this._indent);
            this._source.println("    ISerializable");
        }
        this._source.print(this._indent);
        this._source.println("{");
        this._source.print(this._indent);
        this._source.println("//---------------------------------------------------------------");
        this._source.print(this._indent);
        this._source.println("// Properties.");
        this._source.print(this._indent);
        this._source.println("//");
        this._source.println();
        this._source.print(this._indent);
        this._source.print("    public ");
        this._source.print(context);
        this._source.println("State State");
        this._source.print(this._indent);
        this._source.println("    {");
        this._source.print(this._indent);
        this._source.println("        get");
        this._source.print(this._indent);
        this._source.println("        {");
        if (this._syncFlag) {
            this._source.print(this._indent);
            this._source.println("            lock (this)");
            this._source.print(this._indent);
            this._source.println("            {");
            indent2 = this._indent + "                ";
        } else {
            indent2 = this._indent + "            ";
        }
        this._source.print(indent2);
        this._source.println("if (state_ == null)");
        this._source.print(indent2);
        this._source.println("{");
        this._source.print(indent2);
        this._source.println("    throw(");
        this._source.print(indent2);
        this._source.println("        new statemap.StateUndefinedException());");
        this._source.print(indent2);
        this._source.println("}");
        this._source.println();
        this._source.print(indent2);
        this._source.print("return ((");
        this._source.print(context);
        this._source.println("State) state_);");
        if (this._syncFlag) {
            this._source.print(this._indent);
            this._source.println("            }");
        }
        this._source.print(this._indent);
        this._source.println("        }");
        this._source.print(this._indent);
        this._source.println("        set");
        this._source.print(this._indent);
        this._source.println("        {");
        if (this._syncFlag) {
            this._source.print(this._indent);
            this._source.println("            lock (this)");
            this._source.print(this._indent);
            this._source.println("            {");
            indent2 = this._indent + "                ";
        } else {
            indent2 = this._indent + "            ";
        }
        this._source.print(indent2);
        this._source.println("SetState(value);");
        if (this._syncFlag) {
            this._source.print(this._indent);
            this._source.println("            }");
        }
        this._source.print(this._indent);
        this._source.println("        }");
        this._source.print(this._indent);
        this._source.println("    }");
        this._source.println();
        this._source.print(this._indent);
        this._source.print("    public ");
        this._source.print(context);
        this._source.println(" Owner");
        this._source.print(this._indent);
        this._source.println("    {");
        this._source.print(this._indent);
        this._source.println("        get");
        this._source.print(this._indent);
        this._source.println("        {");
        this._source.print(this._indent);
        this._source.println("            return (_owner);");
        this._source.print(this._indent);
        this._source.println("        }");
        this._source.print(this._indent);
        this._source.println("        set");
        this._source.print(this._indent);
        this._source.println("        {");
        if (this._syncFlag) {
            this._source.print(this._indent);
            this._source.println("            lock (this)");
            this._source.print(this._indent);
            this._source.println("            {");
            indent2 = this._indent + "                ";
        } else {
            indent2 = this._indent + "            ";
        }
        this._source.print(indent2);
        this._source.println("_owner = value;");
        if (this._syncFlag) {
            this._source.print(this._indent);
            this._source.println("            }");
        }
        this._source.print(this._indent);
        this._source.println("        }");
        this._source.print(this._indent);
        this._source.println("    }");
        this._source.println();
        if (this._reflectFlag) {
            this._source.print(this._indent);
            this._source.print("    public ");
            this._source.print(context);
            this._source.println("State[] States");
            this._source.print(this._indent);
            this._source.println("    {");
            this._source.print(this._indent);
            this._source.println("        get");
            this._source.print(this._indent);
            this._source.println("        {");
            this._source.print(this._indent);
            this._source.println("            return (_States);");
            this._source.print(this._indent);
            this._source.println("        }");
            this._source.print(this._indent);
            this._source.println("    }");
            this._source.println();
        }
        this._source.print(this._indent);
        this._source.println("//---------------------------------------------------------------");
        this._source.print(this._indent);
        this._source.println("// Member methods.");
        this._source.print(this._indent);
        this._source.println("//");
        this._source.println();
        int index = startState.indexOf("::");
        String csState = index >= 0 ? startState.substring(0, index) + "." + startState.substring(index + 2) : startState;
        this._source.print(this._indent);
        this._source.print("    public ");
        this._source.print(fsmClassName);
        this._source.print("(");
        this._source.print(context);
        this._source.println(" owner) :");
        this._source.print(this._indent);
        this._source.print("        base (");
        this._source.print(csState);
        this._source.println(")");
        this._source.print(this._indent);
        this._source.println("    {");
        this._source.println("        _owner = owner;");
        this._source.print(this._indent);
        this._source.println("    }");
        this._source.println();
        this._source.print(this._indent);
        this._source.println("    public override void EnterStartState()");
        this._source.print(this._indent);
        this._source.println("    {");
        this._source.print(this._indent);
        this._source.println("        State.Entry(this);");
        this._source.print(this._indent);
        this._source.println("        return;");
        this._source.print(this._indent);
        this._source.println("    }");
        this._source.println();
        if (this._serialFlag) {
            this._source.print(this._indent);
            this._source.print("    public ");
            this._source.print(fsmClassName);
            this._source.print("(SerializationInfo info, ");
            this._source.println("StreamingContext context) :");
            this._source.print(this._indent);
            this._source.println("        base ()");
            this._source.print(this._indent);
            this._source.println("    {");
            this._source.print(this._indent);
            this._source.println("        int stackSize;");
            this._source.print(this._indent);
            this._source.println("        int stateId;");
            this._source.println();
            this._source.print(this._indent);
            this._source.print("        stackSize = ");
            this._source.println("info.GetInt32(\"stackSize\");");
            this._source.print(this._indent);
            this._source.println("        if (stackSize > 0)");
            this._source.print(this._indent);
            this._source.println("        {");
            this._source.print(this._indent);
            this._source.println("            int index;");
            this._source.print(this._indent);
            this._source.println("            String name;");
            this._source.println();
            this._source.print(this._indent);
            this._source.print("            for (index = (stackSize - 1); ");
            this._source.println("index >= 0; --index)");
            this._source.print(this._indent);
            this._source.println("            {");
            this._source.print(this._indent);
            this._source.print("                ");
            this._source.println("name = \"stackIndex\" + index;");
            this._source.print(this._indent);
            this._source.print("                ");
            this._source.println("stateId = info.GetInt32(name);");
            this._source.print(this._indent);
            this._source.print("                ");
            this._source.println("PushState(_States[stateId]);");
            this._source.print(this._indent);
            this._source.println("            }");
            this._source.print(this._indent);
            this._source.println("        }");
            this._source.println();
            this._source.print(this._indent);
            this._source.println("        stateId = info.GetInt32(\"state\");");
            this._source.print(this._indent);
            this._source.println("        PushState(_States[stateId]);");
            this._source.print(this._indent);
            this._source.println("    }");
            this._source.println();
        }
        List transitions = fsm.getTransitions();
        for (SmcTransition trans : transitions) {
            transName = trans.getName();
            if (transName.equals("Default")) continue;
            this._source.print(this._indent);
            this._source.print("    public void ");
            this._source.print(transName);
            this._source.print("(");
            List params = trans.getParameters();
            Iterator pit = params.iterator();
            separator = "";
            while (pit.hasNext()) {
                this._source.print(separator);
                ((SmcParameter)pit.next()).accept((SmcVisitor)this);
                separator = ", ";
            }
            this._source.println(")");
            this._source.print(this._indent);
            this._source.println("    {");
            if (this._syncFlag) {
                this._source.print(this._indent);
                this._source.println("        lock (this)");
                this._source.print(this._indent);
                this._source.println("        {");
                indent2 = this._indent + "            ";
            } else {
                indent2 = this._indent + "        ";
            }
            this._source.print(indent2);
            this._source.print("transition_ = \"");
            this._source.print(transName);
            this._source.println("\";");
            this._source.print(indent2);
            this._source.print("State.");
            this._source.print(transName);
            this._source.print("(this");
            for (SmcParameter param : params) {
                this._source.print(", ");
                this.passParameter(param);
            }
            this._source.println(");");
            this._source.print(indent2);
            this._source.println("transition_ = \"\";");
            if (this._syncFlag) {
                this._source.print(this._indent);
                this._source.println("        }");
                this._source.println();
            }
            this._source.print(this._indent);
            this._source.println("        return;");
            this._source.print(this._indent);
            this._source.println("    }");
            this._source.println();
        }
        if (this._serialFlag) {
            this._source.print(this._indent);
            this._source.print("    public ");
            this._source.print(context);
            this._source.println("State valueOf(int stateId)");
            this._source.print(this._indent);
            this._source.println("    {");
            this._source.print(this._indent);
            this._source.println("        return(_States[stateId]);");
            this._source.print(this._indent);
            this._source.println("    }");
            this._source.println();
        }
        if (this._serialFlag) {
            this._source.print(this._indent);
            this._source.print("    [SecurityPermissionAttribute(");
            this._source.print("SecurityAction.Demand, ");
            this._source.println("SerializationFormatter=true)]");
            this._source.print(this._indent);
            this._source.print("    public void GetObjectData(");
            this._source.println("SerializationInfo info,");
            this._source.print(this._indent);
            this._source.print("                              ");
            this._source.println("StreamingContext context)");
            this._source.print(this._indent);
            this._source.println("    {");
            this._source.print(this._indent);
            this._source.println("        int stackSize = 0;");
            this._source.println();
            this._source.print(this._indent);
            this._source.println("        if (stateStack_ != null)");
            this._source.print(this._indent);
            this._source.println("        {");
            this._source.print(this._indent);
            this._source.println("            stackSize = stateStack_.Count;");
            this._source.print(this._indent);
            this._source.println("        }");
            this._source.println();
            this._source.print(this._indent);
            this._source.print("        ");
            this._source.println("info.AddValue(\"stackSize\", stackSize);");
            this._source.println();
            this._source.print(this._indent);
            this._source.println("        if (stackSize > 0)");
            this._source.print(this._indent);
            this._source.println("        {");
            this._source.print(this._indent);
            this._source.println("            int index = 0;");
            this._source.print(this._indent);
            this._source.println("            String name;");
            this._source.println();
            this._source.print(this._indent);
            this._source.print("            foreach (");
            this._source.print(context);
            this._source.println("State state in stateStack_)");
            this._source.print(this._indent);
            this._source.println("            {");
            this._source.print(this._indent);
            this._source.print("                ");
            this._source.println("name = \"stackIndex\" + index;");
            this._source.print(this._indent);
            this._source.print("                info.AddValue(");
            this._source.println("name, state.Id);");
            this._source.print(this._indent);
            this._source.println("                ++index;");
            this._source.print(this._indent);
            this._source.println("            }");
            this._source.print(this._indent);
            this._source.println("        }");
            this._source.println();
            this._source.print(this._indent);
            this._source.println("        info.AddValue(\"state\", state_.Id);");
            this._source.println();
            this._source.print(this._indent);
            this._source.println("        return;");
            this._source.print(this._indent);
            this._source.println("    }");
            this._source.println();
        }
        this._source.print(this._indent);
        this._source.println("//---------------------------------------------------------------");
        this._source.print(this._indent);
        this._source.println("// Member data.");
        this._source.print(this._indent);
        this._source.println("//");
        this._source.println();
        this._source.print(this._indent);
        this._source.println("    [NonSerialized]");
        this._source.print(this._indent);
        this._source.print("    private ");
        this._source.print(context);
        this._source.println(" _owner;");
        this._source.println();
        if (this._serialFlag || this._reflectFlag) {
            this._source.print(this._indent);
            this._source.println("    // Map state IDs to state objects.");
            this._source.print(this._indent);
            this._source.println("    // Used to deserialize an FSM.");
            this._source.print(this._indent);
            this._source.println("    [NonSerialized]");
            this._source.print(this._indent);
            this._source.print("    private static ");
            this._source.print(context);
            this._source.println("State[] _States =");
            this._source.print(this._indent);
            this._source.print("    {");
            separator = "";
            for (SmcMap map : maps) {
                String mapName = map.getName();
                for (SmcState state : map.getStates()) {
                    this._source.println(separator);
                    this._source.print(this._indent);
                    this._source.print("        ");
                    this._source.print(mapName);
                    this._source.print(".");
                    this._source.print(state.getClassName());
                    separator = ",";
                }
            }
            this._source.println();
            this._source.print(this._indent);
            this._source.println("    };");
            this._source.println();
        }
        this._source.print(this._indent);
        this._source.println("//---------------------------------------------------------------");
        this._source.print(this._indent);
        this._source.println("// Inner classes.");
        this._source.print(this._indent);
        this._source.println("//");
        this._source.println();
        this._source.print(this._indent);
        this._source.print("    public abstract class ");
        this._source.print(context);
        this._source.println("State :");
        this._source.print(this._indent);
        this._source.println("        statemap.State");
        this._source.print(this._indent);
        this._source.println("    {");
        if (this._reflectFlag) {
            this._source.print(this._indent);
            this._source.println("    //-----------------------------------------------------------");
            this._source.print(this._indent);
            this._source.println("    // Properties.");
            this._source.print(this._indent);
            this._source.println("    //");
            this._source.println();
            this._source.print(this._indent);
            this._source.print("        ");
            this._source.print("public abstract IDictionary");
            if (this._genericFlag) {
                this._source.print("<string, int>");
            }
            this._source.println(" Transitions");
            this._source.print(this._indent);
            this._source.println("        {");
            this._source.print(this._indent);
            this._source.println("            get;");
            this._source.print(this._indent);
            this._source.println("        }");
            this._source.println();
        }
        this._source.print(this._indent);
        this._source.println("    //-----------------------------------------------------------");
        this._source.print(this._indent);
        this._source.println("    // Member methods.");
        this._source.print(this._indent);
        this._source.println("    //");
        this._source.println();
        this._source.print(this._indent);
        this._source.print("        internal ");
        this._source.print(context);
        this._source.println("State(string name, int id) :");
        this._source.print(this._indent);
        this._source.println("            base (name, id)");
        this._source.print(this._indent);
        this._source.println("        {}");
        this._source.println();
        this._source.print(this._indent);
        this._source.print("        protected internal virtual void Entry(");
        this._source.print(fsmClassName);
        this._source.println(" context)");
        this._source.print(this._indent);
        this._source.println("        {}");
        this._source.println();
        this._source.print(this._indent);
        this._source.print("        protected internal virtual void Exit(");
        this._source.print(fsmClassName);
        this._source.println(" context)");
        this._source.print(this._indent);
        this._source.println("        {}");
        this._source.println();
        for (SmcTransition trans : transitions) {
            transName = trans.getName();
            if (transName.equals("Default")) continue;
            this._source.print(this._indent);
            this._source.print("        protected internal virtual void ");
            this._source.print(transName);
            this._source.print("(");
            this._source.print(fsmClassName);
            this._source.print(" context");
            for (SmcParameter param : trans.getParameters()) {
                this._source.print(", ");
                param.accept((SmcVisitor)this);
            }
            this._source.println(")");
            this._source.print(this._indent);
            this._source.println("        {");
            this._source.print(this._indent);
            this._source.println("            Default(context);");
            this._source.print(this._indent);
            this._source.println("        }");
            this._source.println();
        }
        this._source.print(this._indent);
        this._source.print("        protected internal virtual void Default(");
        this._source.print(fsmClassName);
        this._source.println(" context)");
        this._source.print(this._indent);
        this._source.println("        {");
        if (this._debugLevel >= 0) {
            this._source.println("#if TRACE");
            this._source.print(this._indent);
            this._source.println("            Trace.WriteLine(");
            this._source.print(this._indent);
            this._source.print("                \"TRANSITION : Default\"");
            this._source.println(");");
            this._source.println("#endif");
        }
        this._source.print(this._indent);
        this._source.println("            throw (");
        this._source.print(this._indent);
        this._source.print("                ");
        this._source.println("new statemap.TransitionUndefinedException(");
        this._source.print(this._indent);
        this._source.println("                    \"State: \" +");
        this._source.print(this._indent);
        this._source.println("                    context.State.Name +");
        this._source.print(this._indent);
        this._source.println("                    \", Transition: \" +");
        this._source.print(this._indent);
        this._source.println("                    context.GetTransition()));");
        this._source.print(this._indent);
        this._source.println("        }");
        this._source.print(this._indent);
        this._source.println("    }");
        for (SmcMap map : maps) {
            map.accept((SmcVisitor)this);
        }
        this._source.print(this._indent);
        this._source.println("}");
        this._source.println();
        if (packageName != null && packageName.length() > 0) {
            this._source.println("}");
        }
    }

    public void visit(SmcMap map) {
        SmcState defaultState = map.getDefaultState();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        List states = map.getStates();
        ArrayList definedDefaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList();
        this._source.println();
        this._source.print(this._indent);
        this._source.print("    internal abstract class ");
        this._source.println(mapName);
        this._source.print(this._indent);
        this._source.println("    {");
        this._source.print(this._indent);
        this._source.println("    //-----------------------------------------------------------");
        this._source.print(this._indent);
        this._source.println("    // Member methods.");
        this._source.print(this._indent);
        this._source.println("    //");
        this._source.println();
        this._source.print(this._indent);
        this._source.println("    //-----------------------------------------------------------");
        this._source.print(this._indent);
        this._source.println("    // Member data.");
        this._source.print(this._indent);
        this._source.println("    //");
        this._source.println();
        this._source.print(this._indent);
        this._source.println("        //-------------------------------------------------------");
        this._source.print(this._indent);
        this._source.println("        // Statics.");
        this._source.print(this._indent);
        this._source.println("        //");
        for (SmcState state : states) {
            this._source.print(this._indent);
            this._source.println("        [NonSerialized]");
            this._source.print(this._indent);
            this._source.print("        internal static readonly ");
            this._source.print(mapName);
            this._source.print("_Default.");
            this._source.print(mapName);
            this._source.print('_');
            this._source.print(state.getClassName());
            this._source.print(' ');
            this._source.print(state.getInstanceName());
            this._source.println(" =");
            this._source.print(this._indent);
            this._source.print("            new ");
            this._source.print(mapName);
            this._source.print("_Default.");
            this._source.print(mapName);
            this._source.print("_");
            this._source.print(state.getClassName());
            this._source.print("(\"");
            this._source.print(mapName);
            this._source.print(".");
            this._source.print(state.getClassName());
            this._source.print("\", ");
            this._source.print(map.getNextStateId());
            this._source.println(");");
        }
        this._source.print(this._indent);
        this._source.println("        [NonSerialized]");
        this._source.print(this._indent);
        this._source.print("        private static readonly ");
        this._source.print(mapName);
        this._source.println("_Default Default =");
        this._source.print(this._indent);
        this._source.print("            new ");
        this._source.print(mapName);
        this._source.print("_Default(\"");
        this._source.print(mapName);
        this._source.println(".Default\", -1);");
        this._source.println();
        this._source.print(this._indent);
        this._source.println("    }");
        this._source.println();
        this._source.print(this._indent);
        this._source.print("    internal class ");
        this._source.print(mapName);
        this._source.println("_Default :");
        this._source.print(this._indent);
        this._source.print("        ");
        this._source.print(context);
        this._source.println("State");
        this._source.print(this._indent);
        this._source.println("    {");
        if (this._reflectFlag) {
            this._source.print(this._indent);
            this._source.println("    //-----------------------------------------------------------");
            this._source.print(this._indent);
            this._source.println("    // Properties.");
            this._source.print(this._indent);
            this._source.println("    //");
            this._source.println();
            this._source.print(this._indent);
            this._source.print("        ");
            this._source.print("public override IDictionary");
            if (this._genericFlag) {
                this._source.print("<string, int>");
            }
            this._source.println(" Transitions");
            this._source.print(this._indent);
            this._source.println("        {");
            this._source.print(this._indent);
            this._source.println("            get");
            this._source.print(this._indent);
            this._source.println("            {");
            this._source.print(this._indent);
            this._source.println("                return (_transitions);");
            this._source.print(this._indent);
            this._source.println("            }");
            this._source.print(this._indent);
            this._source.println("        }");
            this._source.println();
        }
        this._source.print(this._indent);
        this._source.println("    //-----------------------------------------------------------");
        this._source.print(this._indent);
        this._source.println("    // Member methods.");
        this._source.print(this._indent);
        this._source.println("    //");
        this._source.println();
        this._source.print(this._indent);
        this._source.print("        internal ");
        this._source.print(mapName);
        this._source.println("_Default(string name, int id) :");
        this._source.print(this._indent);
        this._source.println("            base (name, id)");
        this._source.print(this._indent);
        this._source.println("        {}");
        String indent2 = this._indent;
        this._indent = this._indent + "        ";
        for (SmcTransition trans : definedDefaultTransitions) {
            trans.accept((SmcVisitor)this);
        }
        this._indent = indent2;
        this._source.println();
        this._source.print(this._indent);
        this._source.println("    //-----------------------------------------------------------");
        this._source.print(this._indent);
        this._source.println("    // Inner classes.");
        this._source.print(this._indent);
        this._source.println("    //");
        for (SmcState state : states) {
            state.accept((SmcVisitor)this);
        }
        if (this._reflectFlag) {
            List allTransitions = map.getFSM().getTransitions();
            this._source.println();
            this._source.print(this._indent);
            this._source.println("    //-----------------------------------------------------------");
            this._source.print(this._indent);
            this._source.println("    // Member data.");
            this._source.print(this._indent);
            this._source.println("    //");
            this._source.println();
            this._source.print(this._indent);
            this._source.println("        //-------------------------------------------------------");
            this._source.print(this._indent);
            this._source.println("        // Statics.");
            this._source.print(this._indent);
            this._source.println("        //");
            this._source.print(this._indent);
            this._source.print("        ");
            this._source.print("private static IDictionary");
            if (this._genericFlag) {
                this._source.print("<string, int>");
            }
            this._source.println(" _transitions;");
            this._source.println();
            this._source.print(this._indent);
            this._source.print("        static ");
            this._source.print(mapName);
            this._source.println("_Default()");
            this._source.print(this._indent);
            this._source.println("        {");
            this._source.print(this._indent);
            this._source.print("            ");
            this._source.print("_transitions = new ");
            if (this._genericFlag) {
                this._source.print("Dictionary<string, int>");
            } else {
                this._source.print("Hashtable");
            }
            this._source.println("();");
            for (SmcTransition transition : allTransitions) {
                String transName = transition.getName();
                transName = transName + "(";
                List parameters = transition.getParameters();
                for (int i = 0; i < parameters.size(); ++i) {
                    SmcParameter singleParam = (SmcParameter)parameters.get(i);
                    transName = transName + singleParam.getType() + " " + singleParam.getName();
                    if (i >= parameters.size() - 1) continue;
                    transName = transName + ", ";
                }
                transName = transName + ")";
                int transDefinition = definedDefaultTransitions.contains(transition) ? 2 : 0;
                this._source.print("            ");
                this._source.print("_transitions.Add(\"");
                this._source.print(transName);
                this._source.print("\", ");
                this._source.print(transDefinition);
                this._source.println(");");
            }
            this._source.print(this._indent);
            this._source.println("        }");
        }
        this._source.print(this._indent);
        this._source.println("    }");
    }

    public void visit(SmcState state) {
        String indent2;
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String fsmClassName = map.getFSM().getFsmClassName();
        String mapName = map.getName();
        String stateName = state.getClassName();
        this._source.println();
        this._source.print(this._indent);
        this._source.print("        internal class ");
        this._source.print(mapName);
        this._source.print("_");
        this._source.print(stateName);
        this._source.println(" :");
        this._source.print(this._indent);
        this._source.print("            ");
        this._source.print(mapName);
        this._source.println("_Default");
        this._source.print(this._indent);
        this._source.println("        {");
        if (this._reflectFlag) {
            this._source.print(this._indent);
            this._source.println("        //-------------------------------------------------------");
            this._source.print(this._indent);
            this._source.println("        // Properties.");
            this._source.print(this._indent);
            this._source.println("        //");
            this._source.println();
            this._source.print(this._indent);
            this._source.print("            ");
            this._source.print("public override IDictionary");
            if (this._genericFlag) {
                this._source.print("<string, int>");
            }
            this._source.println(" Transitions");
            this._source.print(this._indent);
            this._source.println("            {");
            this._source.print(this._indent);
            this._source.println("                get");
            this._source.print(this._indent);
            this._source.println("                {");
            this._source.print(this._indent);
            this._source.println("                    return (_transitions);");
            this._source.print(this._indent);
            this._source.println("                }");
            this._source.print(this._indent);
            this._source.println("            }");
            this._source.println();
        }
        this._source.print(this._indent);
        this._source.println("        //-------------------------------------------------------");
        this._source.print(this._indent);
        this._source.println("        // Member methods.");
        this._source.print(this._indent);
        this._source.println("        //");
        this._source.println();
        this._source.print(this._indent);
        this._source.print("            internal ");
        this._source.print(mapName);
        this._source.print("_");
        this._source.print(stateName);
        this._source.println("(string name, int id) :");
        this._source.print(this._indent);
        this._source.println("                base (name, id)");
        this._source.print(this._indent);
        this._source.println("            {}");
        List actions = state.getEntryActions();
        if (actions != null && !actions.isEmpty()) {
            this._source.println();
            this._source.print(this._indent);
            this._source.print("            ");
            this._source.print("protected internal override void Entry(");
            this._source.print(fsmClassName);
            this._source.println(" context)");
            this._source.print(this._indent);
            this._source.println("            {");
            this._source.print(this._indent);
            this._source.print("                ");
            this._source.print(context);
            this._source.println(" ctxt = context.Owner;");
            this._source.println();
            indent2 = this._indent;
            this._indent = this._indent + "                ";
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
            this._indent = indent2;
            this._source.print(this._indent);
            this._source.println("                return;");
            this._source.print(this._indent);
            this._source.println("            }");
        }
        if ((actions = state.getExitActions()) != null && !actions.isEmpty()) {
            this._source.println();
            this._source.print(this._indent);
            this._source.print("            ");
            this._source.print("protected internal override void Exit(");
            this._source.print(fsmClassName);
            this._source.println(" context)");
            this._source.print(this._indent);
            this._source.println("            {");
            this._source.print(this._indent);
            this._source.print("                ");
            this._source.print(context);
            this._source.println(" ctxt = context.Owner;");
            this._source.println();
            indent2 = this._indent;
            this._indent = this._indent + "                ";
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
            this._source.print(this._indent);
            this._source.println("                return;");
            this._source.print(this._indent);
            this._source.println("            }");
        }
        indent2 = this._indent;
        this._indent = this._indent + "            ";
        for (SmcTransition trans : state.getTransitions()) {
            trans.accept((SmcVisitor)this);
        }
        this._indent = indent2;
        if (this._reflectFlag) {
            List allTransitions = map.getFSM().getTransitions();
            List stateTransitions = state.getTransitions();
            SmcState defaultState = map.getDefaultState();
            ArrayList defaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList();
            this._source.println();
            this._source.print(this._indent);
            this._source.println("        //-------------------------------------------------------");
            this._source.print(this._indent);
            this._source.println("        // Member data.");
            this._source.print(this._indent);
            this._source.println("        //");
            this._source.println();
            this._source.print(this._indent);
            this._source.println("            //---------------------------------------------------");
            this._source.print(this._indent);
            this._source.println("            // Statics.");
            this._source.print(this._indent);
            this._source.println("            //");
            this._source.print(this._indent);
            this._source.print("            ");
            this._source.print("new private static IDictionary");
            if (this._genericFlag) {
                this._source.print("<string, int>");
            }
            this._source.println(" _transitions;");
            this._source.println();
            this._source.print(this._indent);
            this._source.print("            static ");
            this._source.print(mapName);
            this._source.print("_");
            this._source.print(stateName);
            this._source.println("()");
            this._source.print(this._indent);
            this._source.println("            {");
            this._source.print(this._indent);
            this._source.print("                ");
            this._source.print("_transitions = new ");
            if (this._genericFlag) {
                this._source.print("Dictionary<string, int>");
            } else {
                this._source.print("Hashtable");
            }
            this._source.println("();");
            for (SmcTransition transition : allTransitions) {
                String transName = transition.getName();
                transName = transName + "(";
                List parameters = transition.getParameters();
                for (int i = 0; i < parameters.size(); ++i) {
                    SmcParameter singleParam = (SmcParameter)parameters.get(i);
                    transName = transName + singleParam.getType() + " " + singleParam.getName();
                    if (i >= parameters.size() - 1) continue;
                    transName = transName + ", ";
                }
                transName = transName + ")";
                int transDefinition = stateTransitions.contains(transition) ? 1 : (defaultTransitions.contains(transition) ? 2 : 0);
                this._source.print("                ");
                this._source.print("_transitions.Add(\"");
                this._source.print(transName);
                this._source.print("\", ");
                this._source.print(transDefinition);
                this._source.println(");");
            }
            this._source.print(this._indent);
            this._source.println("            }");
        }
        this._source.print(this._indent);
        this._source.println("        }");
    }

    public void visit(SmcTransition transition) {
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String fsmClassName = map.getFSM().getFsmClassName();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        List parameters = transition.getParameters();
        List guards = transition.getGuards();
        boolean nullCondition = false;
        this._source.println();
        this._source.print(this._indent);
        this._source.print("protected internal override void ");
        this._source.print(transName);
        this._source.print("(");
        this._source.print(fsmClassName);
        this._source.print(" context");
        for (SmcParameter param : parameters) {
            this._source.print(", ");
            param.accept((SmcVisitor)this);
        }
        this._source.println(")");
        this._source.print(this._indent);
        this._source.println("{");
        if (transition.hasCtxtReference()) {
            this._source.println();
            this._source.print(this._indent);
            this._source.print("    ");
            this._source.print(context);
            this._source.println(" ctxt = context.Owner;");
            this._source.println();
        }
        if (this._debugLevel >= 0) {
            this._source.println();
            this._source.println("#if TRACE");
            this._source.print(this._indent);
            this._source.println("    Trace.WriteLine(");
            this._source.print(this._indent);
            this._source.print("        \"LEAVING STATE   : ");
            this._source.print(mapName);
            this._source.print('.');
            this._source.print(stateName);
            this._source.println("\");");
            this._source.println("#endif");
            this._source.println();
        }
        this._guardIndex = 0;
        this._guardCount = guards.size();
        for (SmcGuard guard : guards) {
            if (guard.getCondition().length() == 0) {
                nullCondition = true;
            }
            guard.accept((SmcVisitor)this);
            ++this._guardIndex;
        }
        if (this._guardIndex > 0 && !nullCondition) {
            if (this._guardCount == 1) {
                this._source.print(this._indent);
                this._source.println("}");
            }
            this._source.print(this._indent);
            this._source.print("    else");
            this._source.print(this._indent);
            this._source.println("    {");
            this._source.print(this._indent);
            this._source.print("        base.");
            this._source.print(transName);
            this._source.print("(context");
            for (SmcParameter param : parameters) {
                this._source.print(", ");
                this.passParameter(param);
            }
            this._source.println(");");
            this._source.print(this._indent);
            this._source.println("    }");
            this._source.println();
        } else if (this._guardCount > 1) {
            this._source.println();
            this._source.println();
        }
        this._source.print(this._indent);
        this._source.println("    return;");
        this._source.print(this._indent);
        this._source.println("}");
    }

    public void visit(SmcGuard guard) {
        String indent3;
        List parameters;
        String indent2;
        boolean hasActions;
        SmcTransition transition = guard.getTransition();
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        SmcElement.TransType transType = guard.getTransType();
        boolean loopbackFlag = false;
        String endStateName = guard.getEndState();
        String fqEndStateName = "";
        String pushStateName = guard.getPushState();
        String condition = guard.getCondition();
        List actions = guard.getActions();
        boolean bl = hasActions = !actions.isEmpty();
        if (transType != SmcElement.TransType.TRANS_POP && endStateName.length() > 0 && !endStateName.equals("nil")) {
            endStateName = this.scopeStateName(endStateName, mapName);
        }
        stateName = this.scopeStateName(stateName, mapName);
        pushStateName = this.scopeStateName(pushStateName, mapName);
        loopbackFlag = this.isLoopback(transType, endStateName);
        if (this._guardCount > 1) {
            indent2 = this._indent + "        ";
            if (this._guardIndex == 0 && condition.length() > 0) {
                this._source.print(this._indent);
                this._source.print("    if (");
                this._source.print(condition);
                this._source.println(")");
                this._source.print(this._indent);
                this._source.println("    {");
            } else if (condition.length() > 0) {
                this._source.println();
                this._source.print(this._indent);
                this._source.print("    else if (");
                this._source.print(condition);
                this._source.println(")");
                this._source.print(this._indent);
                this._source.println("    {");
            } else {
                this._source.println();
                this._source.print(this._indent);
                this._source.println("    else");
                this._source.print(this._indent);
                this._source.println("    {");
            }
        } else if (condition.length() == 0) {
            indent2 = this._indent + "    ";
        } else {
            indent2 = this._indent + "        ";
            this._source.print(this._indent);
            this._source.print("    if (");
            this._source.print(condition);
            this._source.println(")");
            this._source.print(this._indent);
            this._source.println("    {");
        }
        if (!hasActions && endStateName.length() != 0) {
            fqEndStateName = endStateName;
        } else if (hasActions) {
            if (loopbackFlag) {
                fqEndStateName = "endState";
                this._source.print(indent2);
                this._source.print(context);
                this._source.print("State ");
                this._source.print(fqEndStateName);
                this._source.println(" = context.State;");
            } else {
                fqEndStateName = endStateName;
            }
        }
        this._source.println();
        if (transType == SmcElement.TransType.TRANS_POP || !loopbackFlag) {
            if (this._debugLevel >= 1) {
                this._source.println("#if TRACE");
                this._source.print(indent2);
                this._source.println("Trace.WriteLine(");
                this._source.print(indent2);
                this._source.print("    \"BEFORE EXIT     : ");
                this._source.print(stateName);
                this._source.println(".Exit(context)\");");
                this._source.println("#endif");
                this._source.println();
            }
            this._source.print(indent2);
            this._source.println("context.State.Exit(context);");
            if (this._debugLevel >= 1) {
                this._source.println("#if TRACE");
                this._source.print(indent2);
                this._source.println("Trace.WriteLine(");
                this._source.print(indent2);
                this._source.print("    \"AFTER EXIT      : ");
                this._source.print(stateName);
                this._source.println(".Exit(context)\");");
                this._source.println("#endif");
                this._source.println();
            }
        }
        if (this._debugLevel >= 0) {
            parameters = transition.getParameters();
            this._source.println("#if TRACE");
            this._source.print(indent2);
            this._source.println("Trace.WriteLine(");
            this._source.print(indent2);
            this._source.print("    \"ENTER TRANSITION: ");
            this._source.print(mapName);
            this._source.print('.');
            this._source.print(stateName);
            this._source.print(".");
            this._source.print(transName);
            this._source.print("(");
            for (SmcParameter param : parameters) {
                this._source.print(", ");
                param.accept((SmcVisitor)this);
            }
            this._source.print(")");
            this._source.println("\");");
            this._source.println("#endif");
            this._source.println();
        }
        if (!hasActions) {
            if (condition.length() > 0) {
                this._source.print(indent2);
                this._source.println("// No actions.");
            }
            indent3 = indent2;
        } else {
            this._source.print(indent2);
            this._source.println("context.ClearState();");
            if (!this._noCatchFlag) {
                this._source.println();
                this._source.print(indent2);
                this._source.println("try");
                this._source.print(indent2);
                this._source.println("{");
                indent3 = indent2 + "    ";
            } else {
                indent3 = indent2;
            }
            String indent4 = this._indent;
            this._indent = indent3;
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
            this._indent = indent4;
            if (!this._noCatchFlag) {
                this._source.print(indent2);
                this._source.println("}");
                this._source.print(indent2);
                this._source.println("finally");
                this._source.print(indent2);
                this._source.println("{");
            }
        }
        if (this._debugLevel >= 0) {
            parameters = transition.getParameters();
            this._source.println("#if TRACE");
            this._source.print(indent3);
            this._source.println("Trace.WriteLine(");
            this._source.print(indent3);
            this._source.print("    \"EXIT TRANSITION : ");
            this._source.print(mapName);
            this._source.print('.');
            this._source.print(stateName);
            this._source.print(".");
            this._source.print(transName);
            this._source.print("(");
            for (SmcParameter param : parameters) {
                this._source.print(", ");
                param.accept((SmcVisitor)this);
            }
            this._source.print(")");
            this._source.println("\");");
            this._source.println("#endif");
            this._source.println();
        }
        if (transType == SmcElement.TransType.TRANS_SET && (hasActions || !loopbackFlag)) {
            this._source.print(indent3);
            this._source.print("context.State = ");
            this._source.print(fqEndStateName);
            this._source.println(";");
        } else if (transType == SmcElement.TransType.TRANS_PUSH) {
            if (!(loopbackFlag && !hasActions || fqEndStateName.equals("nil"))) {
                this._source.print(indent3);
                this._source.print("context.State = ");
                this._source.print(fqEndStateName);
                this._source.println(";");
            }
            if (!loopbackFlag) {
                if (this._debugLevel >= 1) {
                    this._source.println("#if TRACE");
                    this._source.print(indent3);
                    this._source.println("Trace.WriteLine(");
                    this._source.print(indent3);
                    this._source.print("    \"BEFORE ENTRY    : ");
                    this._source.print(mapName);
                    this._source.print('.');
                    this._source.print(stateName);
                    this._source.println(".Exit(context)\");");
                    this._source.println("#endif");
                    this._source.println();
                }
                this._source.print(indent3);
                this._source.println("context.State.Entry(context);");
                if (this._debugLevel >= 1) {
                    this._source.println("#if TRACE");
                    this._source.print(indent3);
                    this._source.println("Trace.WriteLine(");
                    this._source.print(indent3);
                    this._source.print("    \"AFTER ENTRY     : ");
                    this._source.print(mapName);
                    this._source.print('.');
                    this._source.print(stateName);
                    this._source.println(".Exit(context)\");");
                    this._source.println("#endif");
                    this._source.println();
                }
            }
            this._source.print(indent3);
            this._source.print("context.PushState(");
            this._source.print(pushStateName);
            this._source.println(");");
        } else if (transType == SmcElement.TransType.TRANS_POP) {
            this._source.print(indent3);
            this._source.println("context.PopState();");
        }
        if (transType == SmcElement.TransType.TRANS_SET && !loopbackFlag || transType == SmcElement.TransType.TRANS_PUSH) {
            if (this._debugLevel >= 1) {
                this._source.println("#if TRACE");
                this._source.print(indent3);
                this._source.println("Trace.WriteLine(");
                this._source.print(indent3);
                this._source.print("    \"BEFORE ENTRY    : ");
                this._source.print(mapName);
                this._source.print('.');
                this._source.print(stateName);
                this._source.println(".Exit(context)\");");
                this._source.println("#endif");
                this._source.println();
            }
            this._source.print(indent3);
            this._source.println("context.State.Entry(context);");
            if (this._debugLevel >= 1) {
                this._source.println("#if TRACE");
                this._source.print(indent3);
                this._source.println("Trace.WriteLine(");
                this._source.print(indent3);
                this._source.print("    \"AFTER ENTRY     : ");
                this._source.print(mapName);
                this._source.print('.');
                this._source.print(stateName);
                this._source.println(".Exit(context)\");");
                this._source.println("#endif");
                this._source.println();
            }
        }
        if (hasActions && !this._noCatchFlag) {
            this._source.print(indent2);
            this._source.println("}");
            this._source.println();
        }
        if (transType == SmcElement.TransType.TRANS_POP && !endStateName.equals("nil") && endStateName.length() > 0) {
            String popArgs = guard.getPopArgs();
            this._source.println();
            this._source.print(indent2);
            this._source.print("context.");
            this._source.print(endStateName);
            this._source.print("(");
            if (popArgs.length() > 0) {
                this._source.print(popArgs);
            }
            this._source.println(");");
        }
        if (this._guardCount > 1) {
            this._source.print(this._indent);
            this._source.print("    }");
        }
    }

    public void visit(SmcAction action) {
        String name = action.getName();
        List arguments = action.getArguments();
        this._source.print(this._indent);
        if (action.isEmptyStateStack()) {
            this._source.println("context.EmptyStateStack();");
        } else {
            if (!action.isStatic()) {
                this._source.print("ctxt.");
            }
            this._source.print(name);
            if (action.isProperty()) {
                String arg = (String)arguments.get(0);
                this._source.print(" = ");
                this._source.print(arg);
                this._source.println(";");
            } else {
                this._source.print("(");
                Iterator it = arguments.iterator();
                String sep = "";
                while (it.hasNext()) {
                    this._source.print(sep);
                    this._source.print((String)it.next());
                    sep = ", ";
                }
                this._source.println(");");
            }
        }
    }

    public void visit(SmcParameter parameter) {
        this._source.print(parameter.getType());
        this._source.print(" ");
        this._source.print(parameter.getName());
    }

    private void passParameter(SmcParameter param) {
        String paramType = param.getType().trim();
        if (paramType.startsWith("ref ")) {
            this._source.print("ref ");
        } else if (paramType.startsWith("out ")) {
            this._source.print("out ");
        }
        this._source.print(param.getName());
    }
}

