/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.SmcVisitor;

public final class SmcCGenerator
extends SmcCodeGenerator {
    private String _context;

    public SmcCGenerator(SmcOptions options) {
        super(options, "c");
    }

    public void visit(SmcFSM fsm) {
        List params;
        String packageName = fsm.getPackage();
        String rawSource = fsm.getSource();
        String context = fsm.getContext();
        String fsmClassName = fsm.getFsmClassName();
        String startStateName = fsm.getStartState();
        boolean packageDepth = false;
        this._source.println("/*");
        this._source.println(" * ex: set ro:");
        this._source.println(" * DO NOT EDIT.");
        this._source.println(" * generated by smc (http://smc.sourceforge.net/)");
        this._source.print(" * from file : ");
        this._source.print(this._srcfileBase);
        this._source.println(".sm");
        this._source.println(" */");
        this._source.println();
        if (packageName != null && packageName.length() > 0) {
            context = packageName + "_" + context;
            startStateName = packageName + "_" + startStateName;
        }
        if (rawSource != null && rawSource.length() > 0) {
            this._source.println(rawSource);
            this._source.println();
        }
        this._source.println("#include <assert.h>");
        for (String include : fsm.getIncludes()) {
            this._source.print("#include ");
            this._source.println(include);
        }
        this._source.print("#include \"");
        if (this._srcDirectory == null && this._headerDirectory != null || this._srcDirectory != null && this._headerDirectory != null && !this._srcDirectory.equals(this._headerDirectory)) {
            this._source.print(this._headerDirectory);
        } else if (this._srcDirectory != null) {
            this._source.print(this._srcDirectory);
        }
        this._source.print(this._srcfileBase);
        this._source.println(".h\"");
        List transList = fsm.getTransitions();
        this._source.println();
        this._source.println("#define getOwner(fsm) \\");
        this._source.println("    (fsm)->_owner");
        this._source.println();
        this._source.println("#define POPULATE_STATE(state) \\");
        if (fsm.hasEntryActions()) {
            this._source.println("    state##_Entry, \\");
        }
        if (fsm.hasExitActions()) {
            this._source.println("    state##_Exit, \\");
        }
        for (SmcTransition trans : transList) {
            if (trans.getName().equals("Default")) continue;
            this._source.print("    state##_");
            this._source.print(trans.getName());
            this._source.println(", \\");
        }
        this._source.println("    state##_Default");
        this._source.println();
        if (fsm.hasEntryActions()) {
            this._source.println("#define ENTRY_STATE(state) \\");
            this._source.println("    if ((state)->Entry != NULL) { \\");
            this._source.println("        (state)->Entry(fsm); \\");
            this._source.println("    }");
        } else {
            this._source.println("#define ENTRY_STATE(state)");
        }
        this._source.println();
        if (fsm.hasExitActions()) {
            this._source.println("#define EXIT_STATE(state) \\");
            this._source.println("    if ((state)->Exit != NULL) { \\");
            this._source.println("        (state)->Exit(fsm); \\");
            this._source.println("    }");
        } else {
            this._source.println("#define EXIT_STATE(state)");
        }
        for (SmcTransition trans : transList) {
            if (trans.getName().equals("Default")) continue;
            this._source.println();
            this._source.print("static void ");
            this._source.print(context);
            this._source.print("State_");
            this._source.print(trans.getName());
            this._source.print("(struct ");
            this._source.print(fsmClassName);
            this._source.print(" *fsm");
            params = trans.getParameters();
            for (SmcParameter param : params) {
                this._source.print(", ");
                param.accept((SmcVisitor)this);
            }
            this._source.println(")");
            this._source.println("{");
            this._source.println("    getState(fsm)->Default(fsm);");
            this._source.println("}");
        }
        this._source.println();
        this._source.print("static void ");
        this._source.print(context);
        this._source.print("State_Default(struct ");
        this._source.print(fsmClassName);
        this._source.println(" *fsm)");
        this._source.println("{");
        if (this._debugLevel >= 0) {
            this._source.println("    if (getDebugFlag(fsm) != 0) {");
            this._source.print("        TRACE(");
            this._source.print("\"TRANSITION   : %s.%s\\n\\r\", ");
            this._source.println("getName(getState(fsm)), getTransition(fsm));");
            this._source.println("    }");
        }
        this._source.println("    State_Default(fsm);");
        this._source.println("}");
        for (SmcMap map : fsm.getMaps()) {
            String mapName = map.getName();
            if (packageName != null && packageName.length() > 0) {
                mapName = packageName + "_" + mapName;
            }
            this._source.println();
            for (SmcState state : map.getStates()) {
                for (SmcTransition trans : transList) {
                    if (trans.getName().equals("Default")) continue;
                    this._source.print("#define ");
                    this._source.print(mapName);
                    this._source.print("_");
                    this._source.print(state.getInstanceName());
                    this._source.print("_");
                    this._source.print(trans.getName());
                    this._source.print(" ");
                    this._source.print(context);
                    this._source.print("State_");
                    this._source.println(trans.getName());
                }
                this._source.print("#define ");
                this._source.print(mapName);
                this._source.print("_");
                this._source.print(state.getInstanceName());
                this._source.print("_Default ");
                this._source.print(context);
                this._source.println("State_Default");
                this._source.print("#define ");
                this._source.print(mapName);
                this._source.print("_");
                this._source.print(state.getInstanceName());
                this._source.println("_Entry NULL");
                this._source.print("#define ");
                this._source.print(mapName);
                this._source.print("_");
                this._source.print(state.getInstanceName());
                this._source.println("_Exit NULL");
            }
            for (SmcTransition trans : transList) {
                if (trans.getName().equals("Default")) continue;
                this._source.print("#define ");
                this._source.print(mapName);
                this._source.print("_DefaultState_");
                this._source.print(trans.getName());
                this._source.print(" ");
                this._source.print(context);
                this._source.print("State_");
                this._source.println(trans.getName());
            }
            map.accept((SmcVisitor)this);
        }
        int index = startStateName.indexOf("::");
        String cState = index >= 0 ? startStateName.substring(0, index) + "_" + startStateName.substring(index + 2) : startStateName;
        this._source.println();
        this._source.print("void ");
        this._source.print(fsmClassName);
        this._source.print("_Init");
        this._source.print("(struct ");
        this._source.print(fsmClassName);
        this._source.print("* fsm, struct ");
        this._source.print(context);
        this._source.println("* owner)");
        this._source.println("{");
        this._source.print("    FSM_INIT(fsm, &");
        this._source.print(cState);
        this._source.println(");");
        this._source.println("    fsm->_owner = owner;");
        this._source.println("}");
        if (fsm.hasEntryActions()) {
            this._source.println();
            this._source.print("void ");
            this._source.print(fsmClassName);
            this._source.print("_EnterStartState(struct ");
            this._source.print(fsmClassName);
            this._source.println("* fsm)");
            this._source.println("{");
            this._source.println("    ENTRY_STATE(getState(fsm));");
            this._source.println("}");
        }
        for (SmcTransition trans : transList) {
            if (trans.getName().equals("Default")) continue;
            this._source.println();
            this._source.print("void ");
            this._source.print(fsmClassName);
            this._source.print("_");
            this._source.print(trans.getName());
            this._source.print("(struct ");
            this._source.print(fsmClassName);
            this._source.print("* fsm");
            params = trans.getParameters();
            for (SmcParameter param : params) {
                this._source.print(", ");
                this._source.print(param.getType());
                this._source.print(" ");
                this._source.print(param.getName());
            }
            this._source.println(")");
            this._source.println("{");
            this._source.print("    const struct ");
            this._source.print(context);
            this._source.println("State* state = getState(fsm);");
            this._source.println();
            this._source.println("    assert(state != NULL);");
            this._source.print("    setTransition(fsm, \"");
            this._source.print(trans.getName());
            this._source.println("\");");
            this._source.print("    state->");
            this._source.print(trans.getName());
            this._source.print("(fsm");
            for (SmcParameter param : params) {
                this._source.print(", ");
                this._source.print(param.getName());
            }
            this._source.println(");");
            this._source.println("    setTransition(fsm, NULL);");
            this._source.println("}");
        }
        this._source.println();
        this._source.println("/*");
        this._source.println(" * Local variables:");
        this._source.println(" *  buffer-read-only: t");
        this._source.println(" * End:");
        this._source.println(" */");
    }

    public void visit(SmcMap map) {
        String stateName;
        String packageName = map.getFSM().getPackage();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        if (packageName != null && packageName.length() > 0) {
            context = packageName + "_" + context;
            mapName = packageName + "_" + mapName;
        }
        if (map.hasDefaultState()) {
            SmcState defaultState = map.getDefaultState();
            for (SmcTransition trans : defaultState.getTransitions()) {
                String transName = trans.getName();
                this._source.println();
                for (SmcState state : map.getStates()) {
                    stateName = state.getInstanceName();
                    this._source.print("#undef ");
                    this._source.print(mapName);
                    this._source.print("_");
                    this._source.print(stateName);
                    this._source.print("_");
                    this._source.println(transName);
                    this._source.print("#define ");
                    this._source.print(mapName);
                    this._source.print("_");
                    this._source.print(stateName);
                    this._source.print("_");
                    this._source.print(transName);
                    this._source.print(" ");
                    this._source.print(mapName);
                    this._source.print("_DefaultState_");
                    this._source.println(transName);
                }
                this._source.print("#undef ");
                this._source.print(mapName);
                this._source.print("_DefaultState_");
                this._source.println(transName);
                trans.accept((SmcVisitor)this);
            }
        }
        for (SmcState state : map.getStates()) {
            stateName = state.getInstanceName();
            state.accept((SmcVisitor)this);
            this._source.println();
            this._source.print("const struct ");
            this._source.print(context);
            this._source.print("State ");
            this._source.print(mapName);
            this._source.print("_");
            this._source.print(stateName);
            this._source.print(" = { POPULATE_STATE(");
            this._source.print(mapName);
            this._source.print("_");
            this._source.print(stateName);
            this._source.print("), \"");
            this._source.print(mapName);
            this._source.print("_");
            this._source.print(stateName);
            this._source.print("\", ");
            this._source.print(Integer.toString(map.getNextStateId()));
            this._source.println(" };");
        }
    }

    public void visit(SmcState state) {
        String indent2;
        SmcMap map = state.getMap();
        String packageName = map.getFSM().getPackage();
        String context = map.getFSM().getContext();
        String fsmClassName = map.getFSM().getFsmClassName();
        String mapName = map.getName();
        String instanceName = state.getInstanceName();
        if (packageName != null && packageName.length() > 0) {
            context = packageName + "_" + context;
            mapName = packageName + "_" + mapName;
        }
        this._context = context;
        List actions = state.getEntryActions();
        if (actions != null && !actions.isEmpty()) {
            this._source.println();
            this._source.print("#undef ");
            this._source.print(mapName);
            this._source.print("_");
            this._source.print(instanceName);
            this._source.println("_Entry");
            this._source.print("void ");
            this._source.print(mapName);
            this._source.print("_");
            this._source.print(instanceName);
            this._source.print("_Entry(struct ");
            this._source.print(fsmClassName);
            this._source.println(" *fsm)");
            this._source.println("{");
            this._source.print("    struct ");
            this._source.print(context);
            this._source.println(" *ctxt = getOwner(fsm);");
            this._source.println();
            indent2 = this._indent;
            this._indent = this._indent + "    ";
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
            this._indent = indent2;
            this._source.println("}");
        }
        if ((actions = state.getExitActions()) != null && !actions.isEmpty()) {
            this._source.println();
            this._source.print("#undef ");
            this._source.print(mapName);
            this._source.print("_");
            this._source.print(instanceName);
            this._source.println("_Exit");
            this._source.print("void ");
            this._source.print(mapName);
            this._source.print("_");
            this._source.print(instanceName);
            this._source.print("_Exit(struct ");
            this._source.print(fsmClassName);
            this._source.println(" *fsm)");
            this._source.println("{");
            this._source.print("    struct ");
            this._source.print(context);
            this._source.println(" *ctxt = getOwner(fsm);");
            this._source.println();
            indent2 = this._indent;
            this._indent = this._indent + "    ";
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
            this._indent = indent2;
            this._source.println("}");
        }
        for (SmcTransition transition : state.getTransitions()) {
            transition.accept((SmcVisitor)this);
        }
    }

    public void visit(SmcTransition transition) {
        SmcGuard guard;
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String packageName = map.getFSM().getPackage();
        String context = map.getFSM().getContext();
        String fsmClassName = map.getFSM().getFsmClassName();
        String mapName = map.getName();
        String stateName = state.getInstanceName();
        String transName = transition.getName();
        boolean nullCondition = false;
        List guards = transition.getGuards();
        if (packageName != null && packageName.length() > 0) {
            context = packageName + "_" + context;
            mapName = packageName + "_" + mapName;
        }
        if (!stateName.equals("DefaultState")) {
            this._source.println();
            this._source.print("#undef ");
            this._source.print(mapName);
            this._source.print("_");
            this._source.print(stateName);
            this._source.print("_");
            this._source.println(transName);
        }
        this._source.print("static void ");
        this._source.print(mapName);
        this._source.print("_");
        this._source.print(stateName);
        this._source.print("_");
        this._source.print(transName);
        this._source.print("(struct ");
        this._source.print(fsmClassName);
        this._source.print(" *fsm");
        for (SmcParameter parameter : transition.getParameters()) {
            this._source.print(", ");
            parameter.accept((SmcVisitor)this);
        }
        this._source.println(")");
        this._source.println("{");
        if (transition.hasCtxtReference()) {
            this._source.print("    struct ");
            this._source.print(context);
            this._source.println("* ctxt = getOwner(fsm);");
        }
        this._guardCount = guards.size();
        if (this._guardCount == 1 && !(guard = (SmcGuard)guards.get(0)).getActions().isEmpty() && this.isLoopback(guard.getTransType(), guard.getEndState())) {
            this._source.print("    const struct ");
            this._source.print(context);
            this._source.println("State* EndStateName = getState(fsm);");
        }
        this._source.println();
        if (this._debugLevel >= 0) {
            this._source.println("    if (getDebugFlag(fsm) != 0) {");
            this._source.print("        TRACE(\"LEAVING STATE   : ");
            this._source.print(mapName);
            this._source.print("_");
            this._source.print(stateName);
            this._source.println(")\\n\\r\");");
            this._source.println("    }");
        }
        Iterator git = guards.iterator();
        this._guardIndex = 0;
        while (git.hasNext()) {
            guard = (SmcGuard)git.next();
            if (guard.getCondition().length() == 0) {
                nullCondition = true;
            }
            guard.accept((SmcVisitor)this);
            ++this._guardIndex;
        }
        if (this._guardIndex > 0 && !nullCondition) {
            if (this._guardCount == 1) {
                this._source.println("    }");
            }
            this._source.println("    else {");
            this._source.print("        ");
            this._source.print(mapName);
            this._source.print("_DefaultState_");
            this._source.print(transName);
            this._source.print("(fsm");
            for (SmcParameter param : transition.getParameters()) {
                this._source.print(", ");
                this._source.print(param.getName());
            }
            this._source.println(");");
            this._source.println("    }");
        } else if (this._guardCount > 1) {
            this._source.println();
        }
        this._source.println("}");
    }

    public void visit(SmcGuard guard) {
        SmcParameter param;
        String sep;
        Iterator pit;
        String indent2;
        SmcTransition transition = guard.getTransition();
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String packageName = map.getFSM().getPackage();
        String context = map.getFSM().getContext();
        String fsmClassName = map.getFSM().getFsmClassName();
        String mapName = map.getName();
        String stateName = state.getInstanceName();
        String transName = transition.getName();
        SmcElement.TransType transType = guard.getTransType();
        boolean loopbackFlag = false;
        String endStateName = guard.getEndState();
        String fqEndStateName = "";
        String pushStateName = guard.getPushState();
        String condition = guard.getCondition();
        List actions = guard.getActions();
        if (packageName != null && packageName.length() > 0) {
            context = packageName + "_" + context;
            mapName = packageName + "_" + mapName;
        }
        this._context = context;
        if (transType != SmcElement.TransType.TRANS_POP && endStateName.length() > 0 && !endStateName.equalsIgnoreCase("nil")) {
            endStateName = "&" + this.scopeStateName(endStateName, mapName);
        }
        stateName = "&" + this.scopeStateName(stateName, mapName);
        pushStateName = this.scopeStateName(pushStateName, mapName);
        pushStateName = packageName != null && packageName.length() > 0 ? "&" + packageName + "_" + pushStateName : "&" + pushStateName;
        loopbackFlag = this.isLoopback(transType, endStateName);
        if (this._guardCount > 1) {
            indent2 = this._indent + "        ";
            if (this._guardIndex == 0 && condition.length() > 0) {
                this._source.print(this._indent);
                this._source.print("    if (");
                this._source.print(condition);
                this._source.println(") {");
            } else if (condition.length() > 0) {
                this._source.println();
                this._source.print(this._indent);
                this._source.print("    else if (");
                this._source.print(condition);
                this._source.println(") {");
            } else {
                this._source.println();
                this._source.print(this._indent);
                this._source.println("    else {");
            }
        } else if (condition.length() == 0) {
            indent2 = this._indent + "    ";
        } else {
            this._source.print(this._indent);
            this._source.print("    if (");
            this._source.print(condition);
            this._source.println(") {");
            indent2 = this._indent + "        ";
        }
        if (actions.size() == 0 && endStateName.length() > 0) {
            fqEndStateName = endStateName;
        } else if (actions.size() > 0) {
            if (loopbackFlag) {
                fqEndStateName = "EndStateName";
                if (this._guardCount > 1) {
                    this._source.print(indent2);
                    this._source.print("const struct ");
                    this._source.print(context);
                    this._source.print("State* ");
                    this._source.print(fqEndStateName);
                    this._source.println(" = getState(fsm);");
                    this._source.println();
                }
            } else {
                fqEndStateName = endStateName;
            }
        }
        if (transType == SmcElement.TransType.TRANS_POP || !loopbackFlag) {
            if (this._debugLevel >= 1) {
                this._source.print(indent2);
                this._source.println("if (getDebugFlag(fsm) != 0) {");
                this._source.print(indent2);
                this._source.print("    TRACE(\"BEFORE EXIT     : ");
                this._source.println("EXIT_STATE(getState(fsm))\\n\\r\");");
                this._source.print(indent2);
                this._source.println("}");
            }
            this._source.print(indent2);
            this._source.println("EXIT_STATE(getState(fsm));");
            if (this._debugLevel >= 1) {
                this._source.print(indent2);
                this._source.println("if (getDebugFlag(fsm) != 0) {");
                this._source.print(indent2);
                this._source.print("    TRACE(\"AFTER EXIT      : ");
                this._source.println("EXIT_STATE(getState(fsm))\\n\\r\");");
                this._source.print(indent2);
                this._source.println("}");
            }
        }
        if (this._debugLevel >= 0) {
            this._source.print(indent2);
            this._source.println("if (getDebugFlag(fsm) != 0) {");
            this._source.print(indent2);
            this._source.print("    TRACE(\"ENTER TRANSITION: ");
            this._source.print(mapName);
            this._source.print("_");
            this._source.print(stateName);
            this._source.print(".");
            this._source.print(transName);
            this._source.print("(");
            pit = transition.getParameters().iterator();
            sep = "";
            while (pit.hasNext()) {
                param = (SmcParameter)pit.next();
                this._source.print(sep);
                this._source.print(param.getName());
                sep = ", ";
            }
            this._source.println(")\\n\\r\");");
            this._source.print(indent2);
            this._source.println("}");
        }
        if (actions.isEmpty()) {
            if (condition.length() > 0) {
                this._source.print(indent2);
                this._source.println("/* No actions. */");
            }
        } else {
            this._source.print(indent2);
            this._source.println("clearState(fsm);");
            String indent4 = this._indent;
            this._indent = indent2;
            for (SmcAction action : actions) {
                action.accept((SmcVisitor)this);
            }
            this._indent = indent4;
        }
        String indent3 = indent2;
        if (this._debugLevel >= 0) {
            this._source.print(indent2);
            this._source.println("if (getDebugFlag(fsm) != 0) {");
            this._source.print(indent2);
            this._source.print("    TRACE(\"EXIT TRANSITION : ");
            this._source.print(mapName);
            this._source.print("_");
            this._source.print(stateName);
            this._source.print(".");
            this._source.print(transName);
            this._source.print("(");
            pit = transition.getParameters().iterator();
            sep = "";
            while (pit.hasNext()) {
                param = (SmcParameter)pit.next();
                this._source.print(sep);
                this._source.print(param.getName());
                sep = ", ";
            }
            this._source.println(")\\n\\r\");");
            this._source.print(indent2);
            this._source.println("}");
        }
        if (!(transType != SmcElement.TransType.TRANS_SET || actions.isEmpty() && loopbackFlag)) {
            this._source.print(indent3);
            this._source.print("setState(fsm, ");
            this._source.print(fqEndStateName);
            this._source.println(");");
        } else if (transType == SmcElement.TransType.TRANS_PUSH) {
            if (!loopbackFlag || !actions.isEmpty()) {
                this._source.print(indent3);
                this._source.print("setState(fsm, ");
                this._source.print(fqEndStateName);
                this._source.println(");");
            }
            if (!loopbackFlag) {
                if (this._debugLevel >= 1) {
                    this._source.print(indent3);
                    this._source.println("if (getDebugFlag(fsm) != 0) {");
                    this._source.print(indent3);
                    this._source.print("    TRACE(\"BEFORE ENTRY    : ");
                    this._source.println("ENTRY_STATE(getState(fsm))\\n\\r\");");
                    this._source.print(indent3);
                    this._source.println("}");
                }
                this._source.print(indent3);
                this._source.println("ENTRY_STATE(getState(fsm));");
                if (this._debugLevel >= 1) {
                    this._source.print(indent3);
                    this._source.println("if (getDebugFlag(fsm) != 0) {");
                    this._source.print(indent3);
                    this._source.print("    TRACE(\"AFTER ENTRY     : ");
                    this._source.println("ENTRY_STATE(getState(fsm))\\n\\r\");");
                    this._source.print(indent3);
                    this._source.println("}");
                }
            }
            this._source.print(indent3);
            this._source.print("pushState(fsm, ");
            this._source.print(pushStateName);
            this._source.println(");");
        } else if (transType == SmcElement.TransType.TRANS_POP) {
            this._source.print(indent3);
            this._source.println("popState(fsm);");
        }
        if (transType == SmcElement.TransType.TRANS_SET && !loopbackFlag || transType == SmcElement.TransType.TRANS_PUSH) {
            if (this._debugLevel >= 1) {
                this._source.print(indent2);
                this._source.println("if (getDebugFlag(fsm) != 0) {");
                this._source.print(indent2);
                this._source.print("    TRACE(\"BEFORE ENTRY    : ");
                this._source.println("ENTRY_STATE(getState(fsm))\\n\\r\");");
                this._source.print(indent2);
                this._source.println("}");
            }
            this._source.print(indent2);
            this._source.println("ENTRY_STATE(getState(fsm));");
            if (this._debugLevel >= 1) {
                this._source.print(indent2);
                this._source.println("if (getDebugFlag(fsm) != 0) {");
                this._source.print(indent2);
                this._source.print("    TRACE(\"AFTER ENTRY     : ");
                this._source.println("ENTRY_STATE(getState(fsm))\\n\\r\");");
                this._source.print(indent2);
                this._source.println("}");
            }
        }
        if (transType == SmcElement.TransType.TRANS_POP && !endStateName.equalsIgnoreCase("nil") && endStateName.length() > 0) {
            String popArgs = guard.getPopArgs();
            this._source.print(indent2);
            this._source.print(fsmClassName);
            this._source.print("_");
            this._source.print(endStateName);
            this._source.print("(fsm");
            if (popArgs.length() > 0) {
                this._source.print(", ");
                this._source.print(popArgs);
            }
            this._source.println(");");
        }
        if (this._guardCount > 1) {
            this._source.print(this._indent);
            this._source.print("    }");
        }
    }

    public void visit(SmcAction action) {
        String name = action.getName();
        this._source.print(this._indent);
        if (action.isEmptyStateStack()) {
            this._source.println("emptyStateStack(fsm);");
        } else {
            this._source.print(this._context);
            this._source.print("_");
            this._source.print(name);
            this._source.print("(ctxt");
            for (String arg : action.getArguments()) {
                if (arg.length() <= 0) continue;
                this._source.print(", ");
                this._source.print(arg);
            }
            this._source.println(");");
        }
    }

    public void visit(SmcParameter parameter) {
        this._source.print(parameter.getType());
        this._source.print(" ");
        this._source.print(parameter.getName());
    }

    @Override
    protected String scopeStateName(String stateName, String mapName) {
        StringWriter retval = new StringWriter();
        int index = stateName.indexOf("::");
        if (index < 0) {
            retval.write(mapName);
            retval.write("_");
            retval.write(stateName);
        } else {
            retval.write(stateName.substring(0, index));
            retval.write(95);
            retval.write(stateName.substring(index + 2));
        }
        return retval.toString();
    }
}

