/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;

public interface UnfailingIterator<T extends Item>
extends SequenceIterator<T> {
    @Override
    public T next();

    default public void forEach(Consumer<T> consumer) {
        T item;
        while ((item = this.next()) != null) {
            consumer.accept(item);
        }
    }

    default public Optional<T> firstWith(Predicate<? super T> condition) {
        T item;
        while ((item = this.next()) != null) {
            if (!condition.test(item)) continue;
            this.close();
            return Optional.of(item);
        }
        return Optional.empty();
    }

    default public List<T> toList() {
        ArrayList list = new ArrayList();
        this.forEach(list::add);
        return list;
    }
}

