/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.Iterator;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Genre;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.tree.jiter.MonoIterator;
import net.sf.saxon.value.EmptySequence;

public interface Item<T extends Item>
extends GroundedValue<T> {
    public Genre getGenre();

    @Override
    default public T head() {
        return (T)this;
    }

    @Override
    public String getStringValue();

    @Override
    public CharSequence getStringValueCS();

    public AtomicSequence atomize() throws XPathException;

    @Override
    default public String toShortString() {
        return this.toString();
    }

    @Override
    default public Iterator<T> iterator() {
        return new MonoIterator<T>(this.head());
    }

    @Override
    default public T itemAt(int n) {
        return n == 0 ? (T)this.head() : null;
    }

    @Override
    default public GroundedValue<T> subsequence(int start, int length) {
        return start <= 0 && start + length > 0 ? this : EmptySequence.getInstance();
    }

    @Override
    default public int getLength() {
        return 1;
    }

    @Override
    default public UnfailingIterator<T> iterate() {
        return SingletonIterator.makeIterator(this.head());
    }

    @Override
    default public GroundedValue<T> reduce() {
        return this;
    }

    default public boolean isStreamed() {
        return false;
    }

    public static Sequence<? extends Item>[] asArgumentArray(Item item) {
        return new Sequence[]{item};
    }
}

