/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Stack;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.One;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;

public class Chain<T extends Item>
implements GroundedValue<T> {
    private List<GroundedValue<T>> children = new ArrayList<GroundedValue<T>>();
    private List<T> extent = null;

    public Chain(List<GroundedValue<T>> children) {
        this.children = children;
        int size = 0;
        boolean copy = false;
        for (GroundedValue<T> gv : children) {
            if (gv instanceof Chain) {
                if (((Chain)gv).children.size() < 30) {
                    size += ((Chain)gv).children.size();
                    copy = true;
                    continue;
                }
                ++size;
                continue;
            }
            ++size;
        }
        if (copy) {
            this.children = new ArrayList<GroundedValue<T>>(size);
            for (GroundedValue<T> gv : children) {
                if (gv instanceof Chain) {
                    if (((Chain)gv).children.size() < 30) {
                        this.children.addAll(((Chain)gv).children);
                        continue;
                    }
                    this.children.add(gv);
                    continue;
                }
                this.children.add(gv);
            }
        } else {
            this.children = children;
        }
    }

    @Override
    public T head() {
        for (GroundedValue<T> seq : this.children) {
            T head = seq.head();
            if (head == null) continue;
            return head;
        }
        return null;
    }

    @Override
    public UnfailingIterator<T> iterate() {
        if (this.extent != null) {
            return new ListIterator<T>(this.extent);
        }
        return new ChainIterator(this);
    }

    public void append(T item) {
        if (this.extent != null) {
            throw new IllegalStateException();
        }
        if (item != null) {
            if (item instanceof GroundedValue) {
                this.children.add((GroundedValue<T>)item);
            } else {
                this.children.add(new One<T>(item));
            }
        }
    }

    private void consolidate() {
        if (this.extent == null) {
            this.extent = this.iterate().toList();
        }
    }

    @Override
    public T itemAt(int n) {
        this.consolidate();
        if (n >= 0 && n < this.extent.size()) {
            return (T)((Item)this.extent.get(n));
        }
        return null;
    }

    @Override
    public GroundedValue subsequence(int start, int length) {
        int newEnd;
        this.consolidate();
        if (start < 0) {
            start = 0;
        } else if (start >= this.extent.size()) {
            return EmptySequence.getInstance();
        }
        int newStart = start;
        if (length == Integer.MAX_VALUE) {
            newEnd = this.extent.size();
        } else {
            if (length < 0) {
                return EmptySequence.getInstance();
            }
            newEnd = newStart + length;
            if (newEnd > this.extent.size()) {
                newEnd = this.extent.size();
            }
        }
        return new SequenceExtent<T>(this.extent.subList(newStart, newEnd));
    }

    @Override
    public int getLength() {
        if (this.extent != null) {
            return this.extent.size();
        }
        int n = 0;
        for (GroundedValue<T> v : this.children) {
            n += v.getLength();
        }
        return n;
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        return ExpressionTool.effectiveBooleanValue(this.iterate());
    }

    @Override
    public String getStringValue() throws XPathException {
        return SequenceTool.getStringValue(this);
    }

    @Override
    public CharSequence getStringValueCS() throws XPathException {
        return SequenceTool.getStringValue(this);
    }

    @Override
    public GroundedValue reduce() {
        this.consolidate();
        return SequenceExtent.makeSequenceExtent(this.extent);
    }

    private static class ChainIterator<T extends Item>
    implements UnfailingIterator<T>,
    GroundedIterator<T> {
        private Queue<UnfailingIterator<T>> queue = new LinkedList<UnfailingIterator<T>>();
        private Stack<ChainPosition> stack;
        private Chain<T> thisChain;

        public ChainIterator(Chain<T> thisChain) {
            this.thisChain = thisChain;
            this.stack = new Stack();
            this.stack.push(new ChainPosition(thisChain, 0));
        }

        @Override
        public T next() {
            while (!this.queue.isEmpty()) {
                UnfailingIterator<T> ui = this.queue.peek();
                while (ui != null) {
                    T current = ui.next();
                    if (current != null) {
                        return current;
                    }
                    this.queue.remove();
                    ui = this.queue.peek();
                }
            }
            while (!this.stack.isEmpty()) {
                ChainPosition cp = this.stack.peek();
                if (cp.offset >= cp.chain.children.size()) {
                    this.stack.pop();
                    continue;
                }
                GroundedValue gv = (GroundedValue)cp.chain.children.get(cp.offset++);
                if (gv instanceof Chain) {
                    this.stack.push(new ChainPosition((Chain)gv, 0));
                    continue;
                }
                if (gv instanceof Item) {
                    return (T)((Item)gv);
                }
                this.queue.offer((UnfailingIterator<T>)gv.iterate());
                return this.next();
            }
            return null;
        }

        @Override
        public void close() {
        }

        @Override
        public int getProperties() {
            return 1;
        }

        @Override
        public GroundedValue<T> materialize() {
            return this.thisChain;
        }

        @Override
        public GroundedValue<T> getResidue() throws XPathException {
            return new SequenceExtent(this);
        }

        private class ChainPosition {
            Chain<T> chain;
            int offset;

            public ChainPosition(Chain<T> chain, int offset) {
                this.chain = chain;
                this.offset = offset;
            }
        }
    }
}

