/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.parser;

import java.util.ArrayList;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.SuppliedParameterReference;
import net.sf.saxon.expr.TailExpression;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.om.Chain;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LazySequence;
import net.sf.saxon.om.MemoSequence;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.MemoClosure;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SingletonClosure;

public abstract class Evaluator {
    public static final Evaluator EMPTY_SEQUENCE = new Evaluator(){

        @Override
        public Sequence<? extends Item> evaluate(Expression expr, XPathContext context) {
            return EmptySequence.getInstance();
        }

        @Override
        public int getCode() {
            return 5;
        }
    };
    public static final Evaluator LITERAL = new Evaluator(){

        @Override
        public Sequence<? extends Item> evaluate(Expression expr, XPathContext context) {
            return ((Literal)expr).getValue();
        }

        @Override
        public int getCode() {
            return 0;
        }
    };
    public static final Evaluator VARIABLE = new Evaluator(){

        @Override
        public Sequence<? extends Item> evaluate(Expression expr, XPathContext context) throws XPathException {
            try {
                return ((VariableReference)expr).evaluateVariable(context);
            }
            catch (ClassCastException e) {
                assert (false);
                return LAZY_SEQUENCE.evaluate(expr, context);
            }
        }

        @Override
        public int getCode() {
            return 6;
        }
    };
    public static final Evaluator SUPPLIED_PARAMETER = new Evaluator(){

        @Override
        public Sequence<? extends Item> evaluate(Expression expr, XPathContext context) throws XPathException {
            try {
                return ((SuppliedParameterReference)expr).evaluateVariable(context);
            }
            catch (ClassCastException e) {
                assert (false);
                return LAZY_SEQUENCE.evaluate(expr, context);
            }
        }

        @Override
        public int getCode() {
            return 14;
        }
    };
    public static final Evaluator SINGLE_ITEM = new Evaluator(){

        public Item evaluate(Expression expr, XPathContext context) throws XPathException {
            return expr.evaluateItem(context);
        }

        @Override
        public int getCode() {
            return 16;
        }
    };
    public static final Evaluator OPTIONAL_ITEM = new Evaluator(){

        @Override
        public Sequence<? extends Item> evaluate(Expression expr, XPathContext context) throws XPathException {
            Item item = expr.evaluateItem(context);
            return item == null ? EmptySequence.getInstance() : item;
        }

        @Override
        public int getCode() {
            return 7;
        }
    };
    public static final Evaluator LAZY_SEQUENCE = new Evaluator(){

        @Override
        public Sequence<? extends Item> evaluate(Expression expr, XPathContext context) throws XPathException {
            SequenceIterator<? extends Item> iter = expr.iterate(context);
            return new LazySequence<Item>(iter);
        }

        @Override
        public int getCode() {
            return 3;
        }
    };
    public static final Evaluator MEMO_SEQUENCE = new Evaluator(){

        @Override
        public Sequence<? extends Item> evaluate(Expression expr, XPathContext context) throws XPathException {
            SequenceIterator<? extends Item> iter = expr.iterate(context);
            return new MemoSequence<Item>(iter);
        }

        @Override
        public int getCode() {
            return 4;
        }
    };
    public static final Evaluator MEMO_CLOSURE = new Evaluator(){

        public Sequence evaluate(Expression expr, XPathContext context) throws XPathException {
            return new MemoClosure(expr, context);
        }

        @Override
        public int getCode() {
            return 4;
        }
    };
    public static final Evaluator SINGLETON_CLOSURE = new Evaluator(){

        public Sequence evaluate(Expression expr, XPathContext context) throws XPathException {
            return new SingletonClosure(expr, context);
        }

        @Override
        public int getCode() {
            return 13;
        }
    };
    public static final Evaluator EAGER_SEQUENCE = new Evaluator(){

        public Sequence evaluate(Expression expr, XPathContext context) throws XPathException {
            SequenceIterator<? extends Item> iter = expr.iterate(context);
            return iter.materialize();
        }

        @Override
        public int getCode() {
            return 8;
        }
    };
    public static final Evaluator SHARED_APPEND = new Evaluator(){

        public Sequence evaluate(Expression expr, XPathContext context) throws XPathException {
            if (expr instanceof Block) {
                Block block = (Block)expr;
                Operand[] children = block.getOperanda();
                ArrayList subsequences = new ArrayList(children.length);
                for (Operand o : children) {
                    Expression child = o.getChildExpression();
                    if (Cardinality.allowsMany(child.getCardinality())) {
                        subsequences.add(child.iterate(context).materialize());
                        continue;
                    }
                    Item j = child.evaluateItem(context);
                    if (j == null) continue;
                    subsequences.add(j);
                }
                return new Chain(subsequences);
            }
            return expr.iterate(context).materialize();
        }

        @Override
        public int getCode() {
            return 11;
        }
    };
    public static final Evaluator STREAMING_ARGUMENT = new Evaluator(){

        public Sequence evaluate(Expression expr, XPathContext context) throws XPathException {
            return context.getConfiguration().obtainOptimizer().evaluateStreamingArgument(expr, context);
        }

        @Override
        public int getCode() {
            return 15;
        }
    };
    public static final Evaluator MAKE_INDEXED_VARIABLE = new Evaluator(){

        public Sequence evaluate(Expression expr, XPathContext context) throws XPathException {
            return context.getConfiguration().obtainOptimizer().makeIndexedValue(expr.iterate(context));
        }

        @Override
        public int getCode() {
            return 12;
        }
    };
    public static final Evaluator PROCESS = new Evaluator(){

        @Override
        public Sequence<? extends Item> evaluate(Expression expr, XPathContext context) throws XPathException {
            Controller controller = context.getController();
            Receiver saved = context.getReceiver();
            SequenceOutputter seq = controller.allocateSequenceOutputter(20);
            seq.getPipelineConfiguration().setHostLanguage(expr.getPackageData().getHostLanguage());
            context.setReceiver(seq);
            seq.open();
            expr.process(context);
            seq.close();
            context.setReceiver(saved);
            Sequence<? extends Item> val = seq.getSequence();
            seq.reset();
            return val;
        }

        @Override
        public int getCode() {
            return 9;
        }
    };
    public static final Evaluator LAZY_TAIL = new Evaluator(){

        public Sequence evaluate(Expression expr, XPathContext context) throws XPathException {
            TailExpression tail = (TailExpression)expr;
            VariableReference vr = (VariableReference)tail.getBaseExpression();
            Sequence<? extends Item> base = VARIABLE.evaluate(vr, context);
            if (base instanceof MemoClosure) {
                SequenceIterator<? extends Item> it = base.iterate();
                base = it.materialize();
            }
            if (base instanceof IntegerRange) {
                long end;
                long start = ((IntegerRange)base).getStart() + (long)tail.getStart() - 1L;
                if (start == (end = ((IntegerRange)base).getEnd())) {
                    return Int64Value.makeIntegerValue(end);
                }
                if (start > end) {
                    return EmptySequence.getInstance();
                }
                return new IntegerRange(start, end);
            }
            if (base instanceof SequenceExtent) {
                if (tail.getStart() > ((SequenceExtent)base).getLength()) {
                    return EmptySequence.getInstance();
                }
                return new SequenceExtent((SequenceExtent)base, tail.getStart() - 1, ((SequenceExtent)base).getLength() - tail.getStart() + 1).reduce();
            }
            return new MemoClosure(tail, context);
        }

        @Override
        public int getCode() {
            return 10;
        }
    };

    public static Evaluator evaluatorForCode(int code) {
        switch (code) {
            case 0: {
                return LITERAL;
            }
            case 1: {
                return VARIABLE;
            }
            case 3: {
                return LAZY_SEQUENCE;
            }
            case 4: {
                return MEMO_CLOSURE;
            }
            case 5: {
                return EMPTY_SEQUENCE;
            }
            case 6: {
                return VARIABLE;
            }
            case 16: {
                return SINGLE_ITEM;
            }
            case 7: {
                return OPTIONAL_ITEM;
            }
            case 8: {
                return EAGER_SEQUENCE;
            }
            case 9: {
                return PROCESS;
            }
            case 10: {
                return LAZY_TAIL;
            }
            case 11: {
                return SHARED_APPEND;
            }
            case 12: {
                return MAKE_INDEXED_VARIABLE;
            }
            case 13: {
                return SINGLETON_CLOSURE;
            }
            case 14: {
                return SUPPLIED_PARAMETER;
            }
            case 15: {
                return STREAMING_ARGUMENT;
            }
        }
        return EAGER_SEQUENCE;
    }

    public abstract Sequence<? extends Item> evaluate(Expression var1, XPathContext var2) throws XPathException;

    public abstract int getCode();
}

