/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.SimpleStepExpression;
import net.sf.saxon.expr.instruct.ApplyTemplates;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.sort.SortExpression;
import net.sf.saxon.expr.sort.SortKeyDefinitionList;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLSort;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.rules.RuleManager;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.value.Whitespace;

public class XSLApplyTemplates
extends StyleElement {
    private Expression select;
    private StructuredQName modeName;
    private boolean useCurrentMode = false;
    private boolean useTailRecursion = false;
    private boolean defaultedSelectExpression = true;
    private Mode mode;
    private String modeAttribute;

    public boolean isInstruction() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String selectAtt = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("mode")) {
                this.modeAttribute = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("select")) {
                selectAtt = atts.getValue(a);
                this.select = this.makeExpression(selectAtt, a);
                this.defaultedSelectExpression = false;
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (this.modeAttribute != null) {
            if (this.modeAttribute.equals("#current")) {
                this.useCurrentMode = true;
            } else if (this.modeAttribute.equals("#unnamed")) {
                this.modeName = Mode.UNNAMED_MODE_NAME;
            } else if (!this.modeAttribute.equals("#default")) {
                try {
                    this.modeName = this.makeQName(this.modeAttribute);
                }
                catch (NamespaceException err) {
                    this.compileError(err.getMessage(), "XTSE0280");
                    this.modeName = null;
                }
                catch (XPathException err) {
                    this.compileError("Mode name " + Err.wrap(this.modeAttribute) + " is not a valid QName", err.getErrorCodeQName());
                    this.modeName = null;
                }
            }
        }
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        NodeInfo child;
        if (this.useCurrentMode) {
            if (this.iterateAxis((byte)0, new NameTest(1, 200, this.getNamePool())).next() == null) {
                this.issueWarning("Specifying mode=\"#current\" when not inside an xsl:template serves no useful purpose", this);
            }
        } else {
            PrincipalStylesheetModule psm = this.getPrincipalStylesheetModule();
            if (this.modeName == null) {
                this.modeName = this.getDefaultMode();
                if ((this.modeName == null || this.modeName.equals(Mode.UNNAMED_MODE_NAME)) && psm.isDeclaredModes() && !psm.getRuleManager().isUnnamedModeExplicit()) {
                    this.compileError("The unnamed mode must be explicitly declared in an xsl:mode declaration", "XTSE3085");
                }
            } else if (this.modeName.equals(Mode.UNNAMED_MODE_NAME) && psm.isDeclaredModes() && !psm.getRuleManager().isUnnamedModeExplicit()) {
                this.compileError("The #unnamed mode must be explicitly declared in an xsl:mode declaration", "XTSE3085");
            }
            if (psm.isDeclaredModes() && psm.getRuleManager().obtainMode(this.modeName, false) == null) {
                this.compileError("Mode name " + this.modeName.getDisplayName() + " must be explicitly declared in an xsl:mode declaration", "XTSE3085");
            }
            this.mode = psm.getRuleManager().obtainMode(this.modeName, true);
        }
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = kids.next()) != null) {
            if (child instanceof XSLSort || child instanceof XSLWithParam) continue;
            if (child.getNodeKind() == 3) {
                if (Whitespace.isWhite(child.getStringValueCS())) continue;
                this.compileError("No character data is allowed within xsl:apply-templates", "XTSE0010");
                continue;
            }
            this.compileError("Invalid element within xsl:apply-templates", "XTSE0010");
        }
        if (this.select == null) {
            Expression here = new ContextItemExpression();
            RoleDiagnostic role = new RoleDiagnostic(13, "", 0);
            role.setErrorCode("XTTE0510");
            here = new ItemChecker(here, AnyNodeTest.getInstance(), role);
            this.select = new SimpleStepExpression(here, new AxisExpression(3, null));
            this.select.setLocation(this.allocateLocation());
            this.select.setRetainedStaticContext(this.makeRetainedStaticContext());
        }
        this.select = this.typeCheck("select", this.select);
    }

    public boolean markTailCalls() {
        this.useTailRecursion = true;
        return true;
    }

    public Expression compile(Compilation compilation, ComponentDeclaration decl) throws XPathException {
        SortKeyDefinitionList sortKeys = this.makeSortKeys(compilation, decl);
        if (sortKeys != null) {
            this.useTailRecursion = false;
        }
        assert (this.select != null);
        Expression sortedSequence = this.select;
        if (sortKeys != null) {
            sortedSequence = new SortExpression(this.select, sortKeys);
        }
        this.compileSequenceConstructor(compilation, decl, true);
        RuleManager rm = compilation.getPrincipalStylesheetModule().getRuleManager();
        ApplyTemplates app = new ApplyTemplates(sortedSequence, this.useCurrentMode, this.useTailRecursion, this.defaultedSelectExpression, this.isWithinDeclaredStreamableConstruct(), this.mode, rm);
        app.setActualParams(this.getWithParamInstructions(app, compilation, decl, false));
        app.setTunnelParams(this.getWithParamInstructions(app, compilation, decl, true));
        return app;
    }
}

