/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.jaxp;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.TransformerHandler;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ReceivingContentHandler;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.jaxp.AbstractTransformerImpl;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.Xslt30Transformer;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.trans.XPathException;

public class StreamingTransformerImpl
extends AbstractTransformerImpl {
    private Xslt30Transformer xsltTransformer;
    private Map<QName, XdmValue> convertedParameters = new HashMap<QName, XdmValue>();

    protected StreamingTransformerImpl(XsltExecutable e, Xslt30Transformer t) {
        super(e);
        this.xsltTransformer = t;
    }

    public void transform(Source xmlSource, Result outputTarget) throws XPathException {
        try {
            Destination destination;
            this.xsltTransformer.setStylesheetParameters(this.convertedParameters);
            if (outputTarget.getSystemId() != null) {
                this.xsltTransformer.setBaseOutputURI(outputTarget.getSystemId());
            }
            if ((destination = this.makeDestination(outputTarget)) == null) {
                SerializerFactory sf = this.getConfiguration().getSerializerFactory();
                SequenceReceiver r = sf.getReceiver(outputTarget, this.getConfiguration().makePipelineConfiguration(), this.getLocalOutputProperties());
                this.transform(xmlSource, r);
                return;
            }
            this.xsltTransformer.applyTemplates(xmlSource, destination);
            if (destination instanceof Serializer && ((Serializer)destination).isMustCloseAfterUse()) {
                destination.close();
            }
        }
        catch (SaxonApiException e) {
            throw XPathException.makeXPathException(e);
        }
    }

    protected void setConvertedParameter(QName name, XdmValue value) {
        this.convertedParameters.put(name, value);
    }

    public void clearParameters() {
        super.clearParameters();
        this.convertedParameters.clear();
    }

    public void setURIResolver(URIResolver resolver) {
        super.setURIResolver(resolver);
        this.xsltTransformer.setURIResolver(resolver);
    }

    public void setErrorListener(ErrorListener listener) throws IllegalArgumentException {
        super.setErrorListener(listener);
        this.xsltTransformer.setErrorListener(listener);
    }

    public void setInitialMode(String name) throws IllegalArgumentException {
        this.xsltTransformer.setInitialMode(QName.fromClarkName(name));
    }

    public Xslt30Transformer getUnderlyingXsltTransformer() {
        return this.xsltTransformer;
    }

    public Controller getUnderlyingController() {
        return this.xsltTransformer.getUnderlyingController();
    }

    public TransformerHandler newTransformerHandler() throws XPathException {
        Controller controller = this.xsltTransformer.getUnderlyingController();
        return new StreamingTransformerHandler(controller);
    }

    public class StreamingTransformerHandler
    extends ReceivingContentHandler
    implements TransformerHandler {
        private Controller controller;
        private String systemId;

        public StreamingTransformerHandler(Controller controller) {
            this.controller = controller;
        }

        public void setResult(Result result) throws IllegalArgumentException {
            try {
                PipelineConfiguration pipe = this.controller.makePipelineConfiguration();
                this.setPipelineConfiguration(pipe);
                SequenceReceiver out = this.controller.getConfiguration().getSerializerFactory().getReceiver(result, pipe, new Properties());
                Receiver in = this.controller.getStreamingReceiver(this.controller.getInitialMode(), out);
                this.setReceiver(in);
            }
            catch (XPathException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public void setSystemId(String systemID) {
            this.systemId = systemID;
        }

        public String getSystemId() {
            return this.systemId;
        }

        public Transformer getTransformer() {
            return StreamingTransformerImpl.this;
        }
    }
}

