/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.jaxp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.JPConverter;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.jaxp.IdentityTransformer;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.s9api.DOMDestination;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SAXDestination;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.JavaExternalObjectType;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.UntypedAtomicValue;
import org.w3c.dom.Node;

abstract class AbstractTransformerImpl
extends IdentityTransformer {
    private XsltExecutable xsltExecutable;
    private Map<String, Object> parameters = new HashMap<String, Object>(8);

    protected AbstractTransformerImpl(XsltExecutable e) {
        super(e.getProcessor().getUnderlyingConfiguration());
        this.xsltExecutable = e;
    }

    protected Destination makeDestination(final Result outputTarget) throws XPathException {
        Destination destination;
        if (outputTarget instanceof StreamResult) {
            StreamResult sr = (StreamResult)outputTarget;
            if (sr.getOutputStream() != null) {
                destination = this.xsltExecutable.getProcessor().newSerializer(sr.getOutputStream());
            } else if (sr.getWriter() != null) {
                destination = this.xsltExecutable.getProcessor().newSerializer(sr.getWriter());
            } else if (sr.getSystemId() != null) {
                FileOutputStream stream;
                URI uri;
                try {
                    uri = new URI(sr.getSystemId());
                }
                catch (URISyntaxException e) {
                    throw new XPathException("System ID in Result object is not a valid URI: " + sr.getSystemId(), e);
                }
                if (!uri.isAbsolute()) {
                    try {
                        uri = new File(sr.getSystemId()).getAbsoluteFile().toURI();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                File file = new File(uri);
                try {
                    if ("file".equals(uri.getScheme()) && !file.exists()) {
                        File directory = file.getParentFile();
                        if (directory != null && !directory.exists()) {
                            directory.mkdirs();
                        }
                        file.createNewFile();
                    }
                }
                catch (IOException err) {
                    throw new XPathException("Failed to create output file " + uri, err);
                }
                try {
                    stream = new FileOutputStream(file);
                }
                catch (FileNotFoundException e) {
                    throw new XPathException("Failed to create output file", e);
                }
                destination = this.xsltExecutable.getProcessor().newSerializer(stream);
                ((Serializer)destination).setCloseOnCompletion(true);
            } else {
                throw new IllegalArgumentException("StreamResult supplies neither an OutputStream nor a Writer");
            }
            Properties localOutputProperties = this.getLocalOutputProperties();
            for (String key : localOutputProperties.stringPropertyNames()) {
                ((Serializer)destination).setOutputProperty(QName.fromClarkName(key), localOutputProperties.getProperty(key));
            }
        } else if (outputTarget instanceof SAXResult) {
            destination = new SAXDestination(((SAXResult)outputTarget).getHandler());
        } else if (outputTarget instanceof DOMResult) {
            Node root = ((DOMResult)outputTarget).getNode();
            if (root == null) {
                try {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    dbf.setNamespaceAware(true);
                    root = dbf.newDocumentBuilder().newDocument();
                    ((DOMResult)outputTarget).setNode(root);
                }
                catch (ParserConfigurationException e) {
                    throw new XPathException(e);
                }
            }
            destination = new DOMDestination(root);
        } else if (outputTarget instanceof Receiver) {
            destination = new Destination(){

                public Receiver getReceiver(Configuration config) throws SaxonApiException {
                    return (Receiver)outputTarget;
                }

                public void close() throws SaxonApiException {
                    try {
                        ((Receiver)outputTarget).close();
                    }
                    catch (XPathException e) {
                        throw new SaxonApiException(e);
                    }
                }
            };
        } else {
            return null;
        }
        return destination;
    }

    public void setParameter(String name, Object value) {
        Sequence converted;
        if (name == null) {
            throw new NullPointerException("Transformer.setParameter() - name is null");
        }
        if (value == null) {
            throw new NullPointerException("Transformer.setParameter() - value is null");
        }
        this.parameters.put(name, value);
        QName qName = QName.fromClarkName(name);
        XsltExecutable.ParameterDetails details = this.xsltExecutable.getGlobalParameters().get(qName);
        if (details == null) {
            return;
        }
        Configuration config = this.getConfiguration();
        SequenceType required = details.getUnderlyingDeclaredType();
        try {
            if (value instanceof Sequence) {
                converted = (ObjectValue<Object>)value;
            } else if (value instanceof String) {
                converted = new UntypedAtomicValue((String)value);
            } else if (required.getPrimaryType() instanceof JavaExternalObjectType) {
                converted = new ObjectValue<Object>(value);
            } else {
                JPConverter converter = JPConverter.allocate(value.getClass(), null, config);
                XPathContextMajor context = this.getUnderlyingController().newXPathContext();
                converted = converter.convert(value, context);
            }
            if (converted == null) {
                converted = EmptySequence.getInstance();
            }
            if (required != null && !required.matches(converted, config.getTypeHierarchy())) {
                RoleDiagnostic role = new RoleDiagnostic(3, qName.toString(), -1);
                converted = config.getTypeHierarchy().applyFunctionConversionRules(converted, required, role, ExplicitLocation.UNKNOWN_LOCATION);
            }
        }
        catch (XPathException e) {
            throw new IllegalArgumentException(e);
        }
        this.setConvertedParameter(qName, XdmValue.wrap(converted));
    }

    protected abstract void setConvertedParameter(QName var1, XdmValue var2);

    public Object getParameter(String name) {
        return this.parameters.get(name);
    }

    public void clearParameters() {
        this.parameters.clear();
    }

    protected Properties getStylesheetOutputProperties() {
        return this.xsltExecutable.getUnderlyingCompiledStylesheet().getDefaultOutputProperties();
    }

    public XsltExecutable getUnderlyingXsltExecutable() {
        return this.xsltExecutable;
    }

    public abstract Controller getUnderlyingController();
}

