/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AbsolutePath;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.SchemaType;

public class ValidationException
extends XPathException
implements Location {
    private String systemId;
    private String publicId;
    private int lineNumber = -1;
    private int columnNumber = -1;
    private NodeInfo node;
    private int schemaPart = -1;
    private String constraintName;
    private String constraintClauseNumber;
    private AbsolutePath path;
    private AbsolutePath contextPath;
    private SchemaType type;

    public ValidationException(String message) {
        super(message);
    }

    public ValidationException(Exception exception) {
        super(exception);
    }

    public ValidationException(String message, Exception exception) {
        super(message, exception);
    }

    public ValidationException(String message, Location locator) {
        super(message, null, locator);
    }

    public void setConstraintReference(int schemaPart, String constraintName, String clause) {
        this.schemaPart = schemaPart;
        this.constraintName = constraintName;
        this.constraintClauseNumber = clause;
    }

    public void setConstraintReference(ValidationException e) {
        this.schemaPart = e.schemaPart;
        this.constraintName = e.constraintName;
        this.constraintClauseNumber = e.constraintClauseNumber;
    }

    public String getConstraintReferenceMessage() {
        if (this.schemaPart == -1) {
            return null;
        }
        return "See http://www.w3.org/TR/xmlschema11-" + this.schemaPart + "/#" + this.constraintName + " clause " + this.constraintClauseNumber;
    }

    public int getConstraintSchemaPart() {
        return this.schemaPart;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public String getConstraintClauseNumber() {
        return this.constraintClauseNumber;
    }

    public String getConstraintReference() {
        return (this.constraintName == null ? "" : this.constraintName) + '.' + (this.constraintClauseNumber == null ? "" : this.constraintClauseNumber);
    }

    public void setPath(AbsolutePath path) {
        this.path = path;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ValidationException: ");
        String message = this.getMessage();
        if (message != null) {
            sb.append(message);
        }
        return sb.toString();
    }

    public String getPublicId() {
        Location loc = this.getLocator();
        if (this.publicId == null && loc != null && loc != this) {
            return loc.getPublicId();
        }
        return this.publicId;
    }

    public String getSystemId() {
        Location loc = this.getLocator();
        if (this.systemId == null && loc != null && loc != this) {
            return loc.getSystemId();
        }
        return this.systemId;
    }

    public int getLineNumber() {
        Location loc = this.getLocator();
        if (this.lineNumber == -1 && loc != null && loc != this) {
            return loc.getLineNumber();
        }
        return this.lineNumber;
    }

    public int getColumnNumber() {
        Location loc = this.getLocator();
        if (this.columnNumber == -1 && loc != null && loc != this) {
            return loc.getColumnNumber();
        }
        return this.columnNumber;
    }

    public Location saveLocation() {
        return new ExplicitLocation(this);
    }

    public NodeInfo getNode() {
        return this.node;
    }

    public String getPath() {
        if (this.path != null) {
            return this.path.getPathUsingAbbreviatedUris();
        }
        if (this.node != null) {
            return Navigator.getPath(this.node);
        }
        return null;
    }

    public AbsolutePath getAbsolutePath() {
        if (this.path != null) {
            return this.path;
        }
        if (this.node != null) {
            return Navigator.getAbsolutePath(this.node);
        }
        return null;
    }

    public void setPublicId(String id) {
        this.publicId = id;
    }

    public void setSystemId(String id) {
        this.systemId = id;
    }

    public void setLineNumber(int line) {
        this.lineNumber = line;
    }

    public void setColumnNumber(int column) {
        this.columnNumber = column;
    }

    public void setLocation(Location locator) {
        if (locator != null) {
            this.setPublicId(locator.getPublicId());
            this.setSystemId(locator.getSystemId());
            this.setLineNumber(locator.getLineNumber());
            this.setColumnNumber(locator.getColumnNumber());
            if (locator instanceof NodeInfo) {
                this.node = (NodeInfo)locator;
            }
        }
        super.setLocator(null);
    }

    public void setNode(NodeInfo node) {
        this.node = node;
    }

    public Location getLocator() {
        Location loc = super.getLocator();
        if (loc != null) {
            return loc;
        }
        return this;
    }

    public void setContextPath(AbsolutePath path) {
        this.contextPath = path;
    }

    public AbsolutePath getContextPath() {
        return this.contextPath;
    }

    public String getValidationLocationText() {
        FastStringBuffer fsb = new FastStringBuffer(256);
        AbsolutePath valPath = this.getAbsolutePath();
        if (valPath != null) {
            fsb.append("Validating ");
            fsb.append(valPath.getPathUsingPrefixes());
            if (valPath.getSystemId() != null) {
                fsb.append(" in ");
                fsb.append(valPath.getSystemId());
            }
        }
        return fsb.toString();
    }

    public String getContextLocationText() {
        FastStringBuffer fsb = new FastStringBuffer(256);
        AbsolutePath contextPath = this.getContextPath();
        if (contextPath != null) {
            fsb.append("Currently processing ");
            fsb.append(contextPath.getPathUsingPrefixes());
            if (contextPath.getSystemId() != null) {
                fsb.append(" in ");
                fsb.append(contextPath.getSystemId());
            }
        }
        return fsb.toString();
    }

    public SchemaType getSchemaType() {
        return this.type;
    }

    public void setSchemaType(SchemaType type) {
        this.type = type;
    }
}

