/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xpath;

import javax.xml.xpath.XPathVariableResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.JPConverter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.EmptySequence;

public class JAXPVariableReference
extends Expression
implements Callable {
    private StructuredQName name;
    private XPathVariableResolver resolver;

    public JAXPVariableReference(StructuredQName name, XPathVariableResolver resolver) {
        this.name = name;
        this.resolver = resolver;
    }

    public String getExpressionName() {
        return "$" + this.name.getDisplayName();
    }

    public Expression copy() {
        return new JAXPVariableReference(this.name, this.resolver);
    }

    public ItemType getItemType() {
        return AnyItemType.getInstance();
    }

    public int computeCardinality() {
        return 57344;
    }

    public int computeSpecialProperties() {
        return 0x400000;
    }

    public int getImplementationMethod() {
        return 2;
    }

    public boolean equals(Object other) {
        return other instanceof JAXPVariableReference && ((JAXPVariableReference)other).name.equals(this.name) && ((JAXPVariableReference)other).resolver == this.resolver;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        Configuration config = context.getConfiguration();
        Object value = this.resolver.resolveVariable(this.name.toJaxpQName());
        if (value == null) {
            return EmptySequence.getInstance();
        }
        JPConverter converter = JPConverter.allocate(value.getClass(), null, config);
        return converter.convert(value, context);
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return this.call(context, null).iterate();
    }

    public String toString() {
        return this.getExpressionName();
    }

    public void export(ExpressionPresenter destination) {
        destination.startElement("jaxpVar", this);
        destination.emitAttribute("name", this.name.getEQName());
        destination.endElement();
    }
}

