/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.DocumentFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Doc
extends SystemFunction
implements Callable {
    private boolean readOnce = false;
    private ParseOptions parseOptions;

    public void setReadOnce(boolean once) {
        this.readOnce = once;
    }

    public boolean isReadOnce() {
        return this.readOnce;
    }

    public ParseOptions getParseOptions() {
        return this.parseOptions;
    }

    public void setParseOptions(ParseOptions parseOptions) {
        this.parseOptions = parseOptions;
    }

    @Override
    public int getCardinality(Expression[] arguments) {
        return arguments[0].getCardinality() & 0xFFFF7FFF;
    }

    @Override
    public ZeroOrOne<NodeInfo> call(XPathContext context, Sequence[] arguments) throws XPathException {
        AtomicValue hrefVal = (AtomicValue)arguments[0].head();
        if (hrefVal == null) {
            return ZeroOrOne.empty();
        }
        String href = hrefVal.getStringValue();
        NodeInfo item = DocumentFn.makeDoc(href, this.getRetainedStaticContext().getStaticBaseUriString(), null, context, null, false);
        if (item == null) {
            throw new XPathException("Failed to load document " + href, "FODC0002", context);
        }
        return new ZeroOrOne<NodeInfo>(item);
    }

    @Override
    public int getSpecialProperties(Expression[] arguments) {
        return 0xCA0000;
    }

    public void sendDocument(XPathContext context, Expression[] args, Receiver out) throws XPathException {
        AtomicValue hrefVal = (AtomicValue)args[0].evaluateItem(context);
        if (hrefVal == null) {
            return;
        }
        String href = hrefVal.getStringValue();
        ParseOptions options = this.parseOptions;
        if (options == null) {
            options = context.getConfiguration().getParseOptions();
        }
        try {
            DocumentFn.sendDoc(href, this.getStaticBaseUriString(), context, null, out, options);
        }
        catch (XPathException e) {
            if (e.getErrorCodeQName() == null) {
                e.setErrorCode("FODC0002");
            }
            throw e;
        }
    }
}

