/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.LocalBinding;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalParam
implements LocalBinding,
SourceLocator {
    private Expression conversion = null;
    private int conversionEvaluationMode = -1;
    private static final int REQUIRED = 4;
    private static final int TUNNEL = 8;
    private static final int IMPLICITLY_REQUIRED = 16;
    private byte properties = 0;
    Expression select = null;
    protected StructuredQName variableQName;
    SequenceType requiredType;
    protected int slotNumber = -999;
    protected int referenceCount = 10;
    protected int evaluationMode = -1;
    private Location locationId = ExplicitLocation.UNKNOWN_LOCATION;

    public LocalParam(PackageData pd) {
    }

    public void setLocationId(Location id) {
        this.locationId = id;
    }

    public final Location getLocationId() {
        return this.locationId;
    }

    @Override
    public int getLineNumber() {
        return this.locationId.getLineNumber();
    }

    @Override
    public int getColumnNumber() {
        return this.locationId.getColumnNumber();
    }

    @Override
    public String getSystemId() {
        return this.locationId.getSystemId();
    }

    @Override
    public final String getPublicId() {
        return null;
    }

    public void setSelectExpression(Expression select) {
        this.select = select;
        this.evaluationMode = -1;
    }

    public Expression getSelectExpression() {
        return this.select;
    }

    public void setRequiredType(SequenceType required) {
        this.requiredType = required;
    }

    @Override
    public SequenceType getRequiredType() {
        return this.requiredType;
    }

    public void setRequiredParam(boolean requiredParam) {
        this.properties = requiredParam ? (byte)(this.properties | 4) : (byte)(this.properties & 0xFFFFFFFB);
    }

    public void setImplicitlyRequiredParam(boolean requiredParam) {
        this.properties = requiredParam ? (byte)(this.properties | 0x10) : (byte)(this.properties & 0xFFFFFFEF);
    }

    public void setTunnel(boolean tunnel) {
        this.properties = tunnel ? (byte)(this.properties | 8) : (byte)(this.properties & 0xFFFFFFF7);
    }

    public void setReferenceCount(int refCount) {
        this.referenceCount = refCount;
    }

    public int getEvaluationMode() {
        if (this.evaluationMode == -1) {
            this.evaluationMode = this.referenceCount == 10000 ? 12 : ExpressionTool.lazyEvaluationMode(this.select);
        }
        return this.evaluationMode;
    }

    public int getCardinality() {
        return 8192;
    }

    @Override
    public boolean isAssignable() {
        return false;
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public int getLocalSlotNumber() {
        return this.slotNumber;
    }

    public final boolean isRequiredParam() {
        return (this.properties & 4) != 0;
    }

    public final boolean isImplicitlyRequiredParam() {
        return (this.properties & 0x10) != 0;
    }

    public final boolean isTunnelParam() {
        return (this.properties & 8) != 0;
    }

    public void simplify(StaticContext env) throws XPathException {
        if (this.select != null) {
            this.select = this.select.simplify();
        }
    }

    public void typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        if (this.select != null) {
            this.select = this.select.typeCheck(visitor, contextItemType);
        }
        this.checkAgainstRequiredType(visitor);
    }

    public void optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        if (this.select != null) {
            this.select = this.select.optimize(visitor, contextItemType);
            this.computeEvaluationMode();
        }
    }

    public void computeEvaluationMode() {
        this.evaluationMode = this.isAssignable() ? ExpressionTool.eagerEvaluationMode(this.select) : (this.referenceCount == 10000 ? 12 : ExpressionTool.lazyEvaluationMode(this.select));
    }

    public Expression copy() {
        throw new UnsupportedOperationException("GeneralVariable.copy()");
    }

    @Override
    public void addReference(boolean isLoopingReference) {
    }

    public void checkAgainstRequiredType(ExpressionVisitor visitor) throws XPathException {
        RoleDiagnostic role = new RoleDiagnostic(3, this.variableQName.getDisplayName(), 0);
        SequenceType r = this.requiredType;
        if (r != null && this.select != null) {
            this.select = TypeChecker.staticTypeCheck(this.select, this.requiredType, false, role, visitor);
        }
    }

    public Sequence getSelectValue(XPathContext context) throws XPathException {
        if (this.select == null) {
            throw new AssertionError((Object)"Internal error: No select expression");
        }
        if (this.select instanceof Literal) {
            return ((Literal)this.select).getValue();
        }
        int savedOutputState = context.getTemporaryOutputState();
        context.setTemporaryOutputState(208);
        Sequence result = ExpressionTool.evaluate(this.select, this.evaluationMode, context, this.referenceCount);
        context.setTemporaryOutputState(savedOutputState);
        return result;
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public void setSlotNumber(int s) {
        this.slotNumber = s;
    }

    public void setVariableQName(StructuredQName s) {
        this.variableQName = s;
    }

    @Override
    public StructuredQName getVariableQName() {
        return this.variableQName;
    }

    public void setConversion(Expression convertor) {
        this.conversion = convertor;
        if (convertor != null) {
            this.conversionEvaluationMode = ExpressionTool.eagerEvaluationMode(this.conversion);
        }
    }

    public Expression getConversion() {
        return this.conversion;
    }

    public int getConversionEvaluationMode() {
        return this.conversionEvaluationMode;
    }

    public int getInstructionNameCode() {
        return 189;
    }

    public Iterable<Operand> operands(Expression parent) {
        ArrayList<Operand> list = new ArrayList<Operand>();
        if (this.select != null) {
            list.add(new Operand(parent, this.select, OperandRole.NAVIGATE));
        }
        if (this.conversion != null) {
            list.add(new Operand(parent, this.conversion, OperandRole.SINGLE_ATOMIC));
        }
        return list;
    }

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.select == original) {
            this.select = replacement;
            found = true;
        }
        if (this.conversion == original) {
            this.conversion = replacement;
            found = true;
        }
        return found;
    }

    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        int wasSupplied = context.useLocalParameter(this.variableQName, this.slotNumber, this.isTunnelParam());
        switch (wasSupplied) {
            case 2: {
                break;
            }
            case 1: {
                if (this.conversion == null) break;
                context.setLocalVariable(this.slotNumber, ExpressionTool.evaluate(this.conversion, this.conversionEvaluationMode, context, 10));
                break;
            }
            case 0: {
                if (this.isImplicitlyRequiredParam()) {
                    String name = "$" + this.getVariableQName().getDisplayName();
                    XPathException e = new XPathException("A value must be supplied for parameter " + name + " because " + "the default value is not a valid instance of the required type");
                    e.setXPathContext(context);
                    e.setErrorCode("XTDE0700");
                    throw e;
                }
                if (this.isRequiredParam()) {
                    String name = "$" + this.getVariableQName().getDisplayName();
                    XPathException e = new XPathException("No value supplied for required parameter " + name);
                    e.setXPathContext(context);
                    e.setErrorCode("XTDE0700");
                    throw e;
                }
                context.setLocalVariable(this.slotNumber, this.getSelectValue(context));
            }
        }
        return null;
    }

    @Override
    public IntegerValue[] getIntegerBoundsForVariable() {
        return null;
    }

    @Override
    public Sequence evaluateVariable(XPathContext c) {
        return c.evaluateLocalVariable(this.slotNumber);
    }

    public boolean isCompatible(LocalParam other) {
        if (!this.getVariableQName().equals(other.getVariableQName())) {
            return false;
        }
        if (!this.getRequiredType().equals(other.getRequiredType())) {
            return false;
        }
        return this.isTunnelParam() == other.isTunnelParam();
    }
}

