/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.LocalBinding;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;

public abstract class VariableReference
extends Expression
implements BindingReference {
    protected Binding binding = null;
    protected SequenceType staticType = null;
    protected GroundedValue constantValue = null;
    private StructuredQName variableName = null;
    private boolean flattened = false;
    private boolean inLoop = true;
    private boolean filtered = false;

    public VariableReference(StructuredQName name) {
        this.variableName = name;
    }

    public VariableReference(Binding binding) {
        this.variableName = binding.getVariableQName();
        this.fixup(binding);
    }

    public void setVariableName(StructuredQName name) {
        this.variableName = name;
    }

    public StructuredQName getVariableName() {
        return this.variableName;
    }

    public abstract Expression copy();

    protected void copyFrom(VariableReference ref) {
        this.binding = ref.binding;
        this.staticType = ref.staticType;
        this.constantValue = ref.constantValue;
        this.variableName = ref.variableName;
        this.flattened = ref.flattened;
        this.inLoop = ref.inLoop;
        this.filtered = ref.filtered;
        ExpressionTool.copyLocationInfo(ref, this);
    }

    public void setStaticType(SequenceType type, GroundedValue value, int properties) {
        if (type == null) {
            type = SequenceType.ANY_SEQUENCE;
        }
        this.staticType = type;
        this.constantValue = value;
        int dependencies = this.getDependencies();
        this.staticProperties = properties & 0xFFFEFFFF | 0x400000 | type.getCardinality() | dependencies;
    }

    public void setFlattened(boolean flattened) {
        this.flattened = flattened;
    }

    public boolean isFlattened() {
        return this.flattened;
    }

    public void setFiltered(boolean filtered) {
        this.filtered = filtered;
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public boolean isInLoop() {
        return this.inLoop;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        if (this.constantValue != null) {
            this.binding = null;
            return Literal.makeLiteral(this.constantValue);
        }
        this.inLoop = ExpressionTool.isLoopingReference(this, this.binding);
        if (this.binding != null) {
            this.binding.addReference(this.inLoop);
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        if (this.constantValue != null) {
            this.binding = null;
            return Literal.makeLiteral(this.constantValue);
        }
        return this;
    }

    public void fixup(Binding binding) {
        this.binding = binding;
        this.resetLocalStaticProperties();
    }

    public void refineVariableType(ItemType type, int cardinality, GroundedValue constantValue, int properties) {
        int newcard;
        ItemType oldItemType;
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        ItemType newItemType = oldItemType = this.getItemType();
        if (th.isSubType(type, oldItemType)) {
            newItemType = type;
        }
        if (oldItemType instanceof NodeTest && type instanceof AtomicType) {
            newItemType = type;
        }
        if ((newcard = cardinality & this.getCardinality()) == 0) {
            newcard = this.getCardinality();
        }
        SequenceType seqType = SequenceType.makeSequenceType(newItemType, newcard);
        this.setStaticType(seqType, constantValue, properties);
    }

    public ItemType getItemType() {
        if (this.staticType == null || this.staticType.getPrimaryType() == AnyItemType.getInstance()) {
            SequenceType st;
            if (this.binding != null && (st = this.binding.getRequiredType()) != null) {
                return st.getPrimaryType();
            }
            return AnyItemType.getInstance();
        }
        return this.staticType.getPrimaryType();
    }

    public IntegerValue[] getIntegerBounds() {
        if (this.binding != null) {
            return this.binding.getIntegerBoundsForVariable();
        }
        return null;
    }

    public int computeCardinality() {
        if (this.staticType == null) {
            if (this.binding == null) {
                return 57344;
            }
            if (this.binding instanceof LetExpression) {
                return this.binding.getRequiredType().getCardinality();
            }
            if (this.binding instanceof Assignation) {
                return 16384;
            }
            if (this.binding.getRequiredType() == null) {
                return 57344;
            }
            return this.binding.getRequiredType().getCardinality();
        }
        return this.staticType.getCardinality();
    }

    public int computeSpecialProperties() {
        Expression exp;
        int p = super.computeSpecialProperties();
        if (this.binding == null || !this.binding.isAssignable()) {
            p |= 0x400000;
        }
        if (this.binding instanceof Assignation && (exp = ((Assignation)this.binding).getSequence()) != null) {
            p |= exp.getSpecialProperties() & 0x2000000;
        }
        if (this.staticType != null && !Cardinality.allowsMany(this.staticType.getCardinality()) && this.staticType.getPrimaryType() instanceof NodeTest) {
            p |= 0x800000;
        }
        return p;
    }

    public boolean equals(Object other) {
        return other instanceof VariableReference && this.binding == ((VariableReference)other).binding && this.binding != null;
    }

    public int hashCode() {
        return this.binding == null ? 73619830 : this.binding.hashCode();
    }

    public int getIntrinsicDependencies() {
        int d = 0;
        if (this.binding == null) {
            d |= 0x680;
        } else if (this.binding.isGlobal()) {
            if (this.binding.isAssignable()) {
                d |= 0x200;
            }
            if (this.binding instanceof GlobalParam) {
                d |= 0x400;
            }
        } else {
            d |= 0x80;
        }
        return d;
    }

    public Expression promote(PromotionOffer offer) throws XPathException {
        return this;
    }

    public int getImplementationMethod() {
        return (Cardinality.allowsMany(this.getCardinality()) ? 0 : 1) | 2 | 4;
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        return pathMap.getPathForVariable(this.getBinding());
    }

    public SequenceIterator iterate(XPathContext c) throws XPathException {
        try {
            Sequence actual = this.evaluateVariable(c);
            return actual.iterate();
        }
        catch (XPathException err) {
            err.maybeSetLocation(this.getLocation());
            throw err;
        }
        catch (NullPointerException err) {
            String msg = "Internal error: no value for variable $" + this.getDisplayName() + " at line " + this.getLocation().getLineNumber() + (this.getSystemId() == null ? "" : " of " + this.getSystemId());
            StandardErrorListener.printStackTrace(c.getConfiguration().getLogger(), c);
            throw new AssertionError((Object)msg);
        }
        catch (AssertionError err) {
            ((Throwable)((Object)err)).printStackTrace();
            String msg = ((Throwable)((Object)err)).getMessage() + ". Variable reference $" + this.getDisplayName() + " at line " + this.getLocation().getLineNumber() + (this.getSystemId() == null ? "" : " of " + this.getSystemId());
            StandardErrorListener.printStackTrace(c.getConfiguration().getLogger(), c);
            throw new AssertionError((Object)msg);
        }
    }

    public Item evaluateItem(XPathContext c) throws XPathException {
        try {
            Sequence actual = this.evaluateVariable(c);
            return actual.head();
        }
        catch (XPathException err) {
            err.maybeSetLocation(this.getLocation());
            throw err;
        }
    }

    public void process(XPathContext c) throws XPathException {
        try {
            Item it;
            SequenceIterator iter = this.evaluateVariable(c).iterate();
            SequenceReceiver out = c.getReceiver();
            Location loc = this.getLocation();
            while ((it = iter.next()) != null) {
                out.append(it, loc, 2);
            }
        }
        catch (XPathException err) {
            err.maybeSetLocation(this.getLocation());
            throw err;
        }
    }

    public Sequence evaluateVariable(XPathContext c) throws XPathException {
        try {
            return this.binding.evaluateVariable(c);
        }
        catch (NullPointerException err) {
            if (this.binding == null) {
                throw new IllegalStateException("Variable $" + this.variableName.getDisplayName() + " has not been fixed up");
            }
            throw err;
        }
    }

    public Binding getBinding() {
        return this.binding;
    }

    public String getDisplayName() {
        if (this.binding != null) {
            return this.binding.getVariableQName().getDisplayName();
        }
        return this.variableName.getDisplayName();
    }

    public String getEQName() {
        if (this.binding != null) {
            StructuredQName q = this.binding.getVariableQName();
            if (q.hasURI("")) {
                return q.getLocalPart();
            }
            return q.getEQName();
        }
        return this.variableName.getEQName();
    }

    public boolean isCompatible(VariableReference other) {
        if (!this.getEQName().equals(other.getEQName())) {
            return false;
        }
        if (this.getItemType().getPrimitiveType() != other.getItemType().getPrimitiveType()) {
            return false;
        }
        return false;
    }

    public String toString() {
        String d = this.getEQName();
        return "$" + (d == null ? "$" : d);
    }

    public String toShortString() {
        return "$" + this.getDisplayName();
    }

    public void export(ExpressionPresenter destination) {
        destination.startElement("varRef", this);
        destination.emitAttribute("name", this.variableName);
        if (this.binding instanceof LocalBinding) {
            destination.emitAttribute("slot", "" + ((LocalBinding)this.binding).getLocalSlotNumber());
        }
        destination.endElement();
    }
}

