/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.arrays;

import java.util.ArrayList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.SimpleArrayItem;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.SequenceType;

public class ArrayForEachPair
extends ExtensionFunctionDefinition {
    private static final StructuredQName name = new StructuredQName("array", "http://www.w3.org/2005/xpath-functions/array", "for-each-pair");
    private static final SequenceType[] ARG_TYPES = new SequenceType[]{ArrayItem.SINGLE_ARRAY_TYPE, ArrayItem.SINGLE_ARRAY_TYPE, SequenceType.makeSequenceType(new SpecificFunctionType(new SequenceType[]{SequenceType.ANY_SEQUENCE, SequenceType.ANY_SEQUENCE}, SequenceType.ANY_SEQUENCE), 16384)};

    public StructuredQName getFunctionQName() {
        return name;
    }

    public int getMinimumNumberOfArguments() {
        return 3;
    }

    public SequenceType[] getArgumentTypes() {
        return ARG_TYPES;
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return ArrayItem.SINGLE_ARRAY_TYPE;
    }

    public boolean trustResultType() {
        return true;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new ExtensionFunctionCall(){

            public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
                ArrayItem array1 = (ArrayItem)arguments[0].head();
                assert (array1 != null);
                ArrayItem array2 = (ArrayItem)arguments[1].head();
                assert (array2 != null);
                Function fn = (Function)arguments[2].head();
                ArrayList<Sequence> list = new ArrayList<Sequence>(1);
                for (int i = 0; i < array1.size() && i < array2.size(); ++i) {
                    list.add(fn.call(context, new Sequence[]{array1.get(i), array2.get(i)}));
                }
                return new SimpleArrayItem(list);
            }
        };
    }
}

