/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sxpath;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.sxpath.AbstractStaticContext;
import net.sf.saxon.sxpath.XPathStaticContext;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.QNameValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndependentContext
extends AbstractStaticContext
implements XPathStaticContext,
NamespaceResolver,
Container {
    protected HashMap<String, String> namespaces = new HashMap(10);
    protected HashMap<StructuredQName, XPathVariable> variables = new HashMap(20);
    protected NamespaceResolver externalResolver = null;
    protected ItemType requiredContextItemType = AnyItemType.getInstance();
    protected Set<String> importedSchemaNamespaces = new HashSet<String>();
    protected boolean autoDeclare = false;
    protected Executable executable;
    protected PackageData packageData;

    public IndependentContext() {
        this(new Configuration());
    }

    public IndependentContext(Configuration config) {
        this.setConfiguration(config);
        this.clearNamespaces();
        this.setDefaultFunctionLibrary();
        this.usingDefaultFunctionLibrary = true;
        this.setDefaultCollationName(config.getDefaultCollationName());
        PackageData pd = new PackageData(config);
        pd.setHostLanguage(54);
        pd.setAllowXPath30(false);
        pd.setSchemaAware(false);
        pd.setLocationMap(this.getLocationMap());
    }

    public IndependentContext(IndependentContext ic) {
        this(ic.getConfiguration());
        this.setBaseURI(ic.getBaseURI());
        this.setLocationMap(ic.getLocationMap());
        this.setDefaultElementNamespace(ic.getDefaultElementNamespace());
        this.setDefaultFunctionNamespace(ic.getDefaultFunctionNamespace());
        this.setBackwardsCompatibilityMode(ic.isInBackwardsCompatibleMode());
        this.setSchemaAware(ic.isSchemaAware());
        this.namespaces = new HashMap<String, String>(ic.namespaces);
        this.variables = new HashMap(10);
        FunctionLibraryList libList = (FunctionLibraryList)ic.getFunctionLibrary();
        if (libList != null) {
            this.setFunctionLibrary((FunctionLibraryList)libList.copy());
        }
        this.setImportedSchemaNamespaces(ic.importedSchemaNamespaces);
        this.externalResolver = ic.externalResolver;
        this.autoDeclare = ic.autoDeclare;
        this.setXPathLanguageLevel(ic.getXPathLanguageLevel());
        this.requiredContextItemType = ic.requiredContextItemType;
        this.setExecutable(ic.getExecutable());
    }

    @Override
    public int getContainerGranularity() {
        return 1;
    }

    @Override
    public PackageData getPackageData() {
        if (this.packageData == null) {
            this.packageData = new PackageData(this.getConfiguration());
            this.packageData.setAllowXPath30(this.getXPathLanguageLevel().equals(DecimalValue.THREE));
            this.packageData.setHostLanguage(this.getHostLanguage());
            this.packageData.setLocationMap(this.getLocationMap());
            this.packageData.setSchemaAware(this.isSchemaAware());
        }
        return this.packageData;
    }

    public void declareNamespace(String prefix, String uri) {
        if (prefix == null) {
            throw new NullPointerException("Null prefix supplied to declareNamespace()");
        }
        if (uri == null) {
            throw new NullPointerException("Null namespace URI supplied to declareNamespace()");
        }
        if ("".equals(prefix)) {
            this.setDefaultElementNamespace(uri);
        } else {
            this.namespaces.put(prefix, uri);
        }
    }

    @Override
    public void setDefaultElementNamespace(String uri) {
        super.setDefaultElementNamespace(uri);
        this.namespaces.put("", uri);
    }

    public void clearNamespaces() {
        this.namespaces.clear();
        this.declareNamespace("xml", "http://www.w3.org/XML/1998/namespace");
        this.declareNamespace("xsl", "http://www.w3.org/1999/XSL/Transform");
        this.declareNamespace("saxon", "http://saxon.sf.net/");
        this.declareNamespace("xs", "http://www.w3.org/2001/XMLSchema");
        this.declareNamespace("", "");
    }

    public void clearAllNamespaces() {
        this.namespaces.clear();
        this.declareNamespace("xml", "http://www.w3.org/XML/1998/namespace");
        this.declareNamespace("", "");
    }

    public void setNamespaces(NodeInfo node) {
        this.namespaces.clear();
        int kind = node.getNodeKind();
        if (kind == 2 || kind == 3 || kind == 8 || kind == 7 || kind == 13) {
            node = node.getParent();
        }
        if (node == null) {
            return;
        }
        AxisIterator iter = node.iterateAxis((byte)8);
        NodeInfo ns;
        while ((ns = iter.next()) != null) {
            String prefix = ns.getLocalPart();
            if ("".equals(prefix)) {
                this.setDefaultElementNamespace(ns.getStringValue());
                continue;
            }
            this.declareNamespace(ns.getLocalPart(), ns.getStringValue());
        }
        return;
    }

    @Override
    public void setNamespaceResolver(NamespaceResolver resolver) {
        this.externalResolver = resolver;
    }

    public void setAllowUndeclaredVariables(boolean allow) {
        this.autoDeclare = allow;
    }

    public boolean isAllowUndeclaredVariables() {
        return this.autoDeclare;
    }

    @Override
    public XPathVariable declareVariable(QNameValue qname) {
        return this.declareVariable(qname.getStructuredQName());
    }

    @Override
    public XPathVariable declareVariable(String namespaceURI, String localName) {
        StructuredQName qName = new StructuredQName("", namespaceURI, localName);
        return this.declareVariable(qName);
    }

    public XPathVariable declareVariable(StructuredQName qName) {
        XPathVariable var = this.variables.get(qName);
        if (var != null) {
            return var;
        }
        var = XPathVariable.make(qName);
        int slot = this.variables.size();
        var.setSlotNumber(slot);
        this.variables.put(qName, var);
        return var;
    }

    public Iterator<XPathVariable> iterateExternalVariables() {
        return this.variables.values().iterator();
    }

    public XPathVariable getExternalVariable(StructuredQName qName) {
        return this.variables.get(qName);
    }

    public int getSlotNumber(QNameValue qname) {
        StructuredQName sq = qname.getStructuredQName();
        XPathVariable var = this.variables.get(sq);
        if (var == null) {
            return -1;
        }
        return var.getLocalSlotNumber();
    }

    @Override
    public String getURIForPrefix(String prefix) throws XPathException {
        String uri = this.getURIForPrefix(prefix, false);
        if (uri == null) {
            throw new XPathException("Prefix " + prefix + " has not been declared", "XPST0081");
        }
        return uri;
    }

    @Override
    public NamespaceResolver getNamespaceResolver() {
        if (this.externalResolver != null) {
            return this.externalResolver;
        }
        return this;
    }

    @Override
    public String getURIForPrefix(String prefix, boolean useDefault) {
        if (this.externalResolver != null) {
            return this.externalResolver.getURIForPrefix(prefix, useDefault);
        }
        if (prefix.length() == 0) {
            return useDefault ? this.getDefaultElementNamespace() : "";
        }
        return this.namespaces.get(prefix);
    }

    @Override
    public Iterator<String> iteratePrefixes() {
        if (this.externalResolver != null) {
            return this.externalResolver.iteratePrefixes();
        }
        return this.namespaces.keySet().iterator();
    }

    @Override
    public Expression bindVariable(StructuredQName qName) throws XPathException {
        XPathVariable var = this.variables.get(qName);
        if (var == null) {
            if (this.autoDeclare) {
                return new LocalVariableReference(this.declareVariable(qName));
            }
            throw new XPathException("Undeclared variable in XPath expression: $" + qName.getClarkName(), "XPST0008");
        }
        return new LocalVariableReference(var);
    }

    @Override
    public SlotManager getStackFrameMap() {
        SlotManager map = this.getConfiguration().makeSlotManager();
        XPathVariable[] va = new XPathVariable[this.variables.size()];
        XPathVariable[] xPathVariableArray = this.variables.values().iterator();
        while (xPathVariableArray.hasNext()) {
            XPathVariable var;
            va[var.getLocalSlotNumber()] = var = xPathVariableArray.next();
        }
        for (XPathVariable v : va) {
            map.allocateSlotNumber(v.getVariableQName());
        }
        return map;
    }

    @Override
    public boolean isImportedSchema(String namespace) {
        return this.importedSchemaNamespaces.contains(namespace);
    }

    @Override
    public Set<String> getImportedSchemaNamespaces() {
        return this.importedSchemaNamespaces;
    }

    public void setImportedSchemaNamespaces(Set<String> namespaces) {
        this.importedSchemaNamespaces = namespaces;
        if (!namespaces.isEmpty()) {
            this.setSchemaAware(true);
        }
    }

    @Override
    public void setSchemaAware(boolean aware) {
        super.setSchemaAware(aware);
        if (this.packageData != null) {
            this.packageData.setSchemaAware(aware);
        }
    }

    public void setRequiredContextItemType(ItemType type) {
        this.requiredContextItemType = type;
    }

    @Override
    public ItemType getRequiredContextItemType() {
        return this.requiredContextItemType;
    }

    public void setExecutable(Executable exec) {
        this.executable = exec;
    }

    public Executable getExecutable() {
        return this.executable;
    }
}

