/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.util.Properties;
import javax.xml.transform.Result;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.serialize.CharacterMapIndex;
import net.sf.saxon.trans.XPathException;

public class ReconfigurableSerializer
extends ProxyReceiver {
    private Result destination;
    private Properties apiDefinedProperties;

    public ReconfigurableSerializer(Receiver next, Properties apiDefinedProperties, Result destination) {
        super(next);
        this.destination = destination;
        this.apiDefinedProperties = apiDefinedProperties;
    }

    public void reconfigure(Properties outputProperties, CharacterMapIndex charMapIndex) throws XPathException {
        SerializerFactory sf = this.getConfiguration().getSerializerFactory();
        Properties combinedProps = new Properties(outputProperties);
        for (String s : this.apiDefinedProperties.stringPropertyNames()) {
            combinedProps.setProperty(s, this.apiDefinedProperties.getProperty(s));
        }
        Receiver r = sf.getReceiver(this.destination, this.getPipelineConfiguration(), combinedProps, charMapIndex);
        this.setUnderlyingReceiver(r);
    }
}

