/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.wrapper;

import net.sf.saxon.Configuration;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.tree.wrapper.VirtualNode;
import net.sf.saxon.type.SchemaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVirtualNode
implements VirtualNode {
    protected NodeInfo node;
    protected AbstractVirtualNode parent;
    protected AbstractVirtualNode docWrapper;

    @Override
    public Item head() {
        return this;
    }

    public SequenceIterator<NodeInfo> iterate() {
        return SingletonIterator.makeIterator(this);
    }

    @Override
    public NodeInfo getUnderlyingNode() {
        return this.node;
    }

    @Override
    public Object getRealNode() {
        Object u = this;
        while ((u = ((VirtualNode)u).getUnderlyingNode()) instanceof VirtualNode) {
        }
        return u;
    }

    @Override
    public Configuration getConfiguration() {
        return this.node.getConfiguration();
    }

    @Override
    public NamePool getNamePool() {
        return this.node.getNamePool();
    }

    @Override
    public int getNodeKind() {
        return this.node.getNodeKind();
    }

    @Override
    public AtomicSequence atomize() throws XPathException {
        return this.node.atomize();
    }

    @Override
    public int getTypeAnnotation() {
        return this.node.getTypeAnnotation();
    }

    @Override
    public SchemaType getSchemaType() {
        return this.node.getSchemaType();
    }

    @Override
    public boolean isSameNodeInfo(NodeInfo other) {
        if (other instanceof AbstractVirtualNode) {
            return this.node.isSameNodeInfo(((AbstractVirtualNode)other).node);
        }
        return this.node.isSameNodeInfo(other);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof NodeInfo && this.isSameNodeInfo((NodeInfo)other);
    }

    @Override
    public int hashCode() {
        return ((Object)this.node).hashCode() ^ 0x3C3C3C3C;
    }

    @Override
    public String getSystemId() {
        return this.node.getSystemId();
    }

    @Override
    public void setSystemId(String uri) {
        this.node.setSystemId(uri);
    }

    @Override
    public String getBaseURI() {
        return this.node.getBaseURI();
    }

    @Override
    public int getLineNumber() {
        return this.node.getLineNumber();
    }

    @Override
    public int getColumnNumber() {
        return this.node.getColumnNumber();
    }

    @Override
    public int compareOrder(NodeInfo other) {
        if (other instanceof AbstractVirtualNode) {
            return this.node.compareOrder(((AbstractVirtualNode)other).node);
        }
        return this.node.compareOrder(other);
    }

    @Override
    public int comparePosition(NodeInfo other) {
        if (other instanceof AbstractVirtualNode) {
            return this.node.comparePosition(((AbstractVirtualNode)other).node);
        }
        return this.node.comparePosition(other);
    }

    @Override
    public final String getStringValue() {
        return ((Object)this.getStringValueCS()).toString();
    }

    @Override
    public CharSequence getStringValueCS() {
        return this.node.getStringValueCS();
    }

    @Override
    public int getNameCode() {
        return this.node.getNameCode();
    }

    @Override
    public int getFingerprint() {
        return this.node.getFingerprint();
    }

    @Override
    public String getLocalPart() {
        return this.node.getLocalPart();
    }

    @Override
    public String getURI() {
        return this.node.getURI();
    }

    @Override
    public String getPrefix() {
        return this.node.getPrefix();
    }

    @Override
    public String getDisplayName() {
        return this.node.getDisplayName();
    }

    @Override
    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        return new Navigator.AxisFilter(this.iterateAxis(axisNumber), nodeTest);
    }

    @Override
    public String getAttributeValue(String uri, String local) {
        return this.node.getAttributeValue(uri, local);
    }

    @Override
    public NodeInfo getRoot() {
        return this.docWrapper;
    }

    @Override
    public DocumentInfo getDocumentRoot() {
        return (DocumentInfo)((Object)this.docWrapper);
    }

    @Override
    public boolean hasChildNodes() {
        return this.node.hasChildNodes();
    }

    @Override
    public void generateId(FastStringBuffer buffer) {
        this.node.generateId(buffer);
    }

    @Override
    public long getDocumentNumber() {
        return this.docWrapper.getDocumentNumber();
    }

    @Override
    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] buffer) {
        return this.node.getDeclaredNamespaces(buffer);
    }

    @Override
    public boolean isId() {
        return this.node.isId();
    }

    @Override
    public boolean isIdref() {
        return this.node.isIdref();
    }

    @Override
    public boolean isNilled() {
        return this.node.isNilled();
    }
}

