/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.wrapper;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.NamespaceNode;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyAxisIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.tree.wrapper.VirtualNode;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNodeWrapper
implements NodeInfo,
VirtualNode {
    @Override
    public final NodeInfo head() {
        return this;
    }

    public SequenceIterator<NodeInfo> iterate() {
        return SingletonIterator.makeIterator(this);
    }

    @Override
    public final Object getRealNode() {
        return this.getUnderlyingNode();
    }

    @Override
    public Configuration getConfiguration() {
        return this.getDocumentRoot().getConfiguration();
    }

    @Override
    public NamePool getNamePool() {
        return this.getConfiguration().getNamePool();
    }

    @Override
    public AtomicSequence atomize() {
        switch (this.getNodeKind()) {
            case 7: 
            case 8: {
                return new StringValue(this.getStringValueCS());
            }
        }
        return new UntypedAtomicValue(this.getStringValueCS());
    }

    @Override
    public int getTypeAnnotation() {
        SchemaType st = this.getSchemaType();
        return st == null ? -1 : st.getFingerprint();
    }

    @Override
    public SchemaType getSchemaType() {
        if (this.getNodeKind() == 2) {
            return BuiltInAtomicType.UNTYPED_ATOMIC;
        }
        return Untyped.getInstance();
    }

    @Override
    public boolean isSameNodeInfo(NodeInfo other) {
        if (!(other instanceof AbstractNodeWrapper)) {
            return false;
        }
        AbstractNodeWrapper ow = (AbstractNodeWrapper)other;
        return this.getUnderlyingNode().equals(ow.getUnderlyingNode());
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof NodeInfo && this.isSameNodeInfo((NodeInfo)other);
    }

    @Override
    public int hashCode() {
        return this.getUnderlyingNode().hashCode();
    }

    @Override
    public String getSystemId() {
        return this.getDocumentRoot().getSystemId();
    }

    @Override
    public void setSystemId(String uri) {
        this.getDocumentRoot().setSystemId(uri);
    }

    @Override
    public String getBaseURI() {
        if (this.getNodeKind() == 13) {
            return null;
        }
        NodeInfo n = this;
        if (this.getNodeKind() != 1) {
            n = this.getParent();
        }
        while (n != null) {
            String xmlbase = n.getAttributeValue("http://www.w3.org/XML/1998/namespace", "base");
            if (xmlbase != null) {
                return xmlbase;
            }
            n = n.getParent();
        }
        return this.getDocumentRoot().getBaseURI();
    }

    @Override
    public int getLineNumber() {
        return -1;
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }

    @Override
    public int comparePosition(NodeInfo other) {
        return Navigator.comparePosition(this, other);
    }

    @Override
    public String getStringValue() {
        return ((Object)this.getStringValueCS()).toString();
    }

    @Override
    public int getNameCode() {
        switch (this.getNodeKind()) {
            case 1: 
            case 2: 
            case 7: 
            case 13: {
                return this.getNamePool().allocate(this.getPrefix(), this.getURI(), this.getLocalPart());
            }
        }
        return -1;
    }

    @Override
    public int getFingerprint() {
        int nc = this.getNameCode();
        if (nc == -1) {
            return -1;
        }
        return nc & 0xFFFFF;
    }

    @Override
    public String getDisplayName() {
        String prefix = this.getPrefix();
        String local = this.getLocalPart();
        if (prefix.length() == 0) {
            return local;
        }
        return prefix + ":" + local;
    }

    @Override
    public String getAttributeValue(String uri, String local) {
        return null;
    }

    @Override
    public AxisIterator iterateAxis(byte axisNumber) {
        return this.iterateAxis(axisNumber, AnyNodeTest.getInstance());
    }

    @Override
    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        int nodeKind = this.getNodeKind();
        switch (axisNumber) {
            case 0: {
                if (nodeKind == 9) {
                    return EmptyAxisIterator.emptyAxisIterator();
                }
                return new Navigator.AxisFilter(new Navigator.AncestorEnumeration(this, false), nodeTest);
            }
            case 1: {
                if (nodeKind == 9) {
                    return Navigator.filteredSingleton(this, nodeTest);
                }
                return new Navigator.AxisFilter(new Navigator.AncestorEnumeration(this, true), nodeTest);
            }
            case 2: {
                if (nodeKind != 1) {
                    return EmptyAxisIterator.emptyAxisIterator();
                }
                return this.iterateAttributes(nodeTest);
            }
            case 3: {
                if (nodeKind == 1 || nodeKind == 9) {
                    return this.iterateChildren(nodeTest);
                }
                return EmptyAxisIterator.emptyAxisIterator();
            }
            case 4: {
                if (nodeKind == 1 || nodeKind == 9) {
                    return this.iterateDescendants(nodeTest, false);
                }
                return EmptyAxisIterator.emptyAxisIterator();
            }
            case 5: {
                if (nodeKind == 1 || nodeKind == 9) {
                    return this.iterateDescendants(nodeTest, true);
                }
                return Navigator.filteredSingleton(this, nodeTest);
            }
            case 6: {
                return new Navigator.AxisFilter(new Navigator.FollowingEnumeration(this), nodeTest);
            }
            case 7: {
                switch (nodeKind) {
                    case 2: 
                    case 9: 
                    case 13: {
                        return EmptyAxisIterator.emptyAxisIterator();
                    }
                }
                return this.iterateSiblings(nodeTest, true);
            }
            case 8: {
                if (nodeKind != 1) {
                    return EmptyAxisIterator.emptyAxisIterator();
                }
                return NamespaceNode.makeIterator(this, nodeTest);
            }
            case 9: {
                return Navigator.filteredSingleton(this.getParent(), nodeTest);
            }
            case 10: {
                return new Navigator.AxisFilter(new Navigator.PrecedingEnumeration(this, false), nodeTest);
            }
            case 11: {
                switch (nodeKind) {
                    case 2: 
                    case 9: 
                    case 13: {
                        return EmptyAxisIterator.emptyAxisIterator();
                    }
                }
                return this.iterateSiblings(nodeTest, false);
            }
            case 12: {
                return Navigator.filteredSingleton(this, nodeTest);
            }
            case 13: {
                return new Navigator.AxisFilter(new Navigator.PrecedingEnumeration(this, true), nodeTest);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + axisNumber);
    }

    protected abstract AxisIterator<NodeInfo> iterateAttributes(NodeTest var1);

    protected abstract AxisIterator<NodeInfo> iterateChildren(NodeTest var1);

    protected abstract AxisIterator<NodeInfo> iterateSiblings(NodeTest var1, boolean var2);

    protected abstract AxisIterator<NodeInfo> iterateDescendants(NodeTest var1, boolean var2);

    @Override
    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] buffer) {
        return new NamespaceBinding[0];
    }

    @Override
    public NodeInfo getRoot() {
        return this.getDocumentRoot();
    }

    @Override
    public boolean hasChildNodes() {
        switch (this.getNodeKind()) {
            case 1: 
            case 9: {
                return this.iterateAxis((byte)3).moveNext();
            }
        }
        return false;
    }

    @Override
    public long getDocumentNumber() {
        return this.getDocumentRoot().getDocumentNumber();
    }

    @Override
    public void copy(Receiver out, int copyOptions, int locationId) throws XPathException {
        Navigator.copy(this, out, copyOptions, locationId);
    }

    @Override
    public boolean isId() {
        return false;
    }

    @Override
    public boolean isIdref() {
        return false;
    }

    @Override
    public boolean isNilled() {
        return false;
    }
}

